/*
 * Decompiled with CFR 0.152.
 */
package com.configcat;

import java.util.Set;
import java.util.stream.Collectors;

final class ConfigCatLogMessages {
    public static final String CONFIG_SERVICE_CANNOT_INITIATE_HTTP_CALLS_WARN = "Client is in offline mode, it cannot initiate HTTP calls.";
    public static final String DATA_GOVERNANCE_IS_OUT_OF_SYNC_WARN = "The `builder.dataGovernance()` parameter specified at the client initialization is not in sync with the preferences on the ConfigCat Dashboard. Read more: https://configcat.com/docs/advanced/data-governance/";
    public static final String CONFIG_SERVICE_CACHE_WRITE_ERROR = "Error occurred while writing the cache";
    public static final String CONFIG_SERVICE_CACHE_READ_ERROR = "Error occurred while reading the cache.";
    public static final String FETCH_RECEIVED_200_WITH_INVALID_BODY_ERROR = "Fetching config JSON was successful but the HTTP response content was invalid.";
    public static final String FETCH_FAILED_DUE_TO_REDIRECT_LOOP_ERROR = "Redirection loop encountered while trying to fetch config JSON. Please contact us at https://configcat.com/support/";
    public static final String FETCH_FAILED_DUE_TO_UNEXPECTED_ERROR = "Unexpected error occurred while trying to fetch config JSON.";
    public static final String FETCH_FAILED_DUE_TO_INVALID_SDK_KEY_ERROR = "Your SDK Key seems to be wrong. You can find the valid SDK Key at https://app.configcat.com/sdkkey";

    private ConfigCatLogMessages() {
    }

    public static String getConfigJsonIsNotPresentedWithDefaultValue(String key, String defaultParamName, Object defaultParamValue) {
        return "Config JSON is not present when evaluating setting '" + key + "'. Returning the `" + defaultParamName + "` parameter that you specified in your application: '" + defaultParamValue + "'.";
    }

    public static String getConfigJsonIsNotPresentedWithEmptyResult(String emptyResult) {
        return "Config JSON is not present. Returning " + emptyResult + ".";
    }

    public static String getSettingEvaluationFailedDueToMissingKey(String key, String defaultParamName, Object defaultParamValue, Set<String> availableKeysSet) {
        return "Failed to evaluate setting '" + key + "' (the key was not found in config JSON). Returning the `" + defaultParamName + "` parameter that you specified in your application: '" + defaultParamValue + "'. Available keys: [" + availableKeysSet.stream().map(keyTo -> "'" + keyTo + "'").collect(Collectors.joining(", ")) + "].";
    }

    public static String getSettingEvaluationErrorWithDefaultValue(String methodName, String key, String defaultParamName, Object defaultParamValue) {
        return "Error occurred in the `" + methodName + "` method while evaluating setting '" + key + "'. Returning the `" + defaultParamName + "` parameter that you specified in your application: '" + defaultParamValue + "'.";
    }

    public static String getSettingEvaluationErrorWithEmptyValue(String methodName, String emptyResult) {
        return "Error occurred in the `" + methodName + "` method. Returning " + emptyResult + ".";
    }

    public static String getForceRefreshError(String methodName) {
        return "Error occurred in the `" + methodName + "` method.";
    }

    public static String getSettingEvaluationFailedForOtherReason(String key, String defaultParamName, Object defaultParamValue) {
        return "Failed to evaluate setting '" + key + "'. Returning the `" + defaultParamName + "` parameter that you specified in your application: '" + defaultParamValue + "'.";
    }

    public static String getSettingForVariationIdIsNotPresent(String variationId) {
        return "Could not find the setting for the specified variation ID: '" + variationId + "'.";
    }

    public static String getFetchFailedDueToUnexpectedHttpResponse(int responseCode, String responseMessage) {
        return "Unexpected HTTP response was received while trying to fetch config JSON: " + responseCode + " " + responseMessage;
    }

    public static String getFetchFailedDueToRequestTimeout(Integer connectTimeoutMillis, Integer readTimeoutMillis, Integer writeTimeoutMillis) {
        return "Request timed out while trying to fetch config JSON. Timeout values: [connect: " + connectTimeoutMillis + "ms, read: " + readTimeoutMillis + "ms, write: " + writeTimeoutMillis + "ms]";
    }

    public static String getLocalFileDataSourceDoesNotExist(String filePath) {
        return "Cannot find the local config file '" + filePath + "'. This is a path that your application provided to the ConfigCat SDK by passing it to the `OverrideDataSourceBuilder.localFile()` method. Read more: https://configcat.com/docs/sdk-reference/java/#json-file";
    }

    public static String getLocalFileDataSourceFailedToReadFile(String filePath) {
        return "Failed to read the local config file '" + filePath + "'.";
    }

    public static String getClientIsAlreadyCreated(String sdkKey) {
        return "There is an existing client instance for the specified SDK Key. No new client instance will be created and the specified options callback is ignored. Returning the existing client instance. SDK Key: '" + sdkKey + "'.";
    }

    public static String getTargetingIsNotPossible(String key) {
        return "Cannot evaluate targeting rules and % options for setting '" + key + "' (User Object is missing). You should pass a User Object to the evaluation methods like `getValue()`/`getValueAsync()` in order to make targeting work properly. Read more: https://configcat.com/docs/advanced/user-object/";
    }

    public static String getConfigServiceMethodHasNoEffectDueToClosedClient(String methodName) {
        return "The client object is already closed, thus `" + methodName + "` has no effect.";
    }

    public static String getAutoPollMaxInitWaitTimeReached(int maxInitWaitTimeSeconds) {
        return "`maxInitWaitTimeSeconds` for the very first fetch reached (" + maxInitWaitTimeSeconds + "s). Returning cached config.";
    }

    public static String getConfigServiceStatusChanged(String mode) {
        return "Switched to " + mode + " mode.";
    }
}

