/*
 * Decompiled with CFR 0.152.
 */
package com.configcat;

import com.configcat.RolloutEvaluator;
import com.configcat.User;
import java.util.ArrayList;
import java.util.List;

public class EvaluateLogger {
    private final List<String> entries = new ArrayList<String>();

    public EvaluateLogger(String key) {
        this.entries.add("Evaluating getValue(" + key + ").");
    }

    public void logReturnValue(String value) {
        this.entries.add("Returning " + value + ".");
    }

    public void logPercentageEvaluationReturnValue(String value) {
        this.entries.add("Evaluating % options. Returning " + value + ".");
    }

    public void logUserObject(User user) {
        this.entries.add("User object: " + user + ".");
    }

    public void logMatch(String comparisonAttribute, String userValue, int comparator, String comparisonValue, Object value) {
        this.entries.add("Evaluating rule: [" + comparisonAttribute + ":" + userValue + "] [" + RolloutEvaluator.COMPARATOR_TEXTS[comparator] + "] [" + comparisonValue + "] => match, returning: " + value + "");
    }

    public void logNoMatch(String comparisonAttribute, String userValue, int comparator, String comparisonValue) {
        this.entries.add("Evaluating rule: [" + comparisonAttribute + ":" + userValue + "] [" + RolloutEvaluator.COMPARATOR_TEXTS[comparator] + "] [" + comparisonValue + "] => no match");
    }

    public String logFormatError(String comparisonAttribute, String userValue, int comparator, String comparisonValue, Exception exception) {
        String message = "Evaluating rule: [" + comparisonAttribute + ":" + userValue + "] [" + RolloutEvaluator.COMPARATOR_TEXTS[comparator] + "] [" + comparisonValue + "] => SKIP rule. Validation error: " + exception + "";
        this.entries.add(message);
        return message;
    }

    public String toPrint() {
        return String.join((CharSequence)System.lineSeparator(), this.entries);
    }
}

