/*
 * Decompiled with CFR 0.152.
 */
package com.configcat;

import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import java.util.TimeZone;

public class DateTimeUtils {
    private DateTimeUtils() {
    }

    public static boolean isValidDate(String date) {
        try {
            Long.parseLong(date);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static String doubleToFormattedUTC(double dateInDouble) {
        long dateInMillisecond = (long)dateInDouble * 1000L;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return simpleDateFormat.format(new Date(dateInMillisecond));
    }

    public static double getUnixSeconds(Date date) {
        return (double)date.getTime() / 1000.0;
    }

    public static double getUnixSeconds(Instant date) {
        return (double)date.toEpochMilli() / 1000.0;
    }
}

