/*
 * Decompiled with CFR 0.152.
 */
package com.configcat;

import com.configcat.LogHelper;
import com.configcat.LogLevel;
import com.configcat.PrerequisiteFlagCondition;
import com.configcat.Segment;
import com.configcat.SegmentComparator;
import com.configcat.SegmentCondition;
import com.configcat.SettingsValue;
import com.configcat.TargetingRule;
import com.configcat.User;

public class EvaluateLogger {
    private final StringBuilder stringBuilder = new StringBuilder();
    private int indentLevel = 0;
    private final boolean isLoggable;

    public EvaluateLogger(LogLevel logLevel) {
        this.isLoggable = logLevel.ordinal() <= LogLevel.INFO.ordinal();
    }

    public final boolean isLoggable() {
        return this.isLoggable;
    }

    public final void logUserObject(User user) {
        if (!this.isLoggable) {
            return;
        }
        this.append(" for User '" + user.toString() + "'");
    }

    public final void logEvaluation(String key) {
        if (!this.isLoggable) {
            return;
        }
        this.append("Evaluating '" + key + "'");
    }

    public final void logPercentageOptionUserMissing() {
        if (!this.isLoggable) {
            return;
        }
        this.newLine();
        this.append("Skipping % options because the User Object is missing.");
    }

    public final void logPercentageOptionUserAttributeMissing(String percentageOptionsAttributeName) {
        if (!this.isLoggable) {
            return;
        }
        this.newLine();
        this.append("Skipping % options because the User." + percentageOptionsAttributeName + " attribute is missing.");
    }

    public final void logPercentageOptionEvaluation(String percentageOptionsAttributeName) {
        if (!this.isLoggable) {
            return;
        }
        this.newLine();
        this.append("Evaluating % options based on the User." + percentageOptionsAttributeName + " attribute:");
    }

    public final void logPercentageOptionEvaluationHash(String percentageOptionsAttributeName, int hashValue) {
        if (!this.isLoggable) {
            return;
        }
        this.newLine();
        this.append("- Computing hash in the [0..99] range from User." + percentageOptionsAttributeName + " => " + hashValue + " (this value is sticky and consistent across all SDKs)");
    }

    public final void append(String line) {
        if (!this.isLoggable) {
            return;
        }
        this.stringBuilder.append(line);
    }

    public final void increaseIndentLevel() {
        if (!this.isLoggable) {
            return;
        }
        ++this.indentLevel;
    }

    public final void decreaseIndentLevel() {
        if (!this.isLoggable) {
            return;
        }
        if (this.indentLevel > 0) {
            --this.indentLevel;
        }
    }

    public final void newLine() {
        if (!this.isLoggable) {
            return;
        }
        this.stringBuilder.append("\n");
        for (int i = 0; i < this.indentLevel; ++i) {
            this.stringBuilder.append("  ");
        }
    }

    public String toPrint() {
        if (!this.isLoggable) {
            return "";
        }
        return this.stringBuilder.toString();
    }

    public void logReturnValue(String returnValue) {
        if (!this.isLoggable) {
            return;
        }
        this.newLine();
        this.append("Returning '" + returnValue + "'.");
    }

    public void logTargetingRules() {
        if (!this.isLoggable) {
            return;
        }
        this.newLine();
        this.append("Evaluating targeting rules and applying the first match if any:");
    }

    public void logConditionConsequence(boolean result) {
        if (!this.isLoggable) {
            return;
        }
        this.append(" => " + result);
        if (!result) {
            this.append(", skipping the remaining AND conditions");
        }
    }

    public void logTargetingRuleIgnored() {
        if (!this.isLoggable) {
            return;
        }
        this.increaseIndentLevel();
        this.newLine();
        this.append("The current targeting rule is ignored and the evaluation continues with the next rule.");
        this.decreaseIndentLevel();
    }

    public void logTargetingRuleConsequence(TargetingRule targetingRule, String error, boolean isMatch, boolean newLine) {
        if (!this.isLoggable) {
            return;
        }
        this.increaseIndentLevel();
        String valueFormat = "% options";
        if (targetingRule != null && targetingRule.getSimpleValue() != null && targetingRule.getSimpleValue().getValue() != null) {
            valueFormat = "'" + targetingRule.getSimpleValue().getValue() + "'";
        }
        if (newLine) {
            this.newLine();
        } else {
            this.append(" ");
        }
        this.append("THEN " + valueFormat + " => ");
        if (error != null && !error.isEmpty()) {
            this.append(error);
        } else if (isMatch) {
            this.append("MATCH, applying rule");
        } else {
            this.append("no match");
        }
        this.decreaseIndentLevel();
    }

    public void logPercentageEvaluationReturnValue(int hashValue, int i, int percentage, SettingsValue settingsValue) {
        if (!this.isLoggable) {
            return;
        }
        String percentageOptionValue = settingsValue != null ? settingsValue.toString() : "<invalid value>";
        this.newLine();
        this.append("- Hash value " + hashValue + " selects % option " + (i + 1) + " (" + percentage + "%), '" + percentageOptionValue + "'.");
    }

    public void logSegmentEvaluationStart(String segmentName) {
        if (!this.isLoggable) {
            return;
        }
        this.newLine();
        this.append("(");
        this.increaseIndentLevel();
        this.newLine();
        this.append("Evaluating segment '" + segmentName + "':");
    }

    public void logSegmentEvaluationResult(SegmentCondition segmentCondition, Segment segment, boolean result, boolean segmentResult) {
        if (!this.isLoggable) {
            return;
        }
        this.newLine();
        String segmentResultComparator = segmentResult ? SegmentComparator.IS_IN_SEGMENT.getName() : SegmentComparator.IS_NOT_IN_SEGMENT.getName();
        this.append("Segment evaluation result: User " + segmentResultComparator + ".");
        this.newLine();
        this.append("Condition (" + LogHelper.formatSegmentFlagCondition(segmentCondition, segment) + ") evaluates to " + result + ".");
        this.decreaseIndentLevel();
        this.newLine();
        this.append(")");
    }

    public void logSegmentEvaluationError(SegmentCondition segmentCondition, Segment segment, String error) {
        if (!this.isLoggable) {
            return;
        }
        this.newLine();
        this.append("Segment evaluation result: " + error + ".");
        this.newLine();
        this.append("Condition (" + LogHelper.formatSegmentFlagCondition(segmentCondition, segment) + ") failed to evaluate.");
        this.decreaseIndentLevel();
        this.newLine();
        this.append(")");
    }

    public void logPrerequisiteFlagEvaluationStart(String prerequisiteFlagKey) {
        if (!this.isLoggable) {
            return;
        }
        this.newLine();
        this.append("(");
        this.increaseIndentLevel();
        this.newLine();
        this.append("Evaluating prerequisite flag '" + prerequisiteFlagKey + "':");
    }

    public void logPrerequisiteFlagEvaluationResult(PrerequisiteFlagCondition prerequisiteFlagCondition, SettingsValue prerequisiteFlagValue, boolean result) {
        if (!this.isLoggable) {
            return;
        }
        this.newLine();
        String prerequisiteFlagValueFormat = prerequisiteFlagValue != null ? prerequisiteFlagValue.toString() : "<invalid value>";
        this.append("Prerequisite flag evaluation result: '" + prerequisiteFlagValueFormat + "'.");
        this.newLine();
        this.append("Condition (" + LogHelper.formatPrerequisiteFlagCondition(prerequisiteFlagCondition) + ") evaluates to " + result + ".");
        this.decreaseIndentLevel();
        this.newLine();
        this.append(")");
    }
}

