/*
 * Decompiled with CFR 0.152.
 */
package com.configcat;

import com.configcat.ConditionAccessor;
import com.configcat.ConfigCatLogMessages;
import com.configcat.ConfigCatLogger;
import com.configcat.DateTimeUtils;
import com.configcat.EvaluateLogger;
import com.configcat.EvaluationContext;
import com.configcat.EvaluationResult;
import com.configcat.LogHelper;
import com.configcat.PercentageOption;
import com.configcat.PrerequisiteComparator;
import com.configcat.PrerequisiteFlagCondition;
import com.configcat.RolloutEvaluatorException;
import com.configcat.Segment;
import com.configcat.SegmentComparator;
import com.configcat.SegmentCondition;
import com.configcat.Setting;
import com.configcat.SettingType;
import com.configcat.SettingsValue;
import com.configcat.TargetingRule;
import com.configcat.User;
import com.configcat.UserAttributeConverter;
import com.configcat.UserComparator;
import com.configcat.UserCondition;
import com.configcat.Utils;
import de.skuzzle.semantic.Version;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.jetbrains.annotations.NotNull;

class RolloutEvaluator {
    public static final String USER_OBJECT_IS_MISSING = "cannot evaluate, User Object is missing";
    public static final String CANNOT_EVALUATE_THE_USER_PREFIX = "cannot evaluate, the User.";
    public static final String COMPARISON_OPERATOR_IS_INVALID = "Comparison operator is invalid.";
    public static final String COMPARISON_VALUE_IS_MISSING_OR_INVALID = "Comparison value is missing or invalid.";
    public static final String CANNOT_EVALUATE_THE_USER_INVALID = " attribute is invalid (";
    public static final String CANNOT_EVALUATE_THE_USER_MISSING = " attribute is missing";
    private final ConfigCatLogger logger;

    public RolloutEvaluator(ConfigCatLogger logger) {
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EvaluationResult evaluate(Setting setting, String key, User user, Map<String, Setting> settings, EvaluateLogger evaluateLogger) {
        try {
            evaluateLogger.logEvaluation(key);
            if (user != null) {
                evaluateLogger.logUserObject(user);
            }
            evaluateLogger.increaseIndentLevel();
            EvaluationContext context = new EvaluationContext(key, user, null, settings);
            EvaluationResult evaluationResult = this.evaluateSetting(setting, evaluateLogger, context);
            evaluateLogger.logReturnValue(evaluationResult.value.toString());
            evaluateLogger.decreaseIndentLevel();
            EvaluationResult evaluationResult2 = evaluationResult;
            return evaluationResult2;
        }
        finally {
            if (evaluateLogger.isLoggable()) {
                this.logger.info(5000, evaluateLogger.toPrint());
            }
        }
    }

    @NotNull
    private EvaluationResult evaluateSetting(Setting setting, EvaluateLogger evaluateLogger, EvaluationContext context) {
        EvaluationResult evaluationResult = null;
        if (setting.getTargetingRules() != null) {
            evaluationResult = this.evaluateTargetingRules(setting, context, evaluateLogger);
        }
        if (evaluationResult == null && setting.getPercentageOptions() != null && setting.getPercentageOptions().length > 0) {
            evaluationResult = this.evaluatePercentageOptions(setting.getPercentageOptions(), setting.getPercentageAttribute(), context, null, evaluateLogger);
        }
        if (evaluationResult == null) {
            evaluationResult = new EvaluationResult(setting.getSettingsValue(), setting.getVariationId(), null, null);
        }
        return evaluationResult;
    }

    private boolean evaluateUserCondition(UserCondition userCondition, EvaluationContext context, String configSalt, String contextSalt, EvaluateLogger evaluateLogger) throws RolloutEvaluatorException {
        evaluateLogger.append(LogHelper.formatUserCondition(userCondition));
        if (context.getUser() == null) {
            if (!context.isUserMissing()) {
                context.setUserMissing(true);
                this.logger.warn(3001, ConfigCatLogMessages.getUserObjectMissing(context.getKey()));
            }
            throw new RolloutEvaluatorException(USER_OBJECT_IS_MISSING);
        }
        String comparisonAttribute = userCondition.getComparisonAttribute();
        UserComparator userComparator = UserComparator.fromId(userCondition.getComparator());
        Object userAttributeValue = context.getUser().getAttribute(comparisonAttribute);
        if (userAttributeValue == null || userAttributeValue instanceof String && ((String)userAttributeValue).isEmpty()) {
            this.logger.warn(3003, ConfigCatLogMessages.getUserAttributeMissing(context.getKey(), userCondition, comparisonAttribute));
            throw new RolloutEvaluatorException(CANNOT_EVALUATE_THE_USER_PREFIX + comparisonAttribute + CANNOT_EVALUATE_THE_USER_MISSING);
        }
        if (userComparator == null) {
            throw new IllegalArgumentException(COMPARISON_OPERATOR_IS_INVALID);
        }
        switch (userComparator) {
            case CONTAINS_ANY_OF: 
            case NOT_CONTAINS_ANY_OF: {
                boolean negateContainsAnyOf = UserComparator.NOT_CONTAINS_ANY_OF.equals((Object)userComparator);
                String userAttributeForContains = this.getUserAttributeAsString(context.getKey(), userCondition, comparisonAttribute, userAttributeValue);
                return this.evaluateContainsAnyOf(userCondition, userAttributeForContains, negateContainsAnyOf);
            }
            case SEMVER_IS_ONE_OF: 
            case SEMVER_IS_NOT_ONE_OF: {
                boolean negateSemverIsOneOf = UserComparator.SEMVER_IS_NOT_ONE_OF.equals((Object)userComparator);
                Version userAttributeValueForSemverIsOneOf = this.getUserAttributeAsVersion(context.getKey(), userCondition, comparisonAttribute, userAttributeValue);
                return this.evaluateSemverIsOneOf(userCondition, userAttributeValueForSemverIsOneOf, negateSemverIsOneOf);
            }
            case SEMVER_LESS: 
            case SEMVER_LESS_EQUALS: 
            case SEMVER_GREATER: 
            case SEMVER_GREATER_EQUALS: {
                Version userAttributeValueForSemverOperators = this.getUserAttributeAsVersion(context.getKey(), userCondition, comparisonAttribute, userAttributeValue);
                return this.evaluateSemver(userCondition, userComparator, userAttributeValueForSemverOperators);
            }
            case NUMBER_EQUALS: 
            case NUMBER_NOT_EQUALS: 
            case NUMBER_LESS: 
            case NUMBER_LESS_EQUALS: 
            case NUMBER_GREATER: 
            case NUMBER_GREATER_EQUALS: {
                Double userAttributeAsDouble = this.getUserAttributeAsDouble(context.getKey(), userCondition, comparisonAttribute, userAttributeValue);
                return this.evaluateNumbers(userCondition, userComparator, userAttributeAsDouble);
            }
            case IS_ONE_OF: 
            case IS_NOT_ONE_OF: 
            case SENSITIVE_IS_ONE_OF: 
            case SENSITIVE_IS_NOT_ONE_OF: {
                boolean negateIsOneOf = UserComparator.SENSITIVE_IS_NOT_ONE_OF.equals((Object)userComparator) || UserComparator.IS_NOT_ONE_OF.equals((Object)userComparator);
                boolean sensitiveIsOneOf = UserComparator.SENSITIVE_IS_ONE_OF.equals((Object)userComparator) || UserComparator.SENSITIVE_IS_NOT_ONE_OF.equals((Object)userComparator);
                String userAttributeForIsOneOf = this.getUserAttributeAsString(context.getKey(), userCondition, comparisonAttribute, userAttributeValue);
                return this.evaluateIsOneOf(userCondition, configSalt, contextSalt, userAttributeForIsOneOf, negateIsOneOf, sensitiveIsOneOf);
            }
            case DATE_BEFORE: 
            case DATE_AFTER: {
                double userAttributeForDate = this.getUserAttributeForDate(userCondition, context, comparisonAttribute, userAttributeValue);
                return this.evaluateDate(userCondition, userComparator, userAttributeForDate);
            }
            case TEXT_EQUALS: 
            case TEXT_NOT_EQUALS: 
            case HASHED_EQUALS: 
            case HASHED_NOT_EQUALS: {
                boolean negateEquals = UserComparator.HASHED_NOT_EQUALS.equals((Object)userComparator) || UserComparator.TEXT_NOT_EQUALS.equals((Object)userComparator);
                boolean hashedEquals = UserComparator.HASHED_EQUALS.equals((Object)userComparator) || UserComparator.HASHED_NOT_EQUALS.equals((Object)userComparator);
                String userAttributeForEquals = this.getUserAttributeAsString(context.getKey(), userCondition, comparisonAttribute, userAttributeValue);
                return this.evaluateEquals(userCondition, configSalt, contextSalt, userAttributeForEquals, negateEquals, hashedEquals);
            }
            case HASHED_STARTS_WITH: 
            case HASHED_ENDS_WITH: 
            case HASHED_NOT_STARTS_WITH: 
            case HASHED_NOT_ENDS_WITH: {
                String userAttributeForHashedStartEnd = this.getUserAttributeAsString(context.getKey(), userCondition, comparisonAttribute, userAttributeValue);
                return this.evaluateHashedStartOrEndsWith(userCondition, configSalt, contextSalt, userComparator, userAttributeForHashedStartEnd);
            }
            case TEXT_STARTS_WITH: 
            case TEXT_NOT_STARTS_WITH: {
                boolean negateTextStartWith = UserComparator.TEXT_NOT_STARTS_WITH.equals((Object)userComparator);
                String userAttributeForTextStart = this.getUserAttributeAsString(context.getKey(), userCondition, comparisonAttribute, userAttributeValue);
                return this.evaluateTextStartsWith(userCondition, userAttributeForTextStart, negateTextStartWith);
            }
            case TEXT_ENDS_WITH: 
            case TEXT_NOT_ENDS_WITH: {
                boolean negateTextEndsWith = UserComparator.TEXT_NOT_ENDS_WITH.equals((Object)userComparator);
                String userAttributeForTextEnd = this.getUserAttributeAsString(context.getKey(), userCondition, comparisonAttribute, userAttributeValue);
                return this.evaluateTextEndsWith(userCondition, userAttributeForTextEnd, negateTextEndsWith);
            }
            case TEXT_ARRAY_CONTAINS: 
            case TEXT_ARRAY_NOT_CONTAINS: 
            case HASHED_ARRAY_CONTAINS: 
            case HASHED_ARRAY_NOT_CONTAINS: {
                boolean negateArrayContains = UserComparator.HASHED_ARRAY_NOT_CONTAINS.equals((Object)userComparator) || UserComparator.TEXT_ARRAY_NOT_CONTAINS.equals((Object)userComparator);
                boolean hashedArrayContains = UserComparator.HASHED_ARRAY_CONTAINS.equals((Object)userComparator) || UserComparator.HASHED_ARRAY_NOT_CONTAINS.equals((Object)userComparator);
                String[] userAttributeAsStringArray = this.getUserAttributeAsStringArray(userCondition, context, comparisonAttribute, userAttributeValue);
                return this.evaluateArrayContains(userCondition, configSalt, contextSalt, userAttributeAsStringArray, negateArrayContains, hashedArrayContains);
            }
        }
        throw new IllegalArgumentException(COMPARISON_OPERATOR_IS_INVALID);
    }

    private String[] getUserAttributeAsStringArray(UserCondition userCondition, EvaluationContext context, String comparisonAttribute, Object userAttributeValue) {
        String[] result = null;
        try {
            if (userAttributeValue instanceof String[]) {
                result = (String[])userAttributeValue;
            } else if (userAttributeValue instanceof List) {
                List list = (List)userAttributeValue;
                String[] userValueArray = new String[list.size()];
                list.toArray(userValueArray);
                result = userValueArray;
            } else if (userAttributeValue instanceof String) {
                result = (String[])Utils.gson.fromJson((String)userAttributeValue, String[].class);
            }
            if (result != null && Arrays.stream(result).noneMatch(Objects::isNull)) {
                return result;
            }
        }
        catch (Exception list) {
            // empty catch block
        }
        String reason = "'" + userAttributeValue + "' is not a valid JSON string array";
        this.logger.warn(3004, ConfigCatLogMessages.getUserAttributeInvalid(context.getKey(), userCondition, reason, comparisonAttribute));
        throw new RolloutEvaluatorException(CANNOT_EVALUATE_THE_USER_PREFIX + comparisonAttribute + CANNOT_EVALUATE_THE_USER_INVALID + reason + ")");
    }

    private double getUserAttributeForDate(UserCondition userCondition, EvaluationContext context, String comparisonAttribute, Object userAttributeValue) {
        try {
            if (userAttributeValue instanceof Date) {
                return DateTimeUtils.getUnixSeconds((Date)userAttributeValue);
            }
            if (userAttributeValue instanceof Instant) {
                return DateTimeUtils.getUnixSeconds((Instant)userAttributeValue);
            }
            return UserAttributeConverter.userAttributeToDouble(userAttributeValue);
        }
        catch (Exception e) {
            String reason = "'" + userAttributeValue + "' is not a valid Unix timestamp (number of seconds elapsed since Unix epoch)";
            this.logger.warn(3004, ConfigCatLogMessages.getUserAttributeInvalid(context.getKey(), userCondition, reason, comparisonAttribute));
            throw new RolloutEvaluatorException(CANNOT_EVALUATE_THE_USER_PREFIX + comparisonAttribute + CANNOT_EVALUATE_THE_USER_INVALID + reason + ")");
        }
    }

    private String getUserAttributeAsString(String key, UserCondition userCondition, String userAttributeName, Object userAttributeValue) {
        if (userAttributeValue instanceof String) {
            return (String)userAttributeValue;
        }
        String convertedUserAttribute = UserAttributeConverter.userAttributeToString(userAttributeValue);
        this.logger.warn(3005, ConfigCatLogMessages.getUserObjectAttributeIsAutoConverted(key, userCondition, userAttributeName, convertedUserAttribute));
        return convertedUserAttribute;
    }

    private Version getUserAttributeAsVersion(String key, UserCondition userCondition, String comparisonAttribute, Object userValue) {
        if (userValue instanceof String) {
            try {
                return Version.parseVersion((String)((String)userValue).trim(), (boolean)true);
            }
            catch (Version.VersionFormatException versionFormatException) {
                // empty catch block
            }
        }
        String reason = "'" + userValue + "' is not a valid semantic version";
        this.logger.warn(3004, ConfigCatLogMessages.getUserAttributeInvalid(key, userCondition, reason, comparisonAttribute));
        throw new RolloutEvaluatorException(CANNOT_EVALUATE_THE_USER_PREFIX + comparisonAttribute + CANNOT_EVALUATE_THE_USER_INVALID + reason + ")");
    }

    private Double getUserAttributeAsDouble(String key, UserCondition userCondition, String comparisonAttribute, Object userAttributeValue) {
        try {
            if (userAttributeValue instanceof Double) {
                return (Double)userAttributeValue;
            }
            return UserAttributeConverter.userAttributeToDouble(userAttributeValue);
        }
        catch (NumberFormatException e) {
            String reason = "'" + userAttributeValue + "' is not a valid decimal number";
            this.logger.warn(3004, ConfigCatLogMessages.getUserAttributeInvalid(key, userCondition, reason, comparisonAttribute));
            throw new RolloutEvaluatorException(CANNOT_EVALUATE_THE_USER_PREFIX + comparisonAttribute + CANNOT_EVALUATE_THE_USER_INVALID + reason + ")");
        }
    }

    private boolean evaluateHashedStartOrEndsWith(UserCondition userCondition, String configSalt, String contextSalt, UserComparator userComparator, String userAttributeValue) {
        String[] comparisonValues = RolloutEvaluator.ensureComparisonValue(userCondition.getStringArrayValue());
        byte[] userAttributeValueUTF8 = userAttributeValue.getBytes(StandardCharsets.UTF_8);
        boolean foundEqual = false;
        for (String comparisonValueHashedStartsEnds : comparisonValues) {
            int comparedTextLengthInt;
            int indexOf = RolloutEvaluator.ensureComparisonValue(comparisonValueHashedStartsEnds).indexOf("_");
            if (indexOf <= 0) {
                throw new IllegalArgumentException(COMPARISON_VALUE_IS_MISSING_OR_INVALID);
            }
            String comparedTextLength = comparisonValueHashedStartsEnds.substring(0, indexOf);
            try {
                comparedTextLengthInt = Integer.parseInt(comparedTextLength);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(COMPARISON_VALUE_IS_MISSING_OR_INVALID);
            }
            if (userAttributeValueUTF8.length < comparedTextLengthInt) continue;
            String comparisonHashValue = comparisonValueHashedStartsEnds.substring(indexOf + 1);
            if (comparisonHashValue.isEmpty()) {
                throw new IllegalArgumentException(COMPARISON_VALUE_IS_MISSING_OR_INVALID);
            }
            byte[] userValueSubStringByteArray = UserComparator.HASHED_STARTS_WITH.equals((Object)userComparator) || UserComparator.HASHED_NOT_STARTS_WITH.equals((Object)userComparator) ? Arrays.copyOfRange(userAttributeValueUTF8, 0, comparedTextLengthInt) : Arrays.copyOfRange(userAttributeValueUTF8, userAttributeValueUTF8.length - comparedTextLengthInt, userAttributeValueUTF8.length);
            String hashUserValueSub = RolloutEvaluator.getSaltedUserValueSlice(userValueSubStringByteArray, configSalt, contextSalt);
            if (!hashUserValueSub.equals(comparisonHashValue)) continue;
            foundEqual = true;
            break;
        }
        if (UserComparator.HASHED_NOT_STARTS_WITH.equals((Object)userComparator) || UserComparator.HASHED_NOT_ENDS_WITH.equals((Object)userComparator)) {
            return !foundEqual;
        }
        return foundEqual;
    }

    private boolean evaluateTextStartsWith(UserCondition userCondition, String userAttributeValue, boolean negateTextStartWith) {
        String[] comparisonValues;
        for (String textValue : comparisonValues = RolloutEvaluator.ensureComparisonValue(userCondition.getStringArrayValue())) {
            if (!userAttributeValue.startsWith(RolloutEvaluator.ensureComparisonValue(textValue))) continue;
            return !negateTextStartWith;
        }
        return negateTextStartWith;
    }

    private boolean evaluateTextEndsWith(UserCondition userCondition, String userAttributeValue, boolean negateTextEndsWith) {
        String[] comparisonValues;
        for (String textValue : comparisonValues = RolloutEvaluator.ensureComparisonValue(userCondition.getStringArrayValue())) {
            if (!userAttributeValue.endsWith(RolloutEvaluator.ensureComparisonValue(textValue))) continue;
            return !negateTextEndsWith;
        }
        return negateTextEndsWith;
    }

    private boolean evaluateArrayContains(UserCondition userCondition, String configSalt, String contextSalt, String[] userContainsValues, boolean negateArrayContains, boolean hashedArrayContains) {
        String[] comparisonValues = RolloutEvaluator.ensureComparisonValue(userCondition.getStringArrayValue());
        if (userContainsValues.length == 0) {
            return false;
        }
        for (String userContainsValue : userContainsValues) {
            String userContainsValueConverted = hashedArrayContains ? RolloutEvaluator.getSaltedUserValue(userContainsValue, configSalt, contextSalt) : userContainsValue;
            for (String inValuesElement : comparisonValues) {
                if (!RolloutEvaluator.ensureComparisonValue(inValuesElement).equals(userContainsValueConverted)) continue;
                return !negateArrayContains;
            }
        }
        return negateArrayContains;
    }

    private boolean evaluateEquals(UserCondition userCondition, String configSalt, String contextSalt, String userValue, boolean negateEquals, boolean hashedEquals) {
        String comparisonValue = RolloutEvaluator.ensureComparisonValue(userCondition.getStringValue());
        String valueEquals = hashedEquals ? RolloutEvaluator.getSaltedUserValue(userValue, configSalt, contextSalt) : userValue;
        return negateEquals != valueEquals.equals(comparisonValue);
    }

    private boolean evaluateDate(UserCondition userCondition, UserComparator userComparator, double userDoubleValue) {
        double comparisonDoubleValue = RolloutEvaluator.ensureComparisonValue(userCondition.getDoubleValue());
        return UserComparator.DATE_BEFORE.equals((Object)userComparator) && userDoubleValue < comparisonDoubleValue || UserComparator.DATE_AFTER.equals((Object)userComparator) && userDoubleValue > comparisonDoubleValue;
    }

    private boolean evaluateIsOneOf(UserCondition userCondition, String configSalt, String contextSalt, String userValue, boolean negateIsOneOf, boolean sensitiveIsOneOf) {
        String[] comparisonValues = RolloutEvaluator.ensureComparisonValue(userCondition.getStringArrayValue());
        String userIsOneOfValue = sensitiveIsOneOf ? RolloutEvaluator.getSaltedUserValue(userValue, configSalt, contextSalt) : userValue;
        for (String inValuesElement : comparisonValues) {
            if (!RolloutEvaluator.ensureComparisonValue(inValuesElement).equals(userIsOneOfValue)) continue;
            return !negateIsOneOf;
        }
        return negateIsOneOf;
    }

    private boolean evaluateNumbers(UserCondition userCondition, UserComparator userComparator, Double userValue) {
        Double comparisonDoubleValue = RolloutEvaluator.ensureComparisonValue(userCondition.getDoubleValue());
        return UserComparator.NUMBER_EQUALS.equals((Object)userComparator) && userValue.equals(comparisonDoubleValue) || UserComparator.NUMBER_NOT_EQUALS.equals((Object)userComparator) && !userValue.equals(comparisonDoubleValue) || UserComparator.NUMBER_LESS.equals((Object)userComparator) && userValue < comparisonDoubleValue || UserComparator.NUMBER_LESS_EQUALS.equals((Object)userComparator) && userValue <= comparisonDoubleValue || UserComparator.NUMBER_GREATER.equals((Object)userComparator) && userValue > comparisonDoubleValue || UserComparator.NUMBER_GREATER_EQUALS.equals((Object)userComparator) && userValue >= comparisonDoubleValue;
    }

    private boolean evaluateSemver(UserCondition userCondition, UserComparator userComparator, Version userValue) {
        Version matchValue;
        String comparisonValue = RolloutEvaluator.ensureComparisonValue(userCondition.getStringValue());
        try {
            matchValue = Version.parseVersion((String)comparisonValue.trim(), (boolean)true);
        }
        catch (Version.VersionFormatException exception) {
            return false;
        }
        return UserComparator.SEMVER_LESS.equals((Object)userComparator) && userValue.isLowerThan(matchValue) || UserComparator.SEMVER_LESS_EQUALS.equals((Object)userComparator) && userValue.compareTo(matchValue) <= 0 || UserComparator.SEMVER_GREATER.equals((Object)userComparator) && userValue.isGreaterThan(matchValue) || UserComparator.SEMVER_GREATER_EQUALS.equals((Object)userComparator) && userValue.compareTo(matchValue) >= 0;
    }

    private boolean evaluateSemverIsOneOf(UserCondition userCondition, Version userVersion, boolean negate) {
        String[] comparisonValues = RolloutEvaluator.ensureComparisonValue(userCondition.getStringArrayValue());
        boolean matched = false;
        for (String semVer : comparisonValues) {
            if (RolloutEvaluator.ensureComparisonValue(semVer).isEmpty()) continue;
            try {
                matched = userVersion.compareTo(Version.parseVersion((String)semVer.trim(), (boolean)true)) == 0 || matched;
            }
            catch (Version.VersionFormatException exception) {
                return false;
            }
        }
        return negate != matched;
    }

    private boolean evaluateContainsAnyOf(UserCondition userCondition, String userValue, boolean negate) {
        String[] comparisonValues;
        for (String containsValue : comparisonValues = RolloutEvaluator.ensureComparisonValue(userCondition.getStringArrayValue())) {
            if (!userValue.contains(RolloutEvaluator.ensureComparisonValue(containsValue))) continue;
            return !negate;
        }
        return negate;
    }

    private static String getSaltedUserValue(String userValue, String configJsonSalt, String contextSalt) {
        return DigestUtils.sha256Hex((String)(userValue + configJsonSalt + contextSalt));
    }

    private static String getSaltedUserValueSlice(byte[] userValueSliceUTF8, String configJsonSalt, String contextSalt) {
        byte[] configSaltByteArray = configJsonSalt.getBytes(StandardCharsets.UTF_8);
        byte[] contextSaltByteArray = contextSalt.getBytes(StandardCharsets.UTF_8);
        byte[] concatByteArrays = new byte[userValueSliceUTF8.length + configSaltByteArray.length + contextSaltByteArray.length];
        System.arraycopy(userValueSliceUTF8, 0, concatByteArrays, 0, userValueSliceUTF8.length);
        System.arraycopy(configSaltByteArray, 0, concatByteArrays, userValueSliceUTF8.length, configSaltByteArray.length);
        System.arraycopy(contextSaltByteArray, 0, concatByteArrays, userValueSliceUTF8.length + configSaltByteArray.length, contextSaltByteArray.length);
        return DigestUtils.sha256Hex((byte[])concatByteArrays);
    }

    private boolean evaluateSegmentCondition(SegmentCondition segmentCondition, EvaluationContext context, String configSalt, Segment[] segments, EvaluateLogger evaluateLogger) {
        boolean result;
        int segmentIndex = segmentCondition.getSegmentIndex();
        Segment segment = null;
        if (segmentIndex < segments.length) {
            segment = segments[segmentIndex];
        }
        evaluateLogger.append(LogHelper.formatSegmentFlagCondition(segmentCondition, segment));
        if (context.getUser() == null) {
            if (!context.isUserMissing()) {
                context.setUserMissing(true);
                this.logger.warn(3001, ConfigCatLogMessages.getUserObjectMissing(context.getKey()));
            }
            throw new RolloutEvaluatorException(USER_OBJECT_IS_MISSING);
        }
        if (segment == null) {
            throw new IllegalArgumentException("Segment reference is invalid.");
        }
        String segmentName = segment.getName();
        if (segmentName == null || segmentName.isEmpty()) {
            throw new IllegalArgumentException("Segment name is missing.");
        }
        evaluateLogger.logSegmentEvaluationStart(segmentName);
        try {
            boolean segmentRulesResult = this.evaluateConditions(segment.getSegmentRules(), null, context, configSalt, segmentName, segments, evaluateLogger);
            SegmentComparator segmentComparator = SegmentComparator.fromId(segmentCondition.getSegmentComparator());
            if (segmentComparator == null) {
                throw new IllegalArgumentException("Segment comparison operator is invalid.");
            }
            switch (segmentComparator) {
                case IS_IN_SEGMENT: {
                    result = segmentRulesResult;
                    break;
                }
                case IS_NOT_IN_SEGMENT: {
                    result = !segmentRulesResult;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Segment comparison operator is invalid.");
                }
            }
            evaluateLogger.logSegmentEvaluationResult(segmentCondition, segment, result, segmentRulesResult);
        }
        catch (RolloutEvaluatorException evaluatorException) {
            evaluateLogger.logSegmentEvaluationError(segmentCondition, segment, evaluatorException.getMessage());
            throw evaluatorException;
        }
        return result;
    }

    private boolean evaluatePrerequisiteFlagCondition(PrerequisiteFlagCondition prerequisiteFlagCondition, EvaluationContext context, EvaluateLogger evaluateLogger) {
        boolean result;
        evaluateLogger.append(LogHelper.formatPrerequisiteFlagCondition(prerequisiteFlagCondition));
        String prerequisiteFlagKey = prerequisiteFlagCondition.getPrerequisiteFlagKey();
        Setting prerequsiteFlagSetting = context.getSettings().get(prerequisiteFlagKey);
        if (prerequisiteFlagKey == null || prerequisiteFlagKey.isEmpty() || prerequsiteFlagSetting == null) {
            throw new IllegalArgumentException("Prerequisite flag key is missing or invalid.");
        }
        SettingType settingType = prerequsiteFlagSetting.getType();
        if (settingType == SettingType.BOOLEAN && prerequisiteFlagCondition.getValue().getBooleanValue() == null || settingType == SettingType.STRING && prerequisiteFlagCondition.getValue().getStringValue() == null || settingType == SettingType.INT && prerequisiteFlagCondition.getValue().getIntegerValue() == null || settingType == SettingType.DOUBLE && prerequisiteFlagCondition.getValue().getDoubleValue() == null) {
            throw new IllegalArgumentException("Type mismatch between comparison value '" + prerequisiteFlagCondition.getValue() + "' and prerequisite flag '" + prerequisiteFlagKey + "'.");
        }
        List<String> visitedKeys = context.getVisitedKeys();
        if (visitedKeys == null) {
            visitedKeys = new ArrayList<String>();
        }
        visitedKeys.add(context.getKey());
        if (visitedKeys.contains(prerequisiteFlagKey)) {
            String dependencyCycle = LogHelper.formatCircularDependencyList(visitedKeys, prerequisiteFlagKey);
            throw new IllegalArgumentException("Circular dependency detected between the following depending flags: " + dependencyCycle + ".");
        }
        evaluateLogger.logPrerequisiteFlagEvaluationStart(prerequisiteFlagKey);
        EvaluationContext prerequisiteFlagContext = new EvaluationContext(prerequisiteFlagKey, context.getUser(), visitedKeys, context.getSettings());
        EvaluationResult evaluateResult = this.evaluateSetting(prerequsiteFlagSetting, evaluateLogger, prerequisiteFlagContext);
        visitedKeys.remove(context.getKey());
        if (evaluateResult.value == null) {
            return false;
        }
        PrerequisiteComparator prerequisiteComparator = PrerequisiteComparator.fromId(prerequisiteFlagCondition.getPrerequisiteComparator());
        SettingsValue conditionValue = prerequisiteFlagCondition.getValue();
        if (prerequisiteComparator == null) {
            throw new IllegalArgumentException("Prerequisite Flag comparison operator is invalid.");
        }
        switch (prerequisiteComparator) {
            case EQUALS: {
                result = conditionValue.equals(evaluateResult.value);
                break;
            }
            case NOT_EQUALS: {
                result = !conditionValue.equals(evaluateResult.value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Prerequisite Flag comparison operator is invalid.");
            }
        }
        evaluateLogger.logPrerequisiteFlagEvaluationResult(prerequisiteFlagCondition, evaluateResult.value, result);
        return result;
    }

    private EvaluationResult evaluateTargetingRules(Setting setting, EvaluationContext context, EvaluateLogger evaluateLogger) {
        evaluateLogger.logTargetingRules();
        for (TargetingRule rule : setting.getTargetingRules()) {
            boolean evaluateConditionsResult;
            String error = null;
            try {
                evaluateConditionsResult = this.evaluateConditions(rule.getConditions(), rule, context, setting.getConfigSalt(), context.getKey(), setting.getSegments(), evaluateLogger);
            }
            catch (RolloutEvaluatorException rolloutEvaluatorException) {
                error = rolloutEvaluatorException.getMessage();
                evaluateConditionsResult = false;
            }
            if (!evaluateConditionsResult) {
                if (error == null) continue;
                evaluateLogger.logTargetingRuleIgnored();
                continue;
            }
            if (rule.getSimpleValue() != null) {
                return new EvaluationResult(rule.getSimpleValue().getValue(), rule.getSimpleValue().getVariationId(), rule, null);
            }
            if (rule.getPercentageOptions() == null || rule.getPercentageOptions().length == 0) {
                throw new IllegalArgumentException("Targeting rule THEN part is missing or invalid.");
            }
            evaluateLogger.increaseIndentLevel();
            EvaluationResult evaluatePercentageOptionsResult = this.evaluatePercentageOptions(rule.getPercentageOptions(), setting.getPercentageAttribute(), context, rule, evaluateLogger);
            evaluateLogger.decreaseIndentLevel();
            if (evaluatePercentageOptionsResult == null) {
                evaluateLogger.logTargetingRuleIgnored();
                continue;
            }
            return evaluatePercentageOptionsResult;
        }
        return null;
    }

    private boolean evaluateConditions(ConditionAccessor[] conditions, TargetingRule targetingRule, EvaluationContext context, String configSalt, String contextSalt, Segment[] segments, EvaluateLogger evaluateLogger) {
        boolean firstConditionFlag = true;
        boolean conditionsEvaluationResult = true;
        String error = null;
        boolean newLine = false;
        for (ConditionAccessor condition : conditions) {
            if (firstConditionFlag) {
                firstConditionFlag = false;
                evaluateLogger.newLine();
                evaluateLogger.append("- IF ");
                evaluateLogger.increaseIndentLevel();
            } else {
                evaluateLogger.increaseIndentLevel();
                evaluateLogger.newLine();
                evaluateLogger.append("AND ");
            }
            if (condition.getUserCondition() != null) {
                try {
                    conditionsEvaluationResult = this.evaluateUserCondition(condition.getUserCondition(), context, configSalt, contextSalt, evaluateLogger);
                }
                catch (RolloutEvaluatorException evaluatorException) {
                    error = evaluatorException.getMessage();
                    conditionsEvaluationResult = false;
                }
                newLine = conditions.length > 1;
            } else if (condition.getSegmentCondition() != null) {
                try {
                    conditionsEvaluationResult = this.evaluateSegmentCondition(condition.getSegmentCondition(), context, configSalt, segments, evaluateLogger);
                }
                catch (RolloutEvaluatorException evaluatorException) {
                    error = evaluatorException.getMessage();
                    conditionsEvaluationResult = false;
                }
                newLine = !USER_OBJECT_IS_MISSING.equals(error) || conditions.length > 1;
            } else if (condition.getPrerequisiteFlagCondition() != null) {
                try {
                    conditionsEvaluationResult = this.evaluatePrerequisiteFlagCondition(condition.getPrerequisiteFlagCondition(), context, evaluateLogger);
                }
                catch (RolloutEvaluatorException evaluatorException) {
                    error = evaluatorException.getMessage();
                    conditionsEvaluationResult = false;
                }
                newLine = true;
            }
            if (targetingRule == null || conditions.length > 1) {
                evaluateLogger.logConditionConsequence(conditionsEvaluationResult);
            }
            evaluateLogger.decreaseIndentLevel();
            if (!conditionsEvaluationResult) break;
        }
        if (targetingRule != null) {
            evaluateLogger.logTargetingRuleConsequence(targetingRule, error, conditionsEvaluationResult, newLine);
        }
        if (error != null) {
            throw new RolloutEvaluatorException(error);
        }
        return conditionsEvaluationResult;
    }

    private EvaluationResult evaluatePercentageOptions(PercentageOption[] percentageOptions, String percentageOptionAttribute, EvaluationContext context, TargetingRule parentTargetingRule, EvaluateLogger evaluateLogger) {
        String percentageOptionAttributeValue;
        if (context.getUser() == null) {
            evaluateLogger.logPercentageOptionUserMissing();
            if (!context.isUserMissing()) {
                context.setUserMissing(true);
                this.logger.warn(3001, ConfigCatLogMessages.getUserObjectMissing(context.getKey()));
            }
            return null;
        }
        String percentageOptionAttributeName = percentageOptionAttribute;
        if (percentageOptionAttributeName == null || percentageOptionAttributeName.isEmpty()) {
            percentageOptionAttributeName = "Identifier";
            percentageOptionAttributeValue = context.getUser().getIdentifier();
        } else {
            percentageOptionAttributeValue = UserAttributeConverter.userAttributeToString(context.getUser().getAttribute(percentageOptionAttributeName));
            if (percentageOptionAttributeValue == null) {
                evaluateLogger.logPercentageOptionUserAttributeMissing(percentageOptionAttributeName);
                if (!context.isUserAttributeMissing()) {
                    context.setUserAttributeMissing(true);
                    this.logger.warn(3003, ConfigCatLogMessages.getUserAttributeMissing(context.getKey(), percentageOptionAttributeName));
                }
                return null;
            }
        }
        evaluateLogger.logPercentageOptionEvaluation(percentageOptionAttributeName);
        String hashCandidate = context.getKey() + percentageOptionAttributeValue;
        int scale = 100;
        String hexHash = new String(Hex.encodeHex((byte[])DigestUtils.sha1((String)hashCandidate))).substring(0, 7);
        int longHash = Integer.parseInt(hexHash, 16);
        int scaled = longHash % scale;
        evaluateLogger.logPercentageOptionEvaluationHash(percentageOptionAttributeName, scaled);
        int bucket = 0;
        for (int i = 0; i < percentageOptions.length; ++i) {
            PercentageOption rule = percentageOptions[i];
            if (scaled >= (bucket += rule.getPercentage())) continue;
            evaluateLogger.logPercentageEvaluationReturnValue(scaled, i, rule.getPercentage(), rule.getValue());
            return new EvaluationResult(rule.getValue(), rule.getVariationId(), parentTargetingRule, rule);
        }
        throw new IllegalArgumentException("Sum of percentage option percentages are less than 100.");
    }

    private static <T> T ensureComparisonValue(T value) {
        if (value == null) {
            throw new IllegalArgumentException(COMPARISON_VALUE_IS_MISSING_OR_INVALID);
        }
        return value;
    }
}

