/*
 * Decompiled with CFR 0.152.
 */
package com.configcat;

import com.configcat.Config;
import com.configcat.Segment;
import com.configcat.Setting;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

final class Utils {
    static final Gson gson = new GsonBuilder().create();

    private Utils() {
    }

    public static DecimalFormat getDecimalFormat() {
        DecimalFormat decimalFormat = new DecimalFormat("0.#####");
        decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.UK));
        return decimalFormat;
    }

    public static Config deserializeConfig(String json) {
        Config config = (Config)gson.fromJson(json, Config.class);
        String salt = config.getPreferences().getSalt();
        if (salt == null || salt.isEmpty()) {
            throw new IllegalArgumentException("Config JSON salt is missing.");
        }
        Segment[] segments = config.getSegments();
        if (segments == null) {
            segments = new Segment[]{};
        }
        for (Setting setting : config.getEntries().values()) {
            setting.setConfigSalt(salt);
            setting.setSegments(segments);
        }
        return config;
    }
}

