/*
 * Decompiled with CFR 0.152.
 */
package com.configcat;

import com.configcat.Utils;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

public class User {
    private static final String IDENTIFIER_KEY = "Identifier";
    private static final String EMAIL = "Email";
    private static final String COUNTRY = "Country";
    private final String identifier;
    private final Map<String, Object> attributes;

    private User(String identifier, String email, String country, Map<String, Object> custom) {
        this.identifier = identifier == null ? "" : identifier;
        this.attributes = new TreeMap<String, Object>();
        this.attributes.put(IDENTIFIER_KEY, identifier);
        if (country != null && !country.isEmpty()) {
            this.attributes.put(COUNTRY, country);
        }
        if (email != null && !email.isEmpty()) {
            this.attributes.put(EMAIL, email);
        }
        if (custom != null) {
            for (Map.Entry<String, Object> entry : custom.entrySet()) {
                if (entry.getKey().equals(IDENTIFIER_KEY) || entry.getKey().equals(COUNTRY) || entry.getKey().equals(EMAIL)) continue;
                this.attributes.put(entry.getKey(), entry.getValue());
            }
        }
    }

    String getIdentifier() {
        return this.identifier;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    Object getAttribute(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null or empty");
        }
        return this.attributes.getOrDefault(key, null);
    }

    public String toString() {
        LinkedHashMap<String, Object> tmp = new LinkedHashMap<String, Object>();
        if (this.attributes.containsKey(IDENTIFIER_KEY)) {
            tmp.put(IDENTIFIER_KEY, this.attributes.get(IDENTIFIER_KEY));
        }
        if (this.attributes.containsKey(EMAIL)) {
            tmp.put(EMAIL, this.attributes.get(EMAIL));
        }
        if (this.attributes.containsKey(COUNTRY)) {
            tmp.put(COUNTRY, this.attributes.get(COUNTRY));
        }
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            if (entry.getKey().equals(IDENTIFIER_KEY) || entry.getKey().equals(COUNTRY) || entry.getKey().equals(EMAIL)) continue;
            tmp.put(entry.getKey(), entry.getValue());
        }
        return Utils.gson.toJson(tmp);
    }

    public static class Builder {
        private String email;
        private String country;
        private Map<String, Object> custom;

        public Builder email(String email) {
            this.email = email;
            return this;
        }

        public Builder country(String country) {
            this.country = country;
            return this;
        }

        public Builder custom(Map<String, Object> custom) {
            this.custom = custom;
            return this;
        }

        public User build(String identifier) {
            return new User(identifier, this.email, this.country, this.custom);
        }
    }
}

