/*
 * Decompiled with CFR 0.152.
 */
package com.configcat;

import com.configcat.FormattableLogMessage;
import com.configcat.FormattableLogMessageWithKeySet;
import com.configcat.FormattableLogMessageWithUserCondition;
import com.configcat.UserCondition;
import java.util.Set;

final class ConfigCatLogMessages {
    public static final String CONFIG_SERVICE_CANNOT_INITIATE_HTTP_CALLS_WARN = "Client is in offline mode, it cannot initiate HTTP calls.";
    public static final String DATA_GOVERNANCE_IS_OUT_OF_SYNC_WARN = "The `builder.dataGovernance()` parameter specified at the client initialization is not in sync with the preferences on the ConfigCat Dashboard. Read more: https://configcat.com/docs/advanced/data-governance/";
    public static final String CONFIG_SERVICE_CACHE_WRITE_ERROR = "Error occurred while writing the cache";
    public static final String CONFIG_SERVICE_CACHE_READ_ERROR = "Error occurred while reading the cache.";
    public static final String FETCH_FAILED_DUE_TO_UNEXPECTED_ERROR = "Unexpected error occurred while trying to fetch config JSON. It is most likely due to a local network issue. Please make sure your application can reach the ConfigCat CDN servers (or your proxy server) over HTTP.";
    private static final String FETCH_FAILED_DUE_TO_INVALID_SDK_KEY_ERROR = "Your SDK Key seems to be wrong. You can find the valid SDK Key at https://app.configcat.com/sdkkey";
    private static final String FETCH_FAILED_DUE_TO_REDIRECT_LOOP_ERROR = "Redirection loop encountered while trying to fetch config JSON. Please contact us at https://configcat.com/support/";
    private static final String FETCH_RECEIVED_200_WITH_INVALID_BODY_ERROR = "Fetching config JSON was successful but the HTTP response content was invalid.";

    private ConfigCatLogMessages() {
    }

    public static FormattableLogMessage getConfigJsonIsNotPresentedWithDefaultValue(String key, String defaultParamName, Object defaultParamValue) {
        return new FormattableLogMessage("Config JSON is not present when evaluating setting '%s'. Returning the `%s` parameter that you specified in your application: '%s'.", key, defaultParamName, defaultParamValue);
    }

    public static FormattableLogMessage getConfigJsonIsNotPresentedWithEmptyResult(String emptyResult) {
        return new FormattableLogMessage("Config JSON is not present. Returning %s.", emptyResult);
    }

    public static FormattableLogMessage getSettingEvaluationFailedDueToMissingKey(String key, String defaultParamName, Object defaultParamValue, Set<String> availableKeysSet) {
        return new FormattableLogMessageWithKeySet("Failed to evaluate setting '%s' (the key was not found in config JSON). Returning the `%s` parameter that you specified in your application: '%s'. Available keys: [%s].", key, defaultParamName, defaultParamValue, availableKeysSet);
    }

    public static FormattableLogMessage getSettingEvaluationErrorWithDefaultValue(String methodName, String key, String defaultParamName, Object defaultParamValue) {
        return new FormattableLogMessage("Error occurred in the `%s` method while evaluating setting '%s'. Returning the `%s` parameter that you specified in your application: '%s'.", methodName, key, defaultParamName, defaultParamValue);
    }

    public static FormattableLogMessage getSettingEvaluationErrorWithEmptyValue(String methodName, String emptyResult) {
        return new FormattableLogMessage("Error occurred in the `%s` method. Returning %s.", methodName, emptyResult);
    }

    public static FormattableLogMessage getForceRefreshError(String methodName) {
        return new FormattableLogMessage("Error occurred in the `%s` method.", methodName);
    }

    public static FormattableLogMessage getSettingEvaluationFailedForOtherReason(String key, String defaultParamName, Object defaultParamValue) {
        return new FormattableLogMessage("Failed to evaluate setting '%s'. Returning the `%s` parameter that you specified in your application: '%s'.", key, defaultParamName, defaultParamValue);
    }

    public static FormattableLogMessage getSettingForVariationIdIsNotPresent(String variationId) {
        return new FormattableLogMessage("Could not find the setting for the specified variation ID: '%s'.", variationId);
    }

    public static FormattableLogMessage getFetchFailedDueToInvalidSDKKey(String cfRayId) {
        if (cfRayId != null) {
            return new FormattableLogMessage("Your SDK Key seems to be wrong. You can find the valid SDK Key at https://app.configcat.com/sdkkey %s", ConfigCatLogMessages.getCFRayIdPostFix(cfRayId));
        }
        return new FormattableLogMessage(FETCH_FAILED_DUE_TO_INVALID_SDK_KEY_ERROR, new Object[0]);
    }

    public static FormattableLogMessage getFetchFailedDueToUnexpectedHttpResponse(int responseCode, String responseMessage, String cfRayId) {
        if (cfRayId != null) {
            return new FormattableLogMessage("Unexpected HTTP response was received while trying to fetch config JSON: %d %s %s", responseCode, responseMessage, ConfigCatLogMessages.getCFRayIdPostFix(cfRayId));
        }
        return new FormattableLogMessage("Unexpected HTTP response was received while trying to fetch config JSON: %d %s", responseCode, responseMessage);
    }

    public static FormattableLogMessage getFetchFailedDueToRequestTimeout(Integer connectTimeoutMillis, Integer readTimeoutMillis, Integer writeTimeoutMillis) {
        return new FormattableLogMessage("Request timed out while trying to fetch config JSON. Timeout values: [connect: %dms, read: %dms, write: %dms]", connectTimeoutMillis, readTimeoutMillis, writeTimeoutMillis);
    }

    public static FormattableLogMessage getFetchFailedDueToRedirectLoop(String cfRayId) {
        if (cfRayId != null) {
            return new FormattableLogMessage("Redirection loop encountered while trying to fetch config JSON. Please contact us at https://configcat.com/support/ %s", ConfigCatLogMessages.getCFRayIdPostFix(cfRayId));
        }
        return new FormattableLogMessage(FETCH_FAILED_DUE_TO_REDIRECT_LOOP_ERROR, new Object[0]);
    }

    public static FormattableLogMessage getFetchReceived200WithInvalidBodyError(String cfRayId) {
        if (cfRayId != null) {
            return new FormattableLogMessage("Fetching config JSON was successful but the HTTP response content was invalid. %s", ConfigCatLogMessages.getCFRayIdPostFix(cfRayId));
        }
        return new FormattableLogMessage(FETCH_RECEIVED_200_WITH_INVALID_BODY_ERROR, new Object[0]);
    }

    public static FormattableLogMessage getLocalFileDataSourceDoesNotExist(String filePath) {
        return new FormattableLogMessage("Cannot find the local config file '%s'. This is a path that your application provided to the ConfigCat SDK by passing it to the `OverrideDataSourceBuilder.localFile()` method. Read more: https://configcat.com/docs/sdk-reference/java/#json-file", filePath);
    }

    public static FormattableLogMessage getLocalFileDataSourceFailedToReadFile(String filePath) {
        return new FormattableLogMessage("Failed to read the local config file '%s'.", filePath);
    }

    public static FormattableLogMessage getClientIsAlreadyCreated(String sdkKey) {
        return new FormattableLogMessage("There is an existing client instance for the specified SDK Key. No new client instance will be created and the specified options callback is ignored. Returning the existing client instance. SDK Key: '%s'.", sdkKey);
    }

    public static FormattableLogMessage getUserObjectMissing(String key) {
        return new FormattableLogMessage("Cannot evaluate targeting rules and %% options for setting '%s' (User Object is missing). You should pass a User Object to the evaluation methods like `getValue()`/`getValueAsync()` in order to make targeting work properly. Read more: https://configcat.com/docs/advanced/user-object/", key);
    }

    public static FormattableLogMessage getUserAttributeMissing(String key, UserCondition userCondition, String attributeName) {
        return new FormattableLogMessageWithUserCondition("Cannot evaluate condition (%s) for setting '%s' (the User.%s attribute is missing). You should set the User.%s attribute in order to make targeting work properly. Read more: https://configcat.com/docs/advanced/user-object/", userCondition, key, attributeName, attributeName);
    }

    public static FormattableLogMessage getUserAttributeMissing(String key, String attributeName) {
        return new FormattableLogMessage("Cannot evaluate %% options for setting '%s' (the User.%s attribute is missing). You should set the User.%s attribute in order to make targeting work properly. Read more: https://configcat.com/docs/advanced/user-object/", key, attributeName, attributeName);
    }

    public static FormattableLogMessage getUserAttributeInvalid(String key, UserCondition userCondition, String reason, String attributeName) {
        return new FormattableLogMessageWithUserCondition("Cannot evaluate condition (%s) for setting '%s' (%s). Please check the User.%s attribute and make sure that its value corresponds to the comparison operator.", userCondition, key, reason, attributeName);
    }

    public static FormattableLogMessage getUserObjectAttributeIsAutoConverted(String key, UserCondition userCondition, String attributeName, String attributeValue) {
        return new FormattableLogMessageWithUserCondition("Evaluation of condition (%s) for setting '%s' may not produce the expected result (the User.%s attribute is not a string value, thus it was automatically converted to the string value '%s'). Please make sure that using a non-string value was intended.", userCondition, key, attributeName, attributeValue);
    }

    public static FormattableLogMessage getConfigServiceMethodHasNoEffectDueToClosedClient(String methodName) {
        return new FormattableLogMessage("The client object is already closed, thus `%s` has no effect.", methodName);
    }

    public static FormattableLogMessage getAutoPollMaxInitWaitTimeReached(int maxInitWaitTimeSeconds) {
        return new FormattableLogMessage("`maxInitWaitTimeSeconds` for the very first fetch reached (%ds). Returning cached config.", maxInitWaitTimeSeconds);
    }

    public static FormattableLogMessage getConfigServiceStatusChanged(String mode) {
        return new FormattableLogMessage("Switched to %s mode.", mode);
    }

    public static FormattableLogMessage getCFRayIdPostFix(String rayId) {
        return new FormattableLogMessage("(Ray ID: %s)", rayId);
    }
}

