/*
 * Decompiled with CFR 0.152.
 */
package com.configcat;

import com.configcat.DateTimeUtils;
import com.configcat.Utils;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Locale;

final class UserAttributeConverter {
    UserAttributeConverter() {
    }

    public static String userAttributeToString(Object userAttribute) {
        if (userAttribute == null) {
            return null;
        }
        if (userAttribute instanceof String) {
            return (String)userAttribute;
        }
        if (userAttribute instanceof String[]) {
            return Utils.gson.toJson(userAttribute);
        }
        if (userAttribute instanceof List) {
            return Utils.gson.toJson(userAttribute);
        }
        if (userAttribute instanceof Date) {
            Date userAttributeDate = (Date)userAttribute;
            return UserAttributeConverter.doubleToString(DateTimeUtils.getUnixSeconds(userAttributeDate));
        }
        if (userAttribute instanceof Instant) {
            Instant userAttributeInstant = (Instant)userAttribute;
            return UserAttributeConverter.doubleToString(DateTimeUtils.getUnixSeconds(userAttributeInstant));
        }
        if (userAttribute instanceof Float) {
            return UserAttributeConverter.doubleToString(((Float)userAttribute).doubleValue());
        }
        if (userAttribute instanceof Double) {
            return UserAttributeConverter.doubleToString((Double)userAttribute);
        }
        return userAttribute.toString();
    }

    private static String doubleToString(Double doubleToString) {
        if (doubleToString.isNaN() || doubleToString.isInfinite()) {
            return doubleToString.toString();
        }
        double abs = Math.abs(doubleToString);
        DecimalFormat fmt = 1.0E-6 <= abs && abs < 1.0E21 ? new DecimalFormat("#.#################") : new DecimalFormat("#.#################E0");
        DecimalFormatSymbols SYMBOLS = DecimalFormatSymbols.getInstance(Locale.UK);
        if (abs > 1.0) {
            SYMBOLS.setExponentSeparator("e+");
        } else {
            SYMBOLS.setExponentSeparator("e");
        }
        fmt.setDecimalFormatSymbols(SYMBOLS);
        return fmt.format(doubleToString);
    }

    public static Double userAttributeToDouble(Object userAttribute) {
        if (userAttribute == null) {
            return null;
        }
        if (userAttribute instanceof Double) {
            return (Double)userAttribute;
        }
        if (userAttribute instanceof String) {
            return Double.parseDouble(((String)userAttribute).trim().replace(",", "."));
        }
        if (userAttribute instanceof Integer) {
            return ((Integer)userAttribute).doubleValue();
        }
        if (userAttribute instanceof Float) {
            return ((Float)userAttribute).doubleValue();
        }
        if (userAttribute instanceof Long) {
            return ((Long)userAttribute).doubleValue();
        }
        if (userAttribute instanceof Byte) {
            return ((Byte)userAttribute).doubleValue();
        }
        if (userAttribute instanceof Short) {
            return ((Short)userAttribute).doubleValue();
        }
        throw new NumberFormatException();
    }
}

