/*
 * Decompiled with CFR 0.152.
 */
package com.configcat;

import com.configcat.ClientCacheState;
import com.configcat.EvaluationDetails;
import com.configcat.Setting;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;

public class ConfigCatHooks {
    private final AtomicReference<ClientCacheState> clientCacheState = new AtomicReference<Object>(null);
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final List<Consumer<Map<String, Setting>>> onConfigChanged = new ArrayList<Consumer<Map<String, Setting>>>();
    private final List<Consumer<ClientCacheState>> onClientReadyWithState = new ArrayList<Consumer<ClientCacheState>>();
    private final List<Runnable> onClientReady = new ArrayList<Runnable>();
    private final List<Consumer<EvaluationDetails<Object>>> onFlagEvaluated = new ArrayList<Consumer<EvaluationDetails<Object>>>();
    private final List<Consumer<String>> onError = new ArrayList<Consumer<String>>();

    public void addOnClientReady(Consumer<ClientCacheState> callback) {
        this.lock.writeLock().lock();
        try {
            if (this.clientCacheState.get() != null) {
                callback.accept(this.clientCacheState.get());
            } else {
                this.onClientReadyWithState.add(callback);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Deprecated
    public void addOnClientReady(Runnable callback) {
        this.lock.writeLock().lock();
        try {
            this.onClientReady.add(callback);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void addOnConfigChanged(Consumer<Map<String, Setting>> callback) {
        this.lock.writeLock().lock();
        try {
            this.onConfigChanged.add(callback);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void addOnError(Consumer<String> callback) {
        this.lock.writeLock().lock();
        try {
            this.onError.add(callback);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void addOnFlagEvaluated(Consumer<EvaluationDetails<Object>> callback) {
        this.lock.writeLock().lock();
        try {
            this.onFlagEvaluated.add(callback);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invokeOnClientReady(ClientCacheState clientCacheState) {
        this.lock.readLock().lock();
        try {
            this.clientCacheState.set(clientCacheState);
            for (Consumer<ClientCacheState> consumer : this.onClientReadyWithState) {
                consumer.accept(clientCacheState);
            }
            for (Runnable runnable : this.onClientReady) {
                runnable.run();
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invokeOnError(Object error) {
        this.lock.readLock().lock();
        try {
            if (!this.onError.isEmpty()) {
                String errorMessage = error.toString();
                for (Consumer<String> func : this.onError) {
                    func.accept(errorMessage);
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invokeOnConfigChanged(Map<String, Setting> settingMap) {
        this.lock.readLock().lock();
        try {
            for (Consumer<Map<String, Setting>> func : this.onConfigChanged) {
                func.accept(settingMap);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invokeOnFlagEvaluated(EvaluationDetails<Object> evaluationDetails) {
        this.lock.readLock().lock();
        try {
            for (Consumer<EvaluationDetails<Object>> func : this.onFlagEvaluated) {
                func.accept(evaluationDetails);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    void clear() {
        this.lock.writeLock().lock();
        try {
            this.onConfigChanged.clear();
            this.onError.clear();
            this.onFlagEvaluated.clear();
            this.onClientReady.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

