/*
 * Decompiled with CFR 0.152.
 */
package com.configcat;

import com.configcat.DateTimeUtils;
import com.configcat.LogLevel;
import com.configcat.PrerequisiteComparator;
import com.configcat.PrerequisiteFlagCondition;
import com.configcat.Segment;
import com.configcat.SegmentComparator;
import com.configcat.SegmentCondition;
import com.configcat.SettingValue;
import com.configcat.TargetingRule;
import com.configcat.User;
import com.configcat.UserComparator;
import com.configcat.UserCondition;
import com.configcat.Utils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class EvaluateLogger {
    private static final String HASHED_VALUE = "<hashed value>";
    public static final String INVALID_VALUE = "<invalid value>";
    public static final String INVALID_NAME = "<invalid name>";
    public static final String INVALID_REFERENCE = "<invalid reference>";
    private static final int MAX_LIST_ELEMENT = 10;
    private final StringBuilder stringBuilder = new StringBuilder();
    private int indentLevel = 0;
    private final boolean isLoggable;

    public EvaluateLogger(LogLevel logLevel) {
        this.isLoggable = logLevel.ordinal() <= LogLevel.INFO.ordinal();
    }

    public final boolean isLoggable() {
        return this.isLoggable;
    }

    public final void logUserObject(User user) {
        if (!this.isLoggable) {
            return;
        }
        this.append(" for User '" + user.toString() + "'");
    }

    public final void logEvaluation(String key) {
        if (!this.isLoggable) {
            return;
        }
        this.append("Evaluating '" + key + "'");
    }

    public final void logPercentageOptionUserMissing() {
        if (!this.isLoggable) {
            return;
        }
        this.newLine();
        this.append("Skipping % options because the User Object is missing.");
    }

    public final void logPercentageOptionUserAttributeMissing(String percentageOptionsAttributeName) {
        if (!this.isLoggable) {
            return;
        }
        this.newLine();
        this.append("Skipping % options because the User." + percentageOptionsAttributeName + " attribute is missing.");
    }

    public final void logPercentageOptionEvaluation(String percentageOptionsAttributeName) {
        if (!this.isLoggable) {
            return;
        }
        this.newLine();
        this.append("Evaluating % options based on the User." + percentageOptionsAttributeName + " attribute:");
    }

    public final void logPercentageOptionEvaluationHash(String percentageOptionsAttributeName, int hashValue) {
        if (!this.isLoggable) {
            return;
        }
        this.newLine();
        this.append("- Computing hash in the [0..99] range from User." + percentageOptionsAttributeName + " => " + hashValue + " (this value is sticky and consistent across all SDKs)");
    }

    public final void append(String line) {
        if (!this.isLoggable) {
            return;
        }
        this.stringBuilder.append(line);
    }

    public final void increaseIndentLevel() {
        if (!this.isLoggable) {
            return;
        }
        ++this.indentLevel;
    }

    public final void decreaseIndentLevel() {
        if (!this.isLoggable) {
            return;
        }
        if (this.indentLevel > 0) {
            --this.indentLevel;
        }
    }

    public final void newLine() {
        if (!this.isLoggable) {
            return;
        }
        this.stringBuilder.append(System.lineSeparator());
        for (int i = 0; i < this.indentLevel; ++i) {
            this.stringBuilder.append("  ");
        }
    }

    public String toPrint() {
        if (!this.isLoggable) {
            return "";
        }
        return this.stringBuilder.toString();
    }

    public void logReturnValue(String returnValue) {
        if (!this.isLoggable) {
            return;
        }
        this.newLine();
        this.append("Returning '" + returnValue + "'.");
    }

    public void logTargetingRules() {
        if (!this.isLoggable) {
            return;
        }
        this.newLine();
        this.append("Evaluating targeting rules and applying the first match if any:");
    }

    public void logConditionConsequence(boolean result) {
        if (!this.isLoggable) {
            return;
        }
        this.append(" => " + result);
        if (!result) {
            this.append(", skipping the remaining AND conditions");
        }
    }

    public void logTargetingRuleIgnored() {
        if (!this.isLoggable) {
            return;
        }
        this.increaseIndentLevel();
        this.newLine();
        this.append("The current targeting rule is ignored and the evaluation continues with the next rule.");
        this.decreaseIndentLevel();
    }

    public void logTargetingRuleConsequence(TargetingRule targetingRule, String error, boolean isMatch, boolean newLine) {
        if (!this.isLoggable) {
            return;
        }
        this.increaseIndentLevel();
        String valueFormat = "% options";
        if (targetingRule != null && targetingRule.getSimpleValue() != null && targetingRule.getSimpleValue().getValue() != null) {
            valueFormat = "'" + targetingRule.getSimpleValue().getValue() + "'";
        }
        if (newLine) {
            this.newLine();
        } else {
            this.append(" ");
        }
        this.append("THEN " + valueFormat + " => ");
        if (error != null && !error.isEmpty()) {
            this.append(error);
        } else if (isMatch) {
            this.append("MATCH, applying rule");
        } else {
            this.append("no match");
        }
        this.decreaseIndentLevel();
    }

    public void logPercentageEvaluationReturnValue(int hashValue, int i, int percentage, SettingValue settingValue) {
        if (!this.isLoggable) {
            return;
        }
        String percentageOptionValue = settingValue != null ? settingValue.toString() : INVALID_VALUE;
        this.newLine();
        this.append("- Hash value " + hashValue + " selects % option " + (i + 1) + " (" + percentage + "%), '" + percentageOptionValue + "'.");
    }

    public void logSegmentEvaluationStart(String segmentName) {
        if (!this.isLoggable) {
            return;
        }
        this.newLine();
        this.append("(");
        this.increaseIndentLevel();
        this.newLine();
        this.append("Evaluating segment '" + segmentName + "':");
    }

    public void logSegmentEvaluationResult(SegmentCondition segmentCondition, Segment segment, boolean result, boolean segmentResult) {
        if (!this.isLoggable) {
            return;
        }
        this.newLine();
        String segmentResultComparator = segmentResult ? SegmentComparator.IS_IN_SEGMENT.getName() : SegmentComparator.IS_NOT_IN_SEGMENT.getName();
        this.append("Segment evaluation result: User " + segmentResultComparator + ".");
        this.newLine();
        this.append("Condition (" + EvaluateLogger.formatSegmentFlagCondition(segmentCondition, segment) + ") evaluates to " + result + ".");
        this.decreaseIndentLevel();
        this.newLine();
        this.append(")");
    }

    public void logSegmentEvaluationError(SegmentCondition segmentCondition, Segment segment, String error) {
        if (!this.isLoggable) {
            return;
        }
        this.newLine();
        this.append("Segment evaluation result: " + error + ".");
        this.newLine();
        this.append("Condition (" + EvaluateLogger.formatSegmentFlagCondition(segmentCondition, segment) + ") failed to evaluate.");
        this.decreaseIndentLevel();
        this.newLine();
        this.append(")");
    }

    public void logPrerequisiteFlagEvaluationStart(String prerequisiteFlagKey) {
        if (!this.isLoggable) {
            return;
        }
        this.newLine();
        this.append("(");
        this.increaseIndentLevel();
        this.newLine();
        this.append("Evaluating prerequisite flag '" + prerequisiteFlagKey + "':");
    }

    public void logPrerequisiteFlagEvaluationResult(PrerequisiteFlagCondition prerequisiteFlagCondition, SettingValue prerequisiteFlagValue, boolean result) {
        if (!this.isLoggable) {
            return;
        }
        this.newLine();
        String prerequisiteFlagValueFormat = prerequisiteFlagValue != null ? prerequisiteFlagValue.toString() : INVALID_VALUE;
        this.append("Prerequisite flag evaluation result: '" + prerequisiteFlagValueFormat + "'.");
        this.newLine();
        this.append("Condition (" + EvaluateLogger.formatPrerequisiteFlagCondition(prerequisiteFlagCondition) + ") evaluates to " + result + ".");
        this.decreaseIndentLevel();
        this.newLine();
        this.append(")");
    }

    private static String formatStringListComparisonValue(String[] comparisonValue, boolean isSensitive) {
        String formattedList;
        if (comparisonValue == null) {
            return INVALID_VALUE;
        }
        ArrayList<String> comparisonValues = new ArrayList<String>(Arrays.asList(comparisonValue));
        if (comparisonValues.isEmpty()) {
            return INVALID_VALUE;
        }
        if (isSensitive) {
            String sensitivePostFix = comparisonValues.size() == 1 ? "value" : "values";
            formattedList = "<" + comparisonValues.size() + " hashed " + sensitivePostFix + ">";
        } else {
            String listPostFix = "";
            if (comparisonValues.size() > 10) {
                int count = comparisonValues.size() - 10;
                String countPostFix = count == 1 ? "value" : "values";
                listPostFix = ", ... <" + count + " more " + countPostFix + ">";
            }
            List subList = comparisonValues.subList(0, Math.min(10, comparisonValues.size()));
            StringBuilder formatListBuilder = new StringBuilder();
            int subListSize = subList.size();
            for (int i = 0; i < subListSize; ++i) {
                formatListBuilder.append("'").append((String)subList.get(i)).append("'");
                if (i == subListSize - 1) continue;
                formatListBuilder.append(", ");
            }
            formatListBuilder.append(listPostFix);
            formattedList = formatListBuilder.toString();
        }
        return "[" + formattedList + "]";
    }

    private static String formatStringComparisonValue(String comparisonValue, boolean isSensitive) {
        return "'" + (isSensitive ? HASHED_VALUE : comparisonValue) + "'";
    }

    private static String formatDoubleComparisonValue(Double comparisonValue, boolean isDate) {
        if (comparisonValue == null) {
            return INVALID_VALUE;
        }
        DecimalFormat decimalFormat = Utils.getDecimalFormat();
        if (isDate) {
            return "'" + decimalFormat.format(comparisonValue) + "' (" + DateTimeUtils.doubleToFormattedUTC(comparisonValue) + " UTC)";
        }
        return "'" + decimalFormat.format(comparisonValue) + "'";
    }

    public static String formatUserCondition(UserCondition userCondition) {
        String comparisonValue;
        UserComparator userComparator = UserComparator.fromId(userCondition.getComparator());
        if (userComparator == null) {
            throw new IllegalArgumentException("Comparison operator is invalid.");
        }
        switch (userComparator) {
            case IS_ONE_OF: 
            case IS_NOT_ONE_OF: 
            case CONTAINS_ANY_OF: 
            case NOT_CONTAINS_ANY_OF: 
            case SEMVER_IS_ONE_OF: 
            case SEMVER_IS_NOT_ONE_OF: 
            case TEXT_STARTS_WITH: 
            case TEXT_NOT_STARTS_WITH: 
            case TEXT_ENDS_WITH: 
            case TEXT_NOT_ENDS_WITH: 
            case TEXT_ARRAY_CONTAINS: 
            case TEXT_ARRAY_NOT_CONTAINS: {
                comparisonValue = EvaluateLogger.formatStringListComparisonValue(userCondition.getStringArrayValue(), false);
                break;
            }
            case SEMVER_LESS: 
            case SEMVER_LESS_EQUALS: 
            case SEMVER_GREATER: 
            case SEMVER_GREATER_EQUALS: 
            case TEXT_EQUALS: 
            case TEXT_NOT_EQUALS: {
                comparisonValue = EvaluateLogger.formatStringComparisonValue(userCondition.getStringValue(), false);
                break;
            }
            case NUMBER_EQUALS: 
            case NUMBER_NOT_EQUALS: 
            case NUMBER_LESS: 
            case NUMBER_LESS_EQUALS: 
            case NUMBER_GREATER: 
            case NUMBER_GREATER_EQUALS: {
                comparisonValue = EvaluateLogger.formatDoubleComparisonValue(userCondition.getDoubleValue(), false);
                break;
            }
            case SENSITIVE_IS_ONE_OF: 
            case SENSITIVE_IS_NOT_ONE_OF: 
            case HASHED_STARTS_WITH: 
            case HASHED_NOT_STARTS_WITH: 
            case HASHED_ENDS_WITH: 
            case HASHED_NOT_ENDS_WITH: 
            case HASHED_ARRAY_CONTAINS: 
            case HASHED_ARRAY_NOT_CONTAINS: {
                comparisonValue = EvaluateLogger.formatStringListComparisonValue(userCondition.getStringArrayValue(), true);
                break;
            }
            case DATE_BEFORE: 
            case DATE_AFTER: {
                comparisonValue = EvaluateLogger.formatDoubleComparisonValue(userCondition.getDoubleValue(), true);
                break;
            }
            case HASHED_EQUALS: 
            case HASHED_NOT_EQUALS: {
                comparisonValue = EvaluateLogger.formatStringComparisonValue(userCondition.getStringValue(), true);
                break;
            }
            default: {
                comparisonValue = INVALID_VALUE;
            }
        }
        return "User." + userCondition.getComparisonAttribute() + " " + userComparator.getName() + " " + comparisonValue;
    }

    public static String formatSegmentFlagCondition(SegmentCondition segmentCondition, Segment segment) {
        SegmentComparator segmentComparator;
        String segmentName;
        if (segment != null) {
            segmentName = segment.getName();
            if (segmentName == null || segmentName.isEmpty()) {
                segmentName = INVALID_NAME;
            }
        } else {
            segmentName = INVALID_REFERENCE;
        }
        if ((segmentComparator = SegmentComparator.fromId(segmentCondition.getSegmentComparator())) == null) {
            throw new IllegalArgumentException("Segment comparison operator is invalid.");
        }
        return "User " + segmentComparator.getName() + " '" + segmentName + "'";
    }

    public static String formatPrerequisiteFlagCondition(PrerequisiteFlagCondition prerequisiteFlagCondition) {
        String prerequisiteFlagKey = prerequisiteFlagCondition.getPrerequisiteFlagKey();
        PrerequisiteComparator prerequisiteComparator = PrerequisiteComparator.fromId(prerequisiteFlagCondition.getPrerequisiteComparator());
        if (prerequisiteComparator == null) {
            throw new IllegalArgumentException("Prerequisite Flag comparison operator is invalid.");
        }
        SettingValue prerequisiteValue = prerequisiteFlagCondition.getValue();
        String comparisonValue = prerequisiteValue == null ? INVALID_VALUE : prerequisiteValue.toString();
        return "Flag '" + prerequisiteFlagKey + "' " + prerequisiteComparator.getName() + " '" + comparisonValue + "'";
    }

    public static String formatCircularDependencyList(List<String> visitedKeys, String key) {
        StringBuilder builder = new StringBuilder();
        visitedKeys.forEach(visitedKey -> builder.append("'").append((String)visitedKey).append("' -> "));
        builder.append("'").append(key).append("'");
        return builder.toString();
    }
}

