/*
 * Decompiled with CFR 0.152.
 */
package com.configcat;

import com.configcat.PercentageOption;
import com.configcat.TargetingRule;
import com.configcat.User;

public class EvaluationDetails<T> {
    private final T value;
    private final String key;
    private final String variationId;
    private final User user;
    private final boolean isDefaultValue;
    private final Object error;
    private final long fetchTimeUnixMilliseconds;
    private final TargetingRule matchedTargetingRule;
    private final PercentageOption matchedPercentageOption;

    public EvaluationDetails(T value, String key, String variationId, User user, boolean isDefaultValue, Object error, long fetchTimeUnixMilliseconds, TargetingRule matchedTargetingRule, PercentageOption matchedPercentageOption) {
        this.value = value;
        this.key = key;
        this.variationId = variationId;
        this.user = user;
        this.isDefaultValue = isDefaultValue;
        this.error = error;
        this.fetchTimeUnixMilliseconds = fetchTimeUnixMilliseconds;
        this.matchedTargetingRule = matchedTargetingRule;
        this.matchedPercentageOption = matchedPercentageOption;
    }

    static <T> EvaluationDetails<T> fromError(String key, T defaultValue, Object error, User user) {
        return new EvaluationDetails<T>(defaultValue, key, "", user, true, error, 0L, null, null);
    }

    <TR> EvaluationDetails<TR> asTypeSpecific() {
        return new EvaluationDetails<T>(this.value, this.key, this.variationId, this.user, this.isDefaultValue, this.error, this.fetchTimeUnixMilliseconds, this.matchedTargetingRule, this.matchedPercentageOption);
    }

    public T getValue() {
        return this.value;
    }

    public String getKey() {
        return this.key;
    }

    public String getVariationId() {
        return this.variationId;
    }

    public User getUser() {
        return this.user;
    }

    public boolean isDefaultValue() {
        return this.isDefaultValue;
    }

    public String getError() {
        if (this.error != null) {
            return this.error.toString();
        }
        return null;
    }

    public Long getFetchTimeUnixMilliseconds() {
        return this.fetchTimeUnixMilliseconds;
    }

    public TargetingRule getMatchedTargetingRule() {
        return this.matchedTargetingRule;
    }

    public PercentageOption getMatchedPercentageOption() {
        return this.matchedPercentageOption;
    }
}

