/*
 * Decompiled with CFR 0.152.
 */
package com.configcat;

import com.configcat.AutoPollingMode;
import com.configcat.LazyLoadingMode;
import com.configcat.ManualPollingMode;
import com.configcat.PollingMode;

public final class PollingModes {
    private static final int DEFAULT_AUTO_POLL_INTERVAL_IN_SECONDS = 60;
    private static final int DEFAULT_MAX_INIT_WAIT_TIME_IN_SECONDS = 5;
    private static final int DEFAULT_CACHE_REFRESH_INTERVAL_IN_SECONDS = 60;

    public static PollingMode autoPoll() {
        return new AutoPollingMode(60, 5);
    }

    public static PollingMode autoPoll(int autoPollIntervalInSeconds) {
        return new AutoPollingMode(autoPollIntervalInSeconds, 5);
    }

    public static PollingMode autoPoll(int autoPollIntervalInSeconds, int maxInitWaitTimeSeconds) {
        return new AutoPollingMode(autoPollIntervalInSeconds, maxInitWaitTimeSeconds);
    }

    public static PollingMode lazyLoad() {
        return new LazyLoadingMode(60);
    }

    public static PollingMode lazyLoad(int cacheRefreshIntervalInSeconds) {
        return new LazyLoadingMode(cacheRefreshIntervalInSeconds);
    }

    public static PollingMode manualPoll() {
        return new ManualPollingMode();
    }
}

