/*
 * Decompiled with CFR 0.152.
 */
package com.configcat;

import com.configcat.Config;
import com.configcat.Segment;
import com.configcat.Setting;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;

final class Utils {
    static final Gson gson = new GsonBuilder().disableHtmlEscaping().create();

    private Utils() {
    }

    public static String sha256(byte[] byteArray) {
        return new String(Hex.encodeHex((byte[])DigestUtils.sha256((byte[])byteArray)));
    }

    public static String sha256(String text) {
        return new String(Hex.encodeHex((byte[])DigestUtils.sha256((String)text)));
    }

    public static String sha1(String text) {
        return new String(Hex.encodeHex((byte[])DigestUtils.sha1((String)text)));
    }

    public static String sha1(byte[] byteArray) {
        return new String(Hex.encodeHex((byte[])DigestUtils.sha1((byte[])byteArray)));
    }

    public static DecimalFormat getDecimalFormat() {
        DecimalFormat decimalFormat = new DecimalFormat("0.#####");
        decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.UK));
        return decimalFormat;
    }

    public static Config deserializeConfig(String json) {
        if (json == null || json.isEmpty()) {
            throw new IllegalArgumentException("Config JSON content cannot be null or empty.");
        }
        Config config = (Config)gson.fromJson(json, Config.class);
        if (config == null) {
            throw new IllegalArgumentException("Invalid config JSON content: " + json);
        }
        String salt = config.getPreferences() != null ? config.getPreferences().getSalt() : null;
        Segment[] segments = config.getSegments();
        if (segments == null) {
            segments = new Segment[]{};
        }
        for (Setting setting : config.getEntries().values()) {
            setting.setConfigSalt(salt);
            setting.setSegments(segments);
        }
        return config;
    }
}

