//	---------------------------------------------------------------------------
//	dark-matter-data
//	Copyright (c) 2010-2021 dark-matter-data committers
//	---------------------------------------------------------------------------
//	This program is free software; you can redistribute it and/or modify it
//	under the terms of the GNU Lesser General Public License as published by the
//	Free Software Foundation; either version 3 of the License, or (at your
//	option) any later version.
//	This program is distributed in the hope that it will be useful, but WITHOUT
//	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
//	FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for
//	more details.
//	You should have received a copy of the GNU Lesser General Public License along
//	with this program; if not, see <http://www.gnu.org/licenses/lgpl.html>.
//	---------------------------------------------------------------------------
package org.dmd.dmg.generated.dmo;

// Generated from: org.dmd.dms.util.GenUtility.formatImports(GenUtility.java:408)
import java.io.Serializable;                                   // Always required - (GenUtility.java:227)
import java.util.*;                                            // Always required if we have any MV attributes - (GenUtility.java:224)
import org.dmd.dmc.DmcAttribute;                               // Any attributes - (GenUtility.java:248)
import org.dmd.dmc.DmcObject;                                  // Structural class - (GenUtility.java:362)
import org.dmd.dmc.DmcSliceInfo;                               // Required for object slicing - (GenUtility.java:232)
import org.dmd.dmc.DmcValueException;                          // Any attributes - (GenUtility.java:249)
import org.dmd.dmg.generated.types.DmcTypeGeneratorMV;         // Required type - (GenUtility.java:339)
import org.dmd.dmg.types.Generator;                            // Primitive type - (GenUtility.java:282)
import org.dmd.dms.generated.dmo.MetaDMSAG;                    // Required for MODREC constructor - (GenUtility.java:231)
import org.dmd.dms.generated.types.DmcTypeModifierMV;          // Required for MODREC constructor - (GenUtility.java:230)
import org.dmd.dms.generated.types.DmcTypeStringMV;            // Required type - (GenUtility.java:339)
import org.dmd.dms.generated.types.DmcTypeStringSV;            // Required type - (GenUtility.java:339)

// Generated from: org.dmd.dms.util.DmoFormatter.getClassHeader(DmoFormatter.java:678)
/**
 * The DmgConfig class is used to specify a set of schemas and a set of \n
 * code generators to be run when you want to generate various types of code.
 * <P>
 * Generated from the dmg schema at version 0.1
 * <P>
 * This code was auto-generated by the dmogenerator utility and shouldn't be alterred manually!
 * Generated from: org.dmd.dms.util.DmoFormatter.dumpDMO(DmoFormatter.java:134)
 */
@SuppressWarnings("serial")
public class DmgConfigDMO  extends DmcObject  implements Serializable  {

    public final static String constructionClassName = "DmgConfig";


    static {
    }

    public DmgConfigDMO() {
        super("DmgConfig");
    }

    protected DmgConfigDMO(String oc) {
        super(oc);
    }

    @Override
    public DmgConfigDMO getNew(){
        DmgConfigDMO rc = new DmgConfigDMO();
        return(rc);
    }

    @Override
    public DmgConfigDMO getSlice(DmcSliceInfo info){
        DmgConfigDMO rc = new DmgConfigDMO();
        populateSlice(rc,info);
        return(rc);
    }

    public DmgConfigDMO(DmcTypeModifierMV mods) {
        super("DmgConfig");
        modrec(true);
        setModifier(mods);
    }

    public DmgConfigDMO getModificationRecorder(){
        DmgConfigDMO rc = new DmgConfigDMO();
        rc.setModifier(new DmcTypeModifierMV(MetaDMSAG.__modify));
        rc.modrec(true);
        return(rc);
    }

    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:798)
    public String getSchemaToLoad(){
        DmcTypeStringSV attr = (DmcTypeStringSV) get(DmgDMSAG.__schemaToLoad);
        if (attr == null)
            return(null);

        return(attr.getSV());
    }

    /**
     * Sets schemaToLoad to the specified value.
     * @param value String
     */
    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:838)
    public void setSchemaToLoad(String value) {
        DmcAttribute<?> attr = get(DmgDMSAG.__schemaToLoad);
        if (attr == null)
            attr = new DmcTypeStringSV(DmgDMSAG.__schemaToLoad);
        
        try{
            attr.set(value);
            set(DmgDMSAG.__schemaToLoad,attr);
        }
        catch(DmcValueException ex){
            throw(new IllegalStateException("The type specific set() method shouldn't throw exceptions!",ex));
        }
    }

    /**
     * Sets schemaToLoad to the specified value.
     * @param value A value compatible with DmcTypeStringSV
     * @throws DmcValueException if value is not correct
     */
    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:892)
    public void setSchemaToLoad(Object value) throws DmcValueException {
        DmcTypeStringSV attr  = (DmcTypeStringSV) get(DmgDMSAG.__schemaToLoad);
        if (attr == null)
            attr = new DmcTypeStringSV(DmgDMSAG.__schemaToLoad);
        
        attr.set(value);
        set(DmgDMSAG.__schemaToLoad,attr);
    }

    /**
     * Removes the schemaToLoad attribute value.
     */
    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:912)
    public void remSchemaToLoad(){
         rem(DmgDMSAG.__schemaToLoad);
    }

    /**
     * @return An Iterator of String objects.
     */
    @SuppressWarnings("unchecked")
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1289)
    public Iterator<String> getConfigSuffix(){
        DmcTypeStringMV attr = (DmcTypeStringMV) get(DmgDMSAG.__configSuffix);
        if (attr == null)
            return( ((List<String>) Collections.EMPTY_LIST).iterator());

        return(attr.getMV());
    }

    /**
     * @param i the index
     * @return The nth String value.
     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1302)
    public String getNthConfigSuffix(int i){
        DmcTypeStringMV attr = (DmcTypeStringMV) get(DmgDMSAG.__configSuffix);
        if (attr == null)
            return(null);

        return(attr.getMVnth(i));
    }

    /**
     * Adds another configSuffix to the specified value.
     * @param value String
     * @return the attribute instance
     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1317)
    public DmcAttribute<?> addConfigSuffix(String value) {
        DmcAttribute<?> attr = get(DmgDMSAG.__configSuffix);
        if (attr == null)
            attr = new DmcTypeStringMV(DmgDMSAG.__configSuffix);
        
        try{
            setLastValue(attr.add(value));
            add(DmgDMSAG.__configSuffix,attr);
        }
        catch(DmcValueException ex){
            throw(new IllegalStateException("The type specific add() method shouldn't throw exceptions!",ex));
        }
        return(attr);
    }

    /**
     * @param value String
     * @return true if we contain a valued keyed by the specified String.
     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1392)
    public boolean configSuffixContains(String value) {
        DmcAttribute<?> attr = get(DmgDMSAG.__configSuffix);
        if (attr == null)
            return(false);
        return(attr.contains(value));
    }

    /**
     * Adds another configSuffix value.
     * @param value A value compatible with String
     * @return the attribute instance
     * @throws DmcValueException if value is not correct
     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1426)
    public DmcAttribute<?> addConfigSuffix(Object value) throws DmcValueException {
        DmcAttribute<?> attr = get(DmgDMSAG.__configSuffix);
        if (attr == null)
            attr = new DmcTypeStringMV(DmgDMSAG.__configSuffix);
        
        setLastValue(attr.add(value));
        add(DmgDMSAG.__configSuffix,attr);
        return(attr);
    }

    /**
     * @return the number of values in configSuffix
     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1443)
    public int getConfigSuffixSize(){
        DmcAttribute<?> attr = get(DmgDMSAG.__configSuffix);
        if (attr == null){
            if (DmgDMSAG.__configSuffix.indexSize == 0)
                return(0);
            else
                return(DmgDMSAG.__configSuffix.indexSize);
        }
        return(attr.getMVSize());
    }

    /**
     * Deletes a configSuffix value.
     * @param value The String to be deleted from set of attribute values.
     * @return the deleted attribute instance
     * @throws DmcValueException if the value is incorrect
     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1505)
    public DmcAttribute<?> delConfigSuffix(Object value) throws DmcValueException {
        DmcAttribute<?> attr = get(DmgDMSAG.__configSuffix);
        
        if ( (attr == null) && (getModifier()!= null))
            delFromEmptyAttribute(new DmcTypeStringMV(DmgDMSAG.__configSuffix), value);
        else
            attr = del(DmgDMSAG.__configSuffix, value);
        
        return(attr);
    }

    /**
     * Deletes a configSuffix from the specified value.
     * @param value String
     * @return the deleted attribute instance     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1522)
    public DmcAttribute<?> delConfigSuffix(String value) {
        DmcAttribute<?> attr = get(DmgDMSAG.__configSuffix);
        
        if ( (attr == null) && (getModifier()!= null))
            delFromEmptyAttribute(new DmcTypeStringMV(DmgDMSAG.__configSuffix), value);
        else
            attr = del(DmgDMSAG.__configSuffix, value);
        
        return(attr);
    }

    /**
     * Removes the configSuffix attribute value.
     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1541)
    public void remConfigSuffix(){
         rem(DmgDMSAG.__configSuffix);
    }

    /**
     * @return An Iterator of String objects.
     */
    @SuppressWarnings("unchecked")
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1289)
    public Iterator<String> getDescription(){
        DmcTypeStringMV attr = (DmcTypeStringMV) get(MetaDMSAG.__description);
        if (attr == null)
            return( ((List<String>) Collections.EMPTY_LIST).iterator());

        return(attr.getMV());
    }

    /**
     * @param i the index
     * @return The nth String value.
     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1302)
    public String getNthDescription(int i){
        DmcTypeStringMV attr = (DmcTypeStringMV) get(MetaDMSAG.__description);
        if (attr == null)
            return(null);

        return(attr.getMVnth(i));
    }

    /**
     * Adds another description to the specified value.
     * @param value String
     * @return the attribute instance
     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1317)
    public DmcAttribute<?> addDescription(String value) {
        DmcAttribute<?> attr = get(MetaDMSAG.__description);
        if (attr == null)
            attr = new DmcTypeStringMV(MetaDMSAG.__description);
        
        try{
            setLastValue(attr.add(value));
            add(MetaDMSAG.__description,attr);
        }
        catch(DmcValueException ex){
            throw(new IllegalStateException("The type specific add() method shouldn't throw exceptions!",ex));
        }
        return(attr);
    }

    /**
     * @param value String
     * @return true if we contain a valued keyed by the specified String.
     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1392)
    public boolean descriptionContains(String value) {
        DmcAttribute<?> attr = get(MetaDMSAG.__description);
        if (attr == null)
            return(false);
        return(attr.contains(value));
    }

    /**
     * Adds another description value.
     * @param value A value compatible with String
     * @return the attribute instance
     * @throws DmcValueException if value is not correct
     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1426)
    public DmcAttribute<?> addDescription(Object value) throws DmcValueException {
        DmcAttribute<?> attr = get(MetaDMSAG.__description);
        if (attr == null)
            attr = new DmcTypeStringMV(MetaDMSAG.__description);
        
        setLastValue(attr.add(value));
        add(MetaDMSAG.__description,attr);
        return(attr);
    }

    /**
     * @return the number of values in description
     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1443)
    public int getDescriptionSize(){
        DmcAttribute<?> attr = get(MetaDMSAG.__description);
        if (attr == null){
            if (MetaDMSAG.__description.indexSize == 0)
                return(0);
            else
                return(MetaDMSAG.__description.indexSize);
        }
        return(attr.getMVSize());
    }

    /**
     * Deletes a description value.
     * @param value The String to be deleted from set of attribute values.
     * @return the deleted attribute instance
     * @throws DmcValueException if the value is incorrect
     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1505)
    public DmcAttribute<?> delDescription(Object value) throws DmcValueException {
        DmcAttribute<?> attr = get(MetaDMSAG.__description);
        
        if ( (attr == null) && (getModifier()!= null))
            delFromEmptyAttribute(new DmcTypeStringMV(MetaDMSAG.__description), value);
        else
            attr = del(MetaDMSAG.__description, value);
        
        return(attr);
    }

    /**
     * Deletes a description from the specified value.
     * @param value String
     * @return the deleted attribute instance     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1522)
    public DmcAttribute<?> delDescription(String value) {
        DmcAttribute<?> attr = get(MetaDMSAG.__description);
        
        if ( (attr == null) && (getModifier()!= null))
            delFromEmptyAttribute(new DmcTypeStringMV(MetaDMSAG.__description), value);
        else
            attr = del(MetaDMSAG.__description, value);
        
        return(attr);
    }

    /**
     * Removes the description attribute value.
     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1541)
    public void remDescription(){
         rem(MetaDMSAG.__description);
    }

    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:798)
    public String getGeneratedFileHeader(){
        DmcTypeStringSV attr = (DmcTypeStringSV) get(MetaDMSAG.__generatedFileHeader);
        if (attr == null)
            return(null);

        return(attr.getSV());
    }

    /**
     * Sets generatedFileHeader to the specified value.
     * @param value String
     */
    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:838)
    public void setGeneratedFileHeader(String value) {
        DmcAttribute<?> attr = get(MetaDMSAG.__generatedFileHeader);
        if (attr == null)
            attr = new DmcTypeStringSV(MetaDMSAG.__generatedFileHeader);
        
        try{
            attr.set(value);
            set(MetaDMSAG.__generatedFileHeader,attr);
        }
        catch(DmcValueException ex){
            throw(new IllegalStateException("The type specific set() method shouldn't throw exceptions!",ex));
        }
    }

    /**
     * Sets generatedFileHeader to the specified value.
     * @param value A value compatible with DmcTypeStringSV
     * @throws DmcValueException if value is not correct
     */
    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:892)
    public void setGeneratedFileHeader(Object value) throws DmcValueException {
        DmcTypeStringSV attr  = (DmcTypeStringSV) get(MetaDMSAG.__generatedFileHeader);
        if (attr == null)
            attr = new DmcTypeStringSV(MetaDMSAG.__generatedFileHeader);
        
        attr.set(value);
        set(MetaDMSAG.__generatedFileHeader,attr);
    }

    /**
     * Removes the generatedFileHeader attribute value.
     */
    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:912)
    public void remGeneratedFileHeader(){
         rem(MetaDMSAG.__generatedFileHeader);
    }

    /**
     * @return An Iterator of Generator objects.
     */
    @SuppressWarnings("unchecked")
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1289)
    public Iterator<Generator> getGenerator(){
        DmcTypeGeneratorMV attr = (DmcTypeGeneratorMV) get(DmgDMSAG.__generator);
        if (attr == null)
            return( ((List<Generator>) Collections.EMPTY_LIST).iterator());

        return(attr.getMV());
    }

    /**
     * @param i the index
     * @return The nth Generator value.
     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1302)
    public Generator getNthGenerator(int i){
        DmcTypeGeneratorMV attr = (DmcTypeGeneratorMV) get(DmgDMSAG.__generator);
        if (attr == null)
            return(null);

        return(attr.getMVnth(i));
    }

    /**
     * Adds another generator to the specified value.
     * @param value Generator
     * @return the attribute instance
     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1317)
    public DmcAttribute<?> addGenerator(Generator value) {
        DmcAttribute<?> attr = get(DmgDMSAG.__generator);
        if (attr == null)
            attr = new DmcTypeGeneratorMV(DmgDMSAG.__generator);
        
        try{
            setLastValue(attr.add(value));
            add(DmgDMSAG.__generator,attr);
        }
        catch(DmcValueException ex){
            throw(new IllegalStateException("The type specific add() method shouldn't throw exceptions!",ex));
        }
        return(attr);
    }

    /**
     * @param value Generator
     * @return true if we contain a valued keyed by the specified Generator.
     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1392)
    public boolean generatorContains(Generator value) {
        DmcAttribute<?> attr = get(DmgDMSAG.__generator);
        if (attr == null)
            return(false);
        return(attr.contains(value));
    }

    /**
     * Adds another generator value.
     * @param value A value compatible with Generator
     * @return the attribute instance
     * @throws DmcValueException if value is not correct
     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1426)
    public DmcAttribute<?> addGenerator(Object value) throws DmcValueException {
        DmcAttribute<?> attr = get(DmgDMSAG.__generator);
        if (attr == null)
            attr = new DmcTypeGeneratorMV(DmgDMSAG.__generator);
        
        setLastValue(attr.add(value));
        add(DmgDMSAG.__generator,attr);
        return(attr);
    }

    /**
     * @return the number of values in generator
     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1443)
    public int getGeneratorSize(){
        DmcAttribute<?> attr = get(DmgDMSAG.__generator);
        if (attr == null){
            if (DmgDMSAG.__generator.indexSize == 0)
                return(0);
            else
                return(DmgDMSAG.__generator.indexSize);
        }
        return(attr.getMVSize());
    }

    /**
     * Deletes a generator value.
     * @param value The Generator to be deleted from set of attribute values.
     * @return the deleted attribute instance
     * @throws DmcValueException if the value is incorrect
     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1505)
    public DmcAttribute<?> delGenerator(Object value) throws DmcValueException {
        DmcAttribute<?> attr = get(DmgDMSAG.__generator);
        
        if ( (attr == null) && (getModifier()!= null))
            delFromEmptyAttribute(new DmcTypeGeneratorMV(DmgDMSAG.__generator), value);
        else
            attr = del(DmgDMSAG.__generator, value);
        
        return(attr);
    }

    /**
     * Deletes a generator from the specified value.
     * @param value Generator
     * @return the deleted attribute instance     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1522)
    public DmcAttribute<?> delGenerator(Generator value) {
        DmcAttribute<?> attr = get(DmgDMSAG.__generator);
        
        if ( (attr == null) && (getModifier()!= null))
            delFromEmptyAttribute(new DmcTypeGeneratorMV(DmgDMSAG.__generator), value);
        else
            attr = del(DmgDMSAG.__generator, value);
        
        return(attr);
    }

    /**
     * Removes the generator attribute value.
     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1541)
    public void remGenerator(){
         rem(DmgDMSAG.__generator);
    }

    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:798)
    public String getGenPackage(){
        DmcTypeStringSV attr = (DmcTypeStringSV) get(DmgDMSAG.__genPackage);
        if (attr == null)
            return(null);

        return(attr.getSV());
    }

    /**
     * Sets genPackage to the specified value.
     * @param value String
     */
    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:838)
    public void setGenPackage(String value) {
        DmcAttribute<?> attr = get(DmgDMSAG.__genPackage);
        if (attr == null)
            attr = new DmcTypeStringSV(DmgDMSAG.__genPackage);
        
        try{
            attr.set(value);
            set(DmgDMSAG.__genPackage,attr);
        }
        catch(DmcValueException ex){
            throw(new IllegalStateException("The type specific set() method shouldn't throw exceptions!",ex));
        }
    }

    /**
     * Sets genPackage to the specified value.
     * @param value A value compatible with DmcTypeStringSV
     * @throws DmcValueException if value is not correct
     */
    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:892)
    public void setGenPackage(Object value) throws DmcValueException {
        DmcTypeStringSV attr  = (DmcTypeStringSV) get(DmgDMSAG.__genPackage);
        if (attr == null)
            attr = new DmcTypeStringSV(DmgDMSAG.__genPackage);
        
        attr.set(value);
        set(DmgDMSAG.__genPackage,attr);
    }

    /**
     * Removes the genPackage attribute value.
     */
    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:912)
    public void remGenPackage(){
         rem(DmgDMSAG.__genPackage);
    }




}
