//	---------------------------------------------------------------------------
//	dark-matter-data
//	Copyright (c) 2010-2021 dark-matter-data committers
//	---------------------------------------------------------------------------
//	This program is free software; you can redistribute it and/or modify it
//	under the terms of the GNU Lesser General Public License as published by the
//	Free Software Foundation; either version 3 of the License, or (at your
//	option) any later version.
//	This program is distributed in the hope that it will be useful, but WITHOUT
//	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
//	FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for
//	more details.
//	You should have received a copy of the GNU Lesser General Public License along
//	with this program; if not, see <http://www.gnu.org/licenses/lgpl.html>.
//	---------------------------------------------------------------------------
package org.dmd.dmg.generated.types;

import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.DmcOutputStreamIF;
import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.types.DmcTypeNamedObjectREF;
import org.dmd.dmc.types.CamelCaseName;

import org.dmd.dmg.generated.types.GenerationContextREF;

import org.dmd.dmg.generated.dmo.GenerationContextDMO;

/**
 * This is the generated DmcAttribute derivative for values of type GenerationContext
 * <P>
 * Generated from the dmg schema at version 0.1
 * <P>
 * This code was auto-generated by the dmogenerator utility and shouldn't be alterred manually!
 * Generated from: org.dmd.dms.util.DmoTypeFormatter.dumpNamedREFHelperType(DmoTypeFormatter.java:589)
 */
@SuppressWarnings("serial")
abstract public class DmcTypeGenerationContextREF extends DmcTypeNamedObjectREF<GenerationContextREF, CamelCaseName> {

    public DmcTypeGenerationContextREF(){
    
    }

    public DmcTypeGenerationContextREF(DmcAttributeInfo ai){
        super(ai);
    }

    @Override
    protected GenerationContextREF getNewHelper(){
        return(new GenerationContextREF());
    }

    @Override
    protected CamelCaseName getNewName(){
        return(new CamelCaseName());
    }

    @Override
    protected String getDMOClassName(){
        return( GenerationContextDMO.class.getName());
    }

    @Override
    protected boolean isDMO(Object value){
        if (value instanceof GenerationContextDMO)
            return(true);
        return(false);
    }

    @Override
    protected GenerationContextREF typeCheck(Object value) throws DmcValueException {
        GenerationContextREF rc = null;

        if (value instanceof GenerationContextREF)
            rc = (GenerationContextREF)value;
        else if (value instanceof GenerationContextDMO)
            rc = new GenerationContextREF((GenerationContextDMO)value);
        else if (value instanceof CamelCaseName)
            rc = new GenerationContextREF((CamelCaseName)value);
        else if (value instanceof String)
            rc = new GenerationContextREF((String)value);
        else
            throw(new DmcValueException("Object of class: " + value.getClass().getName() + " passed where object compatible with GenerationContextREF, GenerationContextDMO or String expected."));

        return(rc);
    }

    @Override
    public void serializeValue(DmcOutputStreamIF dos, GenerationContextREF value) throws Exception {
        value.serializeIt(dos);
    }

    @Override
    public GenerationContextREF deserializeValue(DmcInputStreamIF dis) throws Exception {
        GenerationContextREF rc = new GenerationContextREF();
        rc.deserializeIt(dis);
        return(rc);
    }

    @Override
    public GenerationContextREF cloneValue(GenerationContextREF value){
        return(new GenerationContextREF(value));
    }



}
