//	---------------------------------------------------------------------------
//	dark-matter-data
//	Copyright (c) 2010-2021 dark-matter-data committers
//	---------------------------------------------------------------------------
//	This program is free software; you can redistribute it and/or modify it
//	under the terms of the GNU Lesser General Public License as published by the
//	Free Software Foundation; either version 3 of the License, or (at your
//	option) any later version.
//	This program is distributed in the hope that it will be useful, but WITHOUT
//	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
//	FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for
//	more details.
//	You should have received a copy of the GNU Lesser General Public License along
//	with this program; if not, see <http://www.gnu.org/licenses/lgpl.html>.
//	---------------------------------------------------------------------------
package org.dmd.dmp.shared.generated.dmo;

// Generated from: org.dmd.dms.util.GenUtility.formatImports(GenUtility.java:408)
import java.io.Serializable;                                  // Always required - (GenUtility.java:227)
import org.dmd.dmc.DmcAttribute;                              // Any attributes - (GenUtility.java:248)
import org.dmd.dmc.DmcSliceInfo;                              // Required for object slicing - (GenUtility.java:232)
import org.dmd.dmc.DmcValueException;                         // Any attributes - (GenUtility.java:249)
import org.dmd.dmp.shared.generated.dmo.RequestDMO;           // Base class - (GenUtility.java:367)
import org.dmd.dms.generated.dmo.MetaDMSAG;                   // Required for MODREC constructor - (GenUtility.java:231)
import org.dmd.dms.generated.types.DmcTypeIntegerSV;          // Required type - (GenUtility.java:339)
import org.dmd.dms.generated.types.DmcTypeModifierMV;         // Required for MODREC constructor - (GenUtility.java:230)

// Generated from: org.dmd.dms.util.DmoFormatter.getClassHeader(DmoFormatter.java:678)
/**
 * The ActionCancelRequest is used to cancel an action that is running\n on
 * the server. The serverActionID will have been sent in any ActionResponse\n
 * after the action starts execution.
 * <P>
 * Generated from the dmp schema at version 0.1
 * <P>
 * This code was auto-generated by the dmogenerator utility and shouldn't be alterred manually!
 * Generated from: org.dmd.dms.util.DmoFormatter.dumpDMO(DmoFormatter.java:134)
 */
@SuppressWarnings("serial")
public class ActionCancelRequestDMO  extends RequestDMO  implements Serializable  {

    public final static String constructionClassName = "ActionCancelRequest";


    static {
    }

    public ActionCancelRequestDMO() {
        super("ActionCancelRequest");
    }

    protected ActionCancelRequestDMO(String oc) {
        super(oc);
    }

    @Override
    public ActionCancelRequestDMO getNew(){
        ActionCancelRequestDMO rc = new ActionCancelRequestDMO();
        return(rc);
    }

    @Override
    public ActionCancelRequestDMO getSlice(DmcSliceInfo info){
        ActionCancelRequestDMO rc = new ActionCancelRequestDMO();
        populateSlice(rc,info);
        return(rc);
    }

    public ActionCancelRequestDMO(DmcTypeModifierMV mods) {
        super("ActionCancelRequest");
        modrec(true);
        setModifier(mods);
    }

    public ActionCancelRequestDMO getModificationRecorder(){
        ActionCancelRequestDMO rc = new ActionCancelRequestDMO();
        rc.setModifier(new DmcTypeModifierMV(MetaDMSAG.__modify));
        rc.modrec(true);
        return(rc);
    }

    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:798)
    public Integer getServerActionID(){
        DmcTypeIntegerSV attr = (DmcTypeIntegerSV) get(DmpDMSAG.__serverActionID);
        if (attr == null)
            return(null);

        return(attr.getSV());
    }

    /**
     * Sets serverActionID to the specified value.
     * @param value Integer
     */
    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:838)
    public void setServerActionID(Integer value) {
        DmcAttribute<?> attr = get(DmpDMSAG.__serverActionID);
        if (attr == null)
            attr = new DmcTypeIntegerSV(DmpDMSAG.__serverActionID);
        
        try{
            attr.set(value);
            set(DmpDMSAG.__serverActionID,attr);
        }
        catch(DmcValueException ex){
            throw(new IllegalStateException("The type specific set() method shouldn't throw exceptions!",ex));
        }
    }

    /**
     * Sets serverActionID to the specified value.
     * @param value A value compatible with DmcTypeIntegerSV
     * @throws DmcValueException if value is not correct
     */
    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:892)
    public void setServerActionID(Object value) throws DmcValueException {
        DmcTypeIntegerSV attr  = (DmcTypeIntegerSV) get(DmpDMSAG.__serverActionID);
        if (attr == null)
            attr = new DmcTypeIntegerSV(DmpDMSAG.__serverActionID);
        
        attr.set(value);
        set(DmpDMSAG.__serverActionID,attr);
    }

    /**
     * Removes the serverActionID attribute value.
     */
    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:912)
    public void remServerActionID(){
         rem(DmpDMSAG.__serverActionID);
    }




}
