//	---------------------------------------------------------------------------
//	dark-matter-data
//	Copyright (c) 2012-2021 dark-matter-data committers
//	---------------------------------------------------------------------------
//	This program is free software; you can redistribute it and/or modify it
//	under the terms of the GNU Lesser General Public License as published by the
//	Free Software Foundation; either version 3 of the License, or (at your
//	option) any later version.
//	This program is distributed in the hope that it will be useful, but WITHOUT
//	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
//	FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for
//	more details.
//	You should have received a copy of the GNU Lesser General Public License along
//	with this program; if not, see <http://www.gnu.org/licenses/lgpl.html>.
//	---------------------------------------------------------------------------
package org.dmd.dms.generated.types;

import java.io.Serializable;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.DmcObjectName;
import org.dmd.dmc.DmcOutputStreamIF;
import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.types.DmcTypeNamedObjectREF;
import org.dmd.dms.generated.dmo.*;
import org.dmd.dmc.types.DefinitionName;
/**
 * The DmcTypeRuleCategoryREF class.
 * This code was auto-generated by the createmeta utility and shouldn't be alterred
 * manually.
 * Generated from: org.dmd.dms.meta.MetaGenerator.dumpDmcTypes(MetaGenerator.java:2738)
 */
@SuppressWarnings("serial")
abstract public class DmcTypeRuleCategoryREF extends DmcTypeNamedObjectREF<RuleCategoryREF, DefinitionName> implements Serializable {

    /**
     * Default constructor.
     */
    public DmcTypeRuleCategoryREF(){
    }

    /**
     * Default constructor.
     */
    public DmcTypeRuleCategoryREF(DmcAttributeInfo ai){
        super(ai);
    }

    /**
     * Checks that we have a RuleCategoryREF or RuleCategoryDMO.
     */
    public RuleCategoryREF typeCheck(Object value) throws DmcValueException {
        RuleCategoryREF rc = null;
        if (value instanceof RuleCategoryREF)
            rc = (RuleCategoryREF)value;
        else if (value instanceof RuleCategoryDMO)
            rc = new RuleCategoryREF((RuleCategoryDMO)value);
        else if (value instanceof DmcObjectName){
            rc = new RuleCategoryREF();
            rc.setName((DmcObjectName)value);
        }
        else if (value instanceof String){
            rc = new RuleCategoryREF();
            rc.setName(new DefinitionName((String)value));
        }
        else
            throw(new DmcValueException("Object of class:" + value.getClass().getName() + " passed where a RuleCategoryREF/DMO or DmcObjectName expected."));
        return(rc);
    }

    @Override
    protected RuleCategoryREF getNewHelper(){
        return( new RuleCategoryREF());
    }

    @Override
    protected DefinitionName getNewName(){
        return( new DefinitionName());
    }

    @Override
    protected String getDMOClassName(){
        return( RuleCategoryDMO.class.getName());
    }

    @Override
    protected boolean isDMO(Object value){
        if (value instanceof RuleCategoryDMO)
            return(true);
        return(false);
    }

    /**
     * Returns a clone of a value associated with this type.
     */
    @Override
    public RuleCategoryREF cloneValue(RuleCategoryREF val){
        RuleCategoryREF rc = new RuleCategoryREF(val);
        return(rc);
    }

    @Override
    public void serializeValue(DmcOutputStreamIF dos, RuleCategoryREF value) throws Exception {
        value.serializeIt(dos);
    }

    @Override
    public RuleCategoryREF deserializeValue(DmcInputStreamIF dis) throws Exception {
        RuleCategoryREF rc = new RuleCategoryREF();
        rc.deserializeIt(dis);
        return(rc);
    }

}
