//	---------------------------------------------------------------------------
//	dark-matter-data
//	Copyright (c) 2012 dark-matter-data committers
//	---------------------------------------------------------------------------
//	This program is free software; you can redistribute it and/or modify it
//	under the terms of the GNU Lesser General Public License as published by the
//	Free Software Foundation; either version 3 of the License, or (at your
//	option) any later version.
//	This program is distributed in the hope that it will be useful, but WITHOUT
//	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
//	FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for
//	more details.
//	You should have received a copy of the GNU Lesser General Public License along
//	with this program; if not, see <http://www.gnu.org/licenses/lgpl.html>.
//	---------------------------------------------------------------------------
package org.dmd.dms.generated.types;

import java.io.Serializable;
import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.DmcOutputStreamIF;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.*;

@SuppressWarnings("serial")
/**
 * The DmcTypeRuleScopeEnum class.
 * This code was auto-generated by the createmeta utility and shouldn't be alterred
 * manually.
 * Generated from: org.dmd.dms.meta.MetaGenerator.dumpDmcType(MetaGenerator.java:2837)
 */
abstract public class DmcTypeRuleScopeEnum extends DmcAttribute<RuleScopeEnum> implements Serializable {

    /**
     * Default constructor.
     */
    public DmcTypeRuleScopeEnum(){
    }

    /**
     * Default constructor.
     */
    public DmcTypeRuleScopeEnum(DmcAttributeInfo ai){
        super(ai);
    }

    protected RuleScopeEnum typeCheck(Object value) throws DmcValueException {
        RuleScopeEnum rc = null;

        if (value instanceof RuleScopeEnum){
            rc = (RuleScopeEnum)value;
        }
        else if (value instanceof String){
            rc = RuleScopeEnum.get((String)value);
            if (rc == null){
                throw(new DmcValueException("Value: " + value.toString() + " is not a valid RuleScopeEnum value."));
            }
        }
        else if (value instanceof Integer){
            rc = RuleScopeEnum.get((Integer)value);
            if (rc == null){
                throw(new DmcValueException("Value: " + value.toString() + " is not a valid RuleScopeEnum value."));
            }
        }
        else{
            throw(new DmcValueException("Object of class: " + value.getClass().getName() + " passed where object compatible with RuleScopeEnum expected."));
        }
        return(rc);
    }

    /**
     * Returns a clone of a value associated with this type.
     */
    public RuleScopeEnum cloneValue(RuleScopeEnum val){
        RuleScopeEnum rc = val;
        return(rc);
    }

    /**
     * Writes a RuleScopeEnum.
     */
    @Override
    public void serializeValue(DmcOutputStreamIF dos, RuleScopeEnum value) throws Exception {
        dos.writeShort(value.intValue());
    }

    /**
     * Reads a RuleScopeEnum.
     */
    @Override
    public RuleScopeEnum deserializeValue(DmcInputStreamIF dis) throws Exception {
        return(RuleScopeEnum.get(dis.readShort()));
    }



}
