//	---------------------------------------------------------------------------
//	dark-matter-data
//	Copyright (c) 2012-2021 dark-matter-data committers
//	---------------------------------------------------------------------------
//	This program is free software; you can redistribute it and/or modify it
//	under the terms of the GNU Lesser General Public License as published by the
//	Free Software Foundation; either version 3 of the License, or (at your
//	option) any later version.
//	This program is distributed in the hope that it will be useful, but WITHOUT
//	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
//	FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for
//	more details.
//	You should have received a copy of the GNU Lesser General Public License along
//	with this program; if not, see <http://www.gnu.org/licenses/lgpl.html>.
//	---------------------------------------------------------------------------
package org.dmd.dms.generated.types;

// Generated from: org.dmd.util.codegen.ImportManager.getFormattedImports(ImportManager.java:82)
// Called from: org.dmd.dms.meta.MetaGenerator.dumpComplexType(MetaGenerator.java:3192)
import java.io.Serializable;                                // Marker interface for serialization - (MetaGenerator.java:3169)
import org.dmd.dmc.DmcAttributeInfo;                        // For fake DmcAttributeInfo - (MetaGenerator.java:3175)
import org.dmd.dmc.DmcInputStreamIF;                        // To support serialization - (MetaGenerator.java:3170)
import org.dmd.dmc.DmcOutputStreamIF;                       // To support serialization - (MetaGenerator.java:3171)
import org.dmd.dmc.DmcValueException;                       // For type checking - (MetaGenerator.java:3188)
import org.dmd.dmc.types.IntegerVar;                        // For getNextField() - (MetaGenerator.java:3172)
import org.dmd.dms.generated.enums.DataTypeEnum;            // For fake DmcAttributeInfo - (MetaGenerator.java:3173)
import org.dmd.dms.generated.enums.ValueTypeEnum;           // For fake DmcAttributeInfo - (MetaGenerator.java:3174)
import org.dmd.dms.generated.enums.WrapperTypeEnum;         // Type for field: wrapperType - (MetaGenerator.java:3503)



@SuppressWarnings("serial")
/**
 * The DmwTypeToWrapperType class.
 * This code was auto-generated by the createmeta utility and shouldn't be alterred
 * manually.
 * Generated from: org.dmd.dms.meta.MetaGenerator.dumpComplexType(MetaGenerator.java:3199)
 */
public class DmwTypeToWrapperType implements Serializable {

    // The Dark Matter Wrapper type
    String dmwType;
    final static DmcAttributeInfo dmwTypeAI = new DmcAttributeInfo("dmwType",0,"String",ValueTypeEnum.SINGLE,DataTypeEnum.UNKNOWN);

    // The type of wrapper to be used in this context
    WrapperTypeEnum wrapperType;
    final static DmcAttributeInfo wrapperTypeAI = new DmcAttributeInfo("wrapperType",0,"WrapperTypeEnum",ValueTypeEnum.SINGLE,DataTypeEnum.UNKNOWN);

    /**
     * Default constructor.
     */
    public DmwTypeToWrapperType(){
    }

    /**
     * Copy constructor.
     */
    public DmwTypeToWrapperType(DmwTypeToWrapperType original){
        dmwType = original.dmwType;
        wrapperType = original.wrapperType;
    }

    /**
     * All fields constructor.
     */
    public DmwTypeToWrapperType(String f1, WrapperTypeEnum f2) throws DmcValueException {
        dmwType = DmcTypeStringSTATIC.instance.typeCheck(f1);
        wrapperType = DmcTypeWrapperTypeEnumSTATIC.instance.typeCheck(f2);
    }

    /**
     * String based constructor.
     */
    public DmwTypeToWrapperType(String initialInput) throws DmcValueException {
        IntegerVar seppos = new IntegerVar(-1);
        String input = initialInput.trim();
        input = input.replaceAll("(\\s)+", " ");
        dmwType = DmcTypeStringSTATIC.instance.typeCheck(getNextField(input,seppos,"dmwType",false));
        wrapperType = DmcTypeWrapperTypeEnumSTATIC.instance.typeCheck(getNextField(input,seppos,"wrapperType",true));
    }

    /**
     * Serialization.
     */
    public void serializeIt(DmcOutputStreamIF dos) throws Exception {
        DmcTypeStringSTATIC.instance.serializeValue(dos, dmwType);
        DmcTypeWrapperTypeEnumSTATIC.instance.serializeValue(dos, wrapperType);
    }

    /**
     * Deserialization.
     */
    public void deserializeIt(DmcInputStreamIF dis) throws Exception {
        dmwType = DmcTypeStringSTATIC.instance.deserializeValue(dis);
        wrapperType = DmcTypeWrapperTypeEnumSTATIC.instance.deserializeValue(dis);
    }

    /**
     * String form.
     */
    public String toString(){
        return(dmwType.toString() + " " + wrapperType.toString());
    }

    public String getDmwType(){
        return(dmwType);
    }

    public WrapperTypeEnum getWrapperType(){
        return(wrapperType);
    }

    // org.dmd.dms.meta.MetaGenerator.dumpComplexType(MetaGenerator.java:3391)
    String getNextField(String input, IntegerVar seppos, String fn, boolean last) throws DmcValueException {
    	   String rc = null;
    	   int start = seppos.intValue();

    	   if ( (start+1) >= input.length())
    		   throw (new DmcValueException("Missing value for field: " + fn + " in complex type: DmwTypeToWrapperType"));

    	   if (last){
    	       rc = input.substring(start+1);
    	   }
    	   else{
    	       int pos = -1;
    	       if (start > 0)
    		       pos = input.indexOf(" ", start+1);
    	       else
    		       pos = input.indexOf(" ");

    	       if (pos == -1)
    		       throw (new DmcValueException("Missing value for field: " + fn + " in complex type: DmwTypeToWrapperType"));

    		   while(pos < (input.length()-1)){
    		       if ( input.charAt(pos+1) == ' ')
    		           pos++;
    		       else
    		           break;
    		   }

    	       rc = input.substring(start+1, pos).trim();

    	       seppos.set(pos);
        }

        return(rc);
    }

    public void toJSON(StringBuffer sb, int padding, String indent) {
        throw(new IllegalStateException("This needs to be implemented"));
    }

}
