//	---------------------------------------------------------------------------
//	dark-matter-data
//	Copyright (c) 2012-2021 dark-matter-data committers
//	---------------------------------------------------------------------------
//	This program is free software; you can redistribute it and/or modify it
//	under the terms of the GNU Lesser General Public License as published by the
//	Free Software Foundation; either version 3 of the License, or (at your
//	option) any later version.
//	This program is distributed in the hope that it will be useful, but WITHOUT
//	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
//	FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for
//	more details.
//	You should have received a copy of the GNU Lesser General Public License along
//	with this program; if not, see <http://www.gnu.org/licenses/lgpl.html>.
//	---------------------------------------------------------------------------
package org.dmd.dms.generated.types;

// Generated from: org.dmd.util.codegen.ImportManager.getFormattedImports(ImportManager.java:82)
// Called from: org.dmd.dms.meta.MetaComplexTypeFormatter.dumpComplexType(MetaComplexTypeFormatter.java:101)
import java.io.Serializable;                                  // Marker interface for serialization - (MetaComplexTypeFormatter.java:76)
import java.util.ArrayList;                                   // To store ParsedNameValuePairs - (MetaComplexTypeFormatter.java:83)
import org.dmd.dmc.DmcAttributeInfo;                          // For fake DmcAttributeInfo - (MetaComplexTypeFormatter.java:81)
import org.dmd.dmc.DmcContainerIF;                            // Reference resolution - (MetaComplexTypeFormatter.java:92)
import org.dmd.dmc.DmcInputStreamIF;                          // To support serialization - (MetaComplexTypeFormatter.java:77)
import org.dmd.dmc.DmcNameClashResolverIF;                    // Ambiguous reference resolution - (MetaComplexTypeFormatter.java:88)
import org.dmd.dmc.DmcNameResolverIF;                         // Reference resolution - (MetaComplexTypeFormatter.java:89)
import org.dmd.dmc.DmcNameResolverWithClashSupportIF;         // Ambiguous reference resolution - (MetaComplexTypeFormatter.java:87)
import org.dmd.dmc.DmcNamedObjectIF;                          // Reference resolution - (MetaComplexTypeFormatter.java:90)
import org.dmd.dmc.DmcNamedObjectREF;                         // Reference resolution - (MetaComplexTypeFormatter.java:91)
import org.dmd.dmc.DmcObject;                                 // Ambiguous reference resolution - (MetaComplexTypeFormatter.java:93)
import org.dmd.dmc.DmcOutputStreamIF;                         // To support serialization - (MetaComplexTypeFormatter.java:78)
import org.dmd.dmc.DmcValueException;                         // For type checking - (MetaComplexTypeFormatter.java:97)
import org.dmd.dmc.DmcValueExceptionSet;                      // Ambiguous reference resolution - (MetaComplexTypeFormatter.java:94)
import org.dmd.dmc.util.ComplexTypeSplitter;                  // For parsing initial input - (MetaComplexTypeFormatter.java:82)
import org.dmd.dmc.util.ParsedNameValuePair;                  // To store values parsed from initial input - (MetaComplexTypeFormatter.java:84)
import org.dmd.dms.generated.enums.DataTypeEnum;              // For fake DmcAttributeInfo - (MetaComplexTypeFormatter.java:79)
import org.dmd.dms.generated.enums.ValueTypeEnum;             // For fake DmcAttributeInfo - (MetaComplexTypeFormatter.java:80)



@SuppressWarnings("serial")
/**
 * The Optimize class.
 * This code was auto-generated by the createmeta utility and shouldn't be alterred
 * manually.
 * Generated from: org.dmd.dms.meta.MetaComplexTypeFormatter.dumpComplexType(MetaComplexTypeFormatter.java:108)
 */
public class Optimize implements Serializable {

    // A description of the change to be made
    String what;
    final static DmcAttributeInfo whatAI = new DmcAttributeInfo("what",0,"String",ValueTypeEnum.SINGLE,DataTypeEnum.UNKNOWN);

    // Who made the suggestion
    String who;
    final static DmcAttributeInfo whoAI = new DmcAttributeInfo("who",0,"String",ValueTypeEnum.SINGLE,DataTypeEnum.UNKNOWN);

    // A suggested timeframe for the change
    String when;
    final static DmcAttributeInfo whenAI = new DmcAttributeInfo("when",0,"String",ValueTypeEnum.SINGLE,DataTypeEnum.UNKNOWN);

    // A suggested timeframe for the change
    ConcinnityREF why;
    final static DmcAttributeInfo whyAI = new DmcAttributeInfo("why",0,"Concinnity",ValueTypeEnum.SINGLE,DataTypeEnum.UNKNOWN);

    final static int requiredParts = 1;

    /**
     * Default constructor.
     */
    public Optimize(){
    }

    /**
     * Copy constructor.
     */
    public Optimize(Optimize original){
        what = original.what;
        who = original.who;
        when = original.when;
        why = original.why;
    }

    // Generated from: org.dmd.dms.meta.MetaComplexTypeFormatter.dumpComplexType(MetaComplexTypeFormatter.java:133)
    /**
     * All fields constructor.
     */
    public Optimize(String f1, String f2, String f3, ConcinnityREF f4) throws DmcValueException {
        what = DmcTypeStringSTATIC.instance.typeCheck(f1);
        if (f2 != null)
            who = DmcTypeStringSTATIC.instance.typeCheck(f2);
        if (f3 != null)
            when = DmcTypeStringSTATIC.instance.typeCheck(f3);
        if (f4 != null)
            why = DmcTypeConcinnityREFSTATIC.instance.typeCheck(f4);
    }

    // Generated from: org.dmd.dms.meta.MetaComplexTypeFormatter.dumpComplexType(MetaComplexTypeFormatter.java:160)
    /**
     * String based constructor.
     */
    public Optimize(String initialInput) throws DmcValueException {
        initialize(initialInput);
    }

    // Generated from: org.dmd.dms.meta.MetaComplexTypeFormatter.dumpComplexType(MetaComplexTypeFormatter.java:168)
    void initialize(String initialInput) throws DmcValueException {
        ArrayList<ParsedNameValuePair> nvp = ComplexTypeSplitter.parse(initialInput,':');

        if (nvp.size() < requiredParts)
            throw(new DmcValueException("Missing required values for complex type: Optimize"));

        what = DmcTypeStringSTATIC.instance.typeCheck(nvp.get(0).getValue());

        if (nvp.size() > requiredParts){
            for(int i=1; i<nvp.size(); i++){
                if (nvp.get(i).getName() == null){
                    if (nvp.get(i).getValue() == null)
                        throw(new DmcValueException("Expecting a partname=\"some value\" in complex type: Optimize"));
                    else
                        throw(new DmcValueException("Expecting a partname=\"" + nvp.get(i).getValue() + "\" in complex type: Optimize"));
                }
                if (nvp.get(i).getName().equals("who"))
                    who = DmcTypeStringSTATIC.instance.typeCheck(nvp.get(i).getValue());
                else if (nvp.get(i).getName().equals("when"))
                    when = DmcTypeStringSTATIC.instance.typeCheck(nvp.get(i).getValue());
                else if (nvp.get(i).getName().equals("why"))
                    why = DmcTypeConcinnityREFSTATIC.instance.typeCheck(nvp.get(i).getValue());
                else{
                    throw(new DmcValueException("Unknown field for complex type Optimize: "  + nvp.get(i).getName()));
                }
            }
        }

    }

    /**
     * Serialization.
     */
    public void serializeIt(DmcOutputStreamIF dos) throws Exception {
        dos.writeUTF(toString());
    }

    /**
     * Deserialization.
     */
    public void deserializeIt(DmcInputStreamIF dis) throws Exception {
        initialize(dis.readUTF());
    }

    /**
     * String form.
     * Generated from: org.dmd.dms.meta.MetaComplexTypeFormatter.dumpComplexType(MetaComplexTypeFormatter.java:257)
     */
    public String toString(){
        StringBuffer sb = new StringBuffer();
        sb.append(what.toString());
        if (who != null){
            sb.append(':');
            sb.append("who=" + "\"" + who.toString() + "\"");
        }

        if (when != null){
            sb.append(':');
            sb.append("when=" + "\"" + when.toString() + "\"");
        }

        if (why != null){
            sb.append(':');
            sb.append("why=" + why.toString());
        }

        return(sb.toString());
    }

    public String getWhat(){
        return(what);
    }

    public String getWho(){
        return(who);
    }

    public String getWhen(){
        return(when);
    }

    public ConcinnityREF getWhy(){
        return(why);
    }

    @SuppressWarnings({"unchecked", "rawtypes"})
    // Generated from: org.dmd.dms.meta.MetaComplexTypeFormatter.dumpComplexType(MetaComplexTypeFormatter.java:316)
    public void resolve(DmcNameResolverIF resolver, String attrName) throws DmcValueException {
        DmcNamedObjectIF  obj = null;

        if ((why != null) && (!why.isResolved())){
            obj = resolver.findNamedObject(why.getObjectName());
            if (obj == null)
                throw(new DmcValueException("Could not resolve reference to: " + why.getObjectName() + " via attribute: " + attrName));
        
            if (obj instanceof DmcContainerIF)
                ((DmcNamedObjectREF)why).setObject((DmcNamedObjectIF) ((DmcContainerIF)obj).getDmcObject());
            else
                ((DmcNamedObjectREF)why).setObject(obj);
        }
        
    }

    @SuppressWarnings({"unchecked", "rawtypes"})
    // Generated from: org.dmd.dms.meta.MetaComplexTypeFormatter.dumpComplexType(MetaComplexTypeFormatter.java:338)
    public void resolve(DmcNameResolverWithClashSupportIF resolver, DmcObject object, DmcNameClashResolverIF ncr, DmcAttributeInfo ai) throws DmcValueException, DmcValueExceptionSet {
        DmcNamedObjectIF  obj = null;

        if ((why != null) && (!why.isResolved())){
            obj = resolver.findNamedObjectMayClash(object, why.getObjectName(), ncr, whyAI);
            if (obj == null)
                throw(new DmcValueException("Could not resolve reference to: " + why.getObjectName() + " via attribute: " + ai.name));
        
            if (obj instanceof DmcContainerIF)
                ((DmcNamedObjectREF)why).setObject((DmcNamedObjectIF) ((DmcContainerIF)obj).getDmcObject());
            else
                ((DmcNamedObjectREF)why).setObject(obj);
        }
        
    }

    // Generated from: org.dmd.dms.meta.MetaComplexTypeFormatter.dumpComplexType(MetaComplexTypeFormatter.java:363)
    public void removeBackRefsFromValue(){
    }

    public void toJSON(StringBuffer sb, int padding, String indent) {
        throw(new IllegalStateException("This needs to be implemented"));
    }

}
