//	---------------------------------------------------------------------------
//	dark-matter-data
//	Copyright (c) 2013-2021 dark-matter-data committers
//	---------------------------------------------------------------------------
//	This program is free software; you can redistribute it and/or modify it
//	under the terms of the GNU Lesser General Public License as published by the
//	Free Software Foundation; either version 3 of the License, or (at your
//	option) any later version.
//	This program is distributed in the hope that it will be useful, but WITHOUT
//	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
//	FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for
//	more details.
//	You should have received a copy of the GNU Lesser General Public License along
//	with this program; if not, see <http://www.gnu.org/licenses/lgpl.html>.
//	---------------------------------------------------------------------------
package org.dmd.dmt.dsd.dsdb.shared.generated.types;

import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.DmcOutputStreamIF;
import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.types.DmcTypeNamedObjectREF;
import org.dmd.dmc.types.DefinitionName;

import org.dmd.dmt.dsd.dsdb.shared.generated.types.BConceptXREF;

import org.dmd.dmt.dsd.dsdb.shared.generated.dmo.BConceptXDMO;

/**
 * This is the generated DmcAttribute derivative for values of type BConceptX
 * <P>
 * Generated from the dsdB schema at version unknown
 * <P>
 * This code was auto-generated by the dmogenerator utility and shouldn't be alterred manually!
 * Generated from: org.dmd.dms.util.DmoTypeFormatter.dumpNamedREFHelperType(DmoTypeFormatter.java:589)
 */
@SuppressWarnings("serial")
abstract public class DmcTypeBConceptXREF extends DmcTypeNamedObjectREF<BConceptXREF, DefinitionName> {

    public DmcTypeBConceptXREF(){
    
    }

    public DmcTypeBConceptXREF(DmcAttributeInfo ai){
        super(ai);
    }

    @Override
    protected BConceptXREF getNewHelper(){
        return(new BConceptXREF());
    }

    @Override
    protected DefinitionName getNewName(){
        return(new DefinitionName());
    }

    @Override
    protected String getDMOClassName(){
        return( BConceptXDMO.class.getName());
    }

    @Override
    protected boolean isDMO(Object value){
        if (value instanceof BConceptXDMO)
            return(true);
        return(false);
    }

    @Override
    protected BConceptXREF typeCheck(Object value) throws DmcValueException {
        BConceptXREF rc = null;

        if (value instanceof BConceptXREF)
            rc = (BConceptXREF)value;
        else if (value instanceof BConceptXDMO)
            rc = new BConceptXREF((BConceptXDMO)value);
        else if (value instanceof DefinitionName)
            rc = new BConceptXREF((DefinitionName)value);
        else if (value instanceof String)
            rc = new BConceptXREF((String)value);
        else
            throw(new DmcValueException("Object of class: " + value.getClass().getName() + " passed where object compatible with BConceptXREF, BConceptXDMO or String expected."));

        return(rc);
    }

    @Override
    public void serializeValue(DmcOutputStreamIF dos, BConceptXREF value) throws Exception {
        value.serializeIt(dos);
    }

    @Override
    public BConceptXREF deserializeValue(DmcInputStreamIF dis) throws Exception {
        BConceptXREF rc = new BConceptXREF();
        rc.deserializeIt(dis);
        return(rc);
    }

    @Override
    public BConceptXREF cloneValue(BConceptXREF value){
        return(new BConceptXREF(value));
    }



}
