//	---------------------------------------------------------------------------
//	dark-matter-data
//	Copyright (c) 2020 dark-matter-data committers
//	---------------------------------------------------------------------------
//	This program is free software; you can redistribute it and/or modify it
//	under the terms of the GNU Lesser General Public License as published by the
//	Free Software Foundation; either version 3 of the License, or (at your
//	option) any later version.
//	This program is distributed in the hope that it will be useful, but WITHOUT
//	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
//	FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for
//	more details.
//	You should have received a copy of the GNU Lesser General Public License along
//	with this program; if not, see <http://www.gnu.org/licenses/lgpl.html>.
//	---------------------------------------------------------------------------
package org.dmd.dmu.shared.generated.dmo;

// Generated from: org.dmd.dms.util.GenUtility.formatImports(GenUtility.java:408)
import java.io.Serializable;                                                   // Always required - (GenUtility.java:227)
import org.dmd.dmc.DmcAttribute;                                               // Named object - (GenUtility.java:388)
import org.dmd.dmc.DmcNamedObjectIF;                                           // Named object - (GenUtility.java:387)
import org.dmd.dmc.DmcOmni;                                                    // Lazy resolution - (GenUtility.java:331)
import org.dmd.dmc.DmcSliceInfo;                                               // Required for object slicing - (GenUtility.java:232)
import org.dmd.dmc.DmcValueException;                                          // Any attributes - (GenUtility.java:249)
import org.dmd.dmc.types.DefinitionName;                                       // Naming attribute type - (GenUtility.java:382)
import org.dmd.dms.generated.dmo.MetaDMSAG;                                    // Required for MODREC constructor - (GenUtility.java:231)
import org.dmd.dms.generated.types.DmcTypeDefinitionNameSV;                    // Required type - (GenUtility.java:339)
import org.dmd.dms.generated.types.DmcTypeModifierMV;                          // Required for MODREC constructor - (GenUtility.java:230)
import org.dmd.dms.generated.types.DmcTypeStringSV;                            // Required type - (GenUtility.java:339)
import org.dmd.dmu.shared.generated.dmo.DmuDefinitionDMO;                      // Base class - (GenUtility.java:367)
import org.dmd.dmu.shared.generated.dmo.PayloadSortInfoDMO;                    // Type specific set/add - (GenUtility.java:318)
import org.dmd.dmu.shared.generated.types.DmcTypePayloadSortInfoREFSV;         // Reference type - (GenUtility.java:311)
import org.dmd.dmu.shared.generated.types.PayloadSortInfoREF;                  // Helper class - (GenUtility.java:346)

// Generated from: org.dmd.dms.util.DmoFormatter.getClassHeader(DmoFormatter.java:678)
/**
 * <font color="red">json:</font> The PayloadExample allows you to specify\n
 * examples of JSON payloads to be used to test various functionality.
 * <P>
 * Generated from the dmu schema at version unknown
 * <P>
 * This code was auto-generated by the dmogenerator utility and shouldn't be alterred manually!
 * Generated from: org.dmd.dms.util.DmoFormatter.dumpDMO(DmoFormatter.java:134)
 */
@SuppressWarnings("serial")
public class PayloadExampleDMO  extends DmuDefinitionDMO  implements DmcNamedObjectIF, Serializable  {

    public final static String constructionClassName = "PayloadExample";


    static {
    }

    public PayloadExampleDMO() {
        super("PayloadExample");
    }

    protected PayloadExampleDMO(String oc) {
        super(oc);
    }

    @Override
    public PayloadExampleDMO getNew(){
        PayloadExampleDMO rc = new PayloadExampleDMO();
        return(rc);
    }

    @Override
    public PayloadExampleDMO getSlice(DmcSliceInfo info){
        PayloadExampleDMO rc = new PayloadExampleDMO();
        populateSlice(rc,info);
        return(rc);
    }

    public PayloadExampleDMO(DmcTypeModifierMV mods) {
        super("PayloadExample");
        modrec(true);
        setModifier(mods);
    }

    public PayloadExampleDMO getModificationRecorder(){
        PayloadExampleDMO rc = new PayloadExampleDMO();
        rc.setName(getName());
        rc.setModifier(new DmcTypeModifierMV(MetaDMSAG.__modify));
        rc.modrec(true);
        return(rc);
    }

    // org.dmd.dms.util.DmoFormatter.getAccessFunctions(DmoFormatter.java:752)
    public DefinitionName getObjectName(){
        DmcAttribute<?> name = get(MetaDMSAG.__name);
        if (name != null)
            return((DefinitionName)name.getSV());
    
        return(null);
    }

    // org.dmd.dms.util.DmoFormatter.getAccessFunctions(DmoFormatter.java:769)
    public DmcAttribute<?> getObjectNameAttribute(){
        DmcAttribute<?> name = get(MetaDMSAG.__name);
        return(name);
    }

    // org.dmd.dms.util.DmoFormatter.getAccessFunctions(DmoFormatter.java:776)
    public boolean equals(Object obj){
        if (obj instanceof PayloadExampleDMO){
            return( getObjectName().equals( ((PayloadExampleDMO) obj).getObjectName()) );
        }
        return(false);
    }

    // org.dmd.dms.util.DmoFormatter.getAccessFunctions(DmoFormatter.java:784)
    public int hashCode(){
        DefinitionName objn = getObjectName();
        if (objn == null)
            return(0);
        
        return(objn.hashCode());
    }

    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:678)
    /**
     * @return the PayloadSortInfoREF
     */
    public PayloadSortInfoREF getUseSortInfo(){
        DmcTypePayloadSortInfoREFSV attr = (DmcTypePayloadSortInfoREFSV) get(DmuDMSAG.__useSortInfo);
        if (attr == null)
            return(null);

        if (DmcOmni.instance().lazyResolution()){
            if (attr.doLazyResolution(this)){
                rem(attr.getAttributeInfo());
                return(null);
            }
        }

        return(attr.getSV());
    }

    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:700)
    /**
     * @return the reference to PayloadSortInfo without attempting lazy resolution (if turned on).
     */
    public PayloadSortInfoREF getUseSortInfoREF(){
        DmcTypePayloadSortInfoREFSV attr = (DmcTypePayloadSortInfoREFSV) get(DmuDMSAG.__useSortInfo);
        if (attr == null)
            return(null);

        return(attr.getSV());
    }

    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:718)
    /**
     * Sets useSortInfo to the specified value.
     * @param value PayloadSortInfoDMO
     */
    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:723)
    public void setUseSortInfo(PayloadSortInfoDMO value) {
        DmcAttribute<?> attr = get(DmuDMSAG.__useSortInfo);
        if (attr == null)
            attr = new DmcTypePayloadSortInfoREFSV(DmuDMSAG.__useSortInfo);
        else
            ((DmcTypePayloadSortInfoREFSV)attr).removeBackReferences();
        
        try{
            attr.set(value);
            set(DmuDMSAG.__useSortInfo,attr);
        }
        catch(DmcValueException ex){
            throw(new IllegalStateException("The type specific set() method shouldn't throw exceptions!",ex));
        }
    }

    /**
     * Sets useSortInfo to the specified value.
     * @param value A value compatible with DmcTypePayloadSortInfoREFSV
     * @throws DmcValueException if value is not correct
     */
    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:892)
    public void setUseSortInfo(Object value) throws DmcValueException {
        DmcTypePayloadSortInfoREFSV attr  = (DmcTypePayloadSortInfoREFSV) get(DmuDMSAG.__useSortInfo);
        if (attr == null)
            attr = new DmcTypePayloadSortInfoREFSV(DmuDMSAG.__useSortInfo);
        else
            attr.removeBackReferences();
        
        attr.set(value);
        set(DmuDMSAG.__useSortInfo,attr);
    }

    /**
     * Removes the useSortInfo attribute value.
     */
    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:912)
    public void remUseSortInfo(){
         rem(DmuDMSAG.__useSortInfo);
    }

    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:798)
    public DefinitionName getName(){
        DmcTypeDefinitionNameSV attr = (DmcTypeDefinitionNameSV) get(MetaDMSAG.__name);
        if (attr == null)
            return(null);

        return(attr.getSV());
    }

    /**
     * Sets name to the specified value.
     * @param value DefinitionName
     */
    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:838)
    public void setName(DefinitionName value) {
        DmcAttribute<?> attr = get(MetaDMSAG.__name);
        if (attr == null)
            attr = new DmcTypeDefinitionNameSV(MetaDMSAG.__name);
        
        try{
            attr.set(value);
            set(MetaDMSAG.__name,attr);
        }
        catch(DmcValueException ex){
            throw(new IllegalStateException("The type specific set() method shouldn't throw exceptions!",ex));
        }
    }

    /**
     * Sets name to the specified value.
     * @param value A value compatible with DmcTypeDefinitionNameSV
     * @throws DmcValueException if value is not correct
     */
    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:892)
    public void setName(Object value) throws DmcValueException {
        DmcTypeDefinitionNameSV attr  = (DmcTypeDefinitionNameSV) get(MetaDMSAG.__name);
        if (attr == null)
            attr = new DmcTypeDefinitionNameSV(MetaDMSAG.__name);
        
        attr.set(value);
        set(MetaDMSAG.__name,attr);
    }

    /**
     * Removes the name attribute value.
     */
    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:912)
    public void remName(){
         rem(MetaDMSAG.__name);
    }

    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:798)
    public String getJsonPayload(){
        DmcTypeStringSV attr = (DmcTypeStringSV) get(DmuDMSAG.__jsonPayload);
        if (attr == null)
            return(null);

        return(attr.getSV());
    }

    /**
     * Sets jsonPayload to the specified value.
     * @param value String
     */
    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:838)
    public void setJsonPayload(String value) {
        DmcAttribute<?> attr = get(DmuDMSAG.__jsonPayload);
        if (attr == null)
            attr = new DmcTypeStringSV(DmuDMSAG.__jsonPayload);
        
        try{
            attr.set(value);
            set(DmuDMSAG.__jsonPayload,attr);
        }
        catch(DmcValueException ex){
            throw(new IllegalStateException("The type specific set() method shouldn't throw exceptions!",ex));
        }
    }

    /**
     * Sets jsonPayload to the specified value.
     * @param value A value compatible with DmcTypeStringSV
     * @throws DmcValueException if value is not correct
     */
    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:892)
    public void setJsonPayload(Object value) throws DmcValueException {
        DmcTypeStringSV attr  = (DmcTypeStringSV) get(DmuDMSAG.__jsonPayload);
        if (attr == null)
            attr = new DmcTypeStringSV(DmuDMSAG.__jsonPayload);
        
        attr.set(value);
        set(DmuDMSAG.__jsonPayload,attr);
    }

    /**
     * Removes the jsonPayload attribute value.
     */
    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:912)
    public void remJsonPayload(){
         rem(DmuDMSAG.__jsonPayload);
    }




}
