//	---------------------------------------------------------------------------
//	dark-matter-data
//	Copyright (c) 2020 dark-matter-data committers
//	---------------------------------------------------------------------------
//	This program is free software; you can redistribute it and/or modify it
//	under the terms of the GNU Lesser General Public License as published by the
//	Free Software Foundation; either version 3 of the License, or (at your
//	option) any later version.
//	This program is distributed in the hope that it will be useful, but WITHOUT
//	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
//	FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for
//	more details.
//	You should have received a copy of the GNU Lesser General Public License along
//	with this program; if not, see <http://www.gnu.org/licenses/lgpl.html>.
//	---------------------------------------------------------------------------
package org.dmd.dmu.shared.generated.dmo;

// Generated from: org.dmd.dms.util.GenUtility.formatImports(GenUtility.java:408)
import java.io.Serializable;                                           // Always required - (GenUtility.java:227)
import java.util.*;                                                    // Always required if we have any MV attributes - (GenUtility.java:224)
import org.dmd.dmc.DmcAttribute;                                       // Named object - (GenUtility.java:388)
import org.dmd.dmc.DmcNamedObjectIF;                                   // Named object - (GenUtility.java:387)
import org.dmd.dmc.DmcSliceInfo;                                       // Required for object slicing - (GenUtility.java:232)
import org.dmd.dmc.DmcValueException;                                  // Any attributes - (GenUtility.java:249)
import org.dmd.dmc.types.DefinitionName;                               // Naming attribute type - (GenUtility.java:382)
import org.dmd.dms.generated.dmo.MetaDMSAG;                            // Required for MODREC constructor - (GenUtility.java:231)
import org.dmd.dms.generated.types.DmcTypeDefinitionNameSV;            // Required type - (GenUtility.java:339)
import org.dmd.dms.generated.types.DmcTypeModifierMV;                  // Required for MODREC constructor - (GenUtility.java:230)
import org.dmd.dmu.shared.generated.dmo.DmuDefinitionDMO;              // Base class - (GenUtility.java:367)
import org.dmd.dmu.shared.generated.types.DmcTypePathAndKeyMV;         // Required type - (GenUtility.java:339)
import org.dmd.dmu.shared.types.PathAndKey;                            // Primitive type - (GenUtility.java:282)

// Generated from: org.dmd.dms.util.DmoFormatter.getClassHeader(DmoFormatter.java:678)
/**
 * <font color="red">json:</font> In order to perform the diff between an
 * existing configuration on\n the device and an incoming payload, the JSON
 * objects must have arrays of objects\n sorted based on specified key
 * values. Otherwise, the com.github.fge.jsonpatch.diff.JsonDiff\n diff
 * mechanisms can't provide a decent comparison.
 * <P>
 * Generated from the dmu schema at version unknown
 * <P>
 * This code was auto-generated by the dmogenerator utility and shouldn't be alterred manually!
 * Generated from: org.dmd.dms.util.DmoFormatter.dumpDMO(DmoFormatter.java:134)
 */
@SuppressWarnings("serial")
public class PayloadSortInfoDMO  extends DmuDefinitionDMO  implements DmcNamedObjectIF, Serializable  {

    public final static String constructionClassName = "PayloadSortInfo";


    static {
    }

    public PayloadSortInfoDMO() {
        super("PayloadSortInfo");
    }

    protected PayloadSortInfoDMO(String oc) {
        super(oc);
    }

    @Override
    public PayloadSortInfoDMO getNew(){
        PayloadSortInfoDMO rc = new PayloadSortInfoDMO();
        return(rc);
    }

    @Override
    public PayloadSortInfoDMO getSlice(DmcSliceInfo info){
        PayloadSortInfoDMO rc = new PayloadSortInfoDMO();
        populateSlice(rc,info);
        return(rc);
    }

    public PayloadSortInfoDMO(DmcTypeModifierMV mods) {
        super("PayloadSortInfo");
        modrec(true);
        setModifier(mods);
    }

    public PayloadSortInfoDMO getModificationRecorder(){
        PayloadSortInfoDMO rc = new PayloadSortInfoDMO();
        rc.setName(getName());
        rc.setModifier(new DmcTypeModifierMV(MetaDMSAG.__modify));
        rc.modrec(true);
        return(rc);
    }

    // org.dmd.dms.util.DmoFormatter.getAccessFunctions(DmoFormatter.java:752)
    public DefinitionName getObjectName(){
        DmcAttribute<?> name = get(MetaDMSAG.__name);
        if (name != null)
            return((DefinitionName)name.getSV());
    
        return(null);
    }

    // org.dmd.dms.util.DmoFormatter.getAccessFunctions(DmoFormatter.java:769)
    public DmcAttribute<?> getObjectNameAttribute(){
        DmcAttribute<?> name = get(MetaDMSAG.__name);
        return(name);
    }

    // org.dmd.dms.util.DmoFormatter.getAccessFunctions(DmoFormatter.java:776)
    public boolean equals(Object obj){
        if (obj instanceof PayloadSortInfoDMO){
            return( getObjectName().equals( ((PayloadSortInfoDMO) obj).getObjectName()) );
        }
        return(false);
    }

    // org.dmd.dms.util.DmoFormatter.getAccessFunctions(DmoFormatter.java:784)
    public int hashCode(){
        DefinitionName objn = getObjectName();
        if (objn == null)
            return(0);
        
        return(objn.hashCode());
    }

    /**
     * @return An Iterator of PathAndKey objects.
     */
    @SuppressWarnings("unchecked")
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1289)
    public Iterator<PathAndKey> getPathAndKeys(){
        DmcTypePathAndKeyMV attr = (DmcTypePathAndKeyMV) get(DmuDMSAG.__pathAndKeys);
        if (attr == null)
            return( ((List<PathAndKey>) Collections.EMPTY_LIST).iterator());

        return(attr.getMV());
    }

    /**
     * @param i the index
     * @return The nth PathAndKey value.
     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1302)
    public PathAndKey getNthPathAndKeys(int i){
        DmcTypePathAndKeyMV attr = (DmcTypePathAndKeyMV) get(DmuDMSAG.__pathAndKeys);
        if (attr == null)
            return(null);

        return(attr.getMVnth(i));
    }

    /**
     * Adds another pathAndKeys to the specified value.
     * @param value PathAndKey
     * @return the attribute instance
     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1317)
    public DmcAttribute<?> addPathAndKeys(PathAndKey value) {
        DmcAttribute<?> attr = get(DmuDMSAG.__pathAndKeys);
        if (attr == null)
            attr = new DmcTypePathAndKeyMV(DmuDMSAG.__pathAndKeys);
        
        try{
            setLastValue(attr.add(value));
            add(DmuDMSAG.__pathAndKeys,attr);
        }
        catch(DmcValueException ex){
            throw(new IllegalStateException("The type specific add() method shouldn't throw exceptions!",ex));
        }
        return(attr);
    }

    /**
     * @param value PathAndKey
     * @return true if we contain a valued keyed by the specified PathAndKey.
     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1392)
    public boolean pathAndKeysContains(PathAndKey value) {
        DmcAttribute<?> attr = get(DmuDMSAG.__pathAndKeys);
        if (attr == null)
            return(false);
        return(attr.contains(value));
    }

    /**
     * Adds another pathAndKeys value.
     * @param value A value compatible with PathAndKey
     * @return the attribute instance
     * @throws DmcValueException if value is not correct
     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1426)
    public DmcAttribute<?> addPathAndKeys(Object value) throws DmcValueException {
        DmcAttribute<?> attr = get(DmuDMSAG.__pathAndKeys);
        if (attr == null)
            attr = new DmcTypePathAndKeyMV(DmuDMSAG.__pathAndKeys);
        
        setLastValue(attr.add(value));
        add(DmuDMSAG.__pathAndKeys,attr);
        return(attr);
    }

    /**
     * @return the number of values in pathAndKeys
     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1443)
    public int getPathAndKeysSize(){
        DmcAttribute<?> attr = get(DmuDMSAG.__pathAndKeys);
        if (attr == null){
            if (DmuDMSAG.__pathAndKeys.indexSize == 0)
                return(0);
            else
                return(DmuDMSAG.__pathAndKeys.indexSize);
        }
        return(attr.getMVSize());
    }

    /**
     * Deletes a pathAndKeys value.
     * @param value The PathAndKey to be deleted from set of attribute values.
     * @return the deleted attribute instance
     * @throws DmcValueException if the value is incorrect
     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1505)
    public DmcAttribute<?> delPathAndKeys(Object value) throws DmcValueException {
        DmcAttribute<?> attr = get(DmuDMSAG.__pathAndKeys);
        
        if ( (attr == null) && (getModifier()!= null))
            delFromEmptyAttribute(new DmcTypePathAndKeyMV(DmuDMSAG.__pathAndKeys), value);
        else
            attr = del(DmuDMSAG.__pathAndKeys, value);
        
        return(attr);
    }

    /**
     * Deletes a pathAndKeys from the specified value.
     * @param value PathAndKey
     * @return the deleted attribute instance     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1522)
    public DmcAttribute<?> delPathAndKeys(PathAndKey value) {
        DmcAttribute<?> attr = get(DmuDMSAG.__pathAndKeys);
        
        if ( (attr == null) && (getModifier()!= null))
            delFromEmptyAttribute(new DmcTypePathAndKeyMV(DmuDMSAG.__pathAndKeys), value);
        else
            attr = del(DmuDMSAG.__pathAndKeys, value);
        
        return(attr);
    }

    /**
     * Removes the pathAndKeys attribute value.
     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1541)
    public void remPathAndKeys(){
         rem(DmuDMSAG.__pathAndKeys);
    }

    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:798)
    public DefinitionName getName(){
        DmcTypeDefinitionNameSV attr = (DmcTypeDefinitionNameSV) get(MetaDMSAG.__name);
        if (attr == null)
            return(null);

        return(attr.getSV());
    }

    /**
     * Sets name to the specified value.
     * @param value DefinitionName
     */
    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:838)
    public void setName(DefinitionName value) {
        DmcAttribute<?> attr = get(MetaDMSAG.__name);
        if (attr == null)
            attr = new DmcTypeDefinitionNameSV(MetaDMSAG.__name);
        
        try{
            attr.set(value);
            set(MetaDMSAG.__name,attr);
        }
        catch(DmcValueException ex){
            throw(new IllegalStateException("The type specific set() method shouldn't throw exceptions!",ex));
        }
    }

    /**
     * Sets name to the specified value.
     * @param value A value compatible with DmcTypeDefinitionNameSV
     * @throws DmcValueException if value is not correct
     */
    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:892)
    public void setName(Object value) throws DmcValueException {
        DmcTypeDefinitionNameSV attr  = (DmcTypeDefinitionNameSV) get(MetaDMSAG.__name);
        if (attr == null)
            attr = new DmcTypeDefinitionNameSV(MetaDMSAG.__name);
        
        attr.set(value);
        set(MetaDMSAG.__name,attr);
    }

    /**
     * Removes the name attribute value.
     */
    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:912)
    public void remName(){
         rem(MetaDMSAG.__name);
    }




}
