//	---------------------------------------------------------------------------
//	dark-matter-data
//	Copyright (c) 2010-2021 dark-matter-data committers
//	---------------------------------------------------------------------------
//	This program is free software; you can redistribute it and/or modify it
//	under the terms of the GNU Lesser General Public License as published by the
//	Free Software Foundation; either version 3 of the License, or (at your
//	option) any later version.
//	This program is distributed in the hope that it will be useful, but WITHOUT
//	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
//	FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for
//	more details.
//	You should have received a copy of the GNU Lesser General Public License along
//	with this program; if not, see <http://www.gnu.org/licenses/lgpl.html>.
//	---------------------------------------------------------------------------
package org.dmd.dmv.server.generated;

import org.dmd.dmc.DmcOmni;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.*;
import org.dmd.dms.generated.dmo.*;
import org.dmd.dmv.shared.generated.dmo.DmvDMSAG;


/**
 * The dmv schema defines classes associated with the Dark Matter
 * Validation\n (DMV) framework based on RuleDefinitions. Although you are
 * completely free to define your\n own rules, DMV provides a collection of
 * commonly useful rules taht can be used in a DMO\n run context.
 * <P>
 * Generated from the dmv schema at version 0.1
 * <P>
 * This code was auto-generated by the dmggenerator utility and shouldn't be alterred manually!
 * Generated from: org.dmd.dmg.util.SchemaFormatter.dumpSchema(SchemaFormatter.java:182)
 */
public class DmvSchemaAG extends SchemaDefinition {

    public static ClassDefinition _AllowedAttributesRuleData;
    public static ClassDefinition _InitRuleData;
    public static ClassDefinition _NumericRangeRuleData;
    public static ClassDefinition _UCOAllowedAttributesRuleData;
    public static ClassDefinition _RelatedNumbersRuleData;
    public static ClassDefinition _CheckAttributesBasedOnValueRuleData;
    public static ClassDefinition _OneOfTheseAttributesRequiredRuleData;
    public static ClassDefinition _PatternMatchRuleData;
    public static ClassDefinition _ValueLengthRuleData;
    public static ClassDefinition _ReferencedAttributeTypeRuleData;
    public static ClassDefinition _OnlyOneOfTheseAttributesAllowedRuleData;
    public static ClassDefinition _PartCheckerRuleData;
    public static ClassDefinition _NamedObjectRuleData;
    public static ClassDefinition _RestrictReferencesRuleData;
    public static ClassDefinition _CardinalityRuleData;
    public static ClassDefinition _StringSetRuleData;

    public static AttributeDefinition _nrrMinimum;
    public static AttributeDefinition _nrrMaximum;
    public static AttributeDefinition _numericRelation;
    public static AttributeDefinition _lhs;
    public static AttributeDefinition _rhs;
    public static AttributeDefinition _allowedType;
    public static AttributeDefinition _basedOnAttribute;
    public static AttributeDefinition _basedOnValue;
    public static AttributeDefinition _excludeThisAttribute;
    public static AttributeDefinition _includeThisAttribute;
    public static AttributeDefinition _onePossibility;
    public static AttributeDefinition _andOnlyOne;
    public static AttributeDefinition _matchesPattern;
    public static AttributeDefinition _maxLength;
    public static AttributeDefinition _minLength;
    public static AttributeDefinition _allowedValueType;
    public static AttributeDefinition _allowedReference;
    public static AttributeDefinition _crMinimum;
    public static AttributeDefinition _crMaximum;
    public static AttributeDefinition _allowedString;




    public static EnumDefinition _NumericRelationEnum;

    public static RuleDefinition _AllowedAttributesRule;
    public static RuleDefinition _InitRule;
    public static RuleDefinition _NumericRangeRule;
    public static RuleDefinition _UCOAllowedAttributesRule;
    public static RuleDefinition _RelatedNumbersRule;
    public static RuleDefinition _CheckAttributesBasedOnValueRule;
    public static RuleDefinition _OneOfTheseAttributesRequiredRule;
    public static RuleDefinition _PatternMatchRule;
    public static RuleDefinition _ValueLengthRule;
    public static RuleDefinition _ReferencedAttributeTypeRule;
    public static RuleDefinition _OnlyOneOfTheseAttributesAllowedRule;
    public static RuleDefinition _PartCheckerRule;
    public static RuleDefinition _NamedObjectRule;
    public static RuleDefinition _RestrictReferencesRule;
    public static RuleDefinition _CardinalityRule;
    public static RuleDefinition _StringSetRule;


    static DmvSchemaAG instance;

    public DmvSchemaAG() throws DmcValueException {
        generatedSchema = true;
        staticRefName   = "org.dmd.dmv.server.generated.DmvSchemaAG";

    }

    // Generated from: org.dmd.dmg.util.SchemaFormatter.dumpSchema(SchemaFormatter.java:208)
    private void initialize() throws DmcValueException {
        if (instance == null){
            instance        = this;
            SchemaDefinitionDMO me = (SchemaDefinitionDMO) this.getDmcObject();
            me.setName("dmv");
            me.setDotName("dmv");
            me.setSchemaPackage("org.dmd.dmv.shared");
            me.setDmwPackage("org.dmd.dmv.server");
            me.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/dmv.dms");

            initClasses();
            initAttributes1();
            initTypes();
            initComplexTypes();
            initActions();
            initEnums();
            initRules();
            initDSDModules();
            DmcOmni.instance().addCompactSchema(DmvDMSAG.instance());
        }
    }

    // Generated from: org.dmd.dmg.util.SchemaFormatter.dumpInitFunction(SchemaFormatter.java:313)
    private void initClasses() throws DmcValueException {
// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            ClassDefinitionDMO _AllowedAttributesRuleDataOBJ = new ClassDefinitionDMO();
            _AllowedAttributesRuleData = new ClassDefinition(_AllowedAttributesRuleDataOBJ,DmvDMSAG.__AllowedAttributesRuleData);
            _AllowedAttributesRuleDataOBJ.setName("AllowedAttributesRuleData");
            _AllowedAttributesRuleDataOBJ.setDmdID("-959999");
            _AllowedAttributesRuleDataOBJ.setClassType("STRUCTURAL");
            _AllowedAttributesRuleDataOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/rules.dmd");
            _AllowedAttributesRuleDataOBJ.setLineNumber("2");
            _AllowedAttributesRuleDataOBJ.setInternallyGenerated("true");
            _AllowedAttributesRuleDataOBJ.setIsNamedBy("meta.ruleName");
            _AllowedAttributesRuleDataOBJ.setRuleDefinition("dmv.AllowedAttributesRule");
            _AllowedAttributesRuleDataOBJ.addDescription("Way too long!");
            _AllowedAttributesRuleDataOBJ.setDerivedFrom("meta.RuleData");
            _AllowedAttributesRuleDataOBJ.addMust("meta.ruleName");
            _AllowedAttributesRuleDataOBJ.addMust("meta.ruleTitle");
            _AllowedAttributesRuleDataOBJ.addMay("meta.description");
            _AllowedAttributesRuleDataOBJ.setDmwIteratorImport("org.dmd.dmv.server.generated.dmw.AllowedAttributesRuleDataIterableDMW");
            _AllowedAttributesRuleDataOBJ.setDmwIteratorClass("AllowedAttributesRuleDataIterableDMW");
            _AllowedAttributesRuleDataOBJ.setDmtREFImport("org.dmd.dmv.shared.generated.types.AllowedAttributesRuleDataREF");
            _AllowedAttributesRuleDataOBJ.setDotName("dmv.AllowedAttributesRuleData.ClassDefinition");
            _AllowedAttributesRuleData.setDefinedIn(this);
            addClassDefList(_AllowedAttributesRuleData);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            ClassDefinitionDMO _InitRuleDataOBJ = new ClassDefinitionDMO();
            _InitRuleData = new ClassDefinition(_InitRuleDataOBJ,DmvDMSAG.__InitRuleData);
            _InitRuleDataOBJ.setName("InitRuleData");
            _InitRuleDataOBJ.setDmdID("-959998");
            _InitRuleDataOBJ.setClassType("EXTENSIBLE");
            _InitRuleDataOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/rules.dmd");
            _InitRuleDataOBJ.setLineNumber("31");
            _InitRuleDataOBJ.setInternallyGenerated("true");
            _InitRuleDataOBJ.setIsNamedBy("meta.ruleName");
            _InitRuleDataOBJ.setRuleDefinition("dmv.InitRule");
            _InitRuleDataOBJ.addDescription("Way too long!");
            _InitRuleDataOBJ.setDerivedFrom("meta.RuleData");
            _InitRuleDataOBJ.addMust("meta.ruleName");
            _InitRuleDataOBJ.addMust("meta.ruleTitle");
            _InitRuleDataOBJ.addMay("meta.description");
            _InitRuleDataOBJ.setDmwIteratorImport("org.dmd.dmv.server.generated.dmw.InitRuleDataIterableDMW");
            _InitRuleDataOBJ.setDmwIteratorClass("InitRuleDataIterableDMW");
            _InitRuleDataOBJ.setDmtREFImport("org.dmd.dmv.shared.generated.types.InitRuleDataREF");
            _InitRuleDataOBJ.setDotName("dmv.InitRuleData.ClassDefinition");
            _InitRuleData.setDefinedIn(this);
            addClassDefList(_InitRuleData);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            ClassDefinitionDMO _NumericRangeRuleDataOBJ = new ClassDefinitionDMO();
            _NumericRangeRuleData = new ClassDefinition(_NumericRangeRuleDataOBJ,DmvDMSAG.__NumericRangeRuleData);
            _NumericRangeRuleDataOBJ.setName("NumericRangeRuleData");
            _NumericRangeRuleDataOBJ.setDmdID("-959997");
            _NumericRangeRuleDataOBJ.setClassType("STRUCTURAL");
            _NumericRangeRuleDataOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/rules.dmd");
            _NumericRangeRuleDataOBJ.setLineNumber("57");
            _NumericRangeRuleDataOBJ.setInternallyGenerated("true");
            _NumericRangeRuleDataOBJ.setIsNamedBy("meta.ruleName");
            _NumericRangeRuleDataOBJ.setRuleDefinition("dmv.NumericRangeRule");
            _NumericRangeRuleDataOBJ.addDescription("Way too long!");
            _NumericRangeRuleDataOBJ.setDerivedFrom("meta.RuleData");
            _NumericRangeRuleDataOBJ.addMust("meta.ruleName");
            _NumericRangeRuleDataOBJ.addMust("meta.ruleTitle");
            _NumericRangeRuleDataOBJ.addMust("meta.applyToAttribute");
            _NumericRangeRuleDataOBJ.addMay("meta.description");
            _NumericRangeRuleDataOBJ.addMay("dmv.nrrMinimum");
            _NumericRangeRuleDataOBJ.addMay("dmv.nrrMaximum");
            _NumericRangeRuleDataOBJ.setDmwIteratorImport("org.dmd.dmv.server.generated.dmw.NumericRangeRuleDataIterableDMW");
            _NumericRangeRuleDataOBJ.setDmwIteratorClass("NumericRangeRuleDataIterableDMW");
            _NumericRangeRuleDataOBJ.setDmtREFImport("org.dmd.dmv.shared.generated.types.NumericRangeRuleDataREF");
            _NumericRangeRuleDataOBJ.setDotName("dmv.NumericRangeRuleData.ClassDefinition");
            _NumericRangeRuleData.setDefinedIn(this);
            addClassDefList(_NumericRangeRuleData);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            ClassDefinitionDMO _UCOAllowedAttributesRuleDataOBJ = new ClassDefinitionDMO();
            _UCOAllowedAttributesRuleData = new ClassDefinition(_UCOAllowedAttributesRuleDataOBJ,DmvDMSAG.__UCOAllowedAttributesRuleData);
            _UCOAllowedAttributesRuleDataOBJ.setName("UCOAllowedAttributesRuleData");
            _UCOAllowedAttributesRuleDataOBJ.setDmdID("-959996");
            _UCOAllowedAttributesRuleDataOBJ.setClassType("STRUCTURAL");
            _UCOAllowedAttributesRuleDataOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/rules.dmd");
            _UCOAllowedAttributesRuleDataOBJ.setLineNumber("83");
            _UCOAllowedAttributesRuleDataOBJ.setInternallyGenerated("true");
            _UCOAllowedAttributesRuleDataOBJ.setIsNamedBy("meta.ruleName");
            _UCOAllowedAttributesRuleDataOBJ.setRuleDefinition("dmv.UCOAllowedAttributesRule");
            _UCOAllowedAttributesRuleDataOBJ.addDescription("The UCOAllowedAttributesRule will determine whether or not the \n attributes of a DmcUncheckedObject conform to the must/may specification of its\n class definition. For classes of type EXTENSIBLE only the must have attributes are checked.");
            _UCOAllowedAttributesRuleDataOBJ.setDerivedFrom("meta.RuleData");
            _UCOAllowedAttributesRuleDataOBJ.addMust("meta.ruleName");
            _UCOAllowedAttributesRuleDataOBJ.addMust("meta.ruleTitle");
            _UCOAllowedAttributesRuleDataOBJ.addMay("meta.description");
            _UCOAllowedAttributesRuleDataOBJ.setDmwIteratorImport("org.dmd.dmv.server.generated.dmw.UCOAllowedAttributesRuleDataIterableDMW");
            _UCOAllowedAttributesRuleDataOBJ.setDmwIteratorClass("UCOAllowedAttributesRuleDataIterableDMW");
            _UCOAllowedAttributesRuleDataOBJ.setDmtREFImport("org.dmd.dmv.shared.generated.types.UCOAllowedAttributesRuleDataREF");
            _UCOAllowedAttributesRuleDataOBJ.setDotName("dmv.UCOAllowedAttributesRuleData.ClassDefinition");
            _UCOAllowedAttributesRuleData.setDefinedIn(this);
            addClassDefList(_UCOAllowedAttributesRuleData);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            ClassDefinitionDMO _RelatedNumbersRuleDataOBJ = new ClassDefinitionDMO();
            _RelatedNumbersRuleData = new ClassDefinition(_RelatedNumbersRuleDataOBJ,DmvDMSAG.__RelatedNumbersRuleData);
            _RelatedNumbersRuleDataOBJ.setName("RelatedNumbersRuleData");
            _RelatedNumbersRuleDataOBJ.setDmdID("-959994");
            _RelatedNumbersRuleDataOBJ.setClassType("STRUCTURAL");
            _RelatedNumbersRuleDataOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/rules.dmd");
            _RelatedNumbersRuleDataOBJ.setLineNumber("105");
            _RelatedNumbersRuleDataOBJ.setInternallyGenerated("true");
            _RelatedNumbersRuleDataOBJ.setIsNamedBy("meta.ruleName");
            _RelatedNumbersRuleDataOBJ.setRuleDefinition("dmv.RelatedNumbersRule");
            _RelatedNumbersRuleDataOBJ.addDescription("Way too long!");
            _RelatedNumbersRuleDataOBJ.setDerivedFrom("meta.RuleData");
            _RelatedNumbersRuleDataOBJ.addMust("meta.ruleName");
            _RelatedNumbersRuleDataOBJ.addMust("meta.ruleTitle");
            _RelatedNumbersRuleDataOBJ.addMust("dmv.lhs");
            _RelatedNumbersRuleDataOBJ.addMust("dmv.rhs");
            _RelatedNumbersRuleDataOBJ.addMust("dmv.numericRelation");
            _RelatedNumbersRuleDataOBJ.addMay("meta.description");
            _RelatedNumbersRuleDataOBJ.setDmwIteratorImport("org.dmd.dmv.server.generated.dmw.RelatedNumbersRuleDataIterableDMW");
            _RelatedNumbersRuleDataOBJ.setDmwIteratorClass("RelatedNumbersRuleDataIterableDMW");
            _RelatedNumbersRuleDataOBJ.setDmtREFImport("org.dmd.dmv.shared.generated.types.RelatedNumbersRuleDataREF");
            _RelatedNumbersRuleDataOBJ.setDotName("dmv.RelatedNumbersRuleData.ClassDefinition");
            _RelatedNumbersRuleData.setDefinedIn(this);
            addClassDefList(_RelatedNumbersRuleData);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            ClassDefinitionDMO _CheckAttributesBasedOnValueRuleDataOBJ = new ClassDefinitionDMO();
            _CheckAttributesBasedOnValueRuleData = new ClassDefinition(_CheckAttributesBasedOnValueRuleDataOBJ,DmvDMSAG.__CheckAttributesBasedOnValueRuleData);
            _CheckAttributesBasedOnValueRuleDataOBJ.setName("CheckAttributesBasedOnValueRuleData");
            _CheckAttributesBasedOnValueRuleDataOBJ.setDmdID("-959993");
            _CheckAttributesBasedOnValueRuleDataOBJ.setClassType("STRUCTURAL");
            _CheckAttributesBasedOnValueRuleDataOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/rules.dmd");
            _CheckAttributesBasedOnValueRuleDataOBJ.setLineNumber("139");
            _CheckAttributesBasedOnValueRuleDataOBJ.setInternallyGenerated("true");
            _CheckAttributesBasedOnValueRuleDataOBJ.setIsNamedBy("meta.ruleName");
            _CheckAttributesBasedOnValueRuleDataOBJ.setRuleDefinition("dmv.CheckAttributesBasedOnValueRule");
            _CheckAttributesBasedOnValueRuleDataOBJ.addDescription("Way too long!");
            _CheckAttributesBasedOnValueRuleDataOBJ.setDerivedFrom("meta.RuleData");
            _CheckAttributesBasedOnValueRuleDataOBJ.addMust("meta.ruleName");
            _CheckAttributesBasedOnValueRuleDataOBJ.addMust("meta.ruleTitle");
            _CheckAttributesBasedOnValueRuleDataOBJ.addMust("dmv.basedOnAttribute");
            _CheckAttributesBasedOnValueRuleDataOBJ.addMust("dmv.basedOnValue");
            _CheckAttributesBasedOnValueRuleDataOBJ.addMay("meta.description");
            _CheckAttributesBasedOnValueRuleDataOBJ.addMay("dmv.excludeThisAttribute");
            _CheckAttributesBasedOnValueRuleDataOBJ.addMay("dmv.includeThisAttribute");
            _CheckAttributesBasedOnValueRuleDataOBJ.setDmwIteratorImport("org.dmd.dmv.server.generated.dmw.CheckAttributesBasedOnValueRuleDataIterableDMW");
            _CheckAttributesBasedOnValueRuleDataOBJ.setDmwIteratorClass("CheckAttributesBasedOnValueRuleDataIterableDMW");
            _CheckAttributesBasedOnValueRuleDataOBJ.setDmtREFImport("org.dmd.dmv.shared.generated.types.CheckAttributesBasedOnValueRuleDataREF");
            _CheckAttributesBasedOnValueRuleDataOBJ.setDotName("dmv.CheckAttributesBasedOnValueRuleData.ClassDefinition");
            _CheckAttributesBasedOnValueRuleData.setDefinedIn(this);
            addClassDefList(_CheckAttributesBasedOnValueRuleData);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            ClassDefinitionDMO _OneOfTheseAttributesRequiredRuleDataOBJ = new ClassDefinitionDMO();
            _OneOfTheseAttributesRequiredRuleData = new ClassDefinition(_OneOfTheseAttributesRequiredRuleDataOBJ,DmvDMSAG.__OneOfTheseAttributesRequiredRuleData);
            _OneOfTheseAttributesRequiredRuleDataOBJ.setName("OneOfTheseAttributesRequiredRuleData");
            _OneOfTheseAttributesRequiredRuleDataOBJ.setDmdID("-959992");
            _OneOfTheseAttributesRequiredRuleDataOBJ.setClassType("STRUCTURAL");
            _OneOfTheseAttributesRequiredRuleDataOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/rules.dmd");
            _OneOfTheseAttributesRequiredRuleDataOBJ.setLineNumber("177");
            _OneOfTheseAttributesRequiredRuleDataOBJ.setInternallyGenerated("true");
            _OneOfTheseAttributesRequiredRuleDataOBJ.setIsNamedBy("meta.ruleName");
            _OneOfTheseAttributesRequiredRuleDataOBJ.setRuleDefinition("dmv.OneOfTheseAttributesRequiredRule");
            _OneOfTheseAttributesRequiredRuleDataOBJ.addDescription("Way too long!");
            _OneOfTheseAttributesRequiredRuleDataOBJ.setDerivedFrom("meta.RuleData");
            _OneOfTheseAttributesRequiredRuleDataOBJ.addMust("meta.ruleName");
            _OneOfTheseAttributesRequiredRuleDataOBJ.addMust("meta.ruleTitle");
            _OneOfTheseAttributesRequiredRuleDataOBJ.addMust("dmv.onePossibility");
            _OneOfTheseAttributesRequiredRuleDataOBJ.addMay("meta.description");
            _OneOfTheseAttributesRequiredRuleDataOBJ.addMay("dmv.andOnlyOne");
            _OneOfTheseAttributesRequiredRuleDataOBJ.setDmwIteratorImport("org.dmd.dmv.server.generated.dmw.OneOfTheseAttributesRequiredRuleDataIterableDMW");
            _OneOfTheseAttributesRequiredRuleDataOBJ.setDmwIteratorClass("OneOfTheseAttributesRequiredRuleDataIterableDMW");
            _OneOfTheseAttributesRequiredRuleDataOBJ.setDmtREFImport("org.dmd.dmv.shared.generated.types.OneOfTheseAttributesRequiredRuleDataREF");
            _OneOfTheseAttributesRequiredRuleDataOBJ.setDotName("dmv.OneOfTheseAttributesRequiredRuleData.ClassDefinition");
            _OneOfTheseAttributesRequiredRuleData.setDefinedIn(this);
            addClassDefList(_OneOfTheseAttributesRequiredRuleData);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            ClassDefinitionDMO _PatternMatchRuleDataOBJ = new ClassDefinitionDMO();
            _PatternMatchRuleData = new ClassDefinition(_PatternMatchRuleDataOBJ,DmvDMSAG.__PatternMatchRuleData);
            _PatternMatchRuleDataOBJ.setName("PatternMatchRuleData");
            _PatternMatchRuleDataOBJ.setDmdID("-959991");
            _PatternMatchRuleDataOBJ.setClassType("STRUCTURAL");
            _PatternMatchRuleDataOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/rules.dmd");
            _PatternMatchRuleDataOBJ.setLineNumber("209");
            _PatternMatchRuleDataOBJ.setInternallyGenerated("true");
            _PatternMatchRuleDataOBJ.setIsNamedBy("meta.ruleName");
            _PatternMatchRuleDataOBJ.setRuleDefinition("dmv.PatternMatchRule");
            _PatternMatchRuleDataOBJ.addDescription("Way too long!");
            _PatternMatchRuleDataOBJ.setDerivedFrom("meta.RuleData");
            _PatternMatchRuleDataOBJ.addMust("meta.ruleName");
            _PatternMatchRuleDataOBJ.addMust("meta.ruleTitle");
            _PatternMatchRuleDataOBJ.addMust("meta.applyToAttribute");
            _PatternMatchRuleDataOBJ.addMust("dmv.matchesPattern");
            _PatternMatchRuleDataOBJ.addMay("meta.description");
            _PatternMatchRuleDataOBJ.setDmwIteratorImport("org.dmd.dmv.server.generated.dmw.PatternMatchRuleDataIterableDMW");
            _PatternMatchRuleDataOBJ.setDmwIteratorClass("PatternMatchRuleDataIterableDMW");
            _PatternMatchRuleDataOBJ.setDmtREFImport("org.dmd.dmv.shared.generated.types.PatternMatchRuleDataREF");
            _PatternMatchRuleDataOBJ.setDotName("dmv.PatternMatchRuleData.ClassDefinition");
            _PatternMatchRuleData.setDefinedIn(this);
            addClassDefList(_PatternMatchRuleData);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            ClassDefinitionDMO _ValueLengthRuleDataOBJ = new ClassDefinitionDMO();
            _ValueLengthRuleData = new ClassDefinition(_ValueLengthRuleDataOBJ,DmvDMSAG.__ValueLengthRuleData);
            _ValueLengthRuleDataOBJ.setName("ValueLengthRuleData");
            _ValueLengthRuleDataOBJ.setDmdID("-959990");
            _ValueLengthRuleDataOBJ.setClassType("STRUCTURAL");
            _ValueLengthRuleDataOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/rules.dmd");
            _ValueLengthRuleDataOBJ.setLineNumber("267");
            _ValueLengthRuleDataOBJ.setInternallyGenerated("true");
            _ValueLengthRuleDataOBJ.setIsNamedBy("meta.ruleName");
            _ValueLengthRuleDataOBJ.setRuleDefinition("dmv.ValueLengthRule");
            _ValueLengthRuleDataOBJ.addDescription("Way too long!");
            _ValueLengthRuleDataOBJ.setDerivedFrom("meta.RuleData");
            _ValueLengthRuleDataOBJ.addMust("meta.ruleName");
            _ValueLengthRuleDataOBJ.addMust("meta.ruleTitle");
            _ValueLengthRuleDataOBJ.addMust("meta.applyToAttribute");
            _ValueLengthRuleDataOBJ.addMay("meta.description");
            _ValueLengthRuleDataOBJ.addMay("dmv.maxLength");
            _ValueLengthRuleDataOBJ.addMay("dmv.minLength");
            _ValueLengthRuleDataOBJ.setDmwIteratorImport("org.dmd.dmv.server.generated.dmw.ValueLengthRuleDataIterableDMW");
            _ValueLengthRuleDataOBJ.setDmwIteratorClass("ValueLengthRuleDataIterableDMW");
            _ValueLengthRuleDataOBJ.setDmtREFImport("org.dmd.dmv.shared.generated.types.ValueLengthRuleDataREF");
            _ValueLengthRuleDataOBJ.setDotName("dmv.ValueLengthRuleData.ClassDefinition");
            _ValueLengthRuleData.setDefinedIn(this);
            addClassDefList(_ValueLengthRuleData);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            ClassDefinitionDMO _ReferencedAttributeTypeRuleDataOBJ = new ClassDefinitionDMO();
            _ReferencedAttributeTypeRuleData = new ClassDefinition(_ReferencedAttributeTypeRuleDataOBJ,DmvDMSAG.__ReferencedAttributeTypeRuleData);
            _ReferencedAttributeTypeRuleDataOBJ.setName("ReferencedAttributeTypeRuleData");
            _ReferencedAttributeTypeRuleDataOBJ.setDmdID("-959989");
            _ReferencedAttributeTypeRuleDataOBJ.setClassType("STRUCTURAL");
            _ReferencedAttributeTypeRuleDataOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/rules.dmd");
            _ReferencedAttributeTypeRuleDataOBJ.setLineNumber("348");
            _ReferencedAttributeTypeRuleDataOBJ.setInternallyGenerated("true");
            _ReferencedAttributeTypeRuleDataOBJ.setIsNamedBy("meta.ruleName");
            _ReferencedAttributeTypeRuleDataOBJ.setRuleDefinition("dmv.ReferencedAttributeTypeRule");
            _ReferencedAttributeTypeRuleDataOBJ.addDescription("Way too long!");
            _ReferencedAttributeTypeRuleDataOBJ.setDerivedFrom("meta.RuleData");
            _ReferencedAttributeTypeRuleDataOBJ.addMust("meta.ruleName");
            _ReferencedAttributeTypeRuleDataOBJ.addMust("meta.ruleTitle");
            _ReferencedAttributeTypeRuleDataOBJ.addMust("meta.applyToAttribute");
            _ReferencedAttributeTypeRuleDataOBJ.addMay("meta.description");
            _ReferencedAttributeTypeRuleDataOBJ.addMay("dmv.allowedType");
            _ReferencedAttributeTypeRuleDataOBJ.addMay("dmv.allowedValueType");
            _ReferencedAttributeTypeRuleDataOBJ.setDmwIteratorImport("org.dmd.dmv.server.generated.dmw.ReferencedAttributeTypeRuleDataIterableDMW");
            _ReferencedAttributeTypeRuleDataOBJ.setDmwIteratorClass("ReferencedAttributeTypeRuleDataIterableDMW");
            _ReferencedAttributeTypeRuleDataOBJ.setDmtREFImport("org.dmd.dmv.shared.generated.types.ReferencedAttributeTypeRuleDataREF");
            _ReferencedAttributeTypeRuleDataOBJ.setDotName("dmv.ReferencedAttributeTypeRuleData.ClassDefinition");
            _ReferencedAttributeTypeRuleData.setDefinedIn(this);
            addClassDefList(_ReferencedAttributeTypeRuleData);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            ClassDefinitionDMO _OnlyOneOfTheseAttributesAllowedRuleDataOBJ = new ClassDefinitionDMO();
            _OnlyOneOfTheseAttributesAllowedRuleData = new ClassDefinition(_OnlyOneOfTheseAttributesAllowedRuleDataOBJ,DmvDMSAG.__OnlyOneOfTheseAttributesAllowedRuleData);
            _OnlyOneOfTheseAttributesAllowedRuleDataOBJ.setName("OnlyOneOfTheseAttributesAllowedRuleData");
            _OnlyOneOfTheseAttributesAllowedRuleDataOBJ.setDmdID("-959988");
            _OnlyOneOfTheseAttributesAllowedRuleDataOBJ.setClassType("STRUCTURAL");
            _OnlyOneOfTheseAttributesAllowedRuleDataOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/rules.dmd");
            _OnlyOneOfTheseAttributesAllowedRuleDataOBJ.setLineNumber("386");
            _OnlyOneOfTheseAttributesAllowedRuleDataOBJ.setInternallyGenerated("true");
            _OnlyOneOfTheseAttributesAllowedRuleDataOBJ.setIsNamedBy("meta.ruleName");
            _OnlyOneOfTheseAttributesAllowedRuleDataOBJ.setRuleDefinition("dmv.OnlyOneOfTheseAttributesAllowedRule");
            _OnlyOneOfTheseAttributesAllowedRuleDataOBJ.addDescription("Way too long!");
            _OnlyOneOfTheseAttributesAllowedRuleDataOBJ.setDerivedFrom("meta.RuleData");
            _OnlyOneOfTheseAttributesAllowedRuleDataOBJ.addMust("meta.ruleName");
            _OnlyOneOfTheseAttributesAllowedRuleDataOBJ.addMust("meta.ruleTitle");
            _OnlyOneOfTheseAttributesAllowedRuleDataOBJ.addMust("dmv.onePossibility");
            _OnlyOneOfTheseAttributesAllowedRuleDataOBJ.addMay("meta.description");
            _OnlyOneOfTheseAttributesAllowedRuleDataOBJ.setDmwIteratorImport("org.dmd.dmv.server.generated.dmw.OnlyOneOfTheseAttributesAllowedRuleDataIterableDMW");
            _OnlyOneOfTheseAttributesAllowedRuleDataOBJ.setDmwIteratorClass("OnlyOneOfTheseAttributesAllowedRuleDataIterableDMW");
            _OnlyOneOfTheseAttributesAllowedRuleDataOBJ.setDmtREFImport("org.dmd.dmv.shared.generated.types.OnlyOneOfTheseAttributesAllowedRuleDataREF");
            _OnlyOneOfTheseAttributesAllowedRuleDataOBJ.setDotName("dmv.OnlyOneOfTheseAttributesAllowedRuleData.ClassDefinition");
            _OnlyOneOfTheseAttributesAllowedRuleData.setDefinedIn(this);
            addClassDefList(_OnlyOneOfTheseAttributesAllowedRuleData);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            ClassDefinitionDMO _PartCheckerRuleDataOBJ = new ClassDefinitionDMO();
            _PartCheckerRuleData = new ClassDefinition(_PartCheckerRuleDataOBJ,DmvDMSAG.__PartCheckerRuleData);
            _PartCheckerRuleDataOBJ.setName("PartCheckerRuleData");
            _PartCheckerRuleDataOBJ.setDmdID("-959986");
            _PartCheckerRuleDataOBJ.setClassType("STRUCTURAL");
            _PartCheckerRuleDataOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/rules.dmd");
            _PartCheckerRuleDataOBJ.setLineNumber("408");
            _PartCheckerRuleDataOBJ.setInternallyGenerated("true");
            _PartCheckerRuleDataOBJ.setIsNamedBy("meta.ruleName");
            _PartCheckerRuleDataOBJ.setRuleDefinition("dmv.PartCheckerRule");
            _PartCheckerRuleDataOBJ.addDescription("The PartCheckerRule will validate a ComplexTypeDefinition\n for some of the more tricky aspects of that definition. In particular it will\n check: <br>\n <ul>\n <li> that the greedy flag is only specified on requiredPart attributes </li>\n <li> that the greedy flag is only specified on ComplexTypes where are all parts are required </li>\n <li> that the greedy flag is only specified on the final requiredPart </li>\n </ul>");
            _PartCheckerRuleDataOBJ.setDerivedFrom("meta.RuleData");
            _PartCheckerRuleDataOBJ.addMust("meta.ruleName");
            _PartCheckerRuleDataOBJ.addMust("meta.ruleTitle");
            _PartCheckerRuleDataOBJ.addMay("meta.description");
            _PartCheckerRuleDataOBJ.setDmwIteratorImport("org.dmd.dmv.server.generated.dmw.PartCheckerRuleDataIterableDMW");
            _PartCheckerRuleDataOBJ.setDmwIteratorClass("PartCheckerRuleDataIterableDMW");
            _PartCheckerRuleDataOBJ.setDmtREFImport("org.dmd.dmv.shared.generated.types.PartCheckerRuleDataREF");
            _PartCheckerRuleDataOBJ.setDotName("dmv.PartCheckerRuleData.ClassDefinition");
            _PartCheckerRuleData.setDefinedIn(this);
            addClassDefList(_PartCheckerRuleData);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            ClassDefinitionDMO _NamedObjectRuleDataOBJ = new ClassDefinitionDMO();
            _NamedObjectRuleData = new ClassDefinition(_NamedObjectRuleDataOBJ,DmvDMSAG.__NamedObjectRuleData);
            _NamedObjectRuleDataOBJ.setName("NamedObjectRuleData");
            _NamedObjectRuleDataOBJ.setDmdID("-959985");
            _NamedObjectRuleDataOBJ.setClassType("STRUCTURAL");
            _NamedObjectRuleDataOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/rules.dmd");
            _NamedObjectRuleDataOBJ.setLineNumber("429");
            _NamedObjectRuleDataOBJ.setInternallyGenerated("true");
            _NamedObjectRuleDataOBJ.setIsNamedBy("meta.ruleName");
            _NamedObjectRuleDataOBJ.setRuleDefinition("dmv.NamedObjectRule");
            _NamedObjectRuleDataOBJ.addDescription("The NamedObjectRule will validate a ClassDefinition for a named object\n to ensure that the isNamedBy attribute is included in the must have attributes list.");
            _NamedObjectRuleDataOBJ.setDerivedFrom("meta.RuleData");
            _NamedObjectRuleDataOBJ.addMust("meta.ruleName");
            _NamedObjectRuleDataOBJ.addMust("meta.ruleTitle");
            _NamedObjectRuleDataOBJ.addMay("meta.description");
            _NamedObjectRuleDataOBJ.setDmwIteratorImport("org.dmd.dmv.server.generated.dmw.NamedObjectRuleDataIterableDMW");
            _NamedObjectRuleDataOBJ.setDmwIteratorClass("NamedObjectRuleDataIterableDMW");
            _NamedObjectRuleDataOBJ.setDmtREFImport("org.dmd.dmv.shared.generated.types.NamedObjectRuleDataREF");
            _NamedObjectRuleDataOBJ.setDotName("dmv.NamedObjectRuleData.ClassDefinition");
            _NamedObjectRuleData.setDefinedIn(this);
            addClassDefList(_NamedObjectRuleData);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            ClassDefinitionDMO _RestrictReferencesRuleDataOBJ = new ClassDefinitionDMO();
            _RestrictReferencesRuleData = new ClassDefinition(_RestrictReferencesRuleDataOBJ,DmvDMSAG.__RestrictReferencesRuleData);
            _RestrictReferencesRuleDataOBJ.setName("RestrictReferencesRuleData");
            _RestrictReferencesRuleDataOBJ.setDmdID("-959984");
            _RestrictReferencesRuleDataOBJ.setClassType("STRUCTURAL");
            _RestrictReferencesRuleDataOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/rules.dmd");
            _RestrictReferencesRuleDataOBJ.setLineNumber("444");
            _RestrictReferencesRuleDataOBJ.setInternallyGenerated("true");
            _RestrictReferencesRuleDataOBJ.setIsNamedBy("meta.ruleName");
            _RestrictReferencesRuleDataOBJ.setRuleDefinition("dmv.RestrictReferencesRule");
            _RestrictReferencesRuleDataOBJ.addDescription("Way too long!");
            _RestrictReferencesRuleDataOBJ.setDerivedFrom("meta.RuleData");
            _RestrictReferencesRuleDataOBJ.addMust("meta.ruleName");
            _RestrictReferencesRuleDataOBJ.addMust("meta.ruleTitle");
            _RestrictReferencesRuleDataOBJ.addMust("meta.applyToAttribute");
            _RestrictReferencesRuleDataOBJ.addMust("dmv.allowedReference");
            _RestrictReferencesRuleDataOBJ.addMay("meta.description");
            _RestrictReferencesRuleDataOBJ.setDmwIteratorImport("org.dmd.dmv.server.generated.dmw.RestrictReferencesRuleDataIterableDMW");
            _RestrictReferencesRuleDataOBJ.setDmwIteratorClass("RestrictReferencesRuleDataIterableDMW");
            _RestrictReferencesRuleDataOBJ.setDmtREFImport("org.dmd.dmv.shared.generated.types.RestrictReferencesRuleDataREF");
            _RestrictReferencesRuleDataOBJ.setDotName("dmv.RestrictReferencesRuleData.ClassDefinition");
            _RestrictReferencesRuleData.setDefinedIn(this);
            addClassDefList(_RestrictReferencesRuleData);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            ClassDefinitionDMO _CardinalityRuleDataOBJ = new ClassDefinitionDMO();
            _CardinalityRuleData = new ClassDefinition(_CardinalityRuleDataOBJ,DmvDMSAG.__CardinalityRuleData);
            _CardinalityRuleDataOBJ.setName("CardinalityRuleData");
            _CardinalityRuleDataOBJ.setDmdID("-959983");
            _CardinalityRuleDataOBJ.setClassType("STRUCTURAL");
            _CardinalityRuleDataOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/rules.dmd");
            _CardinalityRuleDataOBJ.setLineNumber("476");
            _CardinalityRuleDataOBJ.setInternallyGenerated("true");
            _CardinalityRuleDataOBJ.setIsNamedBy("meta.ruleName");
            _CardinalityRuleDataOBJ.setRuleDefinition("dmv.CardinalityRule");
            _CardinalityRuleDataOBJ.addDescription("Way too long!");
            _CardinalityRuleDataOBJ.setDerivedFrom("meta.RuleData");
            _CardinalityRuleDataOBJ.addMust("meta.ruleName");
            _CardinalityRuleDataOBJ.addMust("meta.ruleTitle");
            _CardinalityRuleDataOBJ.addMust("meta.applyToAttribute");
            _CardinalityRuleDataOBJ.addMust("dmv.crMinimum");
            _CardinalityRuleDataOBJ.addMust("dmv.crMaximum");
            _CardinalityRuleDataOBJ.addMay("meta.description");
            _CardinalityRuleDataOBJ.setDmwIteratorImport("org.dmd.dmv.server.generated.dmw.CardinalityRuleDataIterableDMW");
            _CardinalityRuleDataOBJ.setDmwIteratorClass("CardinalityRuleDataIterableDMW");
            _CardinalityRuleDataOBJ.setDmtREFImport("org.dmd.dmv.shared.generated.types.CardinalityRuleDataREF");
            _CardinalityRuleDataOBJ.setDotName("dmv.CardinalityRuleData.ClassDefinition");
            _CardinalityRuleData.setDefinedIn(this);
            addClassDefList(_CardinalityRuleData);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            ClassDefinitionDMO _StringSetRuleDataOBJ = new ClassDefinitionDMO();
            _StringSetRuleData = new ClassDefinition(_StringSetRuleDataOBJ,DmvDMSAG.__StringSetRuleData);
            _StringSetRuleDataOBJ.setName("StringSetRuleData");
            _StringSetRuleDataOBJ.setDmdID("-959982");
            _StringSetRuleDataOBJ.setClassType("STRUCTURAL");
            _StringSetRuleDataOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/rules.dmd");
            _StringSetRuleDataOBJ.setLineNumber("652");
            _StringSetRuleDataOBJ.setInternallyGenerated("true");
            _StringSetRuleDataOBJ.setIsNamedBy("meta.ruleName");
            _StringSetRuleDataOBJ.setRuleDefinition("dmv.StringSetRule");
            _StringSetRuleDataOBJ.addDescription("The StringSetRule lets you specify a set of strings that are allowed as values for an attribute.\n <pre>\n StringSetRule\n ruleName	fishRule\n ruleTitle	The fish must be one of red fish, blue fish or green fish.\n applyToAttribute fish\n allowedString red fish\n allowedString blue fish\n allowedString green fish\n </pre>");
            _StringSetRuleDataOBJ.setDerivedFrom("meta.RuleData");
            _StringSetRuleDataOBJ.addMust("meta.ruleName");
            _StringSetRuleDataOBJ.addMust("meta.ruleTitle");
            _StringSetRuleDataOBJ.addMust("meta.applyToAttribute");
            _StringSetRuleDataOBJ.addMust("dmv.allowedString");
            _StringSetRuleDataOBJ.addMay("meta.description");
            _StringSetRuleDataOBJ.setDmwIteratorImport("org.dmd.dmv.server.generated.dmw.StringSetRuleDataIterableDMW");
            _StringSetRuleDataOBJ.setDmwIteratorClass("StringSetRuleDataIterableDMW");
            _StringSetRuleDataOBJ.setDmtREFImport("org.dmd.dmv.shared.generated.types.StringSetRuleDataREF");
            _StringSetRuleDataOBJ.setDotName("dmv.StringSetRuleData.ClassDefinition");
            _StringSetRuleData.setDefinedIn(this);
            addClassDefList(_StringSetRuleData);

    }

    private void initAttributes1() throws DmcValueException {
// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            AttributeDefinitionDMO _nrrMinimumOBJ = new AttributeDefinitionDMO();
            _nrrMinimum = new AttributeDefinition(_nrrMinimumOBJ);
            _nrrMinimumOBJ.addDescription("The minimum numeric value.");
            _nrrMinimumOBJ.setName("nrrMinimum");
            _nrrMinimumOBJ.setDmdID("-479999");
            _nrrMinimumOBJ.setType("meta.Double");
            _nrrMinimumOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/attributes.dmd");
            _nrrMinimumOBJ.setDotName("dmv.nrrMinimum.AttributeDefinition");
            _nrrMinimumOBJ.setLineNumber("1");
            _nrrMinimum.setDefinedIn(this);
            addAttributeDefList(_nrrMinimum);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            AttributeDefinitionDMO _nrrMaximumOBJ = new AttributeDefinitionDMO();
            _nrrMaximum = new AttributeDefinition(_nrrMaximumOBJ);
            _nrrMaximumOBJ.addDescription("The maximum numeric value.");
            _nrrMaximumOBJ.setName("nrrMaximum");
            _nrrMaximumOBJ.setDmdID("-479998");
            _nrrMaximumOBJ.setType("meta.Double");
            _nrrMaximumOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/attributes.dmd");
            _nrrMaximumOBJ.setDotName("dmv.nrrMaximum.AttributeDefinition");
            _nrrMaximumOBJ.setLineNumber("7");
            _nrrMaximum.setDefinedIn(this);
            addAttributeDefList(_nrrMaximum);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            AttributeDefinitionDMO _numericRelationOBJ = new AttributeDefinitionDMO();
            _numericRelation = new AttributeDefinition(_numericRelationOBJ);
            _numericRelationOBJ.addDescription("The relationship between numeric values.");
            _numericRelationOBJ.setName("numericRelation");
            _numericRelationOBJ.setDmdID("-479997");
            _numericRelationOBJ.setType("dmv.NumericRelationEnum");
            _numericRelationOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/attributes.dmd");
            _numericRelationOBJ.setDotName("dmv.numericRelation.AttributeDefinition");
            _numericRelationOBJ.setLineNumber("13");
            _numericRelation.setDefinedIn(this);
            addAttributeDefList(_numericRelation);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            AttributeDefinitionDMO _lhsOBJ = new AttributeDefinitionDMO();
            _lhs = new AttributeDefinition(_lhsOBJ);
            _lhsOBJ.addDescription("The attribute to be used as the left hand side of some relationship. The\n type of the attribute referred to may differ from one rule to the next depending on\n the relationship being tested.");
            _lhsOBJ.setName("lhs");
            _lhsOBJ.setDmdID("-479996");
            _lhsOBJ.setType("meta.AttributeDefinition");
            _lhsOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/attributes.dmd");
            _lhsOBJ.setDotName("dmv.lhs.AttributeDefinition");
            _lhsOBJ.setLineNumber("19");
            _lhs.setDefinedIn(this);
            addAttributeDefList(_lhs);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            AttributeDefinitionDMO _rhsOBJ = new AttributeDefinitionDMO();
            _rhs = new AttributeDefinition(_rhsOBJ);
            _rhsOBJ.addDescription("The attribute to be used as the right hand side of some relationship. The\n type of the attribute referred to may differ from one rule to the next depending on\n the relationship being tested.");
            _rhsOBJ.setName("rhs");
            _rhsOBJ.setDmdID("-479995");
            _rhsOBJ.setType("meta.AttributeDefinition");
            _rhsOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/attributes.dmd");
            _rhsOBJ.setDotName("dmv.rhs.AttributeDefinition");
            _rhsOBJ.setLineNumber("27");
            _rhs.setDefinedIn(this);
            addAttributeDefList(_rhs);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            AttributeDefinitionDMO _allowedTypeOBJ = new AttributeDefinitionDMO();
            _allowedType = new AttributeDefinition(_allowedTypeOBJ);
            _allowedTypeOBJ.addDescription("The allowedType indicates a collection of defined types to which something,\n usually and attribute, must conform.");
            _allowedTypeOBJ.setName("allowedType");
            _allowedTypeOBJ.setDmdID("-479994");
            _allowedTypeOBJ.setType("meta.TypeDefinition");
            _allowedTypeOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/attributes.dmd");
            _allowedTypeOBJ.setDotName("dmv.allowedType.AttributeDefinition");
            _allowedTypeOBJ.setLineNumber("35");
            _allowedTypeOBJ.setValueType("MULTI");
            _allowedType.setDefinedIn(this);
            addAttributeDefList(_allowedType);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            AttributeDefinitionDMO _basedOnAttributeOBJ = new AttributeDefinitionDMO();
            _basedOnAttribute = new AttributeDefinition(_basedOnAttributeOBJ);
            _basedOnAttributeOBJ.addDescription("The basedOnAttribute allows for the specification of an attribute on which\n some type of a decision is made.");
            _basedOnAttributeOBJ.setName("basedOnAttribute");
            _basedOnAttributeOBJ.setDmdID("-479993");
            _basedOnAttributeOBJ.setType("meta.AttributeDefinition");
            _basedOnAttributeOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/attributes.dmd");
            _basedOnAttributeOBJ.setDotName("dmv.basedOnAttribute.AttributeDefinition");
            _basedOnAttributeOBJ.setLineNumber("43");
            _basedOnAttribute.setDefinedIn(this);
            addAttributeDefList(_basedOnAttribute);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            AttributeDefinitionDMO _basedOnValueOBJ = new AttributeDefinitionDMO();
            _basedOnValue = new AttributeDefinition(_basedOnValueOBJ);
            _basedOnValueOBJ.addDescription("The basedOnValue attribute allows for the specification of values for some\n aspect of a rule.");
            _basedOnValueOBJ.setName("basedOnValue");
            _basedOnValueOBJ.setDmdID("-479992");
            _basedOnValueOBJ.setType("meta.String");
            _basedOnValueOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/attributes.dmd");
            _basedOnValueOBJ.setDotName("dmv.basedOnValue.AttributeDefinition");
            _basedOnValueOBJ.setLineNumber("50");
            _basedOnValueOBJ.setValueType("HASHSET");
            _basedOnValue.setDefinedIn(this);
            addAttributeDefList(_basedOnValue);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            AttributeDefinitionDMO _excludeThisAttributeOBJ = new AttributeDefinitionDMO();
            _excludeThisAttribute = new AttributeDefinition(_excludeThisAttributeOBJ);
            _excludeThisAttributeOBJ.addDescription("The excludeThisAttribute indicates an optional attribute that must be\n excluded from an object under certain conditions.");
            _excludeThisAttributeOBJ.setName("excludeThisAttribute");
            _excludeThisAttributeOBJ.setDmdID("-479991");
            _excludeThisAttributeOBJ.setType("meta.AttributeDefinition");
            _excludeThisAttributeOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/attributes.dmd");
            _excludeThisAttributeOBJ.setDotName("dmv.excludeThisAttribute.AttributeDefinition");
            _excludeThisAttributeOBJ.setLineNumber("58");
            _excludeThisAttributeOBJ.setValueType("MULTI");
            _excludeThisAttribute.setDefinedIn(this);
            addAttributeDefList(_excludeThisAttribute);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            AttributeDefinitionDMO _includeThisAttributeOBJ = new AttributeDefinitionDMO();
            _includeThisAttribute = new AttributeDefinition(_includeThisAttributeOBJ);
            _includeThisAttributeOBJ.addDescription("The includeThisAttribute indicates an optional attribute that must be\n present under certain conditions.");
            _includeThisAttributeOBJ.setName("includeThisAttribute");
            _includeThisAttributeOBJ.setDmdID("-479990");
            _includeThisAttributeOBJ.setType("meta.AttributeDefinition");
            _includeThisAttributeOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/attributes.dmd");
            _includeThisAttributeOBJ.setDotName("dmv.includeThisAttribute.AttributeDefinition");
            _includeThisAttributeOBJ.setLineNumber("66");
            _includeThisAttributeOBJ.setValueType("MULTI");
            _includeThisAttribute.setDefinedIn(this);
            addAttributeDefList(_includeThisAttribute);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            AttributeDefinitionDMO _onePossibilityOBJ = new AttributeDefinitionDMO();
            _onePossibility = new AttributeDefinition(_onePossibilityOBJ);
            _onePossibilityOBJ.addDescription("The onePossibility attribute indicates an attribute that is one possiblity among\n many.");
            _onePossibilityOBJ.setName("onePossibility");
            _onePossibilityOBJ.setDmdID("-479989");
            _onePossibilityOBJ.setType("meta.AttributeDefinition");
            _onePossibilityOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/attributes.dmd");
            _onePossibilityOBJ.setDotName("dmv.onePossibility.AttributeDefinition");
            _onePossibilityOBJ.setLineNumber("74");
            _onePossibilityOBJ.setValueType("MULTI");
            _onePossibility.setDefinedIn(this);
            addAttributeDefList(_onePossibility);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            AttributeDefinitionDMO _andOnlyOneOBJ = new AttributeDefinitionDMO();
            _andOnlyOne = new AttributeDefinition(_andOnlyOneOBJ);
            _andOnlyOneOBJ.addDescription("The andOnlyOne attribute indicates that only one of a set of possibilities is\n allowed.");
            _andOnlyOneOBJ.setName("andOnlyOne");
            _andOnlyOneOBJ.setDmdID("-479988");
            _andOnlyOneOBJ.setType("meta.Boolean");
            _andOnlyOneOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/attributes.dmd");
            _andOnlyOneOBJ.setDotName("dmv.andOnlyOne.AttributeDefinition");
            _andOnlyOneOBJ.setLineNumber("82");
            _andOnlyOne.setDefinedIn(this);
            addAttributeDefList(_andOnlyOne);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            AttributeDefinitionDMO _matchesPatternOBJ = new AttributeDefinitionDMO();
            _matchesPattern = new AttributeDefinition(_matchesPatternOBJ);
            _matchesPatternOBJ.addDescription("The matchesPattern attribute indicates a regular expression that conforms\n to the");
            _matchesPatternOBJ.setName("matchesPattern");
            _matchesPatternOBJ.setDmdID("-479987");
            _matchesPatternOBJ.setType("meta.String");
            _matchesPatternOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/attributes.dmd");
            _matchesPatternOBJ.setDotName("dmv.matchesPattern.AttributeDefinition");
            _matchesPatternOBJ.setLineNumber("89");
            _matchesPattern.setDefinedIn(this);
            addAttributeDefList(_matchesPattern);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            AttributeDefinitionDMO _maxLengthOBJ = new AttributeDefinitionDMO();
            _maxLength = new AttributeDefinition(_maxLengthOBJ);
            _maxLengthOBJ.addDescription("The maxLength attribute indicates the maximum length of something.");
            _maxLengthOBJ.setName("maxLength");
            _maxLengthOBJ.setDmdID("-479986");
            _maxLengthOBJ.setType("meta.Integer");
            _maxLengthOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/attributes.dmd");
            _maxLengthOBJ.setDotName("dmv.maxLength.AttributeDefinition");
            _maxLengthOBJ.setLineNumber("96");
            _maxLength.setDefinedIn(this);
            addAttributeDefList(_maxLength);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            AttributeDefinitionDMO _minLengthOBJ = new AttributeDefinitionDMO();
            _minLength = new AttributeDefinition(_minLengthOBJ);
            _minLengthOBJ.addDescription("The minLength attribute indicates the minimum length of something.");
            _minLengthOBJ.setName("minLength");
            _minLengthOBJ.setDmdID("-479985");
            _minLengthOBJ.setType("meta.Integer");
            _minLengthOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/attributes.dmd");
            _minLengthOBJ.setDotName("dmv.minLength.AttributeDefinition");
            _minLengthOBJ.setLineNumber("102");
            _minLength.setDefinedIn(this);
            addAttributeDefList(_minLength);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            AttributeDefinitionDMO _allowedValueTypeOBJ = new AttributeDefinitionDMO();
            _allowedValueType = new AttributeDefinition(_allowedValueTypeOBJ);
            _allowedValueTypeOBJ.addDescription("The allowedValueType indicates the allowed cardinality of an attribute.");
            _allowedValueTypeOBJ.setName("allowedValueType");
            _allowedValueTypeOBJ.setDmdID("-479984");
            _allowedValueTypeOBJ.setType("meta.ValueTypeEnum");
            _allowedValueTypeOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/attributes.dmd");
            _allowedValueTypeOBJ.setDotName("dmv.allowedValueType.AttributeDefinition");
            _allowedValueTypeOBJ.setLineNumber("108");
            _allowedValueType.setDefinedIn(this);
            addAttributeDefList(_allowedValueType);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            AttributeDefinitionDMO _allowedReferenceOBJ = new AttributeDefinitionDMO();
            _allowedReference = new AttributeDefinition(_allowedReferenceOBJ);
            _allowedReferenceOBJ.addDescription("The allowedReference indicates the classes of objects that may be referenced via a reference attribute.");
            _allowedReferenceOBJ.setName("allowedReference");
            _allowedReferenceOBJ.setDmdID("-479983");
            _allowedReferenceOBJ.setType("meta.ClassDefinition");
            _allowedReferenceOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/attributes.dmd");
            _allowedReferenceOBJ.setDotName("dmv.allowedReference.AttributeDefinition");
            _allowedReferenceOBJ.setLineNumber("114");
            _allowedReferenceOBJ.setValueType("MULTI");
            _allowedReference.setDefinedIn(this);
            addAttributeDefList(_allowedReference);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            AttributeDefinitionDMO _crMinimumOBJ = new AttributeDefinitionDMO();
            _crMinimum = new AttributeDefinition(_crMinimumOBJ);
            _crMinimumOBJ.addDescription("Indicates the minimum cardinality in a CardinalityRule. NOTE: although we're specifying the\n type as Double, you should use integer compatible values for this.");
            _crMinimumOBJ.setName("crMinimum");
            _crMinimumOBJ.setDmdID("-479982");
            _crMinimumOBJ.setType("meta.Double");
            _crMinimumOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/attributes.dmd");
            _crMinimumOBJ.setDotName("dmv.crMinimum.AttributeDefinition");
            _crMinimumOBJ.setLineNumber("121");
            _crMinimum.setDefinedIn(this);
            addAttributeDefList(_crMinimum);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            AttributeDefinitionDMO _crMaximumOBJ = new AttributeDefinitionDMO();
            _crMaximum = new AttributeDefinition(_crMaximumOBJ);
            _crMaximumOBJ.addDescription("Indicates the maximum cardinality in a CardinalityRule. NOTE: although we're specifying the\n type as Double, you should use integer compatible values for this.");
            _crMaximumOBJ.setName("crMaximum");
            _crMaximumOBJ.setDmdID("-479981");
            _crMaximumOBJ.setType("meta.Double");
            _crMaximumOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/attributes.dmd");
            _crMaximumOBJ.setDotName("dmv.crMaximum.AttributeDefinition");
            _crMaximumOBJ.setLineNumber("128");
            _crMaximum.setDefinedIn(this);
            addAttributeDefList(_crMaximum);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            AttributeDefinitionDMO _allowedStringOBJ = new AttributeDefinitionDMO();
            _allowedString = new AttributeDefinition(_allowedStringOBJ);
            _allowedStringOBJ.addDescription("The allowedString attribute indicates the strings that are allowed as part of a StringSetRule.");
            _allowedStringOBJ.setName("allowedString");
            _allowedStringOBJ.setDmdID("-479980");
            _allowedStringOBJ.setType("meta.String");
            _allowedStringOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/attributes.dmd");
            _allowedStringOBJ.setDotName("dmv.allowedString.AttributeDefinition");
            _allowedStringOBJ.setLineNumber("141");
            _allowedStringOBJ.setValueType("HASHSET");
            _allowedString.setDefinedIn(this);
            addAttributeDefList(_allowedString);

    }

    // Generated from: org.dmd.dmg.util.SchemaFormatter.dumpInitFunction(SchemaFormatter.java:313)
    private void initTypes() throws DmcValueException {
    }

    // Generated from: org.dmd.dmg.util.SchemaFormatter.dumpInitFunction(SchemaFormatter.java:313)
    private void initComplexTypes() throws DmcValueException {
    }

    // Generated from: org.dmd.dmg.util.SchemaFormatter.dumpInitFunction(SchemaFormatter.java:313)
    private void initActions() throws DmcValueException {
    }

    // Generated from: org.dmd.dmg.util.SchemaFormatter.dumpInitFunction(SchemaFormatter.java:313)
    private void initEnums() throws DmcValueException {
// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            EnumDefinitionDMO _NumericRelationEnumOBJ = new EnumDefinitionDMO();
            _NumericRelationEnum = new EnumDefinition(_NumericRelationEnumOBJ);
            _NumericRelationEnumOBJ.addEnumValue("0 EQUALS Equals : EQ");
            _NumericRelationEnumOBJ.addEnumValue("1 GT Greater than : GT");
            _NumericRelationEnumOBJ.addEnumValue("2 LT Less than : LT");
            _NumericRelationEnumOBJ.addEnumValue("3 NE Not equal : NE");
            _NumericRelationEnumOBJ.addEnumValue("4 GTE Greater than or equal to : GTE");
            _NumericRelationEnumOBJ.addEnumValue("5 LTE Less than or equal to : LTE");
            _NumericRelationEnumOBJ.addDescription("The NumericRelationEnum is used to specify the relationship\n that should exist between two numeric values.");
            _NumericRelationEnumOBJ.setName("NumericRelationEnum");
            _NumericRelationEnumOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/types.dmd");
            _NumericRelationEnumOBJ.setDotName("dmv.NumericRelationEnum.EnumDefinition");
            _NumericRelationEnumOBJ.setLineNumber("1");
            _NumericRelationEnum.setDefinedIn(this);
            addEnumDefList(_NumericRelationEnum);

    }

    // Generated from: org.dmd.dmg.util.SchemaFormatter.dumpInitFunction(SchemaFormatter.java:313)
    private void initRules() throws DmcValueException {
// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            RuleDefinitionDMO _AllowedAttributesRuleOBJ = new RuleDefinitionDMO();
            _AllowedAttributesRule = new RuleDefinition(_AllowedAttributesRuleOBJ);
            _AllowedAttributesRuleOBJ.addDescription("Way too long!");
            _AllowedAttributesRuleOBJ.setName("AllowedAttributesRule");
            _AllowedAttributesRuleOBJ.setDmdID("-959999");
            _AllowedAttributesRuleOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/rules.dmd");
            _AllowedAttributesRuleOBJ.setDotName("dmv.AllowedAttributesRule.RuleDefinition");
            _AllowedAttributesRuleOBJ.addRuleCategory("meta.ObjectValidation");
            _AllowedAttributesRuleOBJ.setLineNumber("2");
            _AllowedAttributesRule.setDefinedIn(this);
            addRuleDefinitionList(_AllowedAttributesRule);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            RuleDefinitionDMO _InitRuleOBJ = new RuleDefinitionDMO();
            _InitRule = new RuleDefinition(_InitRuleOBJ);
            _InitRuleOBJ.addDescription("Way too long!");
            _InitRuleOBJ.setName("InitRule");
            _InitRuleOBJ.setDmdID("-959998");
            _InitRuleOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/rules.dmd");
            _InitRuleOBJ.setDotName("dmv.InitRule.RuleDefinition");
            _InitRuleOBJ.addRuleCategory("meta.Initialization");
            _InitRuleOBJ.setLineNumber("31");
            _InitRule.setDefinedIn(this);
            _InitRuleOBJ.setIsExtensible("true");
            addRuleDefinitionList(_InitRule);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            RuleDefinitionDMO _NumericRangeRuleOBJ = new RuleDefinitionDMO();
            _NumericRangeRule = new RuleDefinition(_NumericRangeRuleOBJ);
            _NumericRangeRuleOBJ.addDescription("Way too long!");
            _NumericRangeRuleOBJ.setName("NumericRangeRule");
            _NumericRangeRuleOBJ.setDmdID("-959997");
            _NumericRangeRuleOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/rules.dmd");
            _NumericRangeRuleOBJ.setDotName("dmv.NumericRangeRule.RuleDefinition");
            _NumericRangeRuleOBJ.addMay("dmv.nrrMinimum");
            _NumericRangeRuleOBJ.addMay("dmv.nrrMaximum");
            _NumericRangeRuleOBJ.addRuleCategory("meta.AttributeValidation");
            _NumericRangeRuleOBJ.setLineNumber("57");
            _NumericRangeRule.setDefinedIn(this);
            addRuleDefinitionList(_NumericRangeRule);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            RuleDefinitionDMO _UCOAllowedAttributesRuleOBJ = new RuleDefinitionDMO();
            _UCOAllowedAttributesRule = new RuleDefinition(_UCOAllowedAttributesRuleOBJ);
            _UCOAllowedAttributesRuleOBJ.addDescription("The UCOAllowedAttributesRule will determine whether or not the \n attributes of a DmcUncheckedObject conform to the must/may specification of its\n class definition. For classes of type EXTENSIBLE only the must have attributes are checked.");
            _UCOAllowedAttributesRuleOBJ.setName("UCOAllowedAttributesRule");
            _UCOAllowedAttributesRuleOBJ.setDmdID("-959996");
            _UCOAllowedAttributesRuleOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/rules.dmd");
            _UCOAllowedAttributesRuleOBJ.setDotName("dmv.UCOAllowedAttributesRule.RuleDefinition");
            _UCOAllowedAttributesRuleOBJ.addRuleCategory("meta.UCOValidation");
            _UCOAllowedAttributesRuleOBJ.setLineNumber("83");
            _UCOAllowedAttributesRule.setDefinedIn(this);
            addRuleDefinitionList(_UCOAllowedAttributesRule);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            RuleDefinitionDMO _RelatedNumbersRuleOBJ = new RuleDefinitionDMO();
            _RelatedNumbersRule = new RuleDefinition(_RelatedNumbersRuleOBJ);
            _RelatedNumbersRuleOBJ.addDescription("Way too long!");
            _RelatedNumbersRuleOBJ.setName("RelatedNumbersRule");
            _RelatedNumbersRuleOBJ.setDmdID("-959994");
            _RelatedNumbersRuleOBJ.addMust("dmv.lhs");
            _RelatedNumbersRuleOBJ.addMust("dmv.rhs");
            _RelatedNumbersRuleOBJ.addMust("dmv.numericRelation");
            _RelatedNumbersRuleOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/rules.dmd");
            _RelatedNumbersRuleOBJ.setDotName("dmv.RelatedNumbersRule.RuleDefinition");
            _RelatedNumbersRuleOBJ.addRuleCategory("meta.ObjectValidation");
            _RelatedNumbersRuleOBJ.setLineNumber("105");
            _RelatedNumbersRule.setDefinedIn(this);
            addRuleDefinitionList(_RelatedNumbersRule);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            RuleDefinitionDMO _CheckAttributesBasedOnValueRuleOBJ = new RuleDefinitionDMO();
            _CheckAttributesBasedOnValueRule = new RuleDefinition(_CheckAttributesBasedOnValueRuleOBJ);
            _CheckAttributesBasedOnValueRuleOBJ.addDescription("Way too long!");
            _CheckAttributesBasedOnValueRuleOBJ.setName("CheckAttributesBasedOnValueRule");
            _CheckAttributesBasedOnValueRuleOBJ.setDmdID("-959993");
            _CheckAttributesBasedOnValueRuleOBJ.addMust("dmv.basedOnAttribute");
            _CheckAttributesBasedOnValueRuleOBJ.addMust("dmv.basedOnValue");
            _CheckAttributesBasedOnValueRuleOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/rules.dmd");
            _CheckAttributesBasedOnValueRuleOBJ.setDotName("dmv.CheckAttributesBasedOnValueRule.RuleDefinition");
            _CheckAttributesBasedOnValueRuleOBJ.addMay("dmv.excludeThisAttribute");
            _CheckAttributesBasedOnValueRuleOBJ.addMay("dmv.includeThisAttribute");
            _CheckAttributesBasedOnValueRuleOBJ.addRuleCategory("meta.ObjectValidation");
            _CheckAttributesBasedOnValueRuleOBJ.setLineNumber("139");
            _CheckAttributesBasedOnValueRule.setDefinedIn(this);
            addRuleDefinitionList(_CheckAttributesBasedOnValueRule);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            RuleDefinitionDMO _OneOfTheseAttributesRequiredRuleOBJ = new RuleDefinitionDMO();
            _OneOfTheseAttributesRequiredRule = new RuleDefinition(_OneOfTheseAttributesRequiredRuleOBJ);
            _OneOfTheseAttributesRequiredRuleOBJ.addDescription("Way too long!");
            _OneOfTheseAttributesRequiredRuleOBJ.setName("OneOfTheseAttributesRequiredRule");
            _OneOfTheseAttributesRequiredRuleOBJ.setDmdID("-959992");
            _OneOfTheseAttributesRequiredRuleOBJ.addMust("dmv.onePossibility");
            _OneOfTheseAttributesRequiredRuleOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/rules.dmd");
            _OneOfTheseAttributesRequiredRuleOBJ.setDotName("dmv.OneOfTheseAttributesRequiredRule.RuleDefinition");
            _OneOfTheseAttributesRequiredRuleOBJ.addMay("dmv.andOnlyOne");
            _OneOfTheseAttributesRequiredRuleOBJ.addRuleCategory("meta.ObjectValidation");
            _OneOfTheseAttributesRequiredRuleOBJ.setLineNumber("177");
            _OneOfTheseAttributesRequiredRule.setDefinedIn(this);
            addRuleDefinitionList(_OneOfTheseAttributesRequiredRule);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            RuleDefinitionDMO _PatternMatchRuleOBJ = new RuleDefinitionDMO();
            _PatternMatchRule = new RuleDefinition(_PatternMatchRuleOBJ);
            _PatternMatchRuleOBJ.addDescription("Way too long!");
            _PatternMatchRuleOBJ.setName("PatternMatchRule");
            _PatternMatchRuleOBJ.setDmdID("-959991");
            _PatternMatchRuleOBJ.addMust("dmv.matchesPattern");
            _PatternMatchRuleOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/rules.dmd");
            _PatternMatchRuleOBJ.setDotName("dmv.PatternMatchRule.RuleDefinition");
            _PatternMatchRuleOBJ.addRuleCategory("meta.AttributeValidation");
            _PatternMatchRuleOBJ.setLineNumber("209");
            _PatternMatchRule.setDefinedIn(this);
            addRuleDefinitionList(_PatternMatchRule);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            RuleDefinitionDMO _ValueLengthRuleOBJ = new RuleDefinitionDMO();
            _ValueLengthRule = new RuleDefinition(_ValueLengthRuleOBJ);
            _ValueLengthRuleOBJ.addDescription("Way too long!");
            _ValueLengthRuleOBJ.setName("ValueLengthRule");
            _ValueLengthRuleOBJ.setDmdID("-959990");
            _ValueLengthRuleOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/rules.dmd");
            _ValueLengthRuleOBJ.setDotName("dmv.ValueLengthRule.RuleDefinition");
            _ValueLengthRuleOBJ.addMay("dmv.maxLength");
            _ValueLengthRuleOBJ.addMay("dmv.minLength");
            _ValueLengthRuleOBJ.addRuleCategory("meta.AttributeValidation");
            _ValueLengthRuleOBJ.setLineNumber("267");
            _ValueLengthRule.setDefinedIn(this);
            addRuleDefinitionList(_ValueLengthRule);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            RuleDefinitionDMO _ReferencedAttributeTypeRuleOBJ = new RuleDefinitionDMO();
            _ReferencedAttributeTypeRule = new RuleDefinition(_ReferencedAttributeTypeRuleOBJ);
            _ReferencedAttributeTypeRuleOBJ.addDescription("Way too long!");
            _ReferencedAttributeTypeRuleOBJ.setName("ReferencedAttributeTypeRule");
            _ReferencedAttributeTypeRuleOBJ.setDmdID("-959989");
            _ReferencedAttributeTypeRuleOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/rules.dmd");
            _ReferencedAttributeTypeRuleOBJ.setDotName("dmv.ReferencedAttributeTypeRule.RuleDefinition");
            _ReferencedAttributeTypeRuleOBJ.addMay("dmv.allowedType");
            _ReferencedAttributeTypeRuleOBJ.addMay("dmv.allowedValueType");
            _ReferencedAttributeTypeRuleOBJ.addRuleCategory("meta.AttributeValidation");
            _ReferencedAttributeTypeRuleOBJ.setLineNumber("348");
            _ReferencedAttributeTypeRule.setDefinedIn(this);
            addRuleDefinitionList(_ReferencedAttributeTypeRule);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            RuleDefinitionDMO _OnlyOneOfTheseAttributesAllowedRuleOBJ = new RuleDefinitionDMO();
            _OnlyOneOfTheseAttributesAllowedRule = new RuleDefinition(_OnlyOneOfTheseAttributesAllowedRuleOBJ);
            _OnlyOneOfTheseAttributesAllowedRuleOBJ.addDescription("Way too long!");
            _OnlyOneOfTheseAttributesAllowedRuleOBJ.setName("OnlyOneOfTheseAttributesAllowedRule");
            _OnlyOneOfTheseAttributesAllowedRuleOBJ.setDmdID("-959988");
            _OnlyOneOfTheseAttributesAllowedRuleOBJ.addMust("dmv.onePossibility");
            _OnlyOneOfTheseAttributesAllowedRuleOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/rules.dmd");
            _OnlyOneOfTheseAttributesAllowedRuleOBJ.setDotName("dmv.OnlyOneOfTheseAttributesAllowedRule.RuleDefinition");
            _OnlyOneOfTheseAttributesAllowedRuleOBJ.addRuleCategory("meta.ObjectValidation");
            _OnlyOneOfTheseAttributesAllowedRuleOBJ.setLineNumber("386");
            _OnlyOneOfTheseAttributesAllowedRule.setDefinedIn(this);
            addRuleDefinitionList(_OnlyOneOfTheseAttributesAllowedRule);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            RuleDefinitionDMO _PartCheckerRuleOBJ = new RuleDefinitionDMO();
            _PartCheckerRule = new RuleDefinition(_PartCheckerRuleOBJ);
            _PartCheckerRuleOBJ.addDescription("The PartCheckerRule will validate a ComplexTypeDefinition\n for some of the more tricky aspects of that definition. In particular it will\n check: <br>\n <ul>\n <li> that the greedy flag is only specified on requiredPart attributes </li>\n <li> that the greedy flag is only specified on ComplexTypes where are all parts are required </li>\n <li> that the greedy flag is only specified on the final requiredPart </li>\n </ul>");
            _PartCheckerRuleOBJ.setName("PartCheckerRule");
            _PartCheckerRuleOBJ.setDmdID("-959986");
            _PartCheckerRuleOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/rules.dmd");
            _PartCheckerRuleOBJ.setDotName("dmv.PartCheckerRule.RuleDefinition");
            _PartCheckerRuleOBJ.addRuleCategory("meta.ObjectValidation");
            _PartCheckerRuleOBJ.setLineNumber("408");
            _PartCheckerRule.setDefinedIn(this);
            addRuleDefinitionList(_PartCheckerRule);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            RuleDefinitionDMO _NamedObjectRuleOBJ = new RuleDefinitionDMO();
            _NamedObjectRule = new RuleDefinition(_NamedObjectRuleOBJ);
            _NamedObjectRuleOBJ.addDescription("The NamedObjectRule will validate a ClassDefinition for a named object\n to ensure that the isNamedBy attribute is included in the must have attributes list.");
            _NamedObjectRuleOBJ.setName("NamedObjectRule");
            _NamedObjectRuleOBJ.setDmdID("-959985");
            _NamedObjectRuleOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/rules.dmd");
            _NamedObjectRuleOBJ.setDotName("dmv.NamedObjectRule.RuleDefinition");
            _NamedObjectRuleOBJ.addRuleCategory("meta.ObjectValidation");
            _NamedObjectRuleOBJ.setLineNumber("429");
            _NamedObjectRule.setDefinedIn(this);
            addRuleDefinitionList(_NamedObjectRule);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            RuleDefinitionDMO _RestrictReferencesRuleOBJ = new RuleDefinitionDMO();
            _RestrictReferencesRule = new RuleDefinition(_RestrictReferencesRuleOBJ);
            _RestrictReferencesRuleOBJ.addDescription("Way too long!");
            _RestrictReferencesRuleOBJ.setName("RestrictReferencesRule");
            _RestrictReferencesRuleOBJ.setDmdID("-959984");
            _RestrictReferencesRuleOBJ.addMust("dmv.allowedReference");
            _RestrictReferencesRuleOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/rules.dmd");
            _RestrictReferencesRuleOBJ.setDotName("dmv.RestrictReferencesRule.RuleDefinition");
            _RestrictReferencesRuleOBJ.addRuleCategory("meta.AttributeValidation");
            _RestrictReferencesRuleOBJ.setLineNumber("444");
            _RestrictReferencesRule.setDefinedIn(this);
            addRuleDefinitionList(_RestrictReferencesRule);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            RuleDefinitionDMO _CardinalityRuleOBJ = new RuleDefinitionDMO();
            _CardinalityRule = new RuleDefinition(_CardinalityRuleOBJ);
            _CardinalityRuleOBJ.addDescription("Way too long!");
            _CardinalityRuleOBJ.setName("CardinalityRule");
            _CardinalityRuleOBJ.setDmdID("-959983");
            _CardinalityRuleOBJ.addMust("dmv.crMinimum");
            _CardinalityRuleOBJ.addMust("dmv.crMaximum");
            _CardinalityRuleOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/rules.dmd");
            _CardinalityRuleOBJ.setDotName("dmv.CardinalityRule.RuleDefinition");
            _CardinalityRuleOBJ.addRuleCategory("meta.AttributeValidation");
            _CardinalityRuleOBJ.setLineNumber("476");
            _CardinalityRule.setDefinedIn(this);
            addRuleDefinitionList(_CardinalityRule);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            RuleDefinitionDMO _StringSetRuleOBJ = new RuleDefinitionDMO();
            _StringSetRule = new RuleDefinition(_StringSetRuleOBJ);
            _StringSetRuleOBJ.addDescription("The StringSetRule lets you specify a set of strings that are allowed as values for an attribute.\n <pre>\n StringSetRule\n ruleName	fishRule\n ruleTitle	The fish must be one of red fish, blue fish or green fish.\n applyToAttribute fish\n allowedString red fish\n allowedString blue fish\n allowedString green fish\n </pre>");
            _StringSetRuleOBJ.setName("StringSetRule");
            _StringSetRuleOBJ.setDmdID("-959982");
            _StringSetRuleOBJ.addMust("dmv.allowedString");
            _StringSetRuleOBJ.setFile("/src/org/dmd/dmv/shared/dmdconfig/v0dot1/rules.dmd");
            _StringSetRuleOBJ.setDotName("dmv.StringSetRule.RuleDefinition");
            _StringSetRuleOBJ.addRuleCategory("meta.AttributeValidation");
            _StringSetRuleOBJ.setLineNumber("652");
            _StringSetRule.setDefinedIn(this);
            addRuleDefinitionList(_StringSetRule);

    }

    // Generated from: org.dmd.dmg.util.SchemaFormatter.dumpInitFunction(SchemaFormatter.java:313)
    private void initDSDModules() throws DmcValueException {
    }

    // Generated from: org.dmd.dmg.util.SchemaFormatter.dumpSchema(SchemaFormatter.java:272)

    @Override
    public synchronized DmvSchemaAG getInstance() throws DmcValueException{
    	   if (instance == null)
    		   initialize();
    	   return(instance);
    }
}

