package org.dmd.dsd.tools.dsdwizard;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

import org.dmd.util.exceptions.ResultException;

/**
 * The DSDSchemaGenerator generates the initial schema definition files required for a
 * new set of domain specific definitions.
 */
public class DSDSchemaGenerator {

	/**
	 * 
	 * @param dir the dmdconfig dir
	 * @param sharedp the shared package name
	 * @param dmwp the dmw package name
	 * @param dsdname the dsd name i.e. the file extension for this type of definition
	 * @param def1 the first definition name
	 * @param def2 the second definition name or null
	 * @param def3 the third definition name or null
	 * @throws IOException  
	 * @throws ResultException 
	 */
	static public void generateSchema(String dir, String sharedp, String dmwp, String dsdname, String def1, String def2, String def3) throws ResultException, IOException {
		createDmsFile(dir, sharedp, dmwp, dsdname);
	}
	
	static void createDmsFile(String dir, String sharedp, String dmwp, String dsdname) throws ResultException, IOException {
		String ofn = dir + "/shared/dmdconfig/" + dsdname + ".dms";
		File dmsFile = new File(ofn);
		
		if (dmsFile.exists()){
			throw(new ResultException("Schema file already exists: " + ofn));
		}
		
		System.out.println("Generating schema: " + ofn);
		
		BufferedWriter out = new BufferedWriter( new FileWriter(ofn) );
		
		out.write("SchemaDefinition\n");
		out.write("name            " + dsdname + "\n");
		out.write("schemaBaseID    200000\n");
		out.write("defFiles        attributes.dmd\n");
		out.write("defFiles        classes.dmd\n");
		out.write("schemaPackage   " + sharedp + "\n");
		out.write("dmwPackage      " + dmwp + "\n");
		out.write("description     Autogenerated by the dark-matter DSDWizard utility.\n");

		out.close();
		
		ofn = dir + "/shared/dmdconfig/attributes.dmd";
		out = new BufferedWriter( new FileWriter(ofn) );
		
		out.close();
		
		ofn = dir + "/shared/dmdconfig/classes.dmd";
		out = new BufferedWriter( new FileWriter(ofn) );
		
		out.close();
		
	}
}
