//	---------------------------------------------------------------------------
//	dark-matter-data
//	Copyright (c) 2011 dark-matter-data committers
//	---------------------------------------------------------------------------
//	This program is free software; you can redistribute it and/or modify it
//	under the terms of the GNU Lesser General Public License as published by the
//	Free Software Foundation; either version 3 of the License, or (at your
//	option) any later version.
//	This program is distributed in the hope that it will be useful, but WITHOUT
//	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
//	FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for
//	more details.
//	You should have received a copy of the GNU Lesser General Public License along
//	with this program; if not, see <http://www.gnu.org/licenses/lgpl.html>.
//	---------------------------------------------------------------------------
package org.dmd.map.generated.enums;

import java.util.*;

import org.dmd.dmc.DmcEnumIF;

/**
 * The MapZoomEnum indicates the various levels of zoom supported\n by Google
 * Maps.
 * <P>
 * Generated from the map schema at version 0.1
 * <P>
 * This code was auto-generated by the dmogenerator utility and shouldn't be altered manually!
 * Generated from: org.dmd.dms.util.DmoEnumFormatter.dumpEnum(DmoEnumFormatter.java:100)
 */
public enum MapZoomEnum implements DmcEnumIF
{
    LEVEL_00(0,"Level 0 - 5000mi/10000km"),

    LEVEL_01(1,"Level 1 - 2000mi/5000km"),

    LEVEL_02(2,"Level 2 - 2000mi/2000km"),

    LEVEL_03(3,"Level 3 - 1000mi/1000km"),

    LEVEL_04(4,"Level 4 - 500mi/500km"),

    LEVEL_05(5,"Level 5 - 200mi/500km"),

    LEVEL_06(6,"Level 6 - 100mi/200km"),

    LEVEL_07(7,"Level 7 - 50mi/100km"),

    LEVEL_08(8,"Level 8 - 20mi/50km"),

    LEVEL_09(9,"Level 9 - 10mi/20km"),

    LEVEL_10(10,"Level 10 - 5mi/10km"),

    LEVEL_11(11,"Level 11 - 2mi/5km"),

    LEVEL_12(12,"Level 12 - 2mi/2km"),

    LEVEL_13(13,"Level 13 - 1mi/1km"),

    LEVEL_14(14,"Level 14 - 2000f/500m"),

    LEVEL_15(15,"Level 15 - 1000f/200m"),

    LEVEL_16(16,"Level 16 - 500f/200m"),

    LEVEL_17(17,"Level 17 - 200f/100m"),

    LEVEL_18(18,"Level 18 - 200f/50m"),

    LEVEL_19(19,"Level 19 - 100f/20m"),

    LEVEL_20(20,"Level 20 - 50f/10m"),

    LEVEL_21(21,"Level 21 - 20f/5m");

    // Maps our integer value to the enumeration value
    private static final Map<Integer,MapZoomEnum> lookup = new HashMap<Integer,MapZoomEnum>();

    static {
        for(MapZoomEnum s : EnumSet.allOf(MapZoomEnum.class))
            lookup.put(s.intValue(), s);
    }

    // Maps our enumeration (string) value to the enumeration value
    private static final Map<String,MapZoomEnum> lookupString = new HashMap<String, MapZoomEnum>();

    static {
        for(MapZoomEnum s : EnumSet.allOf(MapZoomEnum.class))
            lookupString.put(s.name(), s);
    }

    // Our current value as an int - normally, this isn't available in an enum
    private int ival;

    // Our current display value as a String
    private String dval;

    /**
     * This private constructor allows us to access our int value when required.
     */
    private MapZoomEnum(int i, String d){
        ival = i;
        dval = d;
    }

    /**
     * Returns the value of this enum value as an int.
     */
    public int intValue(){
        return(ival);
    }

    /**
     * Returns the display value of this enum value as a String.
     */
    public String displayValue(){
        return(dval);
    }

    /**
     * Returns the enum value of the specified int or null if it's not valid.
     */
    public static MapZoomEnum get(int code) {
        return(lookup.get(code));
    }

    /**
     * Returns a value for this enum or throws an exception if the String value isn't
     * a valid member of this enum.
     */
    public static MapZoomEnum get(String str) {
        return(lookupString.get(str.toUpperCase()));
    }

}