//	---------------------------------------------------------------------------
//	dark-matter-data
//	Copyright (c) 2014 dark-matter-data committers
//	---------------------------------------------------------------------------
//	This program is free software; you can redistribute it and/or modify it
//	under the terms of the GNU Lesser General Public License as published by the
//	Free Software Foundation; either version 3 of the License, or (at your
//	option) any later version.
//	This program is distributed in the hope that it will be useful, but WITHOUT
//	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
//	FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for
//	more details.
//	You should have received a copy of the GNU Lesser General Public License along
//	with this program; if not, see <http://www.gnu.org/licenses/lgpl.html>.
//	---------------------------------------------------------------------------
package org.dmd.templates.server.generated;

import org.dmd.dmc.DmcOmni;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.*;
import org.dmd.dms.generated.dmo.*;
import org.dmd.templates.shared.generated.dmo.DmtdlDMSAG;


/**
 * The dark-matter Template Definition Language (TDL) schema defines objects
 * that\n allow you to define the structure of an artifact composed of a
 * series of Sections and Templates\n that are used to format the Sections.
 * <P>
 * Generated from the dmtdl schema at version unknown
 * <P>
 * This code was auto-generated by the dmggenerator utility and shouldn't be alterred manually!
 * Generated from: org.dmd.dmg.util.SchemaFormatter.dumpSchema(SchemaFormatter.java:182)
 */
public class DmtdlSchemaAG extends SchemaDefinition {

    public static ClassDefinition _TdlDefinition;
    public static ClassDefinition _ContainedElement;
    public static ClassDefinition _Section;
    public static ClassDefinition _TextualArtifact;
    public static ClassDefinition _ExtensionHook;
    public static ClassDefinition _Template;
    public static ClassDefinition _TdlModule;

    public static AttributeDefinition _definedInTdlModule;
    public static AttributeDefinition _dependsOnTdlModule;
    public static AttributeDefinition _insertMarker;
    public static AttributeDefinition _format;
    public static AttributeDefinition _usesTemplate;
    public static AttributeDefinition _contains;
    public static AttributeDefinition _startsWith;
    public static AttributeDefinition _startsWithText;
    public static AttributeDefinition _endsWith;
    public static AttributeDefinition _endsWithText;
    public static AttributeDefinition _value;
    public static AttributeDefinition _templateFile;
    public static AttributeDefinition _package;
    public static AttributeDefinition _hasTemplate;
    public static AttributeDefinition _templateFileSuffix;
    public static AttributeDefinition _maxFastAddValues;
    public static AttributeDefinition _commentFormat;
    public static AttributeDefinition _debugOn;
    public static AttributeDefinition _usesSection;
    public static AttributeDefinition _targetObjectClass;


    public static ComplexTypeDefinition _Contains;
    public static ComplexTypeDefinition _Value;


    public static EnumDefinition _CardinalityEnum;


    public static DSDefinitionModule _TdlModuleDSD;

    static DmtdlSchemaAG instance;

    public DmtdlSchemaAG() throws DmcValueException {
        generatedSchema = true;
        staticRefName   = "org.dmd.templates.server.generated.DmtdlSchemaAG";

        dependsOnSchemaClasses.put("dmv","org.dmd.dmv.server.generated.DmvSchemaAG");

    }

    // Generated from: org.dmd.dmg.util.SchemaFormatter.dumpSchema(SchemaFormatter.java:208)
    private void initialize() throws DmcValueException {
        if (instance == null){
            instance        = this;
            SchemaDefinitionDMO me = (SchemaDefinitionDMO) this.getDmcObject();
            me.setName("dmtdl");
            me.setDotName("dmtdl");
            me.setSchemaPackage("org.dmd.templates.shared");
            me.setDmwPackage("org.dmd.templates.server");
            me.setFile("/src/org/dmd/templates/shared/dmdconfig/dmtdl.dms");


            me.addDependsOn("dmv");
            dependsOnSchemaClasses.put("dmv","org.dmd.dmv.server.generated.DmvSchemaAG");


            initClasses();
            initAttributes1();
            initTypes();
            initComplexTypes();
            initActions();
            initEnums();
            initRules();
            initDSDModules();
            DmcOmni.instance().addCompactSchema(DmtdlDMSAG.instance());
        }
    }

    // Generated from: org.dmd.dmg.util.SchemaFormatter.dumpInitFunction(SchemaFormatter.java:313)
    private void initClasses() throws DmcValueException {
// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            ClassDefinitionDMO _TdlDefinitionOBJ = new ClassDefinitionDMO();
            _TdlDefinition = new ClassDefinition(_TdlDefinitionOBJ,DmtdlDMSAG.__TdlDefinition);
            _TdlDefinitionOBJ.setName("TdlDefinition");
            _TdlDefinitionOBJ.setDmdID("-957198");
            _TdlDefinitionOBJ.setClassType("ABSTRACT");
            _TdlDefinitionOBJ.setFile("/src/org/dmd/templates/shared/dmdconfig/classes.dmd");
            _TdlDefinitionOBJ.setLineNumber("1");
            _TdlDefinitionOBJ.setIsNamedBy("meta.name");
            _TdlDefinitionOBJ.addDescription("The TdlDefinition provides a common base for all dark-matter\n Template Definition Language (TDL) definitions.");
            _TdlDefinitionOBJ.setUseWrapperType("EXTENDED");
            _TdlDefinitionOBJ.setDerivedFrom("meta.DSDefinition");
            _TdlDefinitionOBJ.addMust("meta.name");
            _TdlDefinitionOBJ.addMust("meta.dotName");
            _TdlDefinitionOBJ.addMust("dmtdl.definedInTdlModule");
            _TdlDefinitionOBJ.addMay("meta.description");
            _TdlDefinitionOBJ.setDmwIteratorImport("org.dmd.templates.server.generated.dmw.TdlDefinitionIterableDMW");
            _TdlDefinitionOBJ.setDmwIteratorClass("TdlDefinitionIterableDMW");
            _TdlDefinitionOBJ.setDmtREFImport("org.dmd.templates.shared.generated.types.TdlDefinitionREF");
            _TdlDefinitionOBJ.setDotName("dmtdl.TdlDefinition.ClassDefinition");
            _TdlDefinitionOBJ.setPartOfDefinitionModule("dmtdl.TdlModule");
            _TdlDefinition.setDefinedIn(this);
            addClassDefList(_TdlDefinition);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            ClassDefinitionDMO _ContainedElementOBJ = new ClassDefinitionDMO();
            _ContainedElement = new ClassDefinition(_ContainedElementOBJ,DmtdlDMSAG.__ContainedElement);
            _ContainedElementOBJ.setName("ContainedElement");
            _ContainedElementOBJ.setDmdID("-957197");
            _ContainedElementOBJ.setClassType("ABSTRACT");
            _ContainedElementOBJ.setFile("/src/org/dmd/templates/shared/dmdconfig/classes.dmd");
            _ContainedElementOBJ.setLineNumber("15");
            _ContainedElementOBJ.setIsNamedBy("meta.name");
            _ContainedElementOBJ.setUseWrapperType("EXTENDED");
            _ContainedElementOBJ.setDerivedFrom("dmtdl.TdlDefinition");
            _ContainedElementOBJ.addMust("meta.name");
            _ContainedElementOBJ.setDmwIteratorImport("org.dmd.templates.server.generated.dmw.ContainedElementIterableDMW");
            _ContainedElementOBJ.setDmwIteratorClass("ContainedElementIterableDMW");
            _ContainedElementOBJ.setDmtREFImport("org.dmd.templates.shared.generated.types.ContainedElementREF");
            _ContainedElementOBJ.setDotName("dmtdl.ContainedElement.ClassDefinition");
            _ContainedElementOBJ.setPartOfDefinitionModule("dmtdl.TdlModule");
            _ContainedElement.setDefinedIn(this);
            addClassDefList(_ContainedElement);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            ClassDefinitionDMO _SectionOBJ = new ClassDefinitionDMO();
            _Section = new ClassDefinition(_SectionOBJ,DmtdlDMSAG.__Section);
            _SectionOBJ.setName("Section");
            _SectionOBJ.setDmdID("-957196");
            _SectionOBJ.setClassType("STRUCTURAL");
            _SectionOBJ.setFile("/src/org/dmd/templates/shared/dmdconfig/classes.dmd");
            _SectionOBJ.setLineNumber("24");
            _SectionOBJ.setIsNamedBy("meta.name");
            _SectionOBJ.addDescription("Way too long!");
            _SectionOBJ.setUseWrapperType("EXTENDED");
            _SectionOBJ.setDerivedFrom("dmtdl.ContainedElement");
            _SectionOBJ.addMust("meta.name");
            _SectionOBJ.addMay("dmtdl.contains");
            _SectionOBJ.addMay("dmtdl.startsWith");
            _SectionOBJ.addMay("dmtdl.endsWith");
            _SectionOBJ.addMay("dmtdl.startsWithText");
            _SectionOBJ.addMay("dmtdl.endsWithText");
            _SectionOBJ.addMay("dmtdl.value");
            _SectionOBJ.addMay("dmtdl.hasTemplate");
            _SectionOBJ.addMay("dmtdl.usesTemplate");
            _SectionOBJ.setDmwIteratorImport("org.dmd.templates.server.generated.dmw.SectionIterableDMW");
            _SectionOBJ.setDmwIteratorClass("SectionIterableDMW");
            _SectionOBJ.setDmtREFImport("org.dmd.templates.shared.generated.types.SectionREF");
            _SectionOBJ.setDotName("dmtdl.Section.ClassDefinition");
            _SectionOBJ.setPartOfDefinitionModule("dmtdl.TdlModule");
            _Section.setDefinedIn(this);
            addClassDefList(_Section);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            ClassDefinitionDMO _TextualArtifactOBJ = new ClassDefinitionDMO();
            _TextualArtifact = new ClassDefinition(_TextualArtifactOBJ,DmtdlDMSAG.__TextualArtifact);
            _TextualArtifactOBJ.setName("TextualArtifact");
            _TextualArtifactOBJ.setDmdID("-957195");
            _TextualArtifactOBJ.setClassType("STRUCTURAL");
            _TextualArtifactOBJ.setFile("/src/org/dmd/templates/shared/dmdconfig/classes.dmd");
            _TextualArtifactOBJ.setLineNumber("66");
            _TextualArtifactOBJ.setIsNamedBy("meta.name");
            _TextualArtifactOBJ.addDescription("A TextualArtifact is the top level entity that is comprised of Sections\n and formatted via Templates.");
            _TextualArtifactOBJ.setUseWrapperType("EXTENDED");
            _TextualArtifactOBJ.setDerivedFrom("dmtdl.TdlDefinition");
            _TextualArtifactOBJ.addMust("meta.name");
            _TextualArtifactOBJ.addMust("dmtdl.contains");
            _TextualArtifactOBJ.setDmwIteratorImport("org.dmd.templates.server.generated.dmw.TextualArtifactIterableDMW");
            _TextualArtifactOBJ.setDmwIteratorClass("TextualArtifactIterableDMW");
            _TextualArtifactOBJ.setDmtREFImport("org.dmd.templates.shared.generated.types.TextualArtifactREF");
            _TextualArtifactOBJ.setDotName("dmtdl.TextualArtifact.ClassDefinition");
            _TextualArtifactOBJ.setPartOfDefinitionModule("dmtdl.TdlModule");
            _TextualArtifact.setDefinedIn(this);
            addClassDefList(_TextualArtifact);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            ClassDefinitionDMO _ExtensionHookOBJ = new ClassDefinitionDMO();
            _ExtensionHook = new ClassDefinition(_ExtensionHookOBJ,DmtdlDMSAG.__ExtensionHook);
            _ExtensionHookOBJ.setName("ExtensionHook");
            _ExtensionHookOBJ.setDmdID("-957194");
            _ExtensionHookOBJ.setClassType("STRUCTURAL");
            _ExtensionHookOBJ.setFile("/src/org/dmd/templates/shared/dmdconfig/classes.dmd");
            _ExtensionHookOBJ.setLineNumber("85");
            _ExtensionHookOBJ.setIsNamedBy("meta.name");
            _ExtensionHookOBJ.addDescription("Way too long!");
            _ExtensionHookOBJ.setUseWrapperType("EXTENDED");
            _ExtensionHookOBJ.setDerivedFrom("dmtdl.ContainedElement");
            _ExtensionHookOBJ.addMust("meta.name");
            _ExtensionHookOBJ.addMust("dmtdl.usesSection");
            _ExtensionHookOBJ.addMust("dmtdl.targetObjectClass");
            _ExtensionHookOBJ.setDmwIteratorImport("org.dmd.templates.server.generated.dmw.ExtensionHookIterableDMW");
            _ExtensionHookOBJ.setDmwIteratorClass("ExtensionHookIterableDMW");
            _ExtensionHookOBJ.setDmtREFImport("org.dmd.templates.shared.generated.types.ExtensionHookREF");
            _ExtensionHookOBJ.setDotName("dmtdl.ExtensionHook.ClassDefinition");
            _ExtensionHookOBJ.setPartOfDefinitionModule("dmtdl.TdlModule");
            _ExtensionHook.setDefinedIn(this);
            addClassDefList(_ExtensionHook);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            ClassDefinitionDMO _TemplateOBJ = new ClassDefinitionDMO();
            _Template = new ClassDefinition(_TemplateOBJ,DmtdlDMSAG.__Template);
            _TemplateOBJ.setName("Template");
            _TemplateOBJ.setDmdID("-957193");
            _TemplateOBJ.setClassType("STRUCTURAL");
            _TemplateOBJ.setFile("/src/org/dmd/templates/shared/dmdconfig/classes.dmd");
            _TemplateOBJ.setLineNumber("119");
            _TemplateOBJ.setIsNamedBy("meta.name");
            _TemplateOBJ.addDescription("Way too long!");
            _TemplateOBJ.setUseWrapperType("EXTENDED");
            _TemplateOBJ.addMust("meta.name");
            _TemplateOBJ.addMust("dmtdl.format");
            _TemplateOBJ.addMay("meta.file");
            _TemplateOBJ.addMay("meta.lineNumber");
            _TemplateOBJ.addMay("dmtdl.debugOn");
            _TemplateOBJ.addMay("meta.description");
            _TemplateOBJ.setDmwIteratorImport("org.dmd.templates.server.generated.dmw.TemplateIterableDMW");
            _TemplateOBJ.setDmwIteratorClass("TemplateIterableDMW");
            _TemplateOBJ.setDmtREFImport("org.dmd.templates.shared.generated.types.TemplateREF");
            _TemplateOBJ.setDotName("dmtdl.Template.ClassDefinition");
            _Template.setDefinedIn(this);
            addClassDefList(_Template);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            ClassDefinitionDMO _TdlModuleOBJ = new ClassDefinitionDMO();
            _TdlModule = new ClassDefinition(_TdlModuleOBJ,DmtdlDMSAG.__TdlModule);
            _TdlModuleOBJ.setName("TdlModule");
            _TdlModuleOBJ.setDmdID("-957199");
            _TdlModuleOBJ.setClassType("STRUCTURAL");
            _TdlModuleOBJ.setFile("/src/org/dmd/templates/shared/dmdconfig/module.dmd");
            _TdlModuleOBJ.setLineNumber("1");
            _TdlModuleOBJ.setInternallyGenerated("true");
            _TdlModuleOBJ.setIsNamedBy("meta.name");
            _TdlModuleOBJ.setUseWrapperType("EXTENDED");
            _TdlModuleOBJ.addDescription("Way too long!");
            _TdlModuleOBJ.setDerivedFrom("dmtdl.TdlDefinition");
            _TdlModuleOBJ.addMust("meta.name");
            _TdlModuleOBJ.addMust("dmtdl.package");
            _TdlModuleOBJ.addMust("dmtdl.templateFile");
            _TdlModuleOBJ.addMay("meta.description");
            _TdlModuleOBJ.addMay("meta.defFiles");
            _TdlModuleOBJ.addMay("dmtdl.templateFileSuffix");
            _TdlModuleOBJ.addMay("dmtdl.maxFastAddValues");
            _TdlModuleOBJ.addMay("dmtdl.insertMarker");
            _TdlModuleOBJ.addMay("dmtdl.commentFormat");
            _TdlModuleOBJ.addMay("dmtdl.dependsOnTdlModule");
            _TdlModuleOBJ.setDmwIteratorImport("org.dmd.templates.server.generated.dmw.TdlModuleIterableDMW");
            _TdlModuleOBJ.setDmwIteratorClass("TdlModuleIterableDMW");
            _TdlModuleOBJ.setDmtREFImport("org.dmd.templates.shared.generated.types.TdlModuleREF");
            _TdlModuleOBJ.setDsdModuleDefinition("dmtdl.TdlModule");
            _TdlModuleOBJ.setDotName("dmtdl.TdlModule.ClassDefinition");
            _TdlModuleOBJ.setPartOfDefinitionModule("dmtdl.TdlModule");
            _TdlModule.setDefinedIn(this);
            addClassDefList(_TdlModule);

    }

    private void initAttributes1() throws DmcValueException {
// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            AttributeDefinitionDMO _definedInTdlModuleOBJ = new AttributeDefinitionDMO();
            _definedInTdlModule = new AttributeDefinition(_definedInTdlModuleOBJ);
            _definedInTdlModuleOBJ.addDescription("Indicates the name of the TdlModule in which a definition is defined.");
            _definedInTdlModuleOBJ.setName("definedInTdlModule");
            _definedInTdlModuleOBJ.setDmdID("-478599");
            _definedInTdlModuleOBJ.setType("dmtdl.TdlModule");
            _definedInTdlModuleOBJ.setFile("/src/org/dmd/templates/shared/dmdconfig/attributes.dmd");
            _definedInTdlModuleOBJ.setDotName("dmtdl.definedInTdlModule.AttributeDefinition");
            _definedInTdlModuleOBJ.setLineNumber("1");
            _definedInTdlModule.setDefinedIn(this);
            addAttributeDefList(_definedInTdlModule);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            AttributeDefinitionDMO _dependsOnTdlModuleOBJ = new AttributeDefinitionDMO();
            _dependsOnTdlModule = new AttributeDefinition(_dependsOnTdlModuleOBJ);
            _dependsOnTdlModuleOBJ.addDescription("Indicates the TdlModule on which something depends.");
            _dependsOnTdlModuleOBJ.setName("dependsOnTdlModule");
            _dependsOnTdlModuleOBJ.setDmdID("-478598");
            _dependsOnTdlModuleOBJ.setType("dmtdl.TdlModule");
            _dependsOnTdlModuleOBJ.setFile("/src/org/dmd/templates/shared/dmdconfig/attributes.dmd");
            _dependsOnTdlModuleOBJ.setDotName("dmtdl.dependsOnTdlModule.AttributeDefinition");
            _dependsOnTdlModuleOBJ.setLineNumber("7");
            _dependsOnTdlModuleOBJ.setValueType("MULTI");
            _dependsOnTdlModule.setDefinedIn(this);
            addAttributeDefList(_dependsOnTdlModule);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            AttributeDefinitionDMO _insertMarkerOBJ = new AttributeDefinitionDMO();
            _insertMarker = new AttributeDefinition(_insertMarkerOBJ);
            _insertMarkerOBJ.addDescription("The character sequence that's used to indicate the start and end of\n where a value is inserted in a Template. The default insertMarker is double colon ::.\n We make this configurable because you never know the exact nature of the format you're\n trying to create. If double colons are a construct in that format, you'll have to choose\n some other character sequence to indicate where data is inserted.");
            _insertMarkerOBJ.setName("insertMarker");
            _insertMarkerOBJ.setDmdID("-478597");
            _insertMarkerOBJ.setType("meta.String");
            _insertMarkerOBJ.setNullReturnValue("::");
            _insertMarkerOBJ.setFile("/src/org/dmd/templates/shared/dmdconfig/attributes.dmd");
            _insertMarkerOBJ.setDotName("dmtdl.insertMarker.AttributeDefinition");
            _insertMarkerOBJ.setLineNumber("14");
            _insertMarker.setDefinedIn(this);
            addAttributeDefList(_insertMarker);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            AttributeDefinitionDMO _formatOBJ = new AttributeDefinitionDMO();
            _format = new AttributeDefinition(_formatOBJ);
            _formatOBJ.addDescription("Indicates the matrix of text into which various parts of a dark-matter object\n may be embedded.");
            _formatOBJ.setName("format");
            _formatOBJ.setDmdID("-478596");
            _formatOBJ.setPreserveNewlines("true");
            _formatOBJ.setType("meta.String");
            _formatOBJ.setFile("/src/org/dmd/templates/shared/dmdconfig/attributes.dmd");
            _formatOBJ.setDotName("dmtdl.format.AttributeDefinition");
            _formatOBJ.setLineNumber("25");
            _format.setDefinedIn(this);
            addAttributeDefList(_format);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            AttributeDefinitionDMO _usesTemplateOBJ = new AttributeDefinitionDMO();
            _usesTemplate = new AttributeDefinition(_usesTemplateOBJ);
            _usesTemplateOBJ.addDescription("By default, all Sections require an associated template, however\n if you set this to false, we don't look for an associated template. However, if \n a Section has specified values, it must always have a Template. We'll complain\n if this is set to false, but the Section has values.");
            _usesTemplateOBJ.setName("usesTemplate");
            _usesTemplateOBJ.setDmdID("-478595");
            _usesTemplateOBJ.setType("meta.Boolean");
            _usesTemplateOBJ.setNullReturnValue("true");
            _usesTemplateOBJ.setFile("/src/org/dmd/templates/shared/dmdconfig/attributes.dmd");
            _usesTemplateOBJ.setDotName("dmtdl.usesTemplate.AttributeDefinition");
            _usesTemplateOBJ.setLineNumber("40");
            _usesTemplate.setDefinedIn(this);
            addAttributeDefList(_usesTemplate);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            AttributeDefinitionDMO _containsOBJ = new AttributeDefinitionDMO();
            _contains = new AttributeDefinition(_containsOBJ);
            _containsOBJ.addDescription("Indicates the other Sections contained by a Section and whether they occur one or many times.");
            _containsOBJ.setName("contains");
            _containsOBJ.setDmdID("-478594");
            _containsOBJ.setType("dmtdl.Contains");
            _containsOBJ.setFile("/src/org/dmd/templates/shared/dmdconfig/attributes.dmd");
            _containsOBJ.setDotName("dmtdl.contains.AttributeDefinition");
            _containsOBJ.setLineNumber("50");
            _containsOBJ.setValueType("MULTI");
            _contains.setDefinedIn(this);
            addAttributeDefList(_contains);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            AttributeDefinitionDMO _startsWithOBJ = new AttributeDefinitionDMO();
            _startsWith = new AttributeDefinition(_startsWithOBJ);
            _startsWithOBJ.addDescription("Indicates the Sections that this section of artifact will start with.");
            _startsWithOBJ.setName("startsWith");
            _startsWithOBJ.setDmdID("-478593");
            _startsWithOBJ.setType("dmtdl.Section");
            _startsWithOBJ.setFile("/src/org/dmd/templates/shared/dmdconfig/attributes.dmd");
            _startsWithOBJ.setDotName("dmtdl.startsWith.AttributeDefinition");
            _startsWithOBJ.setLineNumber("57");
            _startsWith.setDefinedIn(this);
            addAttributeDefList(_startsWith);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            AttributeDefinitionDMO _startsWithTextOBJ = new AttributeDefinitionDMO();
            _startsWithText = new AttributeDefinition(_startsWithTextOBJ);
            _startsWithTextOBJ.addDescription("If the text that the section will start with is static, it can be specified via this attribute.");
            _startsWithTextOBJ.setName("startsWithText");
            _startsWithTextOBJ.setDmdID("-478592");
            _startsWithTextOBJ.setPreserveNewlines("true");
            _startsWithTextOBJ.setType("meta.String");
            _startsWithTextOBJ.setFile("/src/org/dmd/templates/shared/dmdconfig/attributes.dmd");
            _startsWithTextOBJ.setDotName("dmtdl.startsWithText.AttributeDefinition");
            _startsWithTextOBJ.setLineNumber("63");
            _startsWithText.setDefinedIn(this);
            addAttributeDefList(_startsWithText);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            AttributeDefinitionDMO _endsWithOBJ = new AttributeDefinitionDMO();
            _endsWith = new AttributeDefinition(_endsWithOBJ);
            _endsWithOBJ.addDescription("Indicates the Sections that this section of artifact will end with.");
            _endsWithOBJ.setName("endsWith");
            _endsWithOBJ.setDmdID("-478591");
            _endsWithOBJ.setType("dmtdl.Section");
            _endsWithOBJ.setFile("/src/org/dmd/templates/shared/dmdconfig/attributes.dmd");
            _endsWithOBJ.setDotName("dmtdl.endsWith.AttributeDefinition");
            _endsWithOBJ.setLineNumber("70");
            _endsWith.setDefinedIn(this);
            addAttributeDefList(_endsWith);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            AttributeDefinitionDMO _endsWithTextOBJ = new AttributeDefinitionDMO();
            _endsWithText = new AttributeDefinition(_endsWithTextOBJ);
            _endsWithTextOBJ.addDescription("If the text that the section will end with is static, it can be specified via this attribute.");
            _endsWithTextOBJ.setName("endsWithText");
            _endsWithTextOBJ.setDmdID("-478590");
            _endsWithTextOBJ.setPreserveNewlines("true");
            _endsWithTextOBJ.setType("meta.String");
            _endsWithTextOBJ.setFile("/src/org/dmd/templates/shared/dmdconfig/attributes.dmd");
            _endsWithTextOBJ.setDotName("dmtdl.endsWithText.AttributeDefinition");
            _endsWithTextOBJ.setLineNumber("76");
            _endsWithText.setDefinedIn(this);
            addAttributeDefList(_endsWithText);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            AttributeDefinitionDMO _valueOBJ = new AttributeDefinitionDMO();
            _value = new AttributeDefinition(_valueOBJ);
            _valueOBJ.addDescription("The name and description of a value that can be inserted into a Template. This name will be used\n when generating the interface of the Section being formatted.");
            _valueOBJ.setName("value");
            _valueOBJ.setDmdID("-478589");
            _valueOBJ.setType("dmtdl.Value");
            _valueOBJ.setFile("/src/org/dmd/templates/shared/dmdconfig/attributes.dmd");
            _valueOBJ.setDotName("dmtdl.value.AttributeDefinition");
            _valueOBJ.setLineNumber("83");
            _valueOBJ.setValueType("MULTI");
            _value.setDefinedIn(this);
            addAttributeDefList(_value);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            AttributeDefinitionDMO _templateFileOBJ = new AttributeDefinitionDMO();
            _templateFile = new AttributeDefinition(_templateFileOBJ);
            _templateFileOBJ.addDescription("The name of the associated file that contains the Template definitions for each \n of the Sections (if they require a Template).");
            _templateFileOBJ.setName("templateFile");
            _templateFileOBJ.setDmdID("-478588");
            _templateFileOBJ.setType("meta.String");
            _templateFileOBJ.setFile("/src/org/dmd/templates/shared/dmdconfig/attributes.dmd");
            _templateFileOBJ.setDotName("dmtdl.templateFile.AttributeDefinition");
            _templateFileOBJ.setLineNumber("91");
            _templateFile.setDefinedIn(this);
            addAttributeDefList(_templateFile);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            AttributeDefinitionDMO _packageOBJ = new AttributeDefinitionDMO();
            _package = new AttributeDefinition(_packageOBJ);
            _packageOBJ.addDescription("The name of the package in which you're placing the artifact generation code.");
            _packageOBJ.setName("package");
            _packageOBJ.setDmdID("-478587");
            _packageOBJ.setType("meta.String");
            _packageOBJ.setFile("/src/org/dmd/templates/shared/dmdconfig/attributes.dmd");
            _packageOBJ.setDotName("dmtdl.package.AttributeDefinition");
            _packageOBJ.setLineNumber("98");
            _package.setDefinedIn(this);
            addAttributeDefList(_package);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            AttributeDefinitionDMO _hasTemplateOBJ = new AttributeDefinitionDMO();
            _hasTemplate = new AttributeDefinition(_hasTemplateOBJ);
            _hasTemplateOBJ.addDescription("Indicates whether or not a Section has an associated Template; by default, \n all Sections require a Template. If, for some reason, a Section doesn't require a Template,\n just set this attribute to false.");
            _hasTemplateOBJ.setName("hasTemplate");
            _hasTemplateOBJ.setDmdID("-478586");
            _hasTemplateOBJ.setType("meta.Boolean");
            _hasTemplateOBJ.setNullReturnValue("true");
            _hasTemplateOBJ.setFile("/src/org/dmd/templates/shared/dmdconfig/attributes.dmd");
            _hasTemplateOBJ.setDotName("dmtdl.hasTemplate.AttributeDefinition");
            _hasTemplateOBJ.setLineNumber("104");
            _hasTemplate.setDefinedIn(this);
            addAttributeDefList(_hasTemplate);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            AttributeDefinitionDMO _templateFileSuffixOBJ = new AttributeDefinitionDMO();
            _templateFileSuffix = new AttributeDefinition(_templateFileSuffixOBJ);
            _templateFileSuffixOBJ.addDescription("The suffix of the template file. By default, the suffix will be .dmt, but,\n if that suffix clashes with some other file type you're using, you can change it.");
            _templateFileSuffixOBJ.setName("templateFileSuffix");
            _templateFileSuffixOBJ.setDmdID("-478585");
            _templateFileSuffixOBJ.setType("meta.String");
            _templateFileSuffixOBJ.setNullReturnValue("dmt");
            _templateFileSuffixOBJ.setFile("/src/org/dmd/templates/shared/dmdconfig/attributes.dmd");
            _templateFileSuffixOBJ.setDotName("dmtdl.templateFileSuffix.AttributeDefinition");
            _templateFileSuffixOBJ.setLineNumber("113");
            _templateFileSuffix.setDefinedIn(this);
            addAttributeDefList(_templateFileSuffix);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            AttributeDefinitionDMO _maxFastAddValuesOBJ = new AttributeDefinitionDMO();
            _maxFastAddValues = new AttributeDefinition(_maxFastAddValuesOBJ);
            _maxFastAddValuesOBJ.addDescription("Way too long!");
            _maxFastAddValuesOBJ.setName("maxFastAddValues");
            _maxFastAddValuesOBJ.setDmdID("-478584");
            _maxFastAddValuesOBJ.setType("meta.Integer");
            _maxFastAddValuesOBJ.setNullReturnValue("8");
            _maxFastAddValuesOBJ.setFile("/src/org/dmd/templates/shared/dmdconfig/attributes.dmd");
            _maxFastAddValuesOBJ.setDotName("dmtdl.maxFastAddValues.AttributeDefinition");
            _maxFastAddValuesOBJ.setLineNumber("121");
            _maxFastAddValues.setDefinedIn(this);
            addAttributeDefList(_maxFastAddValues);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            AttributeDefinitionDMO _commentFormatOBJ = new AttributeDefinitionDMO();
            _commentFormat = new AttributeDefinition(_commentFormatOBJ);
            _commentFormatOBJ.addDescription("By specifying a commentFormat for your TdlModule, you allow the formatting\n mechanism to automatically indicate the Template that was used for format the output. This\n is useful when debugging your formatted output.");
            _commentFormatOBJ.setName("commentFormat");
            _commentFormatOBJ.setDmdID("-478583");
            _commentFormatOBJ.setPreserveNewlines("true");
            _commentFormatOBJ.setType("meta.String");
            _commentFormatOBJ.setFile("/src/org/dmd/templates/shared/dmdconfig/attributes.dmd");
            _commentFormatOBJ.setDotName("dmtdl.commentFormat.AttributeDefinition");
            _commentFormatOBJ.setLineNumber("134");
            _commentFormat.setDefinedIn(this);
            addAttributeDefList(_commentFormat);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            AttributeDefinitionDMO _debugOnOBJ = new AttributeDefinitionDMO();
            _debugOn = new AttributeDefinition(_debugOnOBJ);
            _debugOnOBJ.addDescription("Although it's useful to have debug comments prepended to your generated\n artifact, there are times when you don't want that information dumped for particular Templates.\n For example, if your artifact must start with a particular text sequence. So, if\n you've specified a commentFormat for your TdlModule  but you don't want the debug\n comment for a particular Template, just set the debug attribute to false.");
            _debugOnOBJ.setName("debugOn");
            _debugOnOBJ.setDmdID("-478582");
            _debugOnOBJ.setType("meta.Boolean");
            _debugOnOBJ.setNullReturnValue("true");
            _debugOnOBJ.setFile("/src/org/dmd/templates/shared/dmdconfig/attributes.dmd");
            _debugOnOBJ.setDotName("dmtdl.debugOn.AttributeDefinition");
            _debugOnOBJ.setLineNumber("161");
            _debugOn.setDefinedIn(this);
            addAttributeDefList(_debugOn);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            AttributeDefinitionDMO _usesSectionOBJ = new AttributeDefinitionDMO();
            _usesSection = new AttributeDefinition(_usesSectionOBJ);
            _usesSectionOBJ.addDescription("The Section type that will be used to format the contents of an ExtensionHook.");
            _usesSectionOBJ.setName("usesSection");
            _usesSectionOBJ.setDmdID("-478581");
            _usesSectionOBJ.setType("dmtdl.Section");
            _usesSectionOBJ.setFile("/src/org/dmd/templates/shared/dmdconfig/attributes.dmd");
            _usesSectionOBJ.setDotName("dmtdl.usesSection.AttributeDefinition");
            _usesSectionOBJ.setLineNumber("177");
            _usesSection.setDefinedIn(this);
            addAttributeDefList(_usesSection);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            AttributeDefinitionDMO _targetObjectClassOBJ = new AttributeDefinitionDMO();
            _targetObjectClass = new AttributeDefinition(_targetObjectClassOBJ);
            _targetObjectClassOBJ.addDescription("The fully qualified name of the type of object that is being formatted when\n an ExtensionHook is called.");
            _targetObjectClassOBJ.setName("targetObjectClass");
            _targetObjectClassOBJ.setDmdID("-478580");
            _targetObjectClassOBJ.setType("meta.String");
            _targetObjectClassOBJ.setFile("/src/org/dmd/templates/shared/dmdconfig/attributes.dmd");
            _targetObjectClassOBJ.setDotName("dmtdl.targetObjectClass.AttributeDefinition");
            _targetObjectClassOBJ.setLineNumber("183");
            _targetObjectClass.setDefinedIn(this);
            addAttributeDefList(_targetObjectClass);

    }

    // Generated from: org.dmd.dmg.util.SchemaFormatter.dumpInitFunction(SchemaFormatter.java:313)
    private void initTypes() throws DmcValueException {
    }

    // Generated from: org.dmd.dmg.util.SchemaFormatter.dumpInitFunction(SchemaFormatter.java:313)
    private void initComplexTypes() throws DmcValueException {
// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            ComplexTypeDefinitionDMO _ContainsOBJ = new ComplexTypeDefinitionDMO();
            _Contains = new ComplexTypeDefinition(_ContainsOBJ);
            _ContainsOBJ.addRequiredPart("CardinalityEnum occurences \"The number of times a contained Section will occur.\"");
            _ContainsOBJ.addRequiredPart("ContainedElement element \"The Section or ExtensionHook being referenced.\"");
            _ContainsOBJ.addDescription("The Contains type indicates the number of times a Section will occur within a contain Section");
            _ContainsOBJ.setName("Contains");
            _ContainsOBJ.setFile("/src/org/dmd/templates/shared/dmdconfig/complex.dmd");
            _ContainsOBJ.setDotName("dmtdl.Contains.ComplexTypeDefinition");
            _ContainsOBJ.setLineNumber("2");
            _Contains.setDefinedIn(this);
            addComplexTypeDefList(_Contains);

// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            ComplexTypeDefinitionDMO _ValueOBJ = new ComplexTypeDefinitionDMO();
            _Value = new ComplexTypeDefinition(_ValueOBJ);
            _ValueOBJ.addRequiredPart("String valueName \"The name of the value that can be inserted into a Template\"");
            _ValueOBJ.addRequiredPart("String description \"A description of the value.\" quoted=true");
            _ValueOBJ.addDescription("The Value type indicates a name for a value that can be referenced in a Template along\n with a short description.");
            _ValueOBJ.setName("Value");
            _ValueOBJ.setFile("/src/org/dmd/templates/shared/dmdconfig/complex.dmd");
            _ValueOBJ.setDotName("dmtdl.Value.ComplexTypeDefinition");
            _ValueOBJ.setLineNumber("9");
            _Value.setDefinedIn(this);
            addComplexTypeDefList(_Value);

    }

    // Generated from: org.dmd.dmg.util.SchemaFormatter.dumpInitFunction(SchemaFormatter.java:313)
    private void initActions() throws DmcValueException {
    }

    // Generated from: org.dmd.dmg.util.SchemaFormatter.dumpInitFunction(SchemaFormatter.java:313)
    private void initEnums() throws DmcValueException {
// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            EnumDefinitionDMO _CardinalityEnumOBJ = new EnumDefinitionDMO();
            _CardinalityEnum = new EnumDefinition(_CardinalityEnumOBJ);
            _CardinalityEnumOBJ.addEnumValue("0 ONE Indicates that a section may appear once. You have to manually add the Section.");
            _CardinalityEnumOBJ.addEnumValue("1 MANY Indicates that a section will appear many times.");
            _CardinalityEnumOBJ.addEnumValue("2 STATIC Indicates that a section is static and will be automatically added.");
            _CardinalityEnumOBJ.addDescription("The CardinalityEnum indicates whether a Section will exist one or many times within another Section,\n or whther the Section is static and always added automatically.");
            _CardinalityEnumOBJ.setName("CardinalityEnum");
            _CardinalityEnumOBJ.setFile("/src/org/dmd/templates/shared/dmdconfig/types.dmd");
            _CardinalityEnumOBJ.setDotName("dmtdl.CardinalityEnum.EnumDefinition");
            _CardinalityEnumOBJ.setLineNumber("1");
            _CardinalityEnum.setDefinedIn(this);
            addEnumDefList(_CardinalityEnum);

    }

    // Generated from: org.dmd.dmg.util.SchemaFormatter.dumpInitFunction(SchemaFormatter.java:313)
    private void initRules() throws DmcValueException {
    }

    // Generated from: org.dmd.dmg.util.SchemaFormatter.dumpInitFunction(SchemaFormatter.java:313)
    private void initDSDModules() throws DmcValueException {
// Generated from: org.dmd.dmg.util.SchemaFormatter.getObjectAsCode(SchemaFormatter.java:585)
            DSDefinitionModuleDMO _TdlModuleDSDOBJ = new DSDefinitionModuleDMO();
            _TdlModuleDSD = new DSDefinitionModule(_TdlModuleDSDOBJ);
            _TdlModuleDSDOBJ.setFileExtension("dmtdl");
            _TdlModuleDSDOBJ.setName("TdlModule");
            _TdlModuleDSDOBJ.setDmdID("1");
            _TdlModuleDSDOBJ.setModuleClassName("TdlModule");
            _TdlModuleDSDOBJ.setBaseDefinition("dmtdl.TdlDefinition");
            _TdlModuleDSDOBJ.setModuleDependenceAttribute("dmtdl.dependsOnTdlModule");
            _TdlModuleDSDOBJ.setDefinedInModuleAttribute("dmtdl.definedInTdlModule");
            _TdlModuleDSDOBJ.setFile("/src/org/dmd/templates/shared/dmdconfig/module.dmd");
            _TdlModuleDSDOBJ.setDotName("dmtdl.TdlModule.DSDefinitionModule");
            _TdlModuleDSDOBJ.setLineNumber("1");
            _TdlModuleDSDOBJ.addDescription("Way too long!");
            _TdlModuleDSDOBJ.addMust("dmtdl.package");
            _TdlModuleDSDOBJ.addMust("dmtdl.templateFile");
            _TdlModuleDSDOBJ.addMay("dmtdl.templateFileSuffix");
            _TdlModuleDSDOBJ.addMay("dmtdl.maxFastAddValues");
            _TdlModuleDSDOBJ.addMay("dmtdl.insertMarker");
            _TdlModuleDSDOBJ.addMay("dmtdl.commentFormat");
            _TdlModuleDSD.setDefinedIn(this);
            addDsdModuleList(_TdlModuleDSD);

    }

    // Generated from: org.dmd.dmg.util.SchemaFormatter.dumpSchema(SchemaFormatter.java:272)

    @Override
    public synchronized DmtdlSchemaAG getInstance() throws DmcValueException{
    	   if (instance == null)
    		   initialize();
    	   return(instance);
    }
}

