//	---------------------------------------------------------------------------
//	dark-matter-data
//	Copyright (c) 2014 dark-matter-data committers
//	---------------------------------------------------------------------------
//	This program is free software; you can redistribute it and/or modify it
//	under the terms of the GNU Lesser General Public License as published by the
//	Free Software Foundation; either version 3 of the License, or (at your
//	option) any later version.
//	This program is distributed in the hope that it will be useful, but WITHOUT
//	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
//	FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for
//	more details.
//	You should have received a copy of the GNU Lesser General Public License along
//	with this program; if not, see <http://www.gnu.org/licenses/lgpl.html>.
//	---------------------------------------------------------------------------
package org.dmd.templates.shared.generated.dmo;

// Generated from: org.dmd.dms.util.GenUtility.formatImports(GenUtility.java:408)
import java.io.Serializable;                                               // Always required - (GenUtility.java:227)
import java.util.*;                                                        // Always required if we have any MV attributes - (GenUtility.java:224)
import org.dmd.dmc.DmcAttribute;                                           // Named object - (GenUtility.java:388)
import org.dmd.dmc.DmcNamedObjectIF;                                       // Named object - (GenUtility.java:387)
import org.dmd.dmc.DmcSliceInfo;                                           // Required for object slicing - (GenUtility.java:232)
import org.dmd.dmc.DmcValueException;                                      // Any attributes - (GenUtility.java:249)
import org.dmd.dmc.types.DefinitionName;                                   // Naming attribute type - (GenUtility.java:382)
import org.dmd.dms.generated.dmo.MetaDMSAG;                                // Required for MODREC constructor - (GenUtility.java:231)
import org.dmd.dms.generated.types.DmcTypeDefinitionNameSV;                // Required type - (GenUtility.java:339)
import org.dmd.dms.generated.types.DmcTypeModifierMV;                      // Required for MODREC constructor - (GenUtility.java:230)
import org.dmd.templates.shared.generated.dmo.TdlDefinitionDMO;            // Base class - (GenUtility.java:367)
import org.dmd.templates.shared.generated.types.Contains;                  // Primitive type - (GenUtility.java:282)
import org.dmd.templates.shared.generated.types.DmcTypeContainsMV;         // Required type - (GenUtility.java:339)

// Generated from: org.dmd.dms.util.DmoFormatter.getClassHeader(DmoFormatter.java:678)
/**
 * A TextualArtifact is the top level entity that is comprised of Sections\n
 * and formatted via Templates.
 * <P>
 * Generated from the dmtdl schema at version unknown
 * <P>
 * This code was auto-generated by the dmogenerator utility and shouldn't be alterred manually!
 * Generated from: org.dmd.dms.util.DmoFormatter.dumpDMO(DmoFormatter.java:134)
 */
@SuppressWarnings("serial")
public class TextualArtifactDMO  extends TdlDefinitionDMO  implements DmcNamedObjectIF, Serializable  {

    public final static String constructionClassName = "TextualArtifact";


    static {
    }

    public TextualArtifactDMO() {
        super("TextualArtifact");
    }

    protected TextualArtifactDMO(String oc) {
        super(oc);
    }

    @Override
    public TextualArtifactDMO getNew(){
        TextualArtifactDMO rc = new TextualArtifactDMO();
        return(rc);
    }

    @Override
    public TextualArtifactDMO getSlice(DmcSliceInfo info){
        TextualArtifactDMO rc = new TextualArtifactDMO();
        populateSlice(rc,info);
        return(rc);
    }

    public TextualArtifactDMO(DmcTypeModifierMV mods) {
        super("TextualArtifact");
        modrec(true);
        setModifier(mods);
    }

    public TextualArtifactDMO getModificationRecorder(){
        TextualArtifactDMO rc = new TextualArtifactDMO();
        rc.setName(getName());
        rc.setModifier(new DmcTypeModifierMV(MetaDMSAG.__modify));
        rc.modrec(true);
        return(rc);
    }

    // org.dmd.dms.util.DmoFormatter.getAccessFunctions(DmoFormatter.java:752)
    public DefinitionName getObjectName(){
        DmcAttribute<?> name = get(MetaDMSAG.__name);
        if (name != null)
            return((DefinitionName)name.getSV());
    
        return(null);
    }

    // org.dmd.dms.util.DmoFormatter.getAccessFunctions(DmoFormatter.java:769)
    public DmcAttribute<?> getObjectNameAttribute(){
        DmcAttribute<?> name = get(MetaDMSAG.__name);
        return(name);
    }

    // org.dmd.dms.util.DmoFormatter.getAccessFunctions(DmoFormatter.java:776)
    public boolean equals(Object obj){
        if (obj instanceof TextualArtifactDMO){
            return( getObjectName().equals( ((TextualArtifactDMO) obj).getObjectName()) );
        }
        return(false);
    }

    // org.dmd.dms.util.DmoFormatter.getAccessFunctions(DmoFormatter.java:784)
    public int hashCode(){
        DefinitionName objn = getObjectName();
        if (objn == null)
            return(0);
        
        return(objn.hashCode());
    }

    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:798)
    public DefinitionName getName(){
        DmcTypeDefinitionNameSV attr = (DmcTypeDefinitionNameSV) get(MetaDMSAG.__name);
        if (attr == null)
            return(null);

        return(attr.getSV());
    }

    /**
     * Sets name to the specified value.
     * @param value DefinitionName
     */
    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:838)
    public void setName(DefinitionName value) {
        DmcAttribute<?> attr = get(MetaDMSAG.__name);
        if (attr == null)
            attr = new DmcTypeDefinitionNameSV(MetaDMSAG.__name);
        
        try{
            attr.set(value);
            set(MetaDMSAG.__name,attr);
        }
        catch(DmcValueException ex){
            throw(new IllegalStateException("The type specific set() method shouldn't throw exceptions!",ex));
        }
    }

    /**
     * Sets name to the specified value.
     * @param value A value compatible with DmcTypeDefinitionNameSV
     * @throws DmcValueException if value is not correct
     */
    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:892)
    public void setName(Object value) throws DmcValueException {
        DmcTypeDefinitionNameSV attr  = (DmcTypeDefinitionNameSV) get(MetaDMSAG.__name);
        if (attr == null)
            attr = new DmcTypeDefinitionNameSV(MetaDMSAG.__name);
        
        attr.set(value);
        set(MetaDMSAG.__name,attr);
    }

    /**
     * Removes the name attribute value.
     */
    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:912)
    public void remName(){
         rem(MetaDMSAG.__name);
    }

    /**
     * @return An Iterator of Contains objects.
     */
    @SuppressWarnings("unchecked")
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1289)
    public Iterator<Contains> getContains(){
        DmcTypeContainsMV attr = (DmcTypeContainsMV) get(DmtdlDMSAG.__contains);
        if (attr == null)
            return( ((List<Contains>) Collections.EMPTY_LIST).iterator());

        return(attr.getMV());
    }

    /**
     * @param i the index
     * @return The nth Contains value.
     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1302)
    public Contains getNthContains(int i){
        DmcTypeContainsMV attr = (DmcTypeContainsMV) get(DmtdlDMSAG.__contains);
        if (attr == null)
            return(null);

        return(attr.getMVnth(i));
    }

    /**
     * Adds another contains to the specified value.
     * @param value Contains
     * @return the attribute instance
     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1317)
    public DmcAttribute<?> addContains(Contains value) {
        DmcAttribute<?> attr = get(DmtdlDMSAG.__contains);
        if (attr == null)
            attr = new DmcTypeContainsMV(DmtdlDMSAG.__contains);
        
        try{
            setLastValue(attr.add(value));
            add(DmtdlDMSAG.__contains,attr);
        }
        catch(DmcValueException ex){
            throw(new IllegalStateException("The type specific add() method shouldn't throw exceptions!",ex));
        }
        return(attr);
    }

    /**
     * @param value Contains
     * @return true if we contain a valued keyed by the specified Contains.
     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1392)
    public boolean containsContains(Contains value) {
        DmcAttribute<?> attr = get(DmtdlDMSAG.__contains);
        if (attr == null)
            return(false);
        return(attr.contains(value));
    }

    /**
     * Adds another contains value.
     * @param value A value compatible with Contains
     * @return the attribute instance
     * @throws DmcValueException if value is not correct
     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1426)
    public DmcAttribute<?> addContains(Object value) throws DmcValueException {
        DmcAttribute<?> attr = get(DmtdlDMSAG.__contains);
        if (attr == null)
            attr = new DmcTypeContainsMV(DmtdlDMSAG.__contains);
        
        setLastValue(attr.add(value));
        add(DmtdlDMSAG.__contains,attr);
        return(attr);
    }

    /**
     * @return the number of values in contains
     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1443)
    public int getContainsSize(){
        DmcAttribute<?> attr = get(DmtdlDMSAG.__contains);
        if (attr == null){
            if (DmtdlDMSAG.__contains.indexSize == 0)
                return(0);
            else
                return(DmtdlDMSAG.__contains.indexSize);
        }
        return(attr.getMVSize());
    }

    /**
     * Deletes a contains value.
     * @param value The Contains to be deleted from set of attribute values.
     * @return the deleted attribute instance
     * @throws DmcValueException if the value is incorrect
     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1505)
    public DmcAttribute<?> delContains(Object value) throws DmcValueException {
        DmcAttribute<?> attr = get(DmtdlDMSAG.__contains);
        
        if ( (attr == null) && (getModifier()!= null))
            delFromEmptyAttribute(new DmcTypeContainsMV(DmtdlDMSAG.__contains), value);
        else
            attr = del(DmtdlDMSAG.__contains, value);
        
        return(attr);
    }

    /**
     * Deletes a contains from the specified value.
     * @param value Contains
     * @return the deleted attribute instance     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1522)
    public DmcAttribute<?> delContains(Contains value) {
        DmcAttribute<?> attr = get(DmtdlDMSAG.__contains);
        
        if ( (attr == null) && (getModifier()!= null))
            delFromEmptyAttribute(new DmcTypeContainsMV(DmtdlDMSAG.__contains), value);
        else
            attr = del(DmtdlDMSAG.__contains, value);
        
        return(attr);
    }

    /**
     * Removes the contains attribute value.
     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1541)
    public void remContains(){
         rem(DmtdlDMSAG.__contains);
    }




}
