/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.concinnity.server.generated.dsd;

import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;
import org.dmd.concinnity.server.extended.Concept;
import org.dmd.concinnity.server.extended.ConcinnityDefinition;
import org.dmd.concinnity.server.extended.ConcinnityModule;
import org.dmd.concinnity.server.generated.dsd.ConcinnityModuleDefinitionsIF;
import org.dmd.concinnity.server.generated.dsd.ConcinnityModuleGlobalInterface;
import org.dmd.concinnity.shared.generated.dmo.DmconcinnityDMSAG;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcClassInfo;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcNameClashObjectSet;
import org.dmd.dmc.DmcNameClashResolverIF;
import org.dmd.dmc.DmcNameResolverWithClashSupportIF;
import org.dmd.dmc.DmcNamedObjectIF;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.DmcObjectName;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.DmcValueExceptionSet;
import org.dmd.dmc.definitions.DmcDefinitionSet;
import org.dmd.dmc.types.DotName;
import org.dmd.dms.DSDefinition;
import org.dmd.dmw.DmwNamedObjectWrapper;
import org.dmd.util.exceptions.ResultException;

public class ConcinnityModuleDefinitionManager
implements ConcinnityModuleGlobalInterface,
DmcNameClashResolverIF,
DmcNameResolverWithClashSupportIF,
ConcinnityModuleDefinitionsIF {
    private DmcDefinitionSet<DSDefinition> allDefinitions = new DmcDefinitionSet("allDefinitions");
    private DmcDefinitionSet<ConcinnityDefinition> ConcinnityDefinitionDefs;
    private DmcDefinitionSet<Concept> ConceptDefs;
    private DmcDefinitionSet<ConcinnityModule> ConcinnityModuleDefs;
    private TreeMap<DmcClassInfo, DmcDefinitionSet<?>> indicesByClass = new TreeMap();

    public ConcinnityModuleDefinitionManager() {
        this.ConcinnityDefinitionDefs = new DmcDefinitionSet("ConcinnityDefinition", this.allDefinitions);
        this.indicesByClass.put(DmconcinnityDMSAG.__ConcinnityDefinition, this.ConcinnityDefinitionDefs);
        this.ConceptDefs = new DmcDefinitionSet("Concept", this.allDefinitions, this.ConcinnityDefinitionDefs);
        this.indicesByClass.put(DmconcinnityDMSAG.__Concept, this.ConceptDefs);
        this.ConcinnityModuleDefs = new DmcDefinitionSet("ConcinnityModule", this.allDefinitions, this.ConcinnityDefinitionDefs);
        this.indicesByClass.put(DmconcinnityDMSAG.__ConcinnityModule, this.ConcinnityModuleDefs);
    }

    public void resolveReferences() throws DmcValueExceptionSet {
        for (DSDefinition def : this.allDefinitions.values()) {
            def.resolveReferences(this, this);
        }
    }

    public Collection<DmwNamedObjectWrapper> getIndex(DmcClassInfo ci) {
        DmcDefinitionSet<?> dds = this.indicesByClass.get(ci);
        if (dds == null) {
            throw new IllegalStateException("No index available for class: " + ci.name);
        }
        return dds.getIndex();
    }

    @Override
    public DmcNamedObjectIF findNamedObject(DmcObjectName name) {
        DSDefinition def = null;
        try {
            def = this.allDefinitions.getDefinition(name.toString());
        }
        catch (DmcNameClashException e) {
            e.printStackTrace();
        }
        catch (DmcValueException e) {
            e.printStackTrace();
        }
        return def;
    }

    public DSDefinition findDefinition(DotName name) {
        return this.allDefinitions.getDefinition(name);
    }

    public void deleteDefinition(DotName name) throws ResultException {
        DSDefinition def = this.allDefinitions.getDefinition(name);
        if (def == null) {
            throw new ResultException("Could not find object to delete: " + name.getNameString());
        }
        DmcDefinitionSet<?> dds = this.indicesByClass.get(def.getConstructionClassInfo());
        dds.delete(name);
        def.youAreDeleted();
        ConcinnityDefinition base = (ConcinnityDefinition)def;
        ConcinnityModule module = base.getDefinedInConcinnityModule();
        if (def instanceof Concept) {
            module.deleteConcept((Concept)def);
        } else if (def instanceof ConcinnityModule) {
            // empty if block
        }
    }

    @Override
    public DmcNamedObjectIF findNamedObject(DmcObjectName name, int attributeID) {
        throw new IllegalStateException("This method is not supported on generated definition managers");
    }

    @Override
    public DmcObject findNamedDMO(DmcObjectName name) {
        DSDefinition def = null;
        try {
            def = this.allDefinitions.getDefinition(name.toString());
        }
        catch (DmcNameClashException e) {
            e.printStackTrace();
        }
        catch (DmcValueException e) {
            e.printStackTrace();
        }
        if (def == null) {
            return null;
        }
        return def.getDMO();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DmcNamedObjectIF findNamedObjectMayClash(DmcObject object, DmcObjectName name, DmcNameClashResolverIF resolver, DmcAttributeInfo ai) throws DmcValueException {
        void var5_9;
        Object var5_5 = null;
        DotName dn = new DotName(name.getNameString() + "." + ai.type);
        if (name.getNameString().indexOf(".") == -1) {
            try {
                DSDefinition dSDefinition = this.allDefinitions.getDefinitionByNameAndType(dn);
                return var5_9;
            }
            catch (DmcNameClashException e) {
                DmcNamedObjectIF dmcNamedObjectIF = resolver.resolveClash(object, ai, e.getClashSet());
                if (dmcNamedObjectIF != null) return var5_9;
                DmcValueException ex = new DmcValueException("The reference to : " + name.getNameString() + " is ambiguous. You must specify the module name as a prefix to the name. Here are your options:");
                Iterator<DmcNamedObjectIF> it = e.getMatches();
                while (it.hasNext()) {
                    ConcinnityDefinition def = (ConcinnityDefinition)it.next();
                    ex.addMoreInfo(def.getDefinedInConcinnityModule().getName().getNameString() + "." + name.getNameString());
                }
                throw ex;
            }
        } else {
            DSDefinition dSDefinition = this.allDefinitions.getDefinition(dn);
        }
        return var5_9;
    }

    @Override
    public DmcNamedObjectIF resolveClash(DmcObject obj, DmcAttributeInfo ai, DmcNameClashObjectSet<?> ncos) throws DmcValueException {
        DSDefinition rc = null;
        DSDefinition resolving = (DSDefinition)obj.getContainer();
        Iterator<DmcNamedObjectIF> it = ncos.getMatches();
        while (it.hasNext()) {
            DSDefinition def = (DSDefinition)it.next();
            if (!resolving.getNameOfModuleWhereThisCameFrom().equals(def.getNameOfModuleWhereThisCameFrom())) continue;
            rc = def;
            break;
        }
        return rc;
    }

    void addConcinnityDefinition(ConcinnityDefinition def) {
        this.ConcinnityDefinitionDefs.add(def);
    }

    void deleteConcinnityDefinition(ConcinnityDefinition def) {
        try {
            this.ConcinnityDefinitionDefs.delete(def);
        }
        catch (ResultException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int getConcinnityDefinitionCount() {
        return this.ConcinnityDefinitionDefs.size();
    }

    @Override
    public ConcinnityDefinition getConcinnityDefinition(DotName name) {
        return this.ConcinnityDefinitionDefs.getDefinition(name);
    }

    @Override
    public Iterator<ConcinnityDefinition> getAllConcinnityDefinition() {
        return this.ConcinnityDefinitionDefs.values().iterator();
    }

    @Override
    public void addConcept(Concept def) {
        this.ConceptDefs.add(def);
        this.addConcinnityDefinition(def);
    }

    @Override
    public void deleteConcept(Concept def) {
        try {
            this.ConceptDefs.delete(def);
        }
        catch (ResultException e) {
            throw new IllegalStateException(e);
        }
        this.deleteConcinnityDefinition(def);
    }

    @Override
    public int getConceptCount() {
        return this.ConceptDefs.size();
    }

    @Override
    public Concept getConcept(DotName name) {
        return this.ConceptDefs.getDefinition(name);
    }

    @Override
    public Iterator<Concept> getAllConcept() {
        return this.ConceptDefs.values().iterator();
    }

    @Override
    public Concept getConceptDefinition(String name) throws DmcNameClashException, DmcValueException {
        return this.ConceptDefs.getDefinition(name);
    }

    @Override
    public Iterator<Concept> getConceptDefinitionsByName(String name) throws DmcValueException {
        return this.ConceptDefs.getDefinitionsByName(name);
    }

    @Override
    public int getConceptDefinitionCountByName(String name) throws DmcValueException {
        return this.ConceptDefs.getDefinitionCountByName(name);
    }

    @Override
    public void addConcinnityModule(ConcinnityModule def) {
        this.ConcinnityModuleDefs.add(def);
        this.addConcinnityDefinition(def);
    }

    @Override
    public void deleteConcinnityModule(ConcinnityModule def) {
        try {
            this.ConcinnityModuleDefs.delete(def);
        }
        catch (ResultException e) {
            throw new IllegalStateException(e);
        }
        this.deleteConcinnityDefinition(def);
    }

    @Override
    public int getConcinnityModuleCount() {
        return this.ConcinnityModuleDefs.size();
    }

    @Override
    public ConcinnityModule getConcinnityModule(DotName name) {
        return this.ConcinnityModuleDefs.getDefinition(name);
    }

    @Override
    public Iterator<ConcinnityModule> getAllConcinnityModule() {
        return this.ConcinnityModuleDefs.values().iterator();
    }

    @Override
    public ConcinnityModule getConcinnityModuleDefinition(String name) throws DmcNameClashException, DmcValueException {
        return this.ConcinnityModuleDefs.getDefinition(name);
    }

    @Override
    public Iterator<ConcinnityModule> getConcinnityModuleDefinitionsByName(String name) throws DmcValueException {
        return this.ConcinnityModuleDefs.getDefinitionsByName(name);
    }

    @Override
    public int getConcinnityModuleDefinitionCountByName(String name) throws DmcValueException {
        return this.ConcinnityModuleDefs.getDefinitionCountByName(name);
    }

    public void addDefinition(DSDefinition definition) {
        if (definition instanceof Concept) {
            this.addConcept((Concept)definition);
        } else if (definition instanceof ConcinnityModule) {
            this.addConcinnityModule((ConcinnityModule)definition);
        }
    }

    public void addDefinition(DSDefinition definition, ConcinnityModule module) {
        if (definition instanceof Concept) {
            this.addConcept((Concept)definition);
            module.addConcept((Concept)definition);
        } else if (definition instanceof ConcinnityModule) {
            this.addConcinnityModule((ConcinnityModule)definition);
        }
    }

    public String summary() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.ConcinnityDefinitionDefs.summary());
        sb.append(this.ConceptDefs.summary());
        sb.append(this.ConcinnityModuleDefs.summary());
        return sb.toString();
    }
}

