/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.concinnity.server.generated.dsd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.dmd.concinnity.server.extended.ConcinnityModule;
import org.dmd.concinnity.server.generated.dsd.ConcinnityModuleDefinitionManager;
import org.dmd.concinnity.server.generated.dsd.ConcinnityModuleGeneratorInterface;
import org.dmd.concinnity.server.generated.dsd.ConcinnityModuleParser;
import org.dmd.concinnity.shared.generated.types.ConcinnityModuleREF;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.DmcValueExceptionSet;
import org.dmd.dmc.rules.DmcRuleExceptionSet;
import org.dmd.dmc.types.DefinitionName;
import org.dmd.dms.DSDefinition;
import org.dmd.dmv.shared.DmvRuleManager;
import org.dmd.util.exceptions.ResultException;
import org.dmd.util.parsing.ConfigFinder;
import org.dmd.util.parsing.ConfigLocation;
import org.dmd.util.parsing.ConfigVersion;

public class ConcinnityModuleParsingCoordinator {
    DmvRuleManager rules = new DmvRuleManager();
    ConcinnityModuleDefinitionManager definitions = new ConcinnityModuleDefinitionManager();
    ConcinnityModuleGeneratorInterface generator;
    TreeMap<String, ModuleInfoBase> loadedConfigs = new TreeMap();
    ConcinnityModuleParser parserForConcinnityModule;
    ConfigFinder finderForConcinnityModule = new ConfigFinder(".dmcm");
    TreeMap<DefinitionName, ConcinnityModuleInfo> loadedConcinnityModuleConfigs = new TreeMap();

    public ConcinnityModuleParsingCoordinator(ConcinnityModuleGeneratorInterface g, ArrayList<String> sourceDirs, ArrayList<String> jars) throws ResultException, DmcValueException, DmcNameClashException, DmcRuleExceptionSet, IOException {
        this.generator = g;
        this.parserForConcinnityModule = new ConcinnityModuleParser(this.definitions, this.rules);
        this.finderForConcinnityModule.setSourceAndJarInfo(sourceDirs, jars);
        this.finderForConcinnityModule.findConfigs();
    }

    public DmvRuleManager getRuleManager() {
        return this.rules;
    }

    public ConcinnityModuleParser parserForConcinnityModule() {
        return this.parserForConcinnityModule;
    }

    public void generateForConfig(String configName) throws ResultException, DmcValueException, DmcRuleExceptionSet, DmcNameClashException, DmcValueExceptionSet, IOException {
        ConfigVersion version = this.finderForConcinnityModule.getConfig(configName);
        if (version == null) {
            ResultException ex = new ResultException("Could not find the specified configuration file: " + configName);
            throw ex;
        }
        ConfigLocation location = version.getLatestVersion();
        ConcinnityModule loaded = this.loadConcinnityModuleModule(location);
        if (location.isFromJAR()) {
            ResultException ex = new ResultException("We can't run generation for a config loaded from a JAR: " + configName);
            ex.moreMessages(location.toString());
            throw ex;
        }
        this.generator.parsingComplete(loaded, location, this.definitions);
        this.definitions.resolveReferences();
        this.generator.generate(loaded, location, this.definitions);
    }

    public void generateForAllConfigs() throws ResultException, DmcValueException, DmcRuleExceptionSet, DmcNameClashException, DmcValueExceptionSet, IOException {
        ConcinnityModule loaded = null;
        ConcinnityModuleInfo loadedInfo = null;
        Iterator<ConfigLocation> it = this.finderForConcinnityModule.getLocations();
        while (it.hasNext()) {
            ConfigLocation location = it.next();
            loadedInfo = (ConcinnityModuleInfo)this.loadedConfigs.get(location.getFileName());
            loaded = loadedInfo == null ? this.loadConcinnityModuleModule(location) : loadedInfo.module;
            this.generator.parsingComplete(loaded, location, this.definitions);
            this.definitions.resolveReferences();
            this.generator.objectResolutionComplete(loaded, location, this.definitions);
        }
        this.generator.generate(this.definitions);
    }

    ConcinnityModule loadConcinnityModuleModule(ConfigLocation location) throws ResultException, DmcValueException, DmcRuleExceptionSet, DmcNameClashException {
        ConcinnityModuleInfo info = this.loadedConcinnityModuleConfigs.get(new DefinitionName(location.getConfigName()));
        if (info != null) {
            return info.module;
        }
        ConcinnityModule loaded = this.parserForConcinnityModule.parseConfig(location);
        ConcinnityModuleInfo loadedInfo = new ConcinnityModuleInfo(loaded, location);
        this.loadedConcinnityModuleConfigs.put(loaded.getName(), loadedInfo);
        this.loadedConfigs.put(location.getFileName(), loadedInfo);
        this.loadModuleDependencies(loadedInfo);
        return loaded;
    }

    public ConfigLocation getLocation(ConcinnityModule module) {
        ConcinnityModuleInfo info = this.loadedConcinnityModuleConfigs.get(module.getName());
        if (info == null) {
            throw new IllegalStateException("Couldn't find ConfigLocation for module: \n\n" + module.toOIF());
        }
        return info.location;
    }

    void loadModuleDependencies(ModuleInfoBase mi) throws ResultException, DmcValueException, DmcRuleExceptionSet, DmcNameClashException {
        if (mi.dependenciesLoaded) {
            return;
        }
        if (mi instanceof ConcinnityModuleInfo) {
            ConcinnityModuleInfo info = (ConcinnityModuleInfo)mi;
            if (info.module.getDependsOnConcinnityModuleHasValue()) {
                Iterator<ConcinnityModuleREF> it = info.module.getDMO().getDependsOnConcinnityModule();
                while (it.hasNext()) {
                    ConcinnityModuleREF ref = it.next();
                    ConfigVersion version = this.finderForConcinnityModule.getConfig(ref.toString());
                    if (version == null) {
                        this.missingConfigError(info.module, ref.toString() + ".dmcm");
                    }
                    this.loadConcinnityModuleModule(version.getLatestVersion());
                }
            }
            info.dependenciesLoaded = true;
        }
    }

    void missingConfigError(String missing) throws ResultException {
        ResultException ex = new ResultException("Could not find config: " + missing);
        throw ex;
    }

    void missingConfigError(DSDefinition module, String missing) throws ResultException {
        ResultException ex = new ResultException("Could not find config: " + missing);
        ex.setLocationInfo(module.getFile(), module.getLineNumber());
        throw ex;
    }

    class ConcinnityModuleInfo
    extends ModuleInfoBase {
        ConcinnityModule module;

        ConcinnityModuleInfo(ConcinnityModule m, ConfigLocation l) {
            this.module = m;
            this.location = l;
        }
    }

    class ModuleInfoBase {
        ConfigLocation location;
        boolean dependenciesLoaded;

        ModuleInfoBase() {
        }
    }
}

