/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.concinnity.shared.generated.dsd;

import java.util.Iterator;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.dmd.concinnity.shared.generated.dmo.ConceptDMO;
import org.dmd.concinnity.shared.generated.dmo.ConcinnityDefinitionDMO;
import org.dmd.concinnity.shared.generated.dmo.ConcinnityModuleDMO;
import org.dmd.concinnity.shared.generated.dmo.DmconcinnityDMSAG;
import org.dmd.concinnity.shared.generated.dsd.ConcinnityModuleGlobalInterface;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcNameClashObjectSet;
import org.dmd.dmc.DmcNameClashResolverIF;
import org.dmd.dmc.DmcNameResolverWithClashSupportIF;
import org.dmd.dmc.DmcNamedObjectIF;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.DmcObjectName;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.DmcValueExceptionSet;
import org.dmd.dmc.definitions.DMODefinitionSet;
import org.dmd.dmc.types.DotName;
import org.dmd.dms.generated.dmo.DSDefinitionDMO;
import org.dmd.dmv.shared.DmvRuleManager;

public class ConcinnityModuleDefinitionDMOCache
implements ConcinnityModuleGlobalInterface,
DmcNameClashResolverIF,
DmcNameResolverWithClashSupportIF {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private DmvRuleManager ruleManager = new DmvRuleManager();
    private DMODefinitionSet<DSDefinitionDMO> allDefinitions;
    private TreeMap<String, DMODefinitionSet<?>> indicesByClass;
    private DMODefinitionSet<ConcinnityDefinitionDMO> ConcinnityDefinitionDefs;
    private DMODefinitionSet<ConceptDMO> ConceptDefs;
    private DMODefinitionSet<ConcinnityModuleDMO> ConcinnityModuleDefs;

    public ConcinnityModuleDefinitionDMOCache() {
        this.ruleManager.loadRules(DmconcinnityDMSAG.instance());
        this.allDefinitions = new DMODefinitionSet("allDefinitions");
        this.indicesByClass = new TreeMap();
        this.ConcinnityDefinitionDefs = new DMODefinitionSet("ConcinnityDefinition", this.allDefinitions);
        this.indicesByClass.put(this.ConcinnityDefinitionDefs.className(), this.ConcinnityDefinitionDefs);
        this.ConceptDefs = new DMODefinitionSet("Concept", this.allDefinitions, this.ConcinnityDefinitionDefs);
        this.indicesByClass.put(this.ConceptDefs.className(), this.ConceptDefs);
        this.ConcinnityModuleDefs = new DMODefinitionSet("ConcinnityModule", this.allDefinitions, this.ConcinnityDefinitionDefs);
        this.indicesByClass.put(this.ConcinnityModuleDefs.className(), this.ConcinnityModuleDefs);
    }

    public DmvRuleManager ruleManager() {
        return this.ruleManager;
    }

    public void resolveReferences() throws DmcValueExceptionSet {
        for (DSDefinitionDMO def : this.allDefinitions.values()) {
            def.resolveReferencesExceptClass(this, this);
        }
    }

    @Override
    public DmcNamedObjectIF findNamedObject(DmcObjectName name) {
        DSDefinitionDMO def = null;
        try {
            def = this.allDefinitions.getDefinition(name.toString());
        }
        catch (DmcNameClashException e) {
            this.logger.fine(e.toString());
        }
        catch (DmcValueException e) {
            this.logger.fine(e.toString());
        }
        return def;
    }

    public DSDefinitionDMO findDefinition(DotName name) {
        return this.allDefinitions.getDefinition(name);
    }

    public void deleteDefinition(DotName name) throws Exception {
        DSDefinitionDMO def = this.allDefinitions.getDefinition(name);
        if (def == null) {
            throw new Exception("Could not find object to delete: " + name.getNameString());
        }
        DMODefinitionSet<?> dds = this.indicesByClass.get(def.getConstructionClassName());
        dds.delete(name);
        def.youAreDeleted();
    }

    @Override
    public DmcNamedObjectIF findNamedObject(DmcObjectName name, int attributeID) {
        throw new IllegalStateException("This method is not supported on generated definition managers");
    }

    @Override
    public DmcObject findNamedDMO(DmcObjectName name) {
        DSDefinitionDMO def = null;
        try {
            def = name instanceof DotName ? this.allDefinitions.getDefinition((DotName)name) : this.allDefinitions.getDefinition(name.toString());
        }
        catch (DmcNameClashException e) {
            this.logger.fine(e.toString());
        }
        catch (DmcValueException e) {
            this.logger.fine(e.toString());
        }
        return def;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DmcNamedObjectIF findNamedObjectMayClash(DmcObject object, DmcObjectName name, DmcNameClashResolverIF resolver, DmcAttributeInfo ai) throws DmcValueException {
        void var5_9;
        Object var5_5 = null;
        DotName dn = new DotName(name.getNameString() + "." + ai.type);
        if (name.getNameString().indexOf(".") == -1) {
            try {
                DSDefinitionDMO dSDefinitionDMO = this.allDefinitions.getDefinitionByNameAndType(dn);
                return var5_9;
            }
            catch (DmcNameClashException e) {
                DmcNamedObjectIF dmcNamedObjectIF = resolver.resolveClash(object, ai, e.getClashSet());
                if (dmcNamedObjectIF != null) return var5_9;
                DmcValueException ex = new DmcValueException("The reference to : " + name.getNameString() + " is ambiguous. You must specify the module name as a prefix to the name. Here are your options:");
                Iterator<DmcNamedObjectIF> it = e.getMatches();
                while (it.hasNext()) {
                    ConcinnityDefinitionDMO def = (ConcinnityDefinitionDMO)it.next();
                    ex.addMoreInfo(def.getDefinedInConcinnityModule().getName().getNameString() + "." + name.getNameString());
                }
                throw ex;
            }
        } else {
            DSDefinitionDMO dSDefinitionDMO = this.allDefinitions.getDefinition(dn);
        }
        return var5_9;
    }

    @Override
    public DmcNamedObjectIF resolveClash(DmcObject obj, DmcAttributeInfo ai, DmcNameClashObjectSet<?> ncos) throws DmcValueException {
        DSDefinitionDMO rc = null;
        DSDefinitionDMO resolving = (DSDefinitionDMO)((Object)obj.getContainer());
        Iterator<DmcNamedObjectIF> it = ncos.getMatches();
        while (it.hasNext()) {
            DSDefinitionDMO def = (DSDefinitionDMO)it.next();
            if (!resolving.getDmoFromModule().equals(def.getDmoFromModule())) continue;
            rc = def;
            break;
        }
        return rc;
    }

    void addConcinnityDefinition(ConcinnityDefinitionDMO def) {
        this.ConcinnityDefinitionDefs.add(def);
    }

    @Override
    public int getConcinnityDefinitionCount() {
        return this.ConcinnityDefinitionDefs.size();
    }

    @Override
    public ConcinnityDefinitionDMO getConcinnityDefinition(DotName name) {
        return this.ConcinnityDefinitionDefs.getDefinition(name);
    }

    @Override
    public Iterator<ConcinnityDefinitionDMO> getAllConcinnityDefinition() {
        return this.ConcinnityDefinitionDefs.values().iterator();
    }

    @Override
    public void addConcept(ConceptDMO def) {
        this.ConceptDefs.add(def);
        this.addConcinnityDefinition(def);
    }

    @Override
    public int getConceptCount() {
        return this.ConceptDefs.size();
    }

    @Override
    public ConceptDMO getConcept(DotName name) {
        return this.ConceptDefs.getDefinition(name);
    }

    @Override
    public Iterator<ConceptDMO> getAllConcept() {
        return this.ConceptDefs.values().iterator();
    }

    @Override
    public ConceptDMO getConceptDefinition(String name) throws DmcNameClashException, DmcValueException {
        return this.ConceptDefs.getDefinition(name);
    }

    @Override
    public void addConcinnityModule(ConcinnityModuleDMO def) {
        this.ConcinnityModuleDefs.add(def);
        this.addConcinnityDefinition(def);
    }

    @Override
    public int getConcinnityModuleCount() {
        return this.ConcinnityModuleDefs.size();
    }

    @Override
    public ConcinnityModuleDMO getConcinnityModule(DotName name) {
        return this.ConcinnityModuleDefs.getDefinition(name);
    }

    @Override
    public Iterator<ConcinnityModuleDMO> getAllConcinnityModule() {
        return this.ConcinnityModuleDefs.values().iterator();
    }

    @Override
    public ConcinnityModuleDMO getConcinnityModuleDefinition(String name) throws DmcNameClashException, DmcValueException {
        return this.ConcinnityModuleDefs.getDefinition(name);
    }

    public void addDefinition(DSDefinitionDMO definition) {
        if (definition instanceof ConceptDMO) {
            this.addConcept((ConceptDMO)definition);
        } else if (definition instanceof ConcinnityModuleDMO) {
            this.addConcinnityModule((ConcinnityModuleDMO)definition);
        }
    }

    public String summary() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.ConcinnityDefinitionDefs.summary());
        sb.append(this.ConceptDefs.summary());
        sb.append(this.ConcinnityModuleDefs.summary());
        return sb.toString();
    }
}

