/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.concinnity.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.concinnity.shared.generated.types.ConceptREF;
import org.dmd.concinnity.shared.generated.types.DmcTypeConceptREF;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeConceptREFSET
extends DmcTypeConceptREF
implements Serializable {
    private static final Iterator<ConceptREF> emptyList = new HashSet().iterator();
    protected Set<ConceptREF> value;

    public DmcTypeConceptREFSET() {
        this.value = null;
    }

    public DmcTypeConceptREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<ConceptREF>() : new TreeSet<ConceptREF>();
    }

    public DmcTypeConceptREFSET getNew() {
        return new DmcTypeConceptREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<ConceptREF> cloneIt() {
        DmcTypeConceptREFSET dmcTypeConceptREFSET = this;
        synchronized (dmcTypeConceptREFSET) {
            DmcTypeConceptREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (ConceptREF val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConceptREF add(Object v) throws DmcValueException {
        DmcTypeConceptREFSET dmcTypeConceptREFSET = this;
        synchronized (dmcTypeConceptREFSET) {
            ConceptREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConceptREF del(Object v) {
        DmcTypeConceptREFSET dmcTypeConceptREFSET = this;
        synchronized (dmcTypeConceptREFSET) {
            ConceptREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<ConceptREF> getMV() {
        DmcTypeConceptREFSET dmcTypeConceptREFSET = this;
        synchronized (dmcTypeConceptREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<ConceptREF>(this.value).iterator();
            }
            return new TreeSet<ConceptREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ConceptREF> getMVCopy() {
        DmcTypeConceptREFSET dmcTypeConceptREFSET = this;
        synchronized (dmcTypeConceptREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<ConceptREF>();
                }
                return new HashSet<ConceptREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<ConceptREF>(this.value);
            }
            return new TreeSet<ConceptREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeConceptREFSET dmcTypeConceptREFSET = this;
        synchronized (dmcTypeConceptREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeConceptREFSET dmcTypeConceptREFSET = this;
        synchronized (dmcTypeConceptREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                ConceptREF val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

