/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.concinnity.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.concinnity.shared.generated.types.ConcinnityModuleREF;
import org.dmd.concinnity.shared.generated.types.DmcTypeConcinnityModuleREF;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeConcinnityModuleREFSET
extends DmcTypeConcinnityModuleREF
implements Serializable {
    private static final Iterator<ConcinnityModuleREF> emptyList = new HashSet().iterator();
    protected Set<ConcinnityModuleREF> value;

    public DmcTypeConcinnityModuleREFSET() {
        this.value = null;
    }

    public DmcTypeConcinnityModuleREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<ConcinnityModuleREF>() : new TreeSet<ConcinnityModuleREF>();
    }

    public DmcTypeConcinnityModuleREFSET getNew() {
        return new DmcTypeConcinnityModuleREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<ConcinnityModuleREF> cloneIt() {
        DmcTypeConcinnityModuleREFSET dmcTypeConcinnityModuleREFSET = this;
        synchronized (dmcTypeConcinnityModuleREFSET) {
            DmcTypeConcinnityModuleREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (ConcinnityModuleREF val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConcinnityModuleREF add(Object v) throws DmcValueException {
        DmcTypeConcinnityModuleREFSET dmcTypeConcinnityModuleREFSET = this;
        synchronized (dmcTypeConcinnityModuleREFSET) {
            ConcinnityModuleREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConcinnityModuleREF del(Object v) {
        DmcTypeConcinnityModuleREFSET dmcTypeConcinnityModuleREFSET = this;
        synchronized (dmcTypeConcinnityModuleREFSET) {
            ConcinnityModuleREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<ConcinnityModuleREF> getMV() {
        DmcTypeConcinnityModuleREFSET dmcTypeConcinnityModuleREFSET = this;
        synchronized (dmcTypeConcinnityModuleREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<ConcinnityModuleREF>(this.value).iterator();
            }
            return new TreeSet<ConcinnityModuleREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ConcinnityModuleREF> getMVCopy() {
        DmcTypeConcinnityModuleREFSET dmcTypeConcinnityModuleREFSET = this;
        synchronized (dmcTypeConcinnityModuleREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<ConcinnityModuleREF>();
                }
                return new HashSet<ConcinnityModuleREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<ConcinnityModuleREF>(this.value);
            }
            return new TreeSet<ConcinnityModuleREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeConcinnityModuleREFSET dmcTypeConcinnityModuleREFSET = this;
        synchronized (dmcTypeConcinnityModuleREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeConcinnityModuleREFSET dmcTypeConcinnityModuleREFSET = this;
        synchronized (dmcTypeConcinnityModuleREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                ConcinnityModuleREF val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

