/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmc;

import java.io.Serializable;
import java.util.Iterator;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcExtendedReferenceIF;
import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.DmcNamedObjectIF;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.DmcOmni;
import org.dmd.dmc.DmcOutputStreamIF;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.presentation.DmcAdapterIF;
import org.dmd.dmc.types.Modifier;
import org.dmd.dms.generated.enums.ModifyTypeEnum;
import org.dmd.dms.generated.types.DmcTypeModifierMV;

public abstract class DmcAttribute<VALUE>
implements Cloneable,
Serializable,
Comparable<String> {
    protected Integer ID;
    protected transient DmcAttributeInfo attrInfo;

    protected DmcAttribute() {
        this.ID = -1;
        this.attrInfo = null;
    }

    protected DmcAttribute(DmcAttributeInfo ai) {
        this.ID = ai.id;
        this.attrInfo = ai;
    }

    public DmcAttributeInfo getAttributeInfo() {
        if (this.attrInfo == null) {
            this.attrInfo = DmcOmni.instance().getInfo(this.ID);
        }
        return this.attrInfo;
    }

    public void setAttributeInfo(DmcAttributeInfo ai) {
        this.attrInfo = ai;
        this.ID = ai.id;
    }

    public Integer getID() {
        return this.ID;
    }

    public String getName() {
        if (this.attrInfo == null) {
            this.attrInfo = DmcOmni.instance().getInfo(this.ID);
            if (this.attrInfo == null) {
                throw new IllegalStateException("Unknown attribute ID: " + this.ID + " - you are missing a required schema.");
            }
        }
        return this.attrInfo.name;
    }

    @Override
    public int compareTo(String o) {
        return this.getName().compareTo(o);
    }

    protected abstract VALUE typeCheck(Object var1) throws DmcValueException;

    protected abstract VALUE cloneValue(VALUE var1);

    public abstract void serializeValue(DmcOutputStreamIF var1, VALUE var2) throws Exception;

    public abstract VALUE deserializeValue(DmcInputStreamIF var1) throws Exception;

    protected abstract DmcAttribute<?> getNew();

    public VALUE set(Object value) throws DmcValueException {
        throw new IllegalStateException("The set() method should be overloaded automatically by the DmcType[VALUE]SV class");
    }

    public VALUE getSV() {
        throw new IllegalStateException("The getSV() method should be overloaded automatically by the DmcType[VALUE]SV class");
    }

    public VALUE add(Object value) throws DmcValueException {
        throw new IllegalStateException("The add() method should be overloaded automatically by the DmcType[VALUE]MV/MAP/SET classes");
    }

    public VALUE del(Object v) {
        throw new IllegalStateException("The del() method should be overloaded automatically by the DmcType[VALUE]MV/MAP/SET classes");
    }

    public Iterator<VALUE> getMV() {
        throw new IllegalStateException("The getMV() method should be overloaded automatically by the DmcType[VALUE]MV/MAP/SET classes");
    }

    public int getMVSize() {
        throw new IllegalStateException("The getMVSize() method should be overloaded automatically by the DmcType[VALUE]MV/MAP/SET classes");
    }

    public VALUE getMVnth(int index) {
        throw new IllegalStateException("The getMVnth() method should be overloaded automatically by the DmcType[VALUE]MV class");
    }

    public VALUE setMVnth(int index, Object value) throws DmcValueException {
        throw new IllegalStateException("The setMVnth() method should be overloaded automatically by the DmcType[VALUE]MV class");
    }

    public VALUE getByKey(Object key) {
        throw new IllegalStateException("The getByKey() method should be overloaded automatically by the DmcType[VALUE]MAP class");
    }

    public boolean contains(Object obj) {
        throw new IllegalStateException("The contains() method should be overloaded automatically by the DmcType[VALUE]MV/MAP/SET classes");
    }

    public boolean containsKey(Object key) {
        throw new IllegalStateException("The containsKey() method should be overloaded automatically by the DmcType[VALUE]MAP classes");
    }

    public boolean hasValue() {
        throw new IllegalStateException("The hasValue() method should be overloaded automatically by the DmcType[VALUE]MV classes");
    }

    public abstract DmcAttribute<VALUE> cloneIt();

    public void serializeIt(DmcOutputStreamIF dos) throws Exception {
        block6: {
            block7: {
                block5: {
                    if (this.attrInfo == null) {
                        this.attrInfo = DmcOmni.instance().getInfo(this.ID);
                        if (this.attrInfo == null) {
                            throw new IllegalStateException("This attribute cannot be serialized because its DmcAttributeInfo is not available. ID = " + this.ID);
                        }
                    }
                    dos.writeAttributeID(this.attrInfo);
                    if (this.getMVSize() != 0) break block5;
                    this.serializeValue(dos, this.getSV());
                    break block6;
                }
                dos.writeValueCount(this.getMVSize());
                if (this.attrInfo.indexSize != 0) break block7;
                Iterator<VALUE> iterator = this.getMV();
                if (iterator == null) break block6;
                while (iterator.hasNext()) {
                    this.serializeValue(dos, iterator.next());
                }
                break block6;
            }
            for (int index = 0; index < this.getMVSize(); ++index) {
                VALUE value = this.getMVnth(index);
                if (value == null) {
                    dos.writeInt(-1);
                    continue;
                }
                dos.writeInt(index);
                this.serializeValue(dos, value);
            }
        }
    }

    public void deserializeIt(DmcInputStreamIF dis) throws Exception {
        switch (this.attrInfo.valueType) {
            case SINGLE: {
                this.set(this.deserializeValue(dis));
                break;
            }
            case MULTI: 
            case HASHMAPPED: 
            case TREEMAPPED: 
            case HASHSET: 
            case TREESET: {
                int size = dis.readValueCount();
                if (this.attrInfo.indexSize == 0) {
                    for (int i = 0; i < size; ++i) {
                        this.add(this.deserializeValue(dis));
                    }
                } else {
                    for (int i = 0; i < size; ++i) {
                        int index = dis.readInt();
                        if (index == -1) continue;
                        VALUE value = this.deserializeValue(dis);
                        this.setMVnth(index, value);
                    }
                }
                break;
            }
        }
    }

    protected String formatValue(VALUE value) {
        return value.toString();
    }

    public void toOIF(StringBuffer sb) {
        String name = "???";
        if (this.attrInfo == null) {
            this.attrInfo = DmcOmni.instance().getInfo(this.ID);
            if (this.attrInfo != null) {
                name = this.attrInfo.name;
            }
        } else {
            name = this.attrInfo.name;
        }
        if (this.getMVSize() == 0) {
            if (this.getSV() instanceof DmcObject) {
                sb.append("\n{\n" + ((DmcObject)this.getSV()).toOIF() + "}\n");
            } else if (this.getSV() instanceof DmcExtendedReferenceIF) {
                sb.append(name + " " + this.formatValue(this.getSV()) + "\n");
            } else if (this.getSV() instanceof DmcNamedObjectIF) {
                sb.append(name + " " + ((DmcNamedObjectIF)this.getSV()).getObjectName() + "\n");
            } else {
                sb.append(name + " " + this.formatValue(this.getSV()) + "\n");
            }
        } else {
            Iterator<VALUE> iterator = this.getMV();
            if (iterator != null) {
                boolean first = true;
                int dmoCount = 0;
                if (this.attrInfo != null && this.attrInfo.indexSize > 0) {
                    int index = 0;
                    boolean pad = false;
                    if (this.attrInfo.indexSize > 10) {
                        pad = true;
                    }
                    while (iterator.hasNext()) {
                        VALUE value = iterator.next();
                        String indexstr = "" + index + " ";
                        if (index < 10 && pad) {
                            indexstr = " " + index + " ";
                        }
                        if (value == null) {
                            sb.append(name + " " + indexstr + "\n");
                        } else if (value instanceof DmcObject) {
                            sb.append(" {\n" + ((DmcObject)value).toOIF() + "}\n");
                        } else if (value instanceof DmcExtendedReferenceIF) {
                            sb.append(name + " " + indexstr + this.formatValue(value) + "\n");
                        } else if (value instanceof DmcNamedObjectIF) {
                            sb.append(name + " " + indexstr + ((DmcNamedObjectIF)value).getObjectName() + "\n");
                        } else {
                            sb.append(name + " " + indexstr + this.formatValue(value) + "\n");
                        }
                        ++index;
                    }
                } else {
                    while (iterator.hasNext()) {
                        VALUE value = iterator.next();
                        if (value instanceof DmcObject) {
                            ++dmoCount;
                            if (first) {
                                sb.append("[\n");
                                first = false;
                            }
                            sb.append("{\n" + ((DmcObject)value).toOIF() + "}\n");
                            continue;
                        }
                        if (value instanceof DmcExtendedReferenceIF) {
                            sb.append(name + " " + this.formatValue(value) + "\n");
                            continue;
                        }
                        if (value instanceof DmcNamedObjectIF) {
                            sb.append(name + " " + ((DmcNamedObjectIF)value).getObjectName() + "\n");
                            continue;
                        }
                        sb.append(name + " " + this.formatValue(value) + "\n");
                    }
                    if (dmoCount > 0) {
                        sb.append("]\n");
                    }
                }
            }
        }
    }

    public void toOIF(StringBuffer sb, int padding) {
        String name = "???";
        if (this.attrInfo == null) {
            this.attrInfo = DmcOmni.instance().getInfo(this.ID);
            if (this.attrInfo != null) {
                name = this.attrInfo.name;
            }
        } else {
            name = this.attrInfo.name;
        }
        if (this.getMVSize() == 0) {
            if (this.getSV() instanceof DmcObject) {
                sb.append(name + "\n{\n" + ((DmcObject)this.getSV()).toOIF() + "}\n");
            } else if (this.getSV() instanceof DmcNamedObjectIF && !(this.getSV() instanceof DmcExtendedReferenceIF)) {
                this.addNameWithPadding(name, padding, sb);
                sb.append(" " + ((DmcNamedObjectIF)this.getSV()).getObjectName() + "\n");
            } else if (this.getSV() instanceof DmcAttribute) {
                DmcAttribute da = (DmcAttribute)this.getSV();
                if (da.getMVSize() == 0) {
                    this.addNameWithPadding(name, padding, sb);
                    sb.append(" " + da.getName() + " " + da.getSV().toString() + "\n");
                } else {
                    Iterator<VALUE> iterator = da.getMV();
                    if (iterator != null) {
                        while (iterator.hasNext()) {
                            VALUE obj = iterator.next();
                            this.addNameWithPadding(name, padding, sb);
                            sb.append(" " + da.getName() + " " + obj.toString() + "\n");
                        }
                    }
                }
            } else {
                this.addNameWithPadding(name, padding, sb);
                sb.append(" " + this.formatValue(this.getSV()) + "\n");
            }
        } else {
            Iterator<VALUE> iterator = this.getMV();
            if (iterator != null) {
                boolean first = true;
                int dmoCount = 0;
                if (this.attrInfo != null && this.attrInfo.indexSize > 0) {
                    int index = 0;
                    boolean pad = false;
                    if (this.attrInfo.indexSize > 10) {
                        pad = true;
                    }
                    while (iterator.hasNext()) {
                        VALUE value = iterator.next();
                        String indexstr = "" + index + " ";
                        if (index < 10 && pad) {
                            indexstr = " " + index + " ";
                        }
                        if (value == null) {
                            this.addNameWithPadding(name, padding, sb);
                            sb.append(indexstr + "\n");
                        } else if (value instanceof DmcObject) {
                            this.addNameWithPadding(name, padding, sb);
                            sb.append(indexstr);
                            sb.append(" {\n" + ((DmcObject)value).toOIF() + "}\n");
                        } else {
                            this.addNameWithPadding(name, padding, sb);
                            sb.append(indexstr);
                            if (value instanceof DmcExtendedReferenceIF) {
                                sb.append(" " + this.formatValue(value) + "\n");
                            } else if (value instanceof DmcNamedObjectIF) {
                                sb.append(" " + ((DmcNamedObjectIF)value).getObjectName() + "\n");
                            } else {
                                sb.append(" " + this.formatValue(value) + "\n");
                            }
                        }
                        ++index;
                    }
                } else {
                    while (iterator.hasNext()) {
                        VALUE value = iterator.next();
                        if (value instanceof DmcObject) {
                            ++dmoCount;
                            if (first) {
                                this.addNameWithPadding(name, padding, sb);
                                sb.append("\n[\n");
                                first = false;
                            }
                            sb.append("{\n" + ((DmcObject)value).toOIF() + "}\n");
                            continue;
                        }
                        this.addNameWithPadding(name, padding, sb);
                        if (value instanceof DmcExtendedReferenceIF) {
                            sb.append(" " + this.formatValue(value) + "\n");
                            continue;
                        }
                        if (value instanceof DmcNamedObjectIF) {
                            sb.append(" " + ((DmcNamedObjectIF)value).getObjectName() + "\n");
                            continue;
                        }
                        sb.append(" " + this.formatValue(value) + "\n");
                    }
                    if (dmoCount > 0) {
                        sb.append("]\n");
                    }
                }
            }
        }
    }

    private void addNameWithPadding(String attrName, int padding, StringBuffer sb) {
        sb.append(attrName);
        if (attrName.length() < padding) {
            for (int i = attrName.length(); i < padding; ++i) {
                sb.append(" ");
            }
        }
    }

    public String modifierFormat() {
        String rc;
        block6: {
            block7: {
                block5: {
                    rc = null;
                    if (this.getMVSize() != 0) break block5;
                    rc = this.getSV() instanceof DmcExtendedReferenceIF ? "" + this.getSV() : (this.getSV() instanceof DmcNamedObjectIF ? "" + ((DmcNamedObjectIF)this.getSV()).getObjectName() : "" + this.getSV());
                    break block6;
                }
                if (this.attrInfo.indexSize != 0) break block7;
                if (this.getMVSize() > 1) {
                    throw new IllegalStateException("Multiple values in an attribute used by  a Modifier.");
                }
                Iterator<VALUE> iterator = this.getMV();
                if (iterator == null) break block6;
                while (iterator.hasNext()) {
                    VALUE value = iterator.next();
                    if (value instanceof DmcExtendedReferenceIF) {
                        rc = "" + value;
                        continue;
                    }
                    if (value instanceof DmcNamedObjectIF) {
                        rc = "" + ((DmcNamedObjectIF)value).getObjectName();
                        continue;
                    }
                    rc = "" + value;
                }
                break block6;
            }
            for (int index = 0; index < this.getMVSize(); ++index) {
                VALUE value = this.getMVnth(index);
                if (value == null) continue;
                rc = value instanceof DmcExtendedReferenceIF ? "" + value : (value instanceof DmcNamedObjectIF ? "" + ((DmcNamedObjectIF)value).getObjectName() : "" + value);
            }
        }
        return rc;
    }

    protected void addModsSV(DmcTypeModifierMV mods, DmcAttribute<?> existingValue, DmcAdapterIF adapter) {
        try {
            if (existingValue == null) {
                if (adapter.hasValue()) {
                    mods.add(new Modifier(ModifyTypeEnum.SET, this.cloneIt()));
                }
            } else if (!adapter.hasValue()) {
                mods.add(new Modifier(ModifyTypeEnum.REM, this.attrInfo));
            } else {
                mods.add(new Modifier(ModifyTypeEnum.SET, this.cloneIt()));
            }
        }
        catch (DmcValueException e) {
            throw new IllegalStateException("Changes to the Modifier shouldn't throw an exception.", e);
        }
    }

    protected boolean valueChangedSV(DmcAttribute<?> existingValue, DmcAdapterIF adapter) {
        boolean rc = false;
        if (existingValue == null) {
            if (adapter.hasValue()) {
                rc = true;
            }
        } else if (!adapter.hasValue()) {
            rc = true;
        } else if (!existingValue.getSV().toString().equals(adapter.getValue().toString())) {
            rc = true;
        }
        return rc;
    }

    protected void addModsMV(DmcTypeModifierMV mods, DmcAttribute<?> existingValue, DmcAdapterIF adapter) {
        try {
            if (existingValue == null) {
                if (adapter.hasValue()) {
                    if (this.attrInfo.indexSize == 0) {
                        Iterator<VALUE> it = this.getMV();
                        while (it.hasNext()) {
                            VALUE current = it.next();
                            DmcAttribute<?> mod = this.getNew();
                            mod.add(current);
                            mods.add(new Modifier(ModifyTypeEnum.ADD, mod));
                        }
                    } else {
                        for (int index = 0; index < this.getMVSize(); ++index) {
                            if (this.getMVnth(index) == null) continue;
                            DmcAttribute<?> mod = this.getNew();
                            mod.setMVnth(index, this.getMVnth(index));
                            mods.add(new Modifier(ModifyTypeEnum.NTH, mod, index));
                        }
                    }
                }
            } else if (!adapter.hasValue()) {
                mods.add(new Modifier(ModifyTypeEnum.REM, this.attrInfo));
            } else if (this.attrInfo.indexSize == 0) {
                Iterator<?> eit = existingValue.getMV();
                while (eit.hasNext()) {
                    Object current = eit.next();
                    if (this.contains(current)) continue;
                    DmcAttribute<?> mod = this.getNew();
                    mod.add(current);
                    mods.add(new Modifier(ModifyTypeEnum.DEL, mod));
                }
                Iterator<VALUE> it = this.getMV();
                while (it.hasNext()) {
                    VALUE current = it.next();
                    if (existingValue.contains(current)) continue;
                    DmcAttribute<?> mod = this.getNew();
                    mod.add(current);
                    mods.add(new Modifier(ModifyTypeEnum.ADD, mod));
                }
            } else {
                for (int index = 0; index < this.getMVSize(); ++index) {
                    Object existing = existingValue.getMVnth(index);
                    VALUE current = this.getMVnth(index);
                    boolean replace = false;
                    if (existing == null) {
                        if (current != null) {
                            replace = true;
                        }
                    } else if (current == null) {
                        replace = true;
                    } else if (!existing.equals(current)) {
                        replace = true;
                    }
                    if (!replace) continue;
                    DmcAttribute<?> mod = this.getNew();
                    mod.setMVnth(index, current);
                    mods.add(new Modifier(ModifyTypeEnum.NTH, mod, index));
                }
            }
        }
        catch (DmcValueException e) {
            throw new IllegalStateException("Changes to the Modifier shouldn't throw an exception.", e);
        }
    }

    protected boolean valueChangedMV(DmcAttribute<?> existingValue, DmcAdapterIF adapter) {
        boolean rc;
        block10: {
            block11: {
                rc = false;
                if (existingValue != null) break block11;
                if (!adapter.hasValue()) break block10;
                rc = true;
                break block10;
            }
            if (!adapter.hasValue()) {
                rc = true;
            } else if (this.attrInfo.indexSize == 0) {
                if (existingValue.getMVSize() != this.getMVSize()) {
                    rc = true;
                } else {
                    Iterator<VALUE> iterator = this.getMV();
                    while (iterator.hasNext()) {
                        VALUE val = iterator.next();
                        if (existingValue.contains(val)) continue;
                        rc = true;
                        break;
                    }
                }
            } else {
                for (int i = 0; i < this.attrInfo.indexSize; ++i) {
                    Object existing = existingValue.getMVnth(i);
                    VALUE current = this.getMVnth(i);
                    if (existing == null) {
                        if (current == null) continue;
                        rc = true;
                        break;
                    }
                    if (current == null) {
                        rc = true;
                        break;
                    }
                    if (existing.equals(current)) continue;
                    rc = true;
                }
            }
        }
        return rc;
    }

    void toJSON(StringBuffer sb, int padding, String indent) {
        sb.append(indent);
        this.addJSONNameWithPadding(this, sb, padding);
        if (this.getMVSize() == 0) {
            this.formatValueAsJSON(sb, padding, indent + "  ");
        } else {
            sb.append("[\n");
            this.formatValueAsJSON(sb, padding, indent + "  ");
            sb.append("\n" + indent + "]");
        }
    }

    void toCompactJSON(StringBuffer sb) {
        String name = "???";
        if (this.attrInfo == null) {
            this.attrInfo = DmcOmni.instance().getInfo(this.ID);
            if (this.attrInfo != null) {
                name = this.attrInfo.name;
            }
        } else {
            name = this.attrInfo.name;
        }
        sb.append("\"" + name + "\":");
        if (this.getMVSize() == 0) {
            this.formatValueAsCompactJSON(sb);
        } else {
            sb.append("[");
            this.formatValueAsCompactJSON(sb);
            sb.append("]");
        }
    }

    protected void formatValueAsJSON(StringBuffer sb, int padding, String indent) {
        if (this.getMVSize() == 0) {
            String value = this.getSV().toString();
            if (value.contains("\\")) {
                value = value.replace("\\", "\\\\");
            }
            if (value.contains("\\\\n")) {
                value = value.replace("\\\\n", "\\n");
            }
            if (value.contains("\t")) {
                value = value.replace("\t", "\\t");
            }
            if (value.contains("\"")) {
                value = value.replace("\"", "\\\"");
            }
            if (this.attrInfo.isNumericOrBoolean()) {
                sb.append(value);
            } else {
                sb.append("\"" + value + "\"");
            }
        } else {
            Iterator<VALUE> it = this.getMV();
            while (it.hasNext()) {
                VALUE jvalue = it.next();
                String value = jvalue.toString();
                if (value.contains("\\")) {
                    value = value.replace("\\", "\\\\");
                }
                if (value.contains("\\\\n")) {
                    value = value.replace("\\\\n", "\\n");
                }
                if (value.contains("\t")) {
                    value = value.replace("\t", "\\t");
                }
                if (value.contains("\"")) {
                    value = value.replace("\"", "\\\"");
                }
                if (this.attrInfo.isNumericOrBoolean()) {
                    sb.append(indent + "  " + value);
                } else {
                    sb.append(indent + "  \"" + value + "\"");
                }
                if (!it.hasNext()) continue;
                sb.append(", \n");
            }
        }
    }

    protected void formatValueAsCompactJSON(StringBuffer sb) {
        if (this.getMVSize() == 0) {
            sb.append("\"" + this.getSV().toString().replace("\"", "\\\"") + "\"");
        } else {
            int max = this.getMVSize() - 1;
            for (int i = 0; i < this.getMVSize(); ++i) {
                sb.append("\"" + this.getMVnth(i).toString().replace("\"", "\\\"") + "\"");
                if (i >= max) continue;
                sb.append(",");
            }
        }
    }

    private void addJSONNameWithPadding(DmcAttribute<?> attr, StringBuffer sb, int padding) {
        sb.append("\"" + attr.getName() + "\": ");
        if (this.getMVSize() > 0) {
            return;
        }
        if (attr.getName().length() < padding) {
            for (int i = attr.getName().length(); i < padding; ++i) {
                sb.append(" ");
            }
        }
    }
}

