/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmc;

import java.util.TreeSet;
import org.dmd.dmc.types.DotName;
import org.dmd.dms.generated.enums.DataTypeEnum;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcAttributeInfo
implements Comparable<DmcAttributeInfo> {
    private static final String BOOLEAN = "Boolean";
    private static final String INTEGER = "Integer";
    private static final String LONG = "Long";
    private static final String SHORT = "Short";
    private static final String FLOAT = "Float";
    private static final String DOUBLE = "Double";
    public final DotName qualifiedName;
    public final String name;
    public final int id;
    public final String type;
    public final ValueTypeEnum valueType;
    public final DataTypeEnum dataType;
    public final int indexSize;
    public final boolean weakReference;
    public final boolean numericOrBoolean;
    private static TreeSet<String> numericOrBooleanTypeNames = new TreeSet();

    public DmcAttributeInfo(String n, int i, String t, ValueTypeEnum at, DataTypeEnum dte) {
        this.qualifiedName = new DotName("NOT_SET", n);
        this.name = n;
        this.id = i;
        this.type = t;
        this.valueType = at;
        this.dataType = dte;
        this.indexSize = 0;
        this.weakReference = false;
        this.numericOrBoolean = numericOrBooleanTypeNames.contains(this.type);
    }

    public DmcAttributeInfo(String n, int i, String t, ValueTypeEnum at, DataTypeEnum dte, int is, boolean wr) {
        this.qualifiedName = new DotName("NOT_SET", n);
        this.name = n;
        this.id = i;
        this.type = t;
        this.valueType = at;
        this.dataType = dte;
        this.indexSize = is;
        this.weakReference = wr;
        this.numericOrBoolean = numericOrBooleanTypeNames.contains(this.type);
    }

    public DmcAttributeInfo(String schema, String n, int i, String t, ValueTypeEnum at, DataTypeEnum dte) {
        this.qualifiedName = new DotName(schema, n);
        this.name = n;
        this.id = i;
        this.type = t;
        this.valueType = at;
        this.dataType = dte;
        this.indexSize = 0;
        this.weakReference = false;
        this.numericOrBoolean = numericOrBooleanTypeNames.contains(this.type);
    }

    public DmcAttributeInfo(String schema, String n, int i, String t, ValueTypeEnum at, DataTypeEnum dte, int is) {
        this.qualifiedName = new DotName(schema, n);
        this.name = n;
        this.id = i;
        this.type = t;
        this.valueType = at;
        this.dataType = dte;
        this.indexSize = is;
        this.weakReference = false;
        this.numericOrBoolean = numericOrBooleanTypeNames.contains(this.type);
    }

    public DmcAttributeInfo(String schema, String n, int i, String t, ValueTypeEnum at, DataTypeEnum dte, int is, boolean wr) {
        this.qualifiedName = new DotName(schema, n);
        this.name = n;
        this.id = i;
        this.type = t;
        this.valueType = at;
        this.dataType = dte;
        this.indexSize = is;
        this.weakReference = wr;
        this.numericOrBoolean = numericOrBooleanTypeNames.contains(this.type);
    }

    public boolean isNumericOrBoolean() {
        return this.numericOrBoolean;
    }

    public String toString() {
        return this.qualifiedName + " " + this.name + " " + this.id + " " + this.type + " " + (Object)((Object)this.valueType) + " " + (Object)((Object)this.dataType) + " index: " + this.indexSize + " weak: " + this.weakReference;
    }

    @Override
    public int compareTo(DmcAttributeInfo dai) {
        if (this.id == dai.id) {
            return 0;
        }
        if (this.id < dai.id) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object obj) {
        return obj instanceof DmcAttributeInfo && this.id == ((DmcAttributeInfo)obj).id;
    }

    public int hashCode() {
        return this.id;
    }

    static {
        numericOrBooleanTypeNames.add(BOOLEAN);
        numericOrBooleanTypeNames.add(INTEGER);
        numericOrBooleanTypeNames.add(LONG);
        numericOrBooleanTypeNames.add(SHORT);
        numericOrBooleanTypeNames.add(FLOAT);
        numericOrBooleanTypeNames.add(DOUBLE);
    }
}

