/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmc;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcAttributeInfoRef;
import org.dmd.dms.generated.enums.ClassTypeEnum;
import org.dmd.dms.generated.enums.DataTypeEnum;

public class DmcClassInfo
implements Comparable<DmcClassInfo> {
    public final String name;
    public final String dmoImport;
    public final int id;
    public final ClassTypeEnum classType;
    public final DataTypeEnum dataType;
    public final DmcClassInfo derivedFrom;
    final TreeMap<Integer, DmcAttributeInfoRef> byID;
    final TreeMap<String, DmcAttributeInfoRef> byName;
    public final DmcAttributeInfo nameAttribute;
    transient TreeMap<String, DmcClassInfo> derivedClasses;

    public DmcClassInfo(String n, String di, int i, ClassTypeEnum ct, DataTypeEnum dt, DmcClassInfo bc, DmcAttributeInfo na) {
        this.name = n;
        this.dmoImport = di;
        this.id = i;
        this.classType = ct;
        this.dataType = dt;
        this.derivedFrom = bc;
        this.byID = new TreeMap();
        this.byName = new TreeMap();
        this.nameAttribute = na;
        this.derivedClasses = null;
    }

    public DmcClassInfo(String n, int i, ClassTypeEnum ct, DataTypeEnum dt, DmcClassInfo bc, DmcAttributeInfo na) {
        this.name = n;
        this.dmoImport = null;
        this.id = i;
        this.classType = ct;
        this.dataType = dt;
        this.derivedFrom = bc;
        this.byID = new TreeMap();
        this.byName = new TreeMap();
        this.nameAttribute = na;
        this.derivedClasses = null;
    }

    public void addMust(DmcAttributeInfo info) {
        DmcAttributeInfoRef air = new DmcAttributeInfoRef(info, true);
        this.byID.put(info.id, air);
        this.byName.put(info.name, air);
    }

    public void addMay(DmcAttributeInfo info) {
        DmcAttributeInfoRef air = new DmcAttributeInfoRef(info, false);
        this.byID.put(info.id, air);
        this.byName.put(info.name, air);
    }

    public Map<Integer, DmcAttributeInfoRef> getIdToAttr() {
        return this.byID;
    }

    public boolean isOptional(DmcAttributeInfo ai) {
        DmcAttributeInfoRef existing = this.byID.get(ai.id);
        if (existing == null) {
            return true;
        }
        return !existing.mandatory;
    }

    public boolean allowsAttribute(DmcAttributeInfo ai) {
        boolean rc = true;
        if (this.byID.get(ai.id) == null) {
            rc = this.derivedFrom == null ? false : this.derivedFrom.allowsAttribute(ai);
        }
        return rc;
    }

    public DmcAttributeInfo allowsAttribute(Integer id) {
        DmcAttributeInfo rc = null;
        DmcAttributeInfoRef air = this.byID.get(id);
        if (air == null) {
            if (this.derivedFrom != null) {
                rc = this.derivedFrom.allowsAttribute(id);
            }
        } else {
            rc = air.info;
        }
        return rc;
    }

    public DmcAttributeInfo getAttributeInfo(String an) {
        DmcAttributeInfoRef air = this.byName.get(an);
        if (air == null) {
            if (this.derivedFrom != null) {
                return this.derivedFrom.getAttributeInfo(an);
            }
            return null;
        }
        return air.info;
    }

    public boolean isInstanceOf(int otherID) {
        boolean rc = false;
        if (this.id == otherID) {
            rc = true;
        } else if (this.derivedFrom != null) {
            rc = this.derivedFrom.isInstanceOf(otherID);
        }
        return rc;
    }

    public boolean isInstanceOf(String className) {
        boolean rc = false;
        if (this.name.equals(className)) {
            rc = true;
        } else if (this.derivedFrom != null) {
            rc = this.derivedFrom.isInstanceOf(className);
        }
        return rc;
    }

    public String toString() {
        return this.name + " " + this.id + " " + (Object)((Object)this.classType) + " " + (Object)((Object)this.dataType);
    }

    @Override
    public int compareTo(DmcClassInfo dci) {
        if (this.id == dci.id) {
            return 0;
        }
        if (this.id < dci.id) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object obj) {
        return obj instanceof DmcClassInfo && this.id == ((DmcClassInfo)obj).id;
    }

    public int hashCode() {
        return this.id;
    }

    void addDerivedClass(DmcClassInfo ci) {
        if (this.derivedClasses == null) {
            this.derivedClasses = new TreeMap();
        }
        this.derivedClasses.put(ci.name, ci);
    }

    public Iterator<DmcClassInfo> getDerivedClasses() {
        if (this.derivedClasses != null) {
            return this.derivedClasses.values().iterator();
        }
        return null;
    }
}

