/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcAttributeValidator;
import org.dmd.dmc.DmcClassInfo;
import org.dmd.dmc.DmcContainerIF;
import org.dmd.dmc.DmcExtendedReferenceIF;
import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.DmcMappedAttributeIF;
import org.dmd.dmc.DmcNameClashResolverIF;
import org.dmd.dmc.DmcNameResolverIF;
import org.dmd.dmc.DmcNameResolverWithClashSupportIF;
import org.dmd.dmc.DmcNamedObjectIF;
import org.dmd.dmc.DmcNamedObjectREF;
import org.dmd.dmc.DmcObjectValidator;
import org.dmd.dmc.DmcOmni;
import org.dmd.dmc.DmcOutputStreamIF;
import org.dmd.dmc.DmcSliceInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.DmcValueExceptionSet;
import org.dmd.dmc.types.DefinitionName;
import org.dmd.dmc.types.DmcTypeComplexTypeWithRefs;
import org.dmd.dmc.types.DmcTypeModifier;
import org.dmd.dmc.types.DmcTypeNamedObjectREF;
import org.dmd.dmc.types.Modifier;
import org.dmd.dms.generated.dmo.ClassDefinitionDMO;
import org.dmd.dms.generated.enums.ClassTypeEnum;
import org.dmd.dms.generated.enums.DataTypeEnum;
import org.dmd.dms.generated.enums.ModifyTypeEnum;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dms.generated.types.ClassDefinitionREF;
import org.dmd.dms.generated.types.DmcTypeClassDefinitionREFMV;
import org.dmd.dms.generated.types.DmcTypeModifierMV;

public abstract class DmcObject
implements Serializable {
    static final int CONTAINER = 0;
    static final int BACKREFS = 1;
    static final int MODIFIER = 2;
    static final int LASTVAL = 3;
    static final int MODREC = 4;
    static final int STAGING = 5;
    static final int CONTAINER_SIZE = 1;
    static final int BACKREFS_SIZE = 2;
    static final int MODIFIER_SIZE = 3;
    static final int LASTVAL_SIZE = 4;
    static final int MODREC_SIZE = 5;
    static final int STAGING_SIZE = 6;
    public static final DmcAttributeInfo __objectClass = new DmcAttributeInfo("meta", "objectClass", 1, "ClassDefinition", ValueTypeEnum.MULTI, DataTypeEnum.PERSISTENT);
    protected Map<Integer, DmcAttribute<?>> attributes = new HashMap();
    transient Vector<Object> info = null;

    public DmcObject() {
    }

    protected DmcObject(String oc) {
        DmcTypeClassDefinitionREFMV attr = new DmcTypeClassDefinitionREFMV(__objectClass);
        try {
            ((DmcAttribute)attr).add(new DefinitionName(oc));
            this.add(__objectClass, attr);
        }
        catch (DmcValueException e) {
            throw new IllegalStateException("Setting the objectClass using a String shouldn't ever croak!", e);
        }
    }

    public int numberOfAttributes() {
        return this.attributes.size() - 1;
    }

    public Iterator<ClassDefinitionREF> getObjectClass() {
        DmcTypeClassDefinitionREFMV objClass = (DmcTypeClassDefinitionREFMV)this.attributes.get(DmcObject.__objectClass.id);
        if (objClass == null) {
            throw new IllegalStateException("A DMO shouldn't exist without its objClass attribute!");
        }
        return objClass.getMV();
    }

    public ClassDefinitionREF getConstructionClass() {
        DmcTypeClassDefinitionREFMV objClass = (DmcTypeClassDefinitionREFMV)this.attributes.get(DmcObject.__objectClass.id);
        if (objClass == null) {
            throw new IllegalStateException("A DMO shouldn't exist without its objClass attribute!");
        }
        return objClass.getMVnth(0);
    }

    public DmcClassInfo getConstructionClassInfo() {
        return this.getConstructionClass().getClassInfo();
    }

    public Iterator<DmcAttribute<?>> getAttributeIterator() {
        return this.attributes.values().iterator();
    }

    public boolean supportsBackrefTracking() {
        return true;
    }

    public boolean allowsAttribute(DmcAttributeInfo ai) {
        boolean rc = false;
        if (ai.id == DmcObject.__objectClass.id) {
            return true;
        }
        DmcTypeClassDefinitionREFMV objClass = (DmcTypeClassDefinitionREFMV)this.attributes.get(DmcObject.__objectClass.id);
        for (int i = 0; i < objClass.getMVSize(); ++i) {
            if (!objClass.getMVnth(i).getClassInfo().allowsAttribute(ai)) continue;
            rc = true;
            break;
        }
        return rc;
    }

    public abstract DmcObject getNew();

    public abstract DmcObject getSlice(DmcSliceInfo var1);

    protected Map<Integer, HashMap<String, DmcAttributeValidator>> getAttributeValidators() {
        throw new IllegalStateException("getAttributeValidators() must be overriden in the DMO");
    }

    protected Map<String, DmcObjectValidator> getObjectValidators() {
        throw new IllegalStateException("getObjectValidators() must be overriden in the DMO");
    }

    public void setContainer(DmcContainerIF c) {
        if (this.isStaging().booleanValue()) {
            throw new IllegalStateException("You can't call setContainer() on a STAGING object.");
        }
        this.setInfo(0, 1, c);
    }

    public DmcContainerIF getContainer() {
        return (DmcContainerIF)this.getInfo(0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBackref(Modifier mod) {
        if (this.isStaging().booleanValue()) {
            throw new IllegalStateException("You can't call addBackref() on a STAGING object.");
        }
        Map<Integer, DmcAttribute<?>> map = this.attributes;
        synchronized (map) {
            if (this.getBackref() == null) {
                this.setInfo(1, 2, new DmcTypeModifierMV());
            }
            try {
                this.getBackref().add(mod);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Backref modifier shouldn't throw exceptions.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReferenced() {
        Map<Integer, DmcAttribute<?>> map = this.attributes;
        synchronized (map) {
            if (this.getBackref() == null) {
                return false;
            }
            return this.getBackref().getMVSize() > 0;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int referenceCount() {
        Map<Integer, DmcAttribute<?>> map = this.attributes;
        synchronized (map) {
            if (this.getBackref() == null) {
                return 0;
            }
            return this.getBackref().getMVSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBackref(Modifier mod) {
        if (this.isStaging().booleanValue()) {
            throw new IllegalStateException("You can't call removeBackref() on a STAGING object.");
        }
        Map<Integer, DmcAttribute<?>> map = this.attributes;
        synchronized (map) {
            if (this.getBackref() == null) {
                throw new IllegalStateException("Tried to remove backreference from an object with no backrefs.");
            }
            this.getBackref().del(mod);
        }
    }

    public DmcTypeModifierMV getBackref() {
        return (DmcTypeModifierMV)this.getInfo(1, 2);
    }

    public void setModifier(DmcTypeModifierMV m) {
        if (this.isStaging().booleanValue()) {
            throw new IllegalStateException("You can't call setModifier() on a STAGING object.");
        }
        if (m == null) {
            this.shrinkInfo(2);
        } else {
            this.setInfo(2, 3, m);
        }
    }

    public DmcTypeModifierMV getModifier() {
        return (DmcTypeModifierMV)this.getInfo(2, 3);
    }

    protected void setLastValue(Object val) {
        if (this.getModifier() == null && !DmcOmni.instance().backRefTracking()) {
            return;
        }
        this.setInfo(3, 4, val);
    }

    protected Object getLastValue() {
        return this.getInfo(3, 4);
    }

    protected void modrec(Boolean f) {
        this.setInfo(4, 5, f);
    }

    protected Boolean isModrec() {
        Boolean mr = (Boolean)this.getInfo(4, 5);
        if (mr == null) {
            return false;
        }
        return mr;
    }

    protected void staging(Boolean f) {
        this.setInfo(5, 6, f);
    }

    protected Boolean isStaging() {
        Boolean staging = (Boolean)this.getInfo(5, 6);
        if (staging == null) {
            return false;
        }
        return staging;
    }

    void setInfo(int index, int requiredSize, Object value) {
        if (this.info == null) {
            this.info = new Vector(1, 1);
            switch (index) {
                case 4: {
                    this.info.add(null);
                }
                case 3: {
                    this.info.add(null);
                }
                case 2: {
                    this.info.add(null);
                }
                case 1: {
                    this.info.add(null);
                }
                case 0: {
                    this.info.add(null);
                }
                case 5: {
                    this.info.add(null);
                }
            }
        }
        if (this.info.size() < requiredSize) {
            while (this.info.size() < requiredSize) {
                this.info.add(null);
            }
        }
        this.info.set(index, value);
    }

    Object getInfo(int index, int requiredSize) {
        if (this.info == null) {
            return null;
        }
        if (this.info.size() < requiredSize) {
            return null;
        }
        return this.info.get(index);
    }

    void shrinkInfo(int index) {
        Vector<Object> newinfo = null;
        if (index == 2) {
            if (this.info.get(1) == null) {
                if (this.info.get(0) != null) {
                    newinfo = new Vector(1, 1);
                    newinfo.add(this.info.get(0));
                }
            } else {
                newinfo = new Vector<Object>(2, 1);
                newinfo.add(this.info.get(0));
                newinfo.add(this.info.get(1));
            }
        } else if (index == 1) {
            if (this.info.size() > 2) {
                this.info.set(1, null);
            } else if (this.info.get(0) != null) {
                newinfo = new Vector(1, 1);
                newinfo.add(this.info.get(0));
            }
        }
        this.info = newinfo;
        newinfo = null;
    }

    public void youAreDeleted() {
        if (this.isStaging().booleanValue()) {
            throw new IllegalStateException("You can't call youAreDeleted() on a STAGING object.");
        }
        if (DmcOmni.instance().backRefTracking()) {
            DmcTypeModifierMV mods = this.getBackref();
            if (mods != null) {
                DmcOmni.instance().removeReferences(mods);
                Iterator<Modifier> it = mods.getMV();
                while (it.hasNext()) {
                    Modifier mod = it.next();
                    this.removeBackref(mod);
                }
            }
            for (DmcAttribute<?> attr : this.attributes.values()) {
                if (attr.ID == DmcObject.__objectClass.id || !(attr instanceof DmcTypeNamedObjectREF)) continue;
                ((DmcTypeNamedObjectREF)attr).removeBackReferences();
            }
        }
    }

    public DmcAttributeInfo getAttributeInfo(String an) {
        DmcAttributeInfo rc = this.getConstructionClassInfo().getAttributeInfo(an);
        if (rc == null && an.equals(DmcObject.__objectClass.name)) {
            rc = __objectClass;
        }
        if (rc == null) {
            DmcTypeClassDefinitionREFMV objClass = (DmcTypeClassDefinitionREFMV)this.attributes.get(DmcObject.__objectClass.id);
            for (int i = 0; i < objClass.getMVSize() && (rc = objClass.getMVnth(i).getClassInfo().getAttributeInfo(an)) == null; ++i) {
            }
        }
        return rc;
    }

    public DmcAttributeInfo getAttributeInfo(Integer id) {
        DmcAttributeInfo rc = null;
        if (id == DmcObject.__objectClass.id) {
            return __objectClass;
        }
        DmcTypeClassDefinitionREFMV objClass = (DmcTypeClassDefinitionREFMV)this.attributes.get(DmcObject.__objectClass.id);
        for (int i = 0; i < objClass.getMVSize() && (rc = objClass.getMVnth(i).getClassInfo().allowsAttribute(id)) == null; ++i) {
        }
        return rc;
    }

    public String getConstructionClassName() {
        DmcTypeClassDefinitionREFMV ocl = (DmcTypeClassDefinitionREFMV)this.get(DmcObject.__objectClass.id);
        if (ocl != null) {
            ocl.getAttributeInfo();
            if (ocl.getMVSize() > 0) {
                return ocl.getMVnth(0).getObjectName().getNameString();
            }
        }
        return null;
    }

    public String getFullClassName() {
        StringBuffer sb = new StringBuffer();
        DmcTypeClassDefinitionREFMV objClass = (DmcTypeClassDefinitionREFMV)this.attributes.get(DmcObject.__objectClass.id);
        for (int i = 0; i < objClass.getMVSize(); ++i) {
            if (i > 0) {
                sb.append(" " + objClass.getMVnth((int)i).getClassInfo().name);
                continue;
            }
            sb.append(objClass.getMVnth((int)i).getClassInfo().name);
        }
        return null;
    }

    public void addAux(String cd) throws DmcValueException {
        DmcTypeClassDefinitionREFMV ocl = (DmcTypeClassDefinitionREFMV)this.get(DmcObject.__objectClass.id);
        if (ocl != null) {
            ocl.add(cd);
        }
    }

    public void addAux(ClassDefinitionREF cd) throws DmcValueException {
        DmcTypeClassDefinitionREFMV ocl = (DmcTypeClassDefinitionREFMV)this.get(DmcObject.__objectClass.id);
        if (ocl != null) {
            ocl.add(cd);
        }
    }

    public void removeAux(String cd) {
        DmcTypeClassDefinitionREFMV ocl = (DmcTypeClassDefinitionREFMV)this.get(DmcObject.__objectClass.id);
        if (ocl != null) {
            ocl.del(cd);
        }
    }

    public boolean hasAux(String cd) {
        DmcTypeClassDefinitionREFMV ocl = (DmcTypeClassDefinitionREFMV)this.get(DmcObject.__objectClass.id);
        if (ocl == null) {
            return false;
        }
        return ocl.contains(cd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DmcAttribute<?> get(String name) {
        Map<Integer, DmcAttribute<?>> map = this.attributes;
        synchronized (map) {
            DmcAttributeInfo ai = this.getAttributeInfo(name);
            if (ai == null) {
                return null;
            }
            return this.attributes.get(ai.id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DmcAttribute<?> get(Integer id) {
        Map<Integer, DmcAttribute<?>> map = this.attributes;
        synchronized (map) {
            return this.attributes.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DmcAttribute<?> get(DmcAttributeInfo ai) {
        Map<Integer, DmcAttribute<?>> map = this.attributes;
        synchronized (map) {
            DmcAttribute<?> rc = this.attributes.get(ai.id);
            if (rc != null && rc.getAttributeInfo() == null) {
                rc.setAttributeInfo(ai);
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasValue(DmcAttributeInfo ai) {
        Map<Integer, DmcAttribute<?>> map = this.attributes;
        synchronized (map) {
            DmcAttribute<?> rc = this.attributes.get(ai.id);
            return rc != null;
            {
            }
        }
    }

    public ArrayList<String> getAttributeNames(boolean onlySV) {
        ArrayList<String> names = new ArrayList<String>();
        for (DmcAttribute<?> attr : this.attributes.values()) {
            if (onlySV) {
                if (attr.getAttributeInfo().valueType != ValueTypeEnum.SINGLE) continue;
                names.add(attr.getName());
                continue;
            }
            names.add(attr.getName());
        }
        return names;
    }

    public Map<Integer, DmcAttribute<?>> getAttributes() {
        return this.attributes;
    }

    public <T extends DmcAttribute<?>> T set(String attrName, DmcAttribute<?> attr) throws DmcValueException {
        DmcAttributeInfo ai = this.getAttributeInfo(attrName);
        if (ai == null) {
            DmcValueException dve = new DmcValueException("Invalid attribute: " + attrName + " for class: " + this.getClass().getName());
            throw dve;
        }
        return this.set(ai, attr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends DmcAttribute<?>> T set(DmcAttributeInfo ai, DmcAttribute<?> attr) throws DmcValueException {
        Map<Integer, DmcAttribute<?>> map = this.attributes;
        synchronized (map) {
            DmcAttribute<?> existing = this.attributes.get(ai.id);
            if (existing == null) {
                this.attributes.put(ai.id, attr);
                attr.setAttributeInfo(ai);
            }
            if (this.getModifier() == null) {
                DmcObject obj;
                if (this.supportsBackrefTracking() && !this.isStaging().booleanValue() && DmcOmni.instance().backRefTracking() && DmcOmni.instance().trackThisAttribute(attr.ID) && attr instanceof DmcTypeNamedObjectREF && (obj = (DmcObject)((DmcNamedObjectREF)attr.getSV()).getObject()) != null) {
                    Modifier backrefMod = new Modifier(ModifyTypeEnum.SET, attr, this);
                    obj.addBackref(backrefMod);
                    ((DmcNamedObjectREF)attr.getSV()).setBackrefModifier(backrefMod);
                }
            } else {
                this.getModifier().add(new Modifier(ModifyTypeEnum.SET, attr));
            }
            return (T)attr;
        }
    }

    public <T extends DmcAttribute<?>> T add(String attrName, DmcAttribute<?> attr) throws DmcValueException {
        DmcAttributeInfo ai = this.getAttributeInfo(attrName);
        if (ai == null) {
            DmcValueException dve = new DmcValueException("Invalid attribute: " + attrName + " for class: " + this.getClass().getName());
            throw dve;
        }
        return this.add(ai, attr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends DmcAttribute<?>> T add(DmcAttributeInfo ai, DmcAttribute<?> attr) throws DmcValueException {
        Map<Integer, DmcAttribute<?>> map = this.attributes;
        synchronized (map) {
            DmcObject obj;
            DmcAttribute<?> existing = this.attributes.get(ai.id);
            if (existing == null) {
                this.attributes.put(ai.id, attr);
                attr.setAttributeInfo(ai);
            }
            if (!this.isModrec().booleanValue() && this.supportsBackrefTracking() && !this.isStaging().booleanValue() && DmcOmni.instance().backRefTracking() && DmcOmni.instance().trackThisAttribute(attr.ID) && attr instanceof DmcTypeNamedObjectREF && this.getLastValue() != null && (obj = (DmcObject)((DmcNamedObjectREF)this.getLastValue()).getObject()) != null) {
                DmcAttribute<?> mod = attr.getNew();
                mod.setAttributeInfo(ai);
                mod.add(this.getLastValue());
                Modifier backrefMod = new Modifier(ModifyTypeEnum.ADD, mod, this);
                ((DmcObject)((DmcNamedObjectREF)this.getLastValue()).getObject()).addBackref(backrefMod);
                ((DmcNamedObjectREF)this.getLastValue()).setBackrefModifier(backrefMod);
            }
            if (this.getModifier() != null) {
                if (this.getLastValue() == null) {
                    if ((ai.valueType == ValueTypeEnum.HASHMAPPED || ai.valueType == ValueTypeEnum.TREEMAPPED) && ai.valueType != ValueTypeEnum.HASHSET && ai.valueType != ValueTypeEnum.TREESET) {
                        throw new IllegalStateException("Last value shouldn't be null.");
                    }
                } else {
                    DmcAttribute<?> mod = attr.getNew();
                    mod.setAttributeInfo(ai);
                    mod.add(this.getLastValue());
                    this.getModifier().add(new Modifier(ModifyTypeEnum.ADD, mod));
                }
            }
            return (T)attr;
        }
    }

    public <T extends DmcAttribute<?>> T del(String attrName, Object value) {
        DmcAttributeInfo ai = this.getAttributeInfo(attrName);
        if (ai == null) {
            return null;
        }
        return this.del(ai, value);
    }

    protected void delFromEmptyAttribute(DmcAttribute<?> mod, Object value) {
        try {
            mod.add(value);
            this.getModifier().add(new Modifier(ModifyTypeEnum.DEL, mod));
        }
        catch (DmcValueException e) {
            if (mod.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED || mod.getAttributeInfo().valueType == ValueTypeEnum.TREEMAPPED) {
                throw new IllegalStateException("Changes to the Modifier shouldn't throw an exception. This is a MAPPED attribute and typeCheck () should accept just the key value as well as the mapped type itself.", e);
            }
            throw new IllegalStateException("Changes to the Modifier shouldn't throw an exception.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends DmcAttribute<?>> T del(DmcAttributeInfo ai, Object value) {
        Map<Integer, DmcAttribute<?>> map = this.attributes;
        synchronized (map) {
            DmcNamedObjectREF key;
            DmcAttribute<?> attr = this.attributes.get(ai.id);
            DmcNamedObjectREF ref = null;
            if (this.getModifier() != null) {
                try {
                    DmcAttribute<?> mod = attr.getNew();
                    mod.setAttributeInfo(ai);
                    mod.add(value);
                    this.getModifier().add(new Modifier(ModifyTypeEnum.DEL, mod));
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("Changes to the Modifier shouldn't throw an exception.", e);
                }
            }
            Object rc = null;
            rc = value instanceof DmcNamedObjectREF && !(value instanceof DmcExtendedReferenceIF) ? ((key = (DmcNamedObjectREF)value).getObject() == null ? attr.del(key.getObjectName()) : (value instanceof DmcMappedAttributeIF ? attr.del(((DmcMappedAttributeIF)value).getKey()) : attr.del(key.getObject()))) : (attr.getAttributeInfo().valueType == ValueTypeEnum.HASHSET || attr.getAttributeInfo().valueType == ValueTypeEnum.TREESET ? attr.del(value) : (value instanceof DmcExtendedReferenceIF ? attr.del(value) : (value instanceof DmcMappedAttributeIF ? attr.del(((DmcMappedAttributeIF)value).getKey()) : (value instanceof DmcNamedObjectIF ? attr.del(((DmcNamedObjectIF)value).getObjectName()) : attr.del(value)))));
            if (rc instanceof DmcNamedObjectREF) {
                ref = rc;
            }
            if (ref != null && !this.isModrec().booleanValue() && this.supportsBackrefTracking() && !this.isStaging().booleanValue() && DmcOmni.instance().backRefTracking() && DmcOmni.instance().trackThisAttribute(attr.ID) && ref.getObject() != null && ref.getBackrefModifier() != null) {
                ((DmcObject)ref.getObject()).removeBackref(ref.getBackrefModifier());
            }
            if (attr.getMVSize() == 0) {
                this.rem(ai);
            }
            return (T)attr;
        }
    }

    public <T extends DmcAttribute<?>> T rem(String attrName) {
        DmcAttributeInfo ai = this.getAttributeInfo(attrName);
        if (ai == null) {
            return null;
        }
        return this.rem(ai);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends DmcAttribute<?>> T rem(DmcAttributeInfo ai) {
        Map<Integer, DmcAttribute<?>> map = this.attributes;
        synchronized (map) {
            DmcAttribute<?> attr = this.attributes.remove(ai.id);
            if (this.getModifier() != null) {
                try {
                    this.getModifier().add(new Modifier(ModifyTypeEnum.REM, ai));
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("Changes to the Modifier shouldn't throw an exception.", e);
                }
            }
            if (!this.isModrec().booleanValue() && attr != null && this.supportsBackrefTracking() && !this.isStaging().booleanValue()) {
                if (attr instanceof DmcTypeNamedObjectREF) {
                    ((DmcTypeNamedObjectREF)attr).removeBackReferences();
                } else if (attr instanceof DmcTypeComplexTypeWithRefs) {
                    ((DmcTypeComplexTypeWithRefs)attr).removeBackReferences();
                }
            }
            return (T)attr;
        }
    }

    protected void nthNullFromEmptyAttribute(DmcAttributeInfo ai, int idx) {
        try {
            this.getModifier().add(new Modifier(ModifyTypeEnum.NTH, ai, idx));
        }
        catch (DmcValueException e) {
            throw new IllegalStateException("Changes to the Modifier shouldn't throw an exception.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends DmcAttribute<?>> T nth(DmcAttributeInfo ai, int index, DmcAttribute<?> attr, Object previous) throws DmcValueException {
        Map<Integer, DmcAttribute<?>> map = this.attributes;
        synchronized (map) {
            DmcAttribute<?> existing = this.attributes.get(ai.id);
            if (existing == null) {
                this.attributes.put(ai.id, attr);
                attr.setAttributeInfo(ai);
            }
            if (!this.isModrec().booleanValue() && this.supportsBackrefTracking() && !this.isStaging().booleanValue() && DmcOmni.instance().backRefTracking() && DmcOmni.instance().trackThisAttribute(attr.ID)) {
                DmcNamedObjectREF ref;
                DmcObject obj;
                if (attr instanceof DmcTypeNamedObjectREF && this.getLastValue() != null && (obj = (DmcObject)((DmcNamedObjectREF)this.getLastValue()).getObject()) != null) {
                    DmcAttribute<?> mod = attr.getNew();
                    mod.setAttributeInfo(ai);
                    mod.add(this.getLastValue());
                    Modifier backrefMod = new Modifier(ModifyTypeEnum.NTH, mod, this, index);
                    ((DmcObject)((DmcNamedObjectREF)this.getLastValue()).getObject()).addBackref(backrefMod);
                    ((DmcNamedObjectREF)this.getLastValue()).setBackrefModifier(backrefMod);
                }
                if (attr instanceof DmcTypeNamedObjectREF && previous != null && (ref = (DmcNamedObjectREF)previous).getObject() != null && ref.getBackrefModifier() != null) {
                    ((DmcObject)ref.getObject()).removeBackref(ref.getBackrefModifier());
                }
            }
            if (this.getModifier() != null) {
                if (this.getLastValue() == null) {
                    if (ai.indexSize == 0 || ai.valueType != ValueTypeEnum.MULTI) {
                        throw new IllegalStateException("Code gen error! The nth() interface is not applicable to attribute: " + ai.name + " of valueType: " + (Object)((Object)ai.valueType));
                    }
                    this.getModifier().add(new Modifier(ModifyTypeEnum.NTH, ai, index));
                } else {
                    DmcAttribute<?> mod = attr.getNew();
                    mod.setAttributeInfo(ai);
                    mod.setMVnth(index, this.getLastValue());
                    this.getModifier().add(new Modifier(ModifyTypeEnum.NTH, mod, index));
                }
            }
            if (!attr.hasValue()) {
                this.rem(ai);
            }
            return (T)attr;
        }
    }

    public String toString() {
        return this.toOIF(15);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBackRefs() {
        Map<Integer, DmcAttribute<?>> map = this.attributes;
        synchronized (map) {
            DmcTypeModifierMV mods = this.getBackref();
            if (mods == null) {
                return "No backrefs to " + ((DmcNamedObjectIF)((Object)this)).getObjectName() + " (" + System.identityHashCode(this) + ")";
            }
            StringBuffer sb = new StringBuffer();
            sb.append("References to: " + ((DmcNamedObjectIF)((Object)this)).getObjectName() + " (" + System.identityHashCode(this) + ")\n");
            Iterator<Modifier> modit = mods.getMV();
            if (modit != null) {
                while (modit.hasNext()) {
                    Modifier mod = modit.next();
                    DmcNamedObjectIF referrer = mod.getReferringObject();
                    DmcObject obj = (DmcObject)((Object)referrer);
                    DmcAttribute<?> attr = mod.getAttribute();
                    if (attr == null) {
                        if (mod.getRefFromComplexType() == null) continue;
                        sb.append("  (" + obj.getConstructionClassName() + ") " + referrer.getObjectName() + " via part: " + mod.getPartName() + " in attribute " + mod.getAttributeName() + "\n");
                        continue;
                    }
                    if (attr.getAttributeInfo().valueType == ValueTypeEnum.SINGLE) {
                        sb.append("  (" + obj.getConstructionClassName() + ") " + referrer.getObjectName() + " via SV " + attr.getName() + "\n");
                        continue;
                    }
                    if (attr.getAttributeInfo().indexSize == 0) {
                        sb.append("  (" + obj.getConstructionClassName() + ") " + referrer.getObjectName() + " via MV " + attr.getName() + "\n");
                        continue;
                    }
                    sb.append("  (" + obj.getConstructionClassName() + ") " + referrer.getObjectName() + " via INDEX " + mod.getIndex() + " " + attr.getName() + "\n");
                }
            }
            return sb.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<DmcObject> getReferringObjects() {
        ArrayList<DmcObject> rc = new ArrayList<DmcObject>();
        Map<Integer, DmcAttribute<?>> map = this.attributes;
        synchronized (map) {
            Iterator<Modifier> modit;
            DmcTypeModifierMV mods = this.getBackref();
            if (mods != null && (modit = mods.getMV()) != null) {
                while (modit.hasNext()) {
                    Modifier mod = modit.next();
                    rc.add((DmcObject)((Object)mod.getReferringObject()));
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<DmcObject> getReferringObjectsViaAttribute(DmcAttributeInfo ai) {
        ArrayList<DmcObject> rc = new ArrayList<DmcObject>();
        Map<Integer, DmcAttribute<?>> map = this.attributes;
        synchronized (map) {
            Iterator<Modifier> modit;
            DmcTypeModifierMV mods = this.getBackref();
            if (mods != null && (modit = mods.getMV()) != null) {
                while (modit.hasNext()) {
                    Modifier mod = modit.next();
                    if (mod.getAttributeID() != ai.id) continue;
                    rc.add((DmcObject)((Object)mod.getReferringObject()));
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toOIF() {
        Map<Integer, DmcAttribute<?>> map = this.attributes;
        synchronized (map) {
            int longest = 0;
            for (DmcAttribute<?> attr : this.attributes.values()) {
                if (attr.ID == DmcObject.__objectClass.id || attr.getName().length() <= longest) continue;
                longest = attr.getName().length();
            }
            return this.toOIF(longest + 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toPersistentOIF() {
        Map<Integer, DmcAttribute<?>> map = this.attributes;
        synchronized (map) {
            int longest = 0;
            for (DmcAttribute<?> attr : this.attributes.values()) {
                if (attr.ID == DmcObject.__objectClass.id || attr.attrInfo.dataType != DataTypeEnum.PERSISTENT || attr.getName().length() <= longest) continue;
                longest = attr.getName().length();
            }
            return this.toPersistentOIF(longest + 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toOIFNoPadding() {
        Map<Integer, DmcAttribute<?>> map = this.attributes;
        synchronized (map) {
            StringBuffer sb = new StringBuffer();
            this.appendClassNames(sb);
            if (this.getModifier() == null) {
                for (DmcAttribute<?> attr : this.attributes.values()) {
                    if (attr.getID() == DmcObject.__objectClass.id) continue;
                    attr.toOIF(sb);
                }
            } else {
                DmcAttribute<?> attr;
                if (this.getConstructionClassInfo() != null && this.getConstructionClassInfo().nameAttribute != null && (attr = this.get(this.getConstructionClassInfo().nameAttribute)) != null) {
                    attr.toOIF(sb);
                }
                this.getModifier().toOIF(sb);
            }
            return sb.toString();
        }
    }

    public String toOIF(int padding) {
        StringBuffer sb = new StringBuffer();
        this.appendClassNames(sb);
        if (this.getModifier() == null) {
            TreeMap sorted = new TreeMap();
            for (DmcAttribute<?> dmcAttribute : this.attributes.values()) {
                sorted.put(dmcAttribute.getName(), dmcAttribute);
            }
            for (DmcAttribute<Object> dmcAttribute : sorted.values()) {
                if (dmcAttribute.getID() == DmcObject.__objectClass.id) continue;
                dmcAttribute.toOIF(sb, padding);
            }
        } else {
            DmcAttribute<?> attr;
            if (this.getConstructionClassInfo() != null && this.getConstructionClassInfo().nameAttribute != null && (attr = this.get(this.getConstructionClassInfo().nameAttribute)) != null) {
                attr.toOIF(sb, padding);
            }
            if (this.getModifier().getMVSize() > 0) {
                this.getModifier().toOIF(sb, padding);
            } else {
                sb.append("* no modifications\n");
            }
        }
        return sb.toString();
    }

    public String toPersistentOIF(int padding) {
        StringBuffer sb = new StringBuffer();
        this.appendClassNames(sb);
        if (this.getModifier() == null) {
            TreeMap sorted = new TreeMap();
            for (DmcAttribute<?> dmcAttribute : this.attributes.values()) {
                if (dmcAttribute.attrInfo.dataType != DataTypeEnum.PERSISTENT) continue;
                sorted.put(dmcAttribute.getName(), dmcAttribute);
            }
            for (DmcAttribute<Object> dmcAttribute : sorted.values()) {
                if (dmcAttribute.getID() == DmcObject.__objectClass.id) continue;
                dmcAttribute.toOIF(sb, padding);
            }
        } else {
            DmcAttribute<?> attr;
            if (this.getConstructionClassInfo() != null && this.getConstructionClassInfo().nameAttribute != null && (attr = this.get(this.getConstructionClassInfo().nameAttribute)) != null) {
                attr.toOIF(sb, padding);
            }
            if (this.getModifier().getMVSize() > 0) {
                this.getModifier().toOIF(sb, padding);
            } else {
                sb.append("* no modifications\n");
            }
        }
        return sb.toString();
    }

    public String toJSON() {
        StringBuffer sb = new StringBuffer();
        this.toJSON(sb, 0, "");
        return sb.toString();
    }

    public String toJSON(int padding, String indent) {
        StringBuffer sb = new StringBuffer();
        this.toJSON(sb, padding, indent);
        return sb.toString();
    }

    public void toJSON(StringBuffer sb, int padding, String indent) {
        String indentPlus = indent + "  ";
        sb.append(indent + "{\n");
        DmcAttribute<?> oc = this.get(DmcObject.__objectClass.id);
        if (oc != null) {
            sb.append(indentPlus + "  \"objectClass\": [\n");
            oc.formatValueAsJSON(sb, padding, indentPlus + "  ");
            sb.append("\n" + indentPlus + "  ]");
            sb.append(",\n");
        }
        Iterator<DmcAttribute<?>> it = this.attributes.values().iterator();
        while (it.hasNext()) {
            DmcAttribute<?> attr = it.next();
            if (attr.getID() == DmcObject.__objectClass.id) {
                if (it.hasNext()) continue;
                sb.deleteCharAt(sb.length() - 1);
                sb.deleteCharAt(sb.length() - 1);
                continue;
            }
            if (attr.attrInfo.dataType == DataTypeEnum.NONPERSISTENT) continue;
            attr.toJSON(sb, padding, indentPlus + "  ");
            if (!it.hasNext()) continue;
            sb.append(",\n");
        }
        if (sb.toString().endsWith(",\n")) {
            sb.deleteCharAt(sb.length() - 1);
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("\n" + indent + "}");
    }

    public String toCompactJSON() {
        StringBuffer sb = new StringBuffer();
        this.toCompactJSON(sb);
        return sb.toString();
    }

    public void toCompactJSON(StringBuffer sb) {
        sb.append("{\"" + this.getConstructionClassName() + "\":{");
        sb.append("{");
        DmcAttribute<?> oc = this.get(DmcObject.__objectClass.id);
        if (oc != null) {
            sb.append("\"objectClass\":[");
            oc.formatValueAsCompactJSON(sb);
            sb.append("]");
            sb.append(",");
        }
        Iterator<DmcAttribute<?>> it = this.attributes.values().iterator();
        while (it.hasNext()) {
            DmcAttribute<?> attr = it.next();
            if (attr.getName().equals(DmcObject.__objectClass.name)) {
                if (it.hasNext()) continue;
                sb.deleteCharAt(sb.length() - 1);
                continue;
            }
            attr.toCompactJSON(sb);
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}");
        sb.append("}");
    }

    private void appendClassNames(StringBuffer sb) {
        if (this.getModifier() != null) {
            return;
        }
        DmcTypeClassDefinitionREFMV classes = (DmcTypeClassDefinitionREFMV)this.get(DmcObject.__objectClass.id);
        if (classes != null) {
            Iterator<ClassDefinitionREF> cls = classes.getMV();
            while (cls.hasNext()) {
                ClassDefinitionREF cdr = cls.next();
                sb.append(cdr.getObjectName());
                if (!cls.hasNext()) continue;
                sb.append(" ");
            }
            sb.append("\n");
        }
    }

    public void resolveReferences(DmcNameResolverIF rx) throws DmcValueExceptionSet {
        this.resolveReferences(rx, false, null);
    }

    public void resolveReferencesExceptClass(DmcNameResolverIF rx) throws DmcValueExceptionSet {
        this.resolveReferences(rx, true, null);
    }

    public void resolveReferences(DmcNameResolverWithClashSupportIF rx, DmcNameClashResolverIF ncr) throws DmcValueExceptionSet {
        this.resolveReferences(rx, false, ncr);
    }

    public void resolveReferencesExceptClass(DmcNameResolverWithClashSupportIF rx, DmcNameClashResolverIF ncr) throws DmcValueExceptionSet {
        this.resolveReferences(rx, true, ncr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolveReferences(DmcNameResolverIF rx, boolean skipClass, DmcNameClashResolverIF ncr) throws DmcValueExceptionSet {
        Map<Integer, DmcAttribute<?>> map = this.attributes;
        synchronized (map) {
            DmcValueExceptionSet errors = null;
            for (DmcAttribute<?> attr : this.attributes.values()) {
                if (skipClass && attr.ID == DmcObject.__objectClass.id) continue;
                DmcAttributeInfo ai = attr.getAttributeInfo();
                if (attr instanceof DmcTypeNamedObjectREF) {
                    DmcTypeNamedObjectREF reference = (DmcTypeNamedObjectREF)attr;
                    if (attr.getMVSize() == 0) {
                        DmcNamedObjectREF ref = (DmcNamedObjectREF)attr.getSV();
                        if (ref.isResolved()) continue;
                        DmcNamedObjectIF obj = null;
                        if (ncr == null) {
                            obj = rx.findNamedObject(ref.getObjectName(), attr.ID);
                        } else {
                            try {
                                obj = ((DmcNameResolverWithClashSupportIF)rx).findNamedObjectMayClash(this, ref.getObjectName(), ncr, attr.attrInfo);
                            }
                            catch (DmcValueException ex) {
                                ex.addMoreInfo(this.toOIF());
                                if (ai.weakReference) continue;
                                if (errors == null) {
                                    errors = new DmcValueExceptionSet();
                                }
                                errors.add(ex);
                                continue;
                            }
                        }
                        DmcObject resolvedObject = null;
                        if (obj == null) {
                            if (ai.weakReference) continue;
                            DmcValueException ex = new DmcValueException("Could not resolve reference to: " + ref.getObjectName() + " via attribute: " + attr.getName());
                            ex.addMoreInfo(this.toOIF());
                            if (errors == null) {
                                errors = new DmcValueExceptionSet();
                            }
                            errors.add(ex);
                            continue;
                        }
                        try {
                            if (obj instanceof DmcContainerIF) {
                                resolvedObject = ((DmcContainerIF)((Object)obj)).getDmcObject();
                                ref.setObject((DmcNamedObjectIF)((Object)((DmcContainerIF)((Object)obj)).getDmcObject()));
                            } else {
                                resolvedObject = (DmcObject)((Object)obj);
                                ref.setObject(obj);
                            }
                        }
                        catch (ClassCastException e) {
                            DmcValueException ex = new DmcValueException("Attribute " + attr.getName() + " is of type: " + attr.getAttributeInfo().type + " and you've tried to set it to " + obj.getObjectName() + " which is of type " + resolvedObject.getConstructionClassName());
                            ex.addMoreInfo(this.toOIF());
                            if (errors == null) {
                                errors = new DmcValueExceptionSet();
                            }
                            errors.add(ex);
                            continue;
                        }
                        if (!this.supportsBackrefTracking() || !DmcOmni.instance().backRefTracking() || !DmcOmni.instance().trackThisAttribute(attr.ID)) continue;
                        Modifier backrefMod = new Modifier(ModifyTypeEnum.SET, attr, this);
                        resolvedObject.addBackref(backrefMod);
                        ref.setBackrefModifier(backrefMod);
                        continue;
                    }
                    Iterator refs = reference.getMV();
                    if (refs == null) continue;
                    int currIndex = -1;
                    while (refs.hasNext()) {
                        Modifier backrefMod;
                        DmcAttribute<?> mod;
                        ++currIndex;
                        DmcNamedObjectREF ref = (DmcNamedObjectREF)refs.next();
                        if (ref == null || ref.isResolved()) continue;
                        DmcNamedObjectIF obj = null;
                        if (ncr == null) {
                            obj = rx.findNamedObject(ref.getObjectName(), attr.ID);
                        } else {
                            try {
                                obj = ((DmcNameResolverWithClashSupportIF)rx).findNamedObjectMayClash(this, ref.getObjectName(), ncr, attr.attrInfo);
                            }
                            catch (DmcValueException ex) {
                                if (errors == null) {
                                    errors = new DmcValueExceptionSet();
                                }
                                errors.add(ex);
                                continue;
                            }
                        }
                        DmcObject resolvedObject = null;
                        if (obj == null) {
                            if (ai.weakReference) continue;
                            DmcValueException ex = new DmcValueException("Could not resolve reference to: " + ref.getObjectName() + " via attribute: " + attr.getName());
                            ex.addMoreInfo(this.toOIF());
                            if (errors == null) {
                                errors = new DmcValueExceptionSet();
                            }
                            errors.add(ex);
                            continue;
                        }
                        try {
                            if (obj instanceof DmcContainerIF) {
                                resolvedObject = ((DmcContainerIF)((Object)obj)).getDmcObject();
                                ref.setObject((DmcNamedObjectIF)((Object)((DmcContainerIF)((Object)obj)).getDmcObject()));
                            } else {
                                resolvedObject = (DmcObject)((Object)obj);
                                ref.setObject(obj);
                            }
                        }
                        catch (ClassCastException e) {
                            DmcValueException ex = new DmcValueException("Attribute " + attr.getName() + " is of type: " + attr.getAttributeInfo().type + " and you've tried to set it to " + obj.getObjectName() + " which is of type " + resolvedObject.getConstructionClassName());
                            if (errors == null) {
                                errors = new DmcValueExceptionSet();
                            }
                            errors.add(ex);
                            continue;
                        }
                        if (!this.supportsBackrefTracking() || !DmcOmni.instance().backRefTracking() || !DmcOmni.instance().trackThisAttribute(attr.ID)) continue;
                        if (attr.getAttributeInfo().indexSize == 0) {
                            mod = attr.getNew();
                            mod.setAttributeInfo(attr.getAttributeInfo());
                            try {
                                if (ref instanceof DmcExtendedReferenceIF) {
                                    mod.add(ref);
                                } else {
                                    mod.add(resolvedObject);
                                }
                            }
                            catch (DmcValueException e) {
                                throw new IllegalStateException("Creating backref for MV attribute during object resolution shouldn't throw exception.", e);
                            }
                            backrefMod = new Modifier(ModifyTypeEnum.ADD, mod, this);
                            resolvedObject.addBackref(backrefMod);
                            ref.setBackrefModifier(backrefMod);
                            continue;
                        }
                        mod = attr.getNew();
                        mod.setAttributeInfo(attr.getAttributeInfo());
                        try {
                            if (ref instanceof DmcExtendedReferenceIF) {
                                mod.setMVnth(currIndex, null);
                            } else {
                                mod.setMVnth(currIndex, null);
                            }
                        }
                        catch (DmcValueException e) {
                            throw new IllegalStateException("Creating backref for indexed attribute during object resolution shouldn't throw exception.", e);
                        }
                        backrefMod = new Modifier(ModifyTypeEnum.NTH, mod, this, currIndex);
                        resolvedObject.addBackref(backrefMod);
                        ref.setBackrefModifier(backrefMod);
                    }
                    continue;
                }
                if (!(attr instanceof DmcTypeComplexTypeWithRefs)) continue;
                try {
                    if (ncr == null) {
                        ((DmcTypeComplexTypeWithRefs)attr).resolve(rx, attr.getName());
                        continue;
                    }
                    ((DmcTypeComplexTypeWithRefs)attr).resolve((DmcNameResolverWithClashSupportIF)rx, this, ncr, attr.attrInfo);
                }
                catch (DmcValueException e) {
                    e.addMoreInfo(this.toOIF());
                    if (errors == null) {
                        errors = new DmcValueExceptionSet();
                    }
                    errors.add(e);
                }
            }
            if (errors != null) {
                throw errors;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DmcObject cloneIt() {
        Map<Integer, DmcAttribute<?>> map = this.attributes;
        synchronized (map) {
            DmcObject rc = this.getNew();
            try {
                DmcAttribute<?> ocl = this.get(DmcObject.__objectClass.id);
                if (ocl != null) {
                    ocl.getAttributeInfo();
                    rc.add(__objectClass, ocl.cloneIt());
                }
                for (DmcAttribute<?> attr : this.attributes.values()) {
                    attr.getAttributeInfo();
                    DmcAttribute<?> copy = attr.cloneIt();
                    rc.add(copy.getAttributeInfo(), copy);
                }
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("DmcObject cloning shouldn't throw an exception.", e);
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DmcObject shallowCopy() {
        Map<Integer, DmcAttribute<?>> map = this.attributes;
        synchronized (map) {
            DmcObject rc = this.getNew();
            for (DmcAttribute<?> attr : this.attributes.values()) {
                rc.attributes.put(attr.ID, attr);
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateSlice(DmcObject sliceContainer, DmcSliceInfo info) {
        Map<Integer, DmcAttribute<?>> map = this.attributes;
        synchronized (map) {
            if (this instanceof DmcNamedObjectIF) {
                DmcAttribute<?> na = ((DmcNamedObjectIF)((Object)this)).getObjectNameAttribute();
                sliceContainer.attributes.put(na.ID, na);
            }
            for (Integer id : info.attrIDs) {
                DmcAttribute<?> attr = this.attributes.get(id);
                if (attr == null) continue;
                sliceContainer.attributes.put(id, attr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean applyModifier(DmcTypeModifier mods) throws DmcValueExceptionSet, DmcValueException {
        Map<Integer, DmcAttribute<?>> map = this.attributes;
        synchronized (map) {
            boolean anyChange = false;
            mods.resolved();
            DmcAttribute<?> existing = null;
            Iterator modifiers = mods.getMV();
            block10: while (modifiers.hasNext()) {
                Modifier mod = (Modifier)modifiers.next();
                existing = this.get(mod.getAttributeName());
                if (existing != null) {
                    existing.getAttributeInfo();
                }
                switch (mod.getModifyType()) {
                    case ADD: {
                        Object lastValue;
                        DmcNamedObjectREF ref;
                        Object value;
                        if (existing == null) {
                            Iterator<?> it = mod.getAttribute().getMV();
                            value = it.next();
                            if (value instanceof DmcNamedObjectREF) {
                                existing = mod.getAttribute().getNew();
                                ref = value;
                                lastValue = existing.add(ref);
                                this.setLastValue(lastValue);
                                this.add(existing.getAttributeInfo(), existing);
                            } else {
                                this.add(mod.getAttributeName(), mod.getAttribute().cloneIt());
                            }
                            anyChange = true;
                            break;
                        }
                        Iterator<?> it = mod.getAttribute().getMV();
                        value = it.next();
                        if (value instanceof DmcNamedObjectREF && !(value instanceof DmcExtendedReferenceIF)) {
                            ref = value;
                            lastValue = existing.add(ref);
                            if (lastValue == null) continue block10;
                            this.setLastValue(lastValue);
                            anyChange = true;
                            this.add(existing.getAttributeInfo(), existing);
                            break;
                        }
                        if (existing.add(value) == null) continue block10;
                        anyChange = true;
                        break;
                    }
                    case DEL: {
                        DmcNamedObjectREF ref;
                        if (existing == null) break;
                        Iterator<?> it = mod.getAttribute().getMV();
                        Object value = it.next();
                        if (value instanceof DmcNamedObjectREF && !(value instanceof DmcExtendedReferenceIF)) {
                            ref = value;
                            this.setLastValue(ref);
                            anyChange = true;
                            this.del(existing.getAttributeInfo(), value);
                        } else if (value instanceof DmcMappedAttributeIF) {
                            if (existing.del(((DmcMappedAttributeIF)value).getKey()) != null) {
                                anyChange = true;
                            }
                        } else if (existing.del(value) != null) {
                            anyChange = true;
                        }
                        if (existing.getMVSize() != 0) continue block10;
                        this.rem(existing.getAttributeInfo());
                        break;
                    }
                    case SET: {
                        if (existing == null) {
                            this.set(mod.getAttributeName(), mod.getAttribute());
                            anyChange = true;
                            break;
                        }
                        Object value = mod.getAttribute().getSV();
                        if (value instanceof DmcNamedObjectREF) {
                            ((DmcTypeNamedObjectREF)existing).removeBackReferences();
                            DmcNamedObjectREF ref = (DmcNamedObjectREF)value;
                            if (existing.set(ref) == null) continue block10;
                            this.set(existing.getAttributeInfo(), existing);
                            anyChange = true;
                            break;
                        }
                        if (existing.set(mod.getAttribute().getSV()) == null) continue block10;
                        anyChange = true;
                        break;
                    }
                    case NTH: {
                        int index = mod.getIndex();
                        Object value = null;
                        if (mod.getAttribute() != null) {
                            value = mod.getAttribute().getMVnth(index);
                        }
                        if (existing == null) {
                            if (value == null) break;
                            this.setLastValue(value);
                            this.nth(mod.getAttribute().getAttributeInfo(), index, mod.getAttribute().cloneIt(), null);
                            anyChange = true;
                            break;
                        }
                        Object previous = existing.getMVnth(index);
                        if (value == null) {
                            if (previous != null) {
                                existing.setMVnth(index, value);
                                this.setLastValue(value);
                                this.nth(existing.getAttributeInfo(), index, existing, previous);
                                anyChange = true;
                            }
                        } else if (value instanceof DmcNamedObjectREF) {
                            DmcNamedObjectREF ref = value;
                            if (existing.setMVnth(index, ref) != null) {
                                this.setLastValue(ref);
                                this.nth(existing.getAttributeInfo(), index, existing, previous);
                                anyChange = true;
                            }
                        } else if (existing.setMVnth(index, value) != null) {
                            anyChange = true;
                        }
                        if (existing.hasValue()) continue block10;
                        this.rem(existing.getAttributeInfo());
                        break;
                    }
                    case REM: {
                        if (this.rem(mod.getAttributeName()) == null) break;
                        anyChange = true;
                        break;
                    }
                }
            }
            return anyChange;
        }
    }

    public Map<Integer, DmcAttribute<?>> getAdditionalAttributes() {
        if (this.getConstructionClassInfo().classType == ClassTypeEnum.EXTENSIBLE) {
            TreeMap map = new TreeMap();
            for (DmcAttribute<?> attr : this.attributes.values()) {
                if (this.allowsAttribute(attr.getAttributeInfo())) continue;
                map.put(attr.ID, attr);
            }
            return map;
        }
        return null;
    }

    public DataTypeEnum getDataType() {
        ClassDefinitionREF ref;
        DataTypeEnum rc = DataTypeEnum.UNKNOWN;
        DmcTypeClassDefinitionREFMV objClass = (DmcTypeClassDefinitionREFMV)this.attributes.get(DmcObject.__objectClass.id);
        if (objClass != null && (ref = objClass.getMVnth(0)).getObject() != null) {
            ClassDefinitionDMO dmo = (ClassDefinitionDMO)ref.getObject();
            rc = dmo.getDataType();
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serializeIt(DmcOutputStreamIF dos) throws Exception, DmcValueException {
        Map<Integer, DmcAttribute<?>> map = this.attributes;
        synchronized (map) {
            DmcTypeClassDefinitionREFMV oc = (DmcTypeClassDefinitionREFMV)this.get(DmcObject.__objectClass.id);
            dos.writeInt(oc.getMVSize());
            for (int i = 0; i < oc.getMVSize(); ++i) {
                dos.writeInt(oc.getMVnth((int)i).getClassInfo().id);
            }
            int attrcount = 0;
            for (DmcAttribute<?> attr : this.attributes.values()) {
                if (attr.getID() == DmcObject.__objectClass.id || attr.getAttributeInfo().dataType == DataTypeEnum.TRANSIENT) continue;
                if (dos.isFile()) {
                    if (attr.getAttributeInfo().dataType != DataTypeEnum.PERSISTENT) continue;
                    ++attrcount;
                    continue;
                }
                ++attrcount;
            }
            dos.writeAttributeCount(attrcount);
            for (DmcAttribute<?> attr : this.attributes.values()) {
                if (attr.getID() == DmcObject.__objectClass.id || attr.getAttributeInfo().dataType == DataTypeEnum.TRANSIENT) continue;
                if (dos.isFile()) {
                    if (attr.getAttributeInfo().dataType != DataTypeEnum.PERSISTENT) continue;
                    attr.serializeIt(dos);
                    continue;
                }
                attr.serializeIt(dos);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deserializeIt(DmcInputStreamIF dis) throws Exception {
        int attrCount = dis.readAttributeCount();
        int i = 0;
        while (i < attrCount) {
            int attrID = dis.readAttributeID();
            DmcAttribute<?> attr = null;
            try {
                attr = dis.getAttributeInstance(attrID);
                if (!(attr instanceof DmcTypeNamedObjectREF)) {
                    // empty if block
                }
            }
            catch (Exception ex) {
                throw new IllegalStateException("While decoding: " + this.getConstructionClassName(), ex);
            }
            attr.deserializeIt(dis);
            this.add(attr.getAttributeInfo(), attr);
            ++i;
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        Map<Integer, DmcAttribute<?>> map = this.attributes;
        synchronized (map) {
            boolean rc = true;
            if (obj instanceof DmcObject) {
                DmcObject other = (DmcObject)obj;
                if (this.getConstructionClassName().equals(other.getConstructionClassName())) {
                    if (this.attributes.size() != other.attributes.size()) {
                        return false;
                    }
                    for (DmcAttribute<?> attr : this.attributes.values()) {
                        DmcAttribute<?> otherAttr = other.get(attr.attrInfo);
                        if (otherAttr == null) {
                            rc = false;
                            break;
                        }
                        if (attr.attrInfo.valueType == ValueTypeEnum.SINGLE) {
                            if (!attr.getSV().equals(otherAttr.getSV())) {
                                rc = false;
                                break;
                            }
                        } else {
                            Object thisval;
                            if (attr.getMVSize() != otherAttr.getMVSize()) {
                                rc = false;
                                break;
                            }
                            if (attr.attrInfo.indexSize != 0) {
                                for (int i = 0; i < attr.getMVSize(); ++i) {
                                    thisval = attr.getMVnth(i);
                                    Object thatval = otherAttr.getMVnth(i);
                                    if (thisval == null) {
                                        if (thatval == null) continue;
                                        rc = false;
                                    } else if (thatval == null) {
                                        rc = false;
                                    } else {
                                        if (thisval.equals(thatval)) continue;
                                        rc = false;
                                    }
                                    break;
                                }
                            } else {
                                block2 : switch (attr.attrInfo.valueType) {
                                    case HASHMAPPED: 
                                    case TREEMAPPED: {
                                        Iterator<?> vals = attr.getMV();
                                        while (vals.hasNext()) {
                                            thisval = (DmcMappedAttributeIF)vals.next();
                                            DmcMappedAttributeIF otherval = (DmcMappedAttributeIF)otherAttr.getByKey(thisval.getKey());
                                            if (otherval == null) {
                                                rc = false;
                                                break block2;
                                            }
                                            if (thisval.valuesAreEqual(otherval)) continue;
                                            rc = false;
                                            break block2;
                                        }
                                        break;
                                    }
                                    case HASHSET: 
                                    case TREESET: {
                                        Iterator<?> setvals = attr.getMV();
                                        while (setvals.hasNext()) {
                                            Object thisval2 = setvals.next();
                                            if (otherAttr.contains(thisval2)) continue;
                                            rc = false;
                                            break block2;
                                        }
                                        break;
                                    }
                                    case MULTI: {
                                        for (int i = 0; i < attr.getMVSize(); ++i) {
                                            Object thatval;
                                            Object thisval3 = attr.getMVnth(i);
                                            if (thisval3.equals(thatval = otherAttr.getMVnth(i))) continue;
                                            rc = false;
                                            break block2;
                                        }
                                        break;
                                    }
                                }
                            }
                        }
                        if (rc) continue;
                        break;
                    }
                }
            } else {
                rc = false;
            }
            return rc;
        }
    }

    public void clearReferenceInfo() {
        for (DmcAttribute<?> attr : this.attributes.values()) {
            if (!(attr instanceof DmcTypeNamedObjectREF)) continue;
            DmcTypeNamedObjectREF reference = (DmcTypeNamedObjectREF)attr;
            if (attr.getMVSize() == 0) {
                DmcNamedObjectREF ref = (DmcNamedObjectREF)attr.getSV();
                ref.setObject(null);
                continue;
            }
            Iterator refs = reference.getMV();
            if (refs == null) continue;
            while (refs.hasNext()) {
                DmcNamedObjectREF ref = (DmcNamedObjectREF)refs.next();
                if (ref == null) continue;
                ref.setObject(null);
            }
        }
        this.setInfo(1, 2, null);
        this.shrinkInfo(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DmcObject getStagingObject(DmcTypeModifier mods) {
        Map<Integer, DmcAttribute<?>> map = this.attributes;
        synchronized (map) {
            DmcObject rc = this.getNew();
            rc.staging(true);
            HashSet<DmcAttributeInfo> mayBeChanged = new HashSet<DmcAttributeInfo>();
            Iterator modifiers = mods.getMV();
            while (modifiers.hasNext()) {
                Modifier mod = (Modifier)modifiers.next();
                mayBeChanged.add(mod.getAttributeInfo());
            }
            for (DmcAttribute<?> attr : this.attributes.values()) {
                if (mayBeChanged.contains(attr.getAttributeInfo())) {
                    rc.attributes.put(attr.getID(), attr.cloneIt());
                    continue;
                }
                rc.attributes.put(attr.getID(), attr);
            }
            return rc;
        }
    }
}

