/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcCacheIF;
import org.dmd.dmc.DmcClassInfo;
import org.dmd.dmc.DmcCompactSchemaIF;
import org.dmd.dmc.DmcFilterBuilderIF;
import org.dmd.dmc.DmcLoggerIF;
import org.dmd.dmc.DmcNameBuilderIF;
import org.dmd.dmc.DmcNameResolverIF;
import org.dmd.dmc.DmcNamedObjectIF;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.DmcObjectName;
import org.dmd.dmc.DmcSliceInfo;
import org.dmd.dmc.DmcTypeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.DmcValueExceptionSet;
import org.dmd.dmc.rules.DmcRuleExceptionSet;
import org.dmd.dmc.rules.RuleTracerIF;
import org.dmd.dmc.types.DmcTypeDmcObjectName;
import org.dmd.dmc.types.DotName;
import org.dmd.dmc.types.Modifier;
import org.dmd.dms.generated.dmo.MetaDMSAG;
import org.dmd.dms.generated.types.DmcTypeModifierMV;

public class DmcOmni
implements DmcNameResolverIF {
    protected static DmcOmni omni;
    boolean trackBackRefs;
    boolean lazyResolution;
    boolean autoResolution;
    boolean cleanUpDeadRefs;
    boolean trackSchemaReferences;
    DmcLoggerIF logger;
    boolean traceRules;
    RuleTracerIF ruleTracer;
    ArrayList<DmcNameResolverIF> resolvers;
    TreeMap<Integer, DmcClassInfo> idToClass;
    TreeMap<String, DmcClassInfo> stringToClass;
    TreeMap<Integer, DmcAttributeInfo> idToAttr;
    TreeMap<String, ArrayList<DmcAttributeInfo>> stringToAttribute;
    TreeMap<DotName, DmcAttributeInfo> dotnameToAttribute;
    TreeMap<String, DmcNameBuilderIF> nameBuilders;
    TreeMap<String, DmcFilterBuilderIF> filterBuilders;
    DmcCacheIF cache;
    TreeMap<String, DmcSliceInfo> slices;
    TreeMap<String, DmcTypeInfo> types;
    TreeMap<String, DmcCompactSchemaIF> loadedCompactSchemas;

    protected DmcOmni() {
        this.init();
    }

    public void reset() {
        this.init();
    }

    void init() {
        this.trackBackRefs = false;
        this.lazyResolution = false;
        this.autoResolution = false;
        this.cleanUpDeadRefs = false;
        this.trackSchemaReferences = false;
        this.logger = null;
        this.traceRules = false;
        this.ruleTracer = null;
        this.resolvers = null;
        this.idToClass = new TreeMap();
        this.stringToClass = new TreeMap();
        this.idToAttr = new TreeMap();
        this.stringToAttribute = new TreeMap();
        this.dotnameToAttribute = new TreeMap();
        this.nameBuilders = new TreeMap();
        this.filterBuilders = new TreeMap();
        this.slices = new TreeMap();
        this.types = new TreeMap();
        this.cache = null;
        this.loadedCompactSchemas = new TreeMap();
        this.addCompactSchema(MetaDMSAG.instance());
    }

    public static synchronized DmcOmni instance() {
        if (omni == null) {
            omni = new DmcOmni();
        }
        return omni;
    }

    public TreeMap<String, DmcCompactSchemaIF> loadedCompactSchemas() {
        return this.loadedCompactSchemas;
    }

    public void setTrackSchemaReferences(boolean f) {
        this.trackSchemaReferences = f;
    }

    public boolean trackThisAttribute(int attributeID) {
        if (this.trackSchemaReferences) {
            return true;
        }
        return attributeID > MetaDMSAG.instance().getSchemaMaxID();
    }

    public boolean backRefTracking() {
        return this.trackBackRefs;
    }

    public void backRefTracking(boolean f) {
        this.trackBackRefs = f;
    }

    public boolean lazyResolution() {
        return this.lazyResolution;
    }

    public void lazyResolution(boolean f) {
        this.lazyResolution = f;
    }

    public boolean autoResolution() {
        return this.autoResolution;
    }

    public void autoResolution(boolean f) {
        this.autoResolution = f;
    }

    public boolean cleanUpDeadRefs() {
        return this.cleanUpDeadRefs;
    }

    public void cleanUpDeadRefs(boolean f) {
        this.cleanUpDeadRefs = f;
    }

    public DmcLoggerIF logger() {
        return this.logger;
    }

    public void logger(DmcLoggerIF l) {
        this.logger = l;
    }

    public void logDeadReference(DmcObject referrer, DmcAttribute<?> viaAttribute, DmcObjectName referenceTo) {
        if (this.logger != null) {
            this.logger.logDeadReference(referrer, viaAttribute, referenceTo);
        }
    }

    public void addResolver(DmcNameResolverIF res) {
        if (res == null) {
            throw new IllegalStateException("Name resolver is null! Did you forget to initialize it?");
        }
        if (this.resolvers == null) {
            this.resolvers = new ArrayList();
        }
        this.resolvers.add(res);
    }

    public void addCompactSchema(DmcCompactSchemaIF schema) {
        Iterator<DmcTypeInfo> typeIT;
        Iterator<DmcSliceInfo> sliceIT;
        Iterator<DmcFilterBuilderIF> fbuilders;
        Iterator<DmcNameBuilderIF> nbuilders;
        Iterator<DmcClassInfo> cinfo;
        if (this.loadedCompactSchemas.get(schema.getSchemaName()) != null) {
            return;
        }
        Iterator<DmcAttributeInfo> info = schema.getAttributeInfo();
        if (info != null) {
            while (info.hasNext()) {
                DmcAttributeInfo ai = info.next();
                DmcAttributeInfo existing = this.idToAttr.get(ai.id);
                if (existing != null) {
                    throw new IllegalStateException("Clashing attribute IDs: " + existing + "  <>  " + ai);
                }
                this.idToAttr.put(ai.id, ai);
                ArrayList<DmcAttributeInfo> mapping = this.stringToAttribute.get(ai.name);
                if (mapping == null) {
                    mapping = new ArrayList(1);
                    this.stringToAttribute.put(ai.name, mapping);
                }
                mapping.add(ai);
                DmcAttributeInfo fqai = this.dotnameToAttribute.get(ai.qualifiedName);
                if (fqai == null) {
                    this.dotnameToAttribute.put(ai.qualifiedName, ai);
                    continue;
                }
                throw new IllegalStateException("Clashing attributes: " + fqai + "  <>  " + ai);
            }
        }
        if ((cinfo = schema.getClassInfo()) != null) {
            while (cinfo.hasNext()) {
                DmcClassInfo ci = cinfo.next();
                DmcClassInfo existing = this.idToClass.get(ci.id);
                if (existing != null) {
                    throw new IllegalStateException("Clashing class IDs: " + existing + "  <>  " + ci);
                }
                this.idToClass.put(ci.id, ci);
                existing = this.stringToClass.get(ci.name);
                if (existing != null) {
                    throw new IllegalStateException("Clashing class names: " + existing + "  <>  " + ci);
                }
                this.stringToClass.put(ci.name, ci);
                if (ci.derivedFrom == null) continue;
                ci.derivedFrom.addDerivedClass(ci);
            }
        }
        if ((nbuilders = schema.getNameBuilders()) != null) {
            while (nbuilders.hasNext()) {
                DmcNameBuilderIF builder = nbuilders.next();
                this.nameBuilders.put(builder.getNameClass(), builder);
            }
        }
        if ((fbuilders = schema.getFilterBuilders()) != null) {
            while (fbuilders.hasNext()) {
                DmcFilterBuilderIF builder = fbuilders.next();
                this.filterBuilders.put(builder.getFilterClass(), builder);
            }
        }
        if ((sliceIT = schema.getSliceInfo()) != null) {
            while (sliceIT.hasNext()) {
                DmcSliceInfo dsi = sliceIT.next();
                this.slices.put(dsi.getName(), dsi);
            }
        }
        if ((typeIT = schema.getTypeInfo()) != null) {
            while (typeIT.hasNext()) {
                DmcTypeInfo dti = typeIT.next();
                this.types.put(dti.name, dti);
            }
        }
        this.loadedCompactSchemas.put(schema.getSchemaName(), schema);
    }

    public DmcTypeDmcObjectName<?> buildName(DmcObjectName name) {
        DmcNameBuilderIF builder = this.nameBuilders.get(name.getNameClass());
        if (builder == null) {
            throw new IllegalStateException("No DmcNameBuilderIF available for name class: " + name.getNameClass() + " - ensure that you have loaded the appropriate ASAGs.");
        }
        DmcAttributeInfo ai = this.idToAttr.get(builder.getNameAttributeID());
        return builder.getNewNameHolder(name, ai);
    }

    public void setCacheIF(DmcCacheIF c) {
        this.cache = c;
    }

    public void removeReferences(DmcTypeModifierMV mods) {
        Iterator<Modifier> it = mods.getMV();
        while (it.hasNext()) {
            Modifier mod = it.next();
            if (mod.getRefFromComplexType() != null) {
                mod.getRefFromComplexType().setObject(null);
                continue;
            }
            DmcTypeModifierMV single = new DmcTypeModifierMV();
            try {
                single.add(mod);
                if (this.cache == null) {
                    ((DmcObject)((Object)mod.getReferringObject())).applyModifier(single);
                    continue;
                }
                this.cache.applyModification(mod.getReferringObject(), single);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Adding a prebuilt Modifier to a DmcTypeModifierMV shouldn't thrown an exception.");
            }
            catch (DmcValueExceptionSet e) {
                throw new IllegalStateException("Removing a back reference shouldn't thrown an exception.");
            }
        }
    }

    public DmcClassInfo getClassInfo(String cn) {
        return this.stringToClass.get(cn);
    }

    public DmcClassInfo getClassInfo(Integer id) {
        return this.idToClass.get(id);
    }

    public DmcTypeInfo getTypeInfo(String tn) {
        return this.types.get(tn);
    }

    public DmcAttributeInfo getInfo(Integer id) {
        DmcAttributeInfo ai = this.idToAttr.get(id);
        if (ai == null) {
            return null;
        }
        return ai;
    }

    public DmcAttributeInfo getAttributeInfo(String an) {
        ArrayList<DmcAttributeInfo> mapping = this.stringToAttribute.get(an);
        if (mapping == null) {
            try {
                DotName dn = new DotName(an);
                return this.dotnameToAttribute.get(dn);
            }
            catch (DmcValueException e) {
                e.printStackTrace();
            }
        } else if (mapping.size() == 1) {
            return mapping.get(0);
        }
        return null;
    }

    @Override
    public DmcObject findNamedDMO(DmcObjectName name) {
        DmcNameResolverIF res;
        DmcObject rc = null;
        Iterator<DmcNameResolverIF> iterator = this.resolvers.iterator();
        while (iterator.hasNext() && (rc = (res = iterator.next()).findNamedDMO(name)) == null) {
        }
        return rc;
    }

    @Override
    public DmcNamedObjectIF findNamedObject(DmcObjectName name) {
        DmcNamedObjectIF rc = null;
        for (DmcNameResolverIF res : this.resolvers) {
            DmcObject obj = res.findNamedDMO(name);
            if (obj == null) continue;
            rc = (DmcNamedObjectIF)((Object)obj);
            break;
        }
        return rc;
    }

    @Override
    public DmcNamedObjectIF findNamedObject(DmcObjectName name, int attributeID) {
        DmcNameResolverIF res;
        DmcNamedObjectIF rc = null;
        Iterator<DmcNameResolverIF> iterator = this.resolvers.iterator();
        while (iterator.hasNext() && (rc = (res = iterator.next()).findNamedObject(name, attributeID)) == null) {
        }
        return rc;
    }

    public void dumpASAG() {
        for (DmcAttributeInfo ai : this.idToAttr.values()) {
            System.out.println(ai.toString());
        }
    }

    public DmcSliceInfo getSliceInfo(String name) {
        DmcSliceInfo rc = this.slices.get(name);
        if (rc == null) {
            throw new IllegalStateException("Unknown slice requested: " + name);
        }
        return rc;
    }

    public boolean ruleTracing() {
        return this.traceRules;
    }

    public void ruleTracing(boolean f) {
        this.traceRules = f;
    }

    public void ruleTracer(RuleTracerIF t) {
        this.ruleTracer = t;
    }

    public void ruleExecuted(String info) {
        if (this.traceRules && this.ruleTracer != null) {
            this.ruleTracer.ruleExecuted(info);
        }
    }

    public void ruleAdded(String info) {
        if (this.traceRules && this.ruleTracer != null) {
            this.ruleTracer.ruleAdded(info);
        }
    }

    public void ruleFailed(DmcRuleExceptionSet errors) {
        if (this.traceRules && this.ruleTracer != null) {
            this.ruleTracer.ruleFailed(errors);
        }
    }
}

