/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmc.cache;

import java.util.ArrayList;
import java.util.TreeMap;
import org.dmd.dmc.DmcClassInfo;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.cache.DmoCacheIndexListenerIF;
import org.dmd.dmc.cache.DmoCacheListenerRegistration;
import org.dmd.dmp.shared.generated.dmo.DMPEventDMO;

public class DmoCacheListenerManager {
    TreeMap<DmcClassInfo, ArrayList<DmoCacheListenerRegistration>> listeners = new TreeMap();

    public DmoCacheListenerRegistration register(DmcClassInfo dci, DmoCacheIndexListenerIF listener) {
        DmoCacheListenerRegistration rc = new DmoCacheListenerRegistration(listener);
        ArrayList<DmoCacheListenerRegistration> existing = this.listeners.get(dci);
        if (existing == null) {
            existing = new ArrayList();
            this.listeners.put(dci, existing);
        }
        existing.add(rc);
        return rc;
    }

    public void objectAdded(DmcClassInfo index, DmcObject object, DMPEventDMO event) {
        ArrayList<DmoCacheListenerRegistration> existing = this.listeners.get(index);
        if (existing != null) {
            for (DmoCacheListenerRegistration dclr : existing) {
                dclr.listener().objectAdded(index, object, event);
            }
        }
    }

    public void objectDeleted(DmcClassInfo index, DmcObject object, DMPEventDMO event) {
        ArrayList<DmoCacheListenerRegistration> existing = this.listeners.get(index);
        if (existing != null) {
            for (DmoCacheListenerRegistration dclr : existing) {
                dclr.listener().objectDeleted(index, object, event);
            }
        }
    }

    public void objectModified(DmcClassInfo index, DmcObject object, DMPEventDMO event) {
        ArrayList<DmoCacheListenerRegistration> existing = this.listeners.get(index);
        if (existing != null) {
            for (DmoCacheListenerRegistration dclr : existing) {
                dclr.listener().objectModified(index, object, event);
            }
        }
    }
}

