/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmc.definitions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeMap;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcNamedObjectIF;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DefinitionName;
import org.dmd.dmc.types.DotName;
import org.dmd.dms.generated.dmo.DSDefinitionDMO;

public class DMODefinitionSet<DEF extends DSDefinitionDMO> {
    private static boolean debug = false;
    private TreeMap<DefinitionName, ArrayList<DEF>> nameMap = new TreeMap();
    private TreeMap<DotName, DEF> fullDotNameMap = new TreeMap();
    private TreeMap<DotName, ArrayList<DEF>> nameAndTypeMap = new TreeMap();
    private int longestName;
    private String setName;
    private String className;
    private DMODefinitionSet<DSDefinitionDMO> globalSet;
    private boolean isGlobalSet;
    private DMODefinitionSet<?> derivedFromSet;

    public DMODefinitionSet() {
        this.setName = null;
        this.className = null;
        this.globalSet = null;
        this.isGlobalSet = false;
        this.derivedFromSet = null;
    }

    public DMODefinitionSet(String sn) {
        this.setName = sn;
        this.className = null;
        this.globalSet = null;
        this.isGlobalSet = true;
        this.derivedFromSet = null;
    }

    public DMODefinitionSet(String cn, DMODefinitionSet<DSDefinitionDMO> gs) {
        this.setName = cn;
        this.className = cn;
        this.globalSet = gs;
        this.isGlobalSet = false;
        this.derivedFromSet = null;
    }

    public DMODefinitionSet(String cn, DMODefinitionSet<DSDefinitionDMO> gs, DMODefinitionSet<?> derivedFrom) {
        this.setName = cn;
        this.className = cn;
        this.globalSet = gs;
        this.isGlobalSet = false;
        this.derivedFromSet = derivedFrom;
    }

    public static void debug(boolean f) {
        debug = f;
    }

    public String className() {
        return this.className;
    }

    void addByNameAndType(DEF def, DotName nameAndTypeName) {
        ArrayList<Object> existingNameAndTypeSet = this.nameAndTypeMap.get(nameAndTypeName);
        if (existingNameAndTypeSet == null) {
            existingNameAndTypeSet = new ArrayList(1);
            this.nameAndTypeMap.put(nameAndTypeName, existingNameAndTypeSet);
        }
        existingNameAndTypeSet.add(def);
    }

    void deleteByNameAndType(DEF def, DotName nameAndTypeName) {
        ArrayList<DEF> existingNameAndTypeSet = this.nameAndTypeMap.get(nameAndTypeName);
        if (existingNameAndTypeSet == null) {
            throw new IllegalStateException("No entry in nameAndTypeMap for: " + ((DmcObject)def).toOIF());
        }
        if (!existingNameAndTypeSet.remove(def)) {
            throw new IllegalStateException("Could not delete entry in nameAndTypeMap for: " + ((DmcObject)def).toOIF());
        }
    }

    void addByName(DEF def) {
        ArrayList<Object> existingNameSet = this.nameMap.get(((DSDefinitionDMO)def).getName());
        if (existingNameSet == null) {
            existingNameSet = new ArrayList(1);
            this.nameMap.put(((DSDefinitionDMO)def).getName(), existingNameSet);
        }
        existingNameSet.add(def);
    }

    void deleteByName(DEF def) {
        ArrayList<DEF> existingNameSet = this.nameMap.get(((DSDefinitionDMO)def).getName());
        if (existingNameSet == null) {
            throw new IllegalStateException("No entry in nameMap for: " + ((DmcObject)def).toOIF());
        }
        if (!existingNameSet.remove(def)) {
            throw new IllegalStateException("Could not delete entry in nameMap for: " + ((DmcObject)def).toOIF());
        }
    }

    void addGlobal(DEF def, DotName fullName, DotName nameAndTypeName) {
        if (!this.isGlobalSet) {
            throw new IllegalStateException("");
        }
        this.addByNameAndType(def, nameAndTypeName);
        this.addByFullName(def, fullName);
    }

    void deleteGlobal(DEF def, DotName fullName, DotName nameAndTypeName) {
        if (!this.isGlobalSet) {
            throw new IllegalStateException("");
        }
        this.deleteByNameAndType(def, nameAndTypeName);
        this.deleteByFullName(fullName);
    }

    void addByFullName(DEF def, DotName fullName) {
        if (this.fullDotNameMap.get(fullName) != null) {
            throw new IllegalStateException("Clashing fully qualified name: " + fullName + " - in definition set: " + this.setName + " - For definition: \n\n" + ((DmcObject)def).toOIF());
        }
        this.fullDotNameMap.put(fullName, def);
    }

    void deleteByFullName(DotName fullName) {
        if (this.fullDotNameMap.remove(fullName) == null) {
            throw new IllegalStateException("Could not delete entry in fullDotNameMap for: " + fullName);
        }
    }

    public void add(DEF def) {
        try {
            if (this.className == null) {
                DotName nameAndTypeName = new DotName(((DSDefinitionDMO)def).getName() + "." + ((DmcObject)def).getConstructionClassName());
                this.addByName(def);
                this.addByNameAndType(def, nameAndTypeName);
                this.addByFullName(def, ((DSDefinitionDMO)def).getDotName());
            } else {
                DotName nameAndTypeName = new DotName(((DSDefinitionDMO)def).getName() + "." + this.className);
                DotName fullName = new DotName(((DSDefinitionDMO)def).getDmoFromModule() + "." + ((DSDefinitionDMO)def).getName() + "." + this.className);
                this.addByName(def);
                this.addByNameAndType(def, nameAndTypeName);
                this.addByFullName(def, fullName);
                if (this.globalSet != null) {
                    this.globalSet.addGlobal((DSDefinitionDMO)def, fullName, nameAndTypeName);
                }
            }
        }
        catch (DmcValueException e) {
            e.printStackTrace();
        }
    }

    public void delete(DotName dn) throws Exception {
        DSDefinitionDMO dsd = (DSDefinitionDMO)this.fullDotNameMap.get(dn);
        if (dsd == null) {
            throw new Exception("The specified object: " + dn.getNameString() + " of class: " + this.className + "  doesn't exist");
        }
        if (!dsd.getConstructionClassName().equals(this.className)) {
            throw new Exception("The specified object: " + dn.getNameString() + " is not of class: " + this.className);
        }
        this.delete(dsd);
    }

    protected void deleteFromBase(DSDefinitionDMO dsd) throws Exception {
        DSDefinitionDMO def = dsd;
        this.delete(def);
    }

    public void delete(DEF def) throws Exception {
        ArrayList<DmcObject> refs = ((DmcObject)def).getReferringObjects();
        Exception ex = null;
        StringBuilder sb = null;
        if (refs.size() > 0) {
            for (DmcObject wrapper : refs) {
                DSDefinitionDMO referring = (DSDefinitionDMO)wrapper;
                if (((DSDefinitionDMO)def).getDotName().equals(referring.getDotName())) continue;
                if (sb == null) {
                    sb = new StringBuilder();
                }
                sb.append(referring.getDotName().getNameString() + "\n");
            }
            if (sb != null) {
                ex = new Exception("Cannot delete object because of outstanding references: " + ((DSDefinitionDMO)def).getDotName() + "\n" + sb.toString());
                throw ex;
            }
        }
        try {
            DotName nameAndTypeName = new DotName(((DSDefinitionDMO)def).getName() + "." + this.className);
            DotName fullName = new DotName(((DSDefinitionDMO)def).getDmoFromModule() + "." + ((DSDefinitionDMO)def).getName() + "." + this.className);
            this.deleteByName(def);
            this.deleteByNameAndType(def, nameAndTypeName);
            this.deleteByFullName(fullName);
            if (this.globalSet != null) {
                this.globalSet.deleteGlobal((DSDefinitionDMO)def, fullName, nameAndTypeName);
            }
            if (this.derivedFromSet != null) {
                this.derivedFromSet.deleteFromBase((DSDefinitionDMO)def);
            }
        }
        catch (DmcValueException e) {
            e.printStackTrace();
        }
    }

    public int size() {
        return this.fullDotNameMap.size();
    }

    public int getLongestName() {
        return this.longestName;
    }

    public DEF getDefinition(DotName name) {
        return (DEF)((DSDefinitionDMO)this.fullDotNameMap.get(name));
    }

    public Collection<DEF> values() {
        return this.fullDotNameMap.values();
    }

    public DEF getDefinition(String name) throws DmcNameClashException, DmcValueException {
        DefinitionName dn = new DefinitionName(name);
        ArrayList<DEF> existing = this.nameMap.get(dn);
        if (existing == null) {
            return null;
        }
        if (existing.size() == 1) {
            return (DEF)((DSDefinitionDMO)existing.get(0));
        }
        ArrayList<DmcNamedObjectIF> namedObjects = new ArrayList<DmcNamedObjectIF>();
        for (DSDefinitionDMO obj : existing) {
            namedObjects.add(obj);
        }
        DmcNameClashException mdce = new DmcNameClashException("", namedObjects);
        throw mdce;
    }

    public DEF getDefinitionByNameAndType(DotName dn) throws DmcNameClashException {
        ArrayList<DEF> existing = this.nameAndTypeMap.get(dn);
        if (existing == null) {
            return null;
        }
        if (existing.size() == 1) {
            return (DEF)((DSDefinitionDMO)existing.get(0));
        }
        ArrayList<DmcNamedObjectIF> namedObjects = new ArrayList<DmcNamedObjectIF>();
        for (DSDefinitionDMO obj : existing) {
            namedObjects.add(obj);
        }
        DmcNameClashException mdce = new DmcNameClashException("", namedObjects);
        throw mdce;
    }

    public String getAllDotNames() {
        StringBuffer sb = new StringBuffer();
        for (DotName dn : this.fullDotNameMap.keySet()) {
            sb.append(dn.toString() + "\n");
        }
        return sb.toString();
    }

    public String summary() {
        ArrayList<DEF> defs;
        StringBuilder sb = new StringBuilder();
        if (this.fullDotNameMap.size() == 0) {
            return "";
        }
        if (this.setName != null) {
            sb.append("setname:     " + this.setName + "\n");
        }
        if (this.className != null) {
            sb.append("classname:   " + this.className + "\n");
        }
        if (this.derivedFromSet != null) {
            sb.append("derivedfrom: " + this.derivedFromSet.className + "\n");
        }
        sb.append("fullDotNameMap: " + this.fullDotNameMap.size() + "\n");
        for (DotName dotName : this.fullDotNameMap.keySet()) {
            DSDefinitionDMO def = (DSDefinitionDMO)this.fullDotNameMap.get(dotName);
            if (def == null) {
                sb.append("    " + dotName + " -- no value\n");
                continue;
            }
            sb.append("    " + dotName + " -- " + def.getConstructionClassName() + "\n");
        }
        sb.append("\n");
        sb.append("nameMap:\n");
        for (DefinitionName definitionName : this.nameMap.keySet()) {
            sb.append("    " + definitionName.getNameString() + "\n");
            defs = this.nameMap.get(definitionName);
            if (defs == null) continue;
            for (DSDefinitionDMO def : defs) {
                sb.append("        " + def.getDotName());
            }
        }
        sb.append("\n");
        sb.append("nameAndTypeMap:\n");
        for (DotName dotName : this.nameAndTypeMap.keySet()) {
            sb.append("    " + dotName.getNameString() + "\n");
            defs = this.nameAndTypeMap.get(dotName);
            if (defs == null) continue;
            for (DSDefinitionDMO def : defs) {
                sb.append("        " + def.getDotName());
            }
        }
        sb.append("\n\n");
        return sb.toString();
    }
}

