/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmc.definitions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcNamedObjectIF;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DefinitionName;
import org.dmd.dmc.types.DotName;
import org.dmd.dms.DSDefinition;
import org.dmd.dms.generated.dmw.DSDefinitionDMW;
import org.dmd.dmw.DmwNamedObjectWrapper;
import org.dmd.dmw.DmwWrapper;
import org.dmd.util.exceptions.ResultException;

public class DmcDefinitionSet<DEF extends DSDefinition> {
    static boolean debug = false;
    private TreeMap<DefinitionName, ArrayList<DEF>> nameMap = new TreeMap();
    private TreeMap<DotName, DEF> fullDotNameMap = new TreeMap();
    private TreeMap<DotName, ArrayList<DEF>> nameAndTypeMap = new TreeMap();
    private int longestName;
    private String setName;
    private String className;
    private DmcDefinitionSet<DSDefinition> globalSet;
    private boolean isGlobalSet;
    private DmcDefinitionSet<?> derivedFromSet;

    public DmcDefinitionSet() {
        this.setName = null;
        this.className = null;
        this.globalSet = null;
        this.isGlobalSet = false;
        this.derivedFromSet = null;
    }

    public DmcDefinitionSet(String sn) {
        this.setName = sn;
        this.className = null;
        this.globalSet = null;
        this.isGlobalSet = true;
        this.derivedFromSet = null;
    }

    public DmcDefinitionSet(String sn, String cn) {
        this.setName = sn;
        this.className = cn;
        this.globalSet = null;
        this.isGlobalSet = true;
        this.derivedFromSet = null;
    }

    public DmcDefinitionSet(String cn, DmcDefinitionSet<DSDefinition> gs) {
        this.setName = cn;
        this.className = cn;
        this.globalSet = gs;
        this.isGlobalSet = false;
        this.derivedFromSet = null;
    }

    public DmcDefinitionSet(String cn, DmcDefinitionSet<DSDefinition> gs, DmcDefinitionSet<?> derivedFrom) {
        this.setName = cn;
        this.className = cn;
        this.globalSet = gs;
        this.isGlobalSet = false;
        this.derivedFromSet = derivedFrom;
    }

    public static void debug(boolean f) {
        debug = f;
    }

    void addByNameAndType(DEF def, DotName nameAndTypeName) {
        ArrayList<Object> existingNameAndTypeSet = this.nameAndTypeMap.get(nameAndTypeName);
        if (existingNameAndTypeSet == null) {
            existingNameAndTypeSet = new ArrayList(1);
            this.nameAndTypeMap.put(nameAndTypeName, existingNameAndTypeSet);
        }
        existingNameAndTypeSet.add(def);
    }

    void deleteByNameAndType(DEF def, DotName nameAndTypeName) {
        ArrayList<DEF> existingNameAndTypeSet = this.nameAndTypeMap.get(nameAndTypeName);
        if (existingNameAndTypeSet == null) {
            throw new IllegalStateException("No entry in nameAndTypeMap for: " + ((DmwWrapper)def).toOIF());
        }
        if (!existingNameAndTypeSet.remove(def)) {
            throw new IllegalStateException("Could not delete entry in nameAndTypeMap for: " + ((DmwWrapper)def).toOIF());
        }
    }

    void addByName(DEF def) {
        ArrayList<Object> existingNameSet = this.nameMap.get(((DSDefinitionDMW)def).getName());
        if (existingNameSet == null) {
            existingNameSet = new ArrayList(1);
            this.nameMap.put(((DSDefinitionDMW)def).getName(), existingNameSet);
        }
        existingNameSet.add(def);
    }

    void deleteByName(DEF def) {
        ArrayList<DEF> existingNameSet = this.nameMap.get(((DSDefinitionDMW)def).getName());
        if (existingNameSet == null) {
            throw new IllegalStateException("No entry in nameMap for: " + ((DmwWrapper)def).toOIF());
        }
        if (!existingNameSet.remove(def)) {
            throw new IllegalStateException("Could not delete entry in nameMap for: " + ((DmwWrapper)def).toOIF());
        }
    }

    void addGlobal(DEF def, DotName fullName, DotName nameAndTypeName) {
        if (!this.isGlobalSet) {
            throw new IllegalStateException("");
        }
        this.addByNameAndType(def, nameAndTypeName);
        this.addByFullName(def, fullName);
    }

    void deleteGlobal(DEF def, DotName fullName, DotName nameAndTypeName) {
        if (!this.isGlobalSet) {
            throw new IllegalStateException("");
        }
        this.deleteByNameAndType(def, nameAndTypeName);
        this.deleteByFullName(fullName);
    }

    void addByFullName(DEF def, DotName fullName) {
        if (this.fullDotNameMap.get(fullName) != null) {
            throw new IllegalStateException("Clashing fully qualified name: " + fullName + " - in definition set: " + this.setName + " - For definition: \n\n" + ((DmwWrapper)def).toOIF());
        }
        this.fullDotNameMap.put(fullName, def);
    }

    void deleteByFullName(DotName fullName) {
        if (this.fullDotNameMap.remove(fullName) == null) {
            throw new IllegalStateException("Could not delete entry in fullDotNameMap for: " + fullName);
        }
    }

    public void add(DEF def) {
        try {
            if (this.className == null) {
                DotName nameAndTypeName = new DotName(((DSDefinitionDMW)def).getName() + "." + ((DmwWrapper)def).getConstructionClassName());
                this.addByName(def);
                this.addByNameAndType(def, nameAndTypeName);
                this.addByFullName(def, ((DSDefinitionDMW)def).getDotName());
            } else {
                DotName nameAndTypeName = new DotName(((DSDefinitionDMW)def).getName() + "." + this.className);
                DotName fullName = new DotName(((DSDefinition)def).getNameOfModuleWhereThisCameFrom() + "." + ((DSDefinitionDMW)def).getName() + "." + this.className);
                this.addByName(def);
                this.addByNameAndType(def, nameAndTypeName);
                this.addByFullName(def, fullName);
                if (this.globalSet != null) {
                    this.globalSet.addGlobal((DSDefinition)def, fullName, nameAndTypeName);
                }
            }
        }
        catch (DmcValueException e) {
            e.printStackTrace();
        }
    }

    public void delete(DotName dn) throws ResultException {
        DSDefinition dsd = (DSDefinition)this.fullDotNameMap.get(dn);
        if (dsd == null) {
            throw new ResultException("The specified object: " + dn.getNameString() + " of class: " + this.className + "  doesn't exist");
        }
        if (!dsd.getConstructionClassName().equals(this.className)) {
            throw new ResultException("The specified object: " + dn.getNameString() + " is not of class: " + this.className);
        }
        this.delete(dsd);
    }

    protected void deleteFromBase(DSDefinition dsd) throws ResultException {
        DSDefinition def = dsd;
        this.delete(def);
    }

    public void delete(DEF def) throws ResultException {
        ArrayList<DmwWrapper> refs = ((DmwWrapper)def).getReferringObjects();
        ResultException ex = null;
        if (refs.size() > 0) {
            for (DmwWrapper wrapper : refs) {
                DSDefinition referring = (DSDefinition)wrapper;
                if (((DSDefinitionDMW)def).getDotName().equals(referring.getDotName())) continue;
                if (ex == null) {
                    ex = new ResultException("Cannot delete object because of outstanding references: " + ((DSDefinitionDMW)def).getDotName());
                }
                ex.moreMessages(referring.getDotName().getNameString());
            }
            if (ex != null) {
                throw ex;
            }
        }
        try {
            DotName nameAndTypeName = new DotName(((DSDefinitionDMW)def).getName() + "." + this.className);
            DotName fullName = new DotName(((DSDefinition)def).getNameOfModuleWhereThisCameFrom() + "." + ((DSDefinitionDMW)def).getName() + "." + this.className);
            this.deleteByName(def);
            this.deleteByNameAndType(def, nameAndTypeName);
            this.deleteByFullName(fullName);
            if (this.globalSet != null) {
                this.globalSet.deleteGlobal((DSDefinition)def, fullName, nameAndTypeName);
            }
            if (this.derivedFromSet != null) {
                this.derivedFromSet.deleteFromBase((DSDefinition)def);
            }
        }
        catch (DmcValueException e) {
            e.printStackTrace();
        }
    }

    public int size() {
        return this.fullDotNameMap.size();
    }

    public int getLongestName() {
        return this.longestName;
    }

    public DEF getDefinition(DotName name) {
        return (DEF)((DSDefinition)this.fullDotNameMap.get(name));
    }

    public Collection<DEF> values() {
        return this.fullDotNameMap.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DmwNamedObjectWrapper> getIndex() {
        TreeMap<DotName, DEF> treeMap = this.fullDotNameMap;
        synchronized (treeMap) {
            if (this.fullDotNameMap.size() == 0) {
                return Collections.EMPTY_LIST;
            }
            LinkedList<DmwNamedObjectWrapper> values = new LinkedList<DmwNamedObjectWrapper>();
            for (DSDefinition def : this.fullDotNameMap.values()) {
                values.add(def);
            }
            return values;
        }
    }

    public DEF getDefinition(String name) throws DmcNameClashException, DmcValueException {
        DefinitionName dn = new DefinitionName(name);
        ArrayList<DEF> existing = this.nameMap.get(dn);
        if (existing == null) {
            return null;
        }
        if (existing.size() == 0) {
            return null;
        }
        if (existing.size() == 1) {
            return (DEF)((DSDefinition)existing.get(0));
        }
        ArrayList<DmcNamedObjectIF> clash = new ArrayList<DmcNamedObjectIF>();
        for (DSDefinition def : existing) {
            clash.add(def);
        }
        DmcNameClashException mdce = new DmcNameClashException("", clash);
        throw mdce;
    }

    public Iterator<DEF> getDefinitionsByName(String name) throws DmcValueException {
        DefinitionName dn = new DefinitionName(name);
        ArrayList<DEF> defs = this.nameMap.get(dn);
        if (defs == null) {
            return null;
        }
        return defs.iterator();
    }

    public int getDefinitionCountByName(String name) throws DmcValueException {
        DefinitionName dn = new DefinitionName(name);
        ArrayList<DEF> defs = this.nameMap.get(dn);
        if (defs == null) {
            return 0;
        }
        return defs.size();
    }

    public DEF getDefinitionByNameAndType(DotName dn) throws DmcNameClashException {
        ArrayList<DEF> existing = this.nameAndTypeMap.get(dn);
        if (existing == null) {
            return null;
        }
        if (existing.size() == 1) {
            return (DEF)((DSDefinition)existing.get(0));
        }
        ArrayList<DmcNamedObjectIF> namedObjects = new ArrayList<DmcNamedObjectIF>();
        for (DSDefinition obj : existing) {
            namedObjects.add(obj);
        }
        DmcNameClashException mdce = new DmcNameClashException("", namedObjects);
        throw mdce;
    }

    public String getAllDotNames() {
        StringBuffer sb = new StringBuffer();
        for (DotName dn : this.fullDotNameMap.keySet()) {
            sb.append(dn.toString() + "\n");
        }
        return sb.toString();
    }

    public String summary() {
        ArrayList<DEF> defs;
        StringBuilder sb = new StringBuilder();
        if (this.fullDotNameMap.size() == 0) {
            return "";
        }
        if (this.setName != null) {
            sb.append("setname:     " + this.setName + "\n");
        }
        if (this.className != null) {
            sb.append("classname:   " + this.className + "\n");
        }
        if (this.derivedFromSet != null) {
            sb.append("derivedfrom: " + this.derivedFromSet.className + "\n");
        }
        sb.append("fullDotNameMap: " + this.fullDotNameMap.size() + "\n");
        for (DotName dotName : this.fullDotNameMap.keySet()) {
            DSDefinition def = (DSDefinition)this.fullDotNameMap.get(dotName);
            if (def == null) {
                sb.append("    " + dotName + " -- no value\n");
                continue;
            }
            sb.append("    " + dotName + " -- " + def.getConstructionClassName() + "\n");
        }
        sb.append("\n");
        sb.append("nameMap:\n");
        for (DefinitionName definitionName : this.nameMap.keySet()) {
            sb.append("    " + definitionName.getNameString() + "\n");
            defs = this.nameMap.get(definitionName);
            if (defs == null) continue;
            for (DSDefinition def : defs) {
                sb.append("        " + def.getDotName());
            }
        }
        sb.append("\n");
        sb.append("nameAndTypeMap:\n");
        for (DotName dotName : this.nameAndTypeMap.keySet()) {
            sb.append("    " + dotName.getNameString() + "\n");
            defs = this.nameAndTypeMap.get(dotName);
            if (defs == null) continue;
            for (DSDefinition def : defs) {
                sb.append("        " + def.getDotName());
            }
        }
        sb.append("\n\n");
        return sb.toString();
    }
}

