/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmc.presentation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.dmd.dmc.presentation.DmcChangeListenerIF;
import org.dmd.dmc.presentation.DmcPresentationIF;
import org.dmd.dmc.presentation.DmcPresentationTrackerIF;
import org.dmd.dmc.presentation.DmcReadyListenerIF;
import org.dmd.dmc.presentation.DmcValueChangeListenerIF;

public class Tracker
implements DmcPresentationTrackerIF {
    private Logger logger;
    int uniqueID = 0;
    HashMap<Integer, DmcPresentationIF> presenters = new HashMap();
    HashMap<Integer, DmcPresentationIF> ready = new HashMap();
    HashMap<Integer, DmcPresentationIF> notReady = new HashMap();
    HashMap<Integer, DmcPresentationIF> changed = new HashMap();
    ArrayList<DmcReadyListenerIF> readyListeners = new ArrayList();
    ArrayList<DmcChangeListenerIF> changeListeners = new ArrayList();
    ArrayList<DmcValueChangeListenerIF> valueChangeListeners = new ArrayList();
    boolean debug = false;

    @Override
    public void debug(boolean d) {
        if (d && this.logger == null) {
            this.logger = Logger.getLogger(this.getClass().getSimpleName());
        }
        this.debug = d;
    }

    @Override
    public boolean debug() {
        return this.debug;
    }

    @Override
    public void debug(String message) {
        if (this.debug) {
            this.logger.log(Level.FINE, message);
        }
    }

    String getFieldName(DmcPresentationIF dpi) {
        if (dpi.getAdapter() == null) {
            return dpi.getLabel();
        }
        return dpi.getAdapter().getAttributeInfo().name;
    }

    @Override
    public void addReadyListener(DmcReadyListenerIF listener) {
        this.readyListeners.add(listener);
    }

    @Override
    public void addChangeListener(DmcChangeListenerIF listener) {
        this.changeListeners.add(listener);
    }

    @Override
    public void addValueChangeListener(DmcValueChangeListenerIF listener) {
        this.valueChangeListeners.add(listener);
    }

    @Override
    public void isNotReady(DmcPresentationIF dpi) {
        if (this.debug) {
            this.logger.log(Level.FINE, this.getFieldName(dpi) + " is NOT ready");
        }
        this.ready.remove(dpi.getID());
        this.notReady.put(dpi.getID(), dpi);
        if (dpi.valueChanged()) {
            if (this.changed.get(dpi.getID()) == null) {
                this.changed.put(dpi.getID(), dpi);
            }
        } else {
            this.changed.remove(dpi.getID());
        }
        for (DmcReadyListenerIF dmcReadyListenerIF : this.readyListeners) {
            dmcReadyListenerIF.isReady(this.notReady.size() == 0 && this.changed.size() > 0);
        }
        for (DmcChangeListenerIF dmcChangeListenerIF : this.changeListeners) {
            dmcChangeListenerIF.isChanged(this.changed.size() > 0);
        }
        for (DmcValueChangeListenerIF dmcValueChangeListenerIF : this.valueChangeListeners) {
            dmcValueChangeListenerIF.valueUpdated(dpi);
        }
    }

    @Override
    public void isReady(DmcPresentationIF dpi) {
        if (this.debug) {
            System.out.println(this.getFieldName(dpi) + " is ready");
        }
        this.notReady.remove(dpi.getID());
        this.ready.put(dpi.getID(), dpi);
        if (dpi.valueChanged()) {
            if (this.debug) {
                this.logger.log(Level.FINE, "Tracker: value has changed " + this.getFieldName(dpi));
            }
            this.changed.put(dpi.getID(), dpi);
        } else {
            if (this.debug) {
                this.logger.log(Level.FINE, "Tracker: value has NOT changed " + this.getFieldName(dpi));
            }
            this.changed.remove(dpi.getID());
        }
        if (this.debug) {
            this.logger.log(Level.FINE, "Tracker: not ready size = " + this.notReady.size());
            for (DmcPresentationIF dmcPresentationIF : this.notReady.values()) {
                this.logger.log(Level.FINE, "    not ready: " + this.getFieldName(dmcPresentationIF));
            }
            System.out.println("\nTracker: changed size   = " + this.changed.size());
            for (DmcPresentationIF dmcPresentationIF : this.changed.values()) {
                this.logger.log(Level.FINE, "    changed: " + this.getFieldName(dmcPresentationIF));
            }
            System.out.println();
        }
        for (DmcReadyListenerIF dmcReadyListenerIF : this.readyListeners) {
            dmcReadyListenerIF.isReady(this.notReady.size() == 0 && this.changed.size() > 0);
        }
        for (DmcChangeListenerIF dmcChangeListenerIF : this.changeListeners) {
            dmcChangeListenerIF.isChanged(this.changed.size() > 0);
        }
        for (DmcValueChangeListenerIF dmcValueChangeListenerIF : this.valueChangeListeners) {
            dmcValueChangeListenerIF.valueUpdated(dpi);
        }
    }

    @Override
    public void startTracking() {
        for (DmcPresentationIF dmcPresentationIF : this.presenters.values()) {
            if (dmcPresentationIF.isReady()) {
                this.ready.put(dmcPresentationIF.getID(), dmcPresentationIF);
                continue;
            }
            this.notReady.put(dmcPresentationIF.getID(), dmcPresentationIF);
        }
        if (this.debug) {
            this.logger.log(Level.FINE, "not ready size = " + this.notReady.size());
        }
        for (DmcReadyListenerIF dmcReadyListenerIF : this.readyListeners) {
            dmcReadyListenerIF.isReady(this.notReady.size() == 0 && this.changed.size() > 0);
        }
        for (DmcChangeListenerIF dmcChangeListenerIF : this.changeListeners) {
            dmcChangeListenerIF.isChanged(this.changed.size() > 0);
        }
    }

    @Override
    public void track(DmcPresentationIF dpi) {
        dpi.setTracker(this, this.uniqueID++);
        this.presenters.put(dpi.getID(), dpi);
    }

    @Override
    public void reset() {
        this.ready.clear();
        this.notReady.clear();
        this.changed.clear();
        for (DmcPresentationIF dmcPresentationIF : this.presenters.values()) {
            dmcPresentationIF.resetToExisting();
            if (dmcPresentationIF.isReady()) {
                this.ready.put(dmcPresentationIF.getID(), dmcPresentationIF);
                continue;
            }
            this.notReady.put(dmcPresentationIF.getID(), dmcPresentationIF);
        }
        for (DmcReadyListenerIF dmcReadyListenerIF : this.readyListeners) {
            dmcReadyListenerIF.isReady(this.notReady.size() == 0 && this.changed.size() > 0);
        }
        for (DmcChangeListenerIF dmcChangeListenerIF : this.changeListeners) {
            dmcChangeListenerIF.isChanged(this.changed.size() > 0);
        }
    }

    @Override
    public void validateAll() {
        for (DmcPresentationIF presenter : this.presenters.values()) {
            presenter.isValid();
        }
    }
}

