/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmc.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcClassInfo;
import org.dmd.dmc.DmcOmni;
import org.dmd.dmc.rules.AttributeRuleKey;
import org.dmd.dmc.rules.RuleCollection;
import org.dmd.dmc.rules.RuleIF;
import org.dmd.dmc.rules.RuleKey;
import org.dmd.dmc.rules.RuleList;

public abstract class AttributeRuleCollection<I extends RuleIF>
extends RuleCollection<I> {
    protected HashMap<DmcAttributeInfo, ArrayList<I>> globalRules = new HashMap();

    public AttributeRuleCollection() {
        this.rules = new TreeMap();
    }

    protected void addThisRule(I rule) {
        if (rule.getApplyToClass() == null) {
            ArrayList<Object> grl = this.globalRules.get(rule.getApplyToAttribute());
            if (grl == null) {
                grl = new ArrayList();
                this.globalRules.put(rule.getApplyToAttribute(), grl);
            }
            grl.add(rule);
            if (DmcOmni.instance().ruleTracing()) {
                DmcOmni.instance().ruleAdded(this.getClass().getName() + " added global attribute rule: " + rule.getRuleTitle());
            }
        } else {
            RuleList<I> attrRules = (RuleList<I>)this.rules.get(rule.getKey());
            if (attrRules == null) {
                attrRules = new RuleList<I>();
                this.rules.put(rule.getKey(), attrRules);
            }
            attrRules.addRule(rule);
            if (DmcOmni.instance().ruleTracing()) {
                DmcOmni.instance().ruleAdded(this.getClass().getName() + " added specific attribute rule: " + rule.getKey().toString() + " - " + rule.getRuleTitle());
            }
        }
    }

    protected ArrayList<I> getRules(DmcAttributeInfo ai, DmcClassInfo ci) {
        AttributeRuleKey ark = new AttributeRuleKey(ai, ci);
        RuleList ruleList = (RuleList)this.rules.get(ark);
        if (ruleList == null) {
            ruleList = new RuleList();
            this.initializeFromHere(ark, ruleList);
        } else if (!ruleList.initialized()) {
            this.initializeFromHere(ark, ruleList);
        }
        return ruleList.getRules();
    }

    private void initializeFromHere(AttributeRuleKey ark, RuleList<I> ruleList) {
        DmcClassInfo base = ark.classInfo.derivedFrom;
        while (base != null) {
            AttributeRuleKey baseKey = new AttributeRuleKey(ark.attrInfo, base);
            RuleList baseRules = (RuleList)this.rules.get(baseKey);
            if (baseRules != null) {
                ArrayList rl = baseRules.getRules();
                for (RuleIF rule : rl) {
                    ruleList.addRule(rule);
                }
            }
            base = base.derivedFrom;
        }
        ruleList.setInitialized();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Global Rules:\n");
        for (ArrayList<I> rules : this.globalRules.values()) {
            for (RuleIF rule : rules) {
                sb.append(rule.getRuleTitle());
            }
        }
        sb.append("\nSpecific Attribute Rules:\n");
        for (RuleKey key : this.rules.keySet()) {
            RuleList list = (RuleList)this.rules.get(key);
            for (RuleIF rule : list.getRules()) {
                sb.append(key.toString() + "  -  " + rule.getRuleTitle() + "\n");
            }
        }
        return sb.toString();
    }
}

