/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmc.rules;

import java.util.ArrayList;
import java.util.TreeMap;
import org.dmd.dmc.DmcClassInfo;
import org.dmd.dmc.DmcOmni;
import org.dmd.dmc.rules.ClassRuleKey;
import org.dmd.dmc.rules.RuleCollection;
import org.dmd.dmc.rules.RuleIF;
import org.dmd.dmc.rules.RuleList;

public abstract class ClassRuleCollection<I extends RuleIF>
extends RuleCollection<I> {
    protected ArrayList<I> globalRules = new ArrayList();

    public ClassRuleCollection() {
        this.rules = new TreeMap();
    }

    protected void addThisRule(I rule) {
        if (rule.getApplyToClass() == null) {
            this.globalRules.add(rule);
            if (DmcOmni.instance().ruleTracing()) {
                DmcOmni.instance().ruleAdded(this.getClass().getName() + " added global class rule: " + rule.getRuleTitle());
            }
        } else {
            RuleList<I> classRules = (RuleList<I>)this.rules.get(rule.getKey());
            if (classRules == null) {
                classRules = new RuleList<I>();
                this.rules.put(rule.getKey(), classRules);
            }
            classRules.addRule(rule);
            if (DmcOmni.instance().ruleTracing()) {
                DmcOmni.instance().ruleAdded(this.getClass().getName() + " added specific class rule: " + rule.getKey().toString() + " - " + rule.getRuleTitle());
            }
        }
    }

    protected ArrayList<I> getRules(DmcClassInfo ci) {
        ClassRuleKey crk = new ClassRuleKey(ci);
        RuleList ruleList = (RuleList)this.rules.get(crk);
        if (ruleList == null) {
            ruleList = new RuleList();
            this.initializeFromHere(crk, ruleList);
        } else if (!ruleList.initialized()) {
            this.initializeFromHere(crk, ruleList);
        }
        return ruleList.getRules();
    }

    private void initializeFromHere(ClassRuleKey crk, RuleList<I> ruleList) {
        DmcClassInfo base = crk.classInfo.derivedFrom;
        while (base != null) {
            ClassRuleKey baseKey = new ClassRuleKey(base);
            RuleList baseRules = (RuleList)this.rules.get(baseKey);
            if (baseRules != null) {
                ArrayList rl = baseRules.getRules();
                for (RuleIF rule : rl) {
                    ruleList.addRule(rule);
                }
            }
            base = base.derivedFrom;
        }
        ruleList.setInitialized();
    }
}

