/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmc.rules;

import java.util.ArrayList;
import java.util.Iterator;
import org.dmd.dmc.rules.DmcRuleException;
import org.dmd.dmc.rules.SourceInfo;

public class DmcRuleExceptionSet
extends Exception {
    SourceInfo source = null;
    ArrayList<DmcRuleException> exceptions = new ArrayList();

    public void add(DmcRuleException ex) {
        this.exceptions.add(ex);
    }

    public ArrayList<DmcRuleException> geExceptions() {
        return this.exceptions;
    }

    public void source(SourceInfo s) {
        this.source = s;
    }

    public SourceInfo source() {
        return this.source;
    }

    public void add(DmcRuleExceptionSet dres) {
        if (dres == null) {
            return;
        }
        if (dres.exceptions == null) {
            return;
        }
        if (this.exceptions == null) {
            this.exceptions = new ArrayList();
        }
        for (DmcRuleException ex : dres.exceptions) {
            this.exceptions.add(ex);
        }
    }

    public boolean immediateHalt() {
        if (this.exceptions == null) {
            return false;
        }
        for (DmcRuleException ex : this.exceptions) {
            if (!ex.immediateHalt) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.source != null) {
            sb.append(this.source.toString() + "\n");
        }
        for (DmcRuleException ex : this.exceptions) {
            sb.append(ex.toString() + "\n");
        }
        return sb.toString();
    }

    public Iterator<DmcRuleException> getExceptions() {
        return this.exceptions.iterator();
    }

    public int getCount() {
        return this.exceptions.size();
    }
}

