/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmc.types;

import java.io.Serializable;
import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.DmcMappedAttributeIF;
import org.dmd.dmc.DmcObjectName;
import org.dmd.dmc.DmcObjectNameIF;
import org.dmd.dmc.DmcOutputStreamIF;
import org.dmd.dmc.DmcValueException;

public class CamelCaseName
extends DmcObjectName
implements DmcObjectNameIF,
Serializable {
    public static final String className = "CamelCaseName";
    static final String camelCase = "[a-zA-Z][a-zA-Z0-9]*";
    String name;

    public CamelCaseName() {
    }

    public CamelCaseName(CamelCaseName n) {
        this.name = n.name;
    }

    public CamelCaseName(String n) throws DmcValueException {
        if (!n.matches(camelCase)) {
            throw new DmcValueException("The String: " + n + " does not conform to camelCase format.");
        }
        this.name = n;
    }

    @Override
    public String getNameString() {
        return this.name;
    }

    @Override
    public void setNameString(String n) throws DmcValueException {
        if (!n.matches(camelCase)) {
            throw new DmcValueException("The String: " + n + " does not conform to camelCase format.");
        }
        this.name = n;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CamelCaseName) {
            return this.name.equals(((CamelCaseName)obj).name);
        }
        if (obj instanceof String) {
            return this.name.equals((String)obj);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public void serializeIt(DmcOutputStreamIF dos) throws Exception {
        dos.writeUTF(this.name);
    }

    @Override
    public void deserializeIt(DmcInputStreamIF dis) throws Exception {
        this.name = dis.readUTF();
    }

    @Override
    public int compareTo(DmcObjectName o) {
        if (o instanceof CamelCaseName) {
            return this.name.compareTo(((CamelCaseName)o).name);
        }
        return this.name.compareTo(o.getNameString());
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public Object getKey() {
        return this.name;
    }

    @Override
    public String getKeyAsString() {
        return this.name;
    }

    @Override
    public String getNameClass() {
        return className;
    }

    @Override
    public boolean valuesAreEqual(DmcMappedAttributeIF obj) {
        boolean rc = false;
        if (obj instanceof CamelCaseName) {
            CamelCaseName other = (CamelCaseName)obj;
            rc = this.name.equals(other.name);
        }
        return rc;
    }

    @Override
    public DmcObjectName cloneIt() {
        return new CamelCaseName(this);
    }

    @Override
    public DmcObjectName getNew() {
        return new CamelCaseName();
    }

    @Override
    public String getPresentationString() {
        return this.name;
    }
}

