/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmc.types;

import java.io.Serializable;
import org.dmd.dmc.DmcClassInfo;
import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.DmcMappedAttributeIF;
import org.dmd.dmc.DmcOmni;
import org.dmd.dmc.DmcOutputStreamIF;

public class ClassInfoRef
implements DmcMappedAttributeIF,
Comparable<ClassInfoRef>,
Serializable {
    Integer id;
    transient DmcClassInfo info;

    public ClassInfoRef() {
        this.id = -1;
        this.info = null;
    }

    public ClassInfoRef(Integer i) {
        this.id = i;
        this.info = DmcOmni.instance().getClassInfo(this.id);
        if (this.info == null) {
            throw new IllegalStateException("DmcClassInfo unavailable for id: " + i);
        }
    }

    public ClassInfoRef(ClassInfoRef original) {
        this.id = original.id;
        this.info = original.info;
    }

    public ClassInfoRef(DmcClassInfo dci) {
        this.id = dci.id;
        this.info = dci;
    }

    public ClassInfoRef(String cn) {
        this.info = DmcOmni.instance().getClassInfo(cn);
        if (this.info == null) {
            throw new IllegalStateException("DmcClassInfo unavailable for class name: " + cn);
        }
        this.id = this.info.id;
    }

    public DmcClassInfo getInfo() {
        if (this.info == null) {
            this.info = DmcOmni.instance().getClassInfo(this.id);
            if (this.info == null) {
                throw new IllegalStateException("DmcClassInfo unavailable for id: " + this.id);
            }
        }
        return this.info;
    }

    @Override
    public Object getKey() {
        return this.id;
    }

    @Override
    public String getKeyAsString() {
        return this.id.toString();
    }

    @Override
    public boolean valuesAreEqual(DmcMappedAttributeIF obj) {
        boolean rc = false;
        if (obj != null && obj instanceof ClassInfoRef && this.id.equals(((ClassInfoRef)obj).id)) {
            rc = true;
        }
        return rc;
    }

    public void serializeIt(DmcOutputStreamIF dos) throws Exception {
        dos.writeInt(this.id);
    }

    public void deserializeIt(DmcInputStreamIF dis) throws Exception {
        this.id = dis.readInt();
        this.info = DmcOmni.instance().getClassInfo(this.id);
        if (this.info == null) {
            throw new IllegalStateException("DmcClassInfo unavailable for id: " + this.id);
        }
    }

    @Override
    public int compareTo(ClassInfoRef o) {
        return this.id - o.id;
    }

    public boolean equals(Object obj) {
        boolean rc = false;
        if (obj != null && obj instanceof ClassInfoRef && this.id == ((ClassInfoRef)obj).id) {
            rc = true;
        }
        return rc;
    }
}

