/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmc.types;

import java.io.Serializable;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.DmcOutputStreamIF;
import org.dmd.dmc.DmcValueException;

public abstract class DmcTypeBoolean
extends DmcAttribute<Boolean>
implements Serializable {
    public DmcTypeBoolean() {
    }

    public DmcTypeBoolean(DmcAttributeInfo ai) {
        super(ai);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Boolean typeCheck(Object value) throws DmcValueException {
        Boolean rc = null;
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            String v = (String)value;
            if (v.toLowerCase().equals("true")) {
                return new Boolean(true);
            }
            if (!v.toLowerCase().equals("false")) throw new DmcValueException("Invalid Boolean value: " + v);
            return new Boolean(false);
        }
        if (!(value instanceof Integer)) throw new DmcValueException("Object of class: " + value.getClass().getName() + " passed where object compatible with Boolean expected.");
        Integer v = (Integer)value;
        if (v != 0) return new Boolean(true);
        return new Boolean(false);
    }

    @Override
    public Boolean cloneValue(Boolean original) {
        return new Boolean(original);
    }

    @Override
    public void serializeValue(DmcOutputStreamIF dos, Boolean value) throws Exception {
        dos.writeBoolean(value);
    }

    @Override
    public Boolean deserializeValue(DmcInputStreamIF dis) throws Exception {
        return new Boolean(dis.readBoolean());
    }
}

