/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmc.types;

import java.io.Serializable;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.DmcOutputStreamIF;
import org.dmd.dmc.DmcValueException;

public abstract class DmcTypeByte
extends DmcAttribute<Byte>
implements Serializable {
    public DmcTypeByte() {
    }

    public DmcTypeByte(DmcAttributeInfo ai) {
        super(ai);
    }

    @Override
    public Byte typeCheck(Object value) throws DmcValueException {
        Byte rc = null;
        if (value instanceof Byte) {
            rc = (Byte)value;
        } else if (value instanceof String) {
            String v = (String)value;
            try {
                rc = Byte.valueOf(v);
            }
            catch (NumberFormatException e) {
                throw new DmcValueException("Invalid Byte value: " + v);
            }
        } else {
            throw new DmcValueException("Object of class: " + value.getClass().getName() + " passed where object compatible with Byte expected.");
        }
        return rc;
    }

    @Override
    public Byte cloneValue(Byte original) {
        return new Byte(original);
    }

    @Override
    public void serializeValue(DmcOutputStreamIF dos, Byte value) throws Exception {
        dos.writeByte(value.byteValue());
    }

    @Override
    public Byte deserializeValue(DmcInputStreamIF dis) throws Exception {
        return new Byte(dis.readByte());
    }
}

